/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.aql.evaluation.strategy;

import java.io.IOException;
import java.nio.charset.Charset;
import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.acceleo.OpenModeKind;
import org.eclipse.acceleo.aql.evaluation.strategy.IWriterFactory;
import org.eclipse.acceleo.aql.evaluation.writer.IAcceleoWriter;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.URIConverter;

public class PreviewWriterFactory
implements IWriterFactory {
    private final Map<URI, String> preview = new LinkedHashMap<URI, String>();

    @Override
    public IAcceleoWriter createWriter(OpenModeKind openModeKind, URI uri, URIConverter uriConverter, Charset charset, String lineDelimiter) {
        return new PreviewWriter(uri, charset, this.preview);
    }

    public Map<URI, String> getPreview() {
        return this.preview;
    }

    private static final class PreviewWriter
    implements IAcceleoWriter {
        private final URI uri;
        private final Charset charset;
        private final StringBuilder builder = new StringBuilder();
        private final Map<URI, String> preview;

        public PreviewWriter(URI targetURI, Charset charset, Map<URI, String> preview) {
            this.uri = targetURI;
            this.charset = charset;
            this.preview = preview;
        }

        @Override
        public void close() throws IOException {
            this.preview.put(this.getTargetURI(), this.builder.toString());
        }

        @Override
        public URI getTargetURI() {
            return this.uri;
        }

        @Override
        public Charset getCharset() {
            return this.charset;
        }

        @Override
        public void append(String content) {
            this.builder.append(content);
        }
    }
}

