/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.query.doc.internal;

import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.function.Function;
import org.eclipse.acceleo.annotations.api.documentation.Documentation;
import org.eclipse.acceleo.annotations.api.documentation.Example;
import org.eclipse.acceleo.annotations.api.documentation.Other;
import org.eclipse.acceleo.annotations.api.documentation.Param;
import org.eclipse.acceleo.annotations.api.documentation.ServiceProvider;
import org.eclipse.emf.ecore.EClass;

public final class AQLHelpContentUtils {
    public static final String AQL_HREF_PREFIX = "aql_service_";
    public static final Function<Method, StringBuffer> METHOD_SIGNATURE_GENERATOR_2016 = new MethodSignatureGenerator2016();
    private static final String LS = System.getProperty("line.separator");
    private static final Function<Method, StringBuffer> METHODE_SIGNATURE_OLD_GENERATOR = new MethodSignatureOldGenerator();

    private AQLHelpContentUtils() {
    }

    public static StringBuffer html(StringBuffer head, StringBuffer body) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("<!DOCTYPE html>").append(LS);
        buffer.append("<html lang=\"en\">").append(LS);
        buffer.append("<!--").append(LS);
        buffer.append("/********************************************************************************").append(LS);
        buffer.append("** Copyright (c) 2015 Obeo.").append(LS);
        buffer.append("** All rights reserved. This program and the accompanying materials").append(LS);
        buffer.append("** are made available under the terms of the Eclipse Public License v2.0").append(LS);
        buffer.append("** which accompanies this distribution, and is available at").append(LS);
        buffer.append("** http://www.eclipse.org/legal/epl-v20.html").append(LS);
        buffer.append("**").append(LS);
        buffer.append("** Contributors:").append(LS);
        buffer.append("**    Stephane Begaudeau (Obeo) - initial API and implementation").append(LS);
        buffer.append("*********************************************************************************/").append(LS);
        buffer.append("-->").append(LS);
        buffer.append(head).append(LS);
        buffer.append(body).append(LS);
        buffer.append("</html>").append(LS);
        return buffer;
    }

    public static StringBuffer head() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("  <head>").append(LS);
        buffer.append("    <meta charset=\"utf-8\">").append(LS);
        buffer.append("    <meta http-equiv=\"X-UA-Compatible\" content=\"IE=edge,chrome=1\">").append(LS);
        buffer.append("    <meta name=\"viewport\" content=\"width=device-width, initial-scale=1.0\">").append(LS);
        buffer.append("    <meta name=\"description\" content=\"\">").append(LS);
        buffer.append("    <meta name=\"author\" content=\"St&eacute;phane B&eacute;gaudeau\">").append(LS);
        buffer.append("    <!-- IE6-8 support of HTML elements -->").append(LS);
        buffer.append("    <!--[if lt IE 9]>").append(LS);
        buffer.append("      <script src=\"http://html5shim.googlecode.com/svn/trunk/html5.js\"></script>").append(LS);
        buffer.append("    <![endif]-->").append(LS);
        buffer.append("    <link href=\"../assets/css/bootstrap.css\" rel=\"stylesheet\">").append(LS);
        buffer.append("    <link href=\"../assets/css/docs.css\" rel=\"stylesheet\">").append(LS);
        buffer.append("    <title>Acceleo</title>").append(LS);
        buffer.append("  </head>").append(LS);
        return buffer;
    }

    public static StringBuffer body(StringBuffer header, List<StringBuffer> sections) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("  <body>").append(LS);
        buffer.append("    <div class=\"container\">").append(LS);
        buffer.append(header).append(LS);
        for (StringBuffer section : sections) {
            buffer.append(section).append(LS);
        }
        buffer.append("    </div>").append(LS);
        buffer.append("  </body>").append(LS);
        return buffer;
    }

    public static StringBuffer header(boolean isMainPage) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("   <header class=\"jumbotron subhead\" id=\"overview\">").append(LS);
        if (!isMainPage) {
            buffer.append("    <h1>Acceleo Query Language Documentation</h1>").append(LS);
        }
        buffer.append("    <!--<div class=\"subnav\">").append(LS);
        buffer.append("       <ul class=\"nav nav-pills\">").append(LS);
        buffer.append("        <li><a href=\"#introduction\">Introduction</a></li>").append(LS);
        buffer.append("        <li><a href=\"#language\">Language</a></li>").append(LS);
        buffer.append("        <li><a href=\"#operations\">Operations</a></li>").append(LS);
        buffer.append("        <li><a href=\"#standalone\">Stand Alone</a></li>").append(LS);
        buffer.append("        <li><a href=\"#migration\">Migration</a></li>").append(LS);
        buffer.append("        <li><a href=\"#textproductionrules\">Text Production Rules</a></li>").append(LS);
        buffer.append("        <li><a href=\"#onlineresources\">Online Resources</a></li>").append(LS);
        buffer.append("      </ul>").append(LS);
        buffer.append("    </div>-->").append(LS);
        buffer.append("  </header>").append(LS);
        return buffer;
    }

    public static StringBuffer computeToc(Class<?> ... serviceProviders) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>").append(LS);
        buffer.append("<?NLS TYPE=\"org.eclipse.help.toc\"?>").append(LS);
        buffer.append("<toc label=\"Acceleo Query Language Documentation\" topic=\"pages/index.html\">").append(LS);
        Class<?>[] classArray = serviceProviders;
        int n = serviceProviders.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?> serviceProviderClass = classArray[n2];
            if (serviceProviderClass.isAnnotationPresent(ServiceProvider.class)) {
                ServiceProvider serviceProvider = serviceProviderClass.getAnnotation(ServiceProvider.class);
                buffer.append("<topic href=\"pages/aql_service_" + serviceProviderClass.getSimpleName().toLowerCase() + ".html\" label=\"" + serviceProvider.value() + "\"></topic>").append(LS);
            }
            ++n2;
        }
        buffer.append("</toc>").append(LS);
        return buffer;
    }

    public static List<StringBuffer> computeAQLOverviewSections() {
        ArrayList<StringBuffer> buffers = new ArrayList<StringBuffer>();
        StringBuffer introductionSection = new StringBuffer();
        introductionSection.append("  <div class=\"jumbotron masthead\">").append(LS);
        introductionSection.append("    <h1>Acceleo Query Language</h1>").append(LS);
        introductionSection.append("  </div>").append(LS);
        introductionSection.append("  <div class=\"marketing\">").append(LS);
        introductionSection.append("    <h1>Query and navigate in EMF models</h1>").append(LS);
        introductionSection.append("  </div>").append(LS);
        introductionSection.append("").append(LS);
        introductionSection.append("  <section id=\"overview\">").append(LS);
        introductionSection.append("    <div class=\"page-header\">").append(LS);
        introductionSection.append("      <h1>Overview</h1>").append(LS);
        introductionSection.append("    </div>").append(LS);
        introductionSection.append("    <p>").append(LS);
        introductionSection.append("      The Acceleo Query Language (AQL) is a language used to navigate and query an EMF model. In this document, you will find the description ").append(LS);
        introductionSection.append("      of all the services of the standard library of AQL.").append(LS);
        introductionSection.append("    </p>").append(LS);
        introductionSection.append("  </section>").append(LS);
        buffers.add(introductionSection);
        return buffers;
    }

    public static List<StringBuffer> computeServiceSections(Class<?> serviceProviderClass) {
        return AQLHelpContentUtils.computeServiceSections(serviceProviderClass, 1, METHODE_SIGNATURE_OLD_GENERATOR);
    }

    public static List<StringBuffer> computeServiceSections(Class<?> serviceProviderClass, int titleLevel, Function<Method, StringBuffer> signatureGenerator) {
        ArrayList<StringBuffer> buffers = new ArrayList<StringBuffer>();
        ServiceProvider serviceProvider = serviceProviderClass.getAnnotation(ServiceProvider.class);
        if (serviceProvider == null) {
            return buffers;
        }
        StringBuffer servicesSection = new StringBuffer();
        servicesSection.append("  <section id=\"services\">").append(LS);
        servicesSection.append("    <div class=\"page-header\">").append(LS);
        servicesSection.append("      <h" + titleLevel + ">").append(serviceProvider.value()).append("</h" + titleLevel + ">").append(LS);
        servicesSection.append("    </div>").append(LS);
        Method[] methods = serviceProviderClass.getMethods();
        Method[] sortedMethods = Arrays.copyOf(methods, methods.length);
        Comparator<Method> comparator = new Comparator<Method>(){

            @Override
            public int compare(Method o1, Method o2) {
                return o1.getName().compareTo(o2.getName());
            }
        };
        Arrays.sort(sortedMethods, 0, sortedMethods.length, comparator);
        Method[] methodArray = sortedMethods;
        int n = sortedMethods.length;
        int n2 = 0;
        while (n2 < n) {
            Method method = methodArray[n2];
            if (method.isAnnotationPresent(Documentation.class)) {
                Documentation serviceDocumentation = method.getAnnotation(Documentation.class);
                servicesSection.append(LS);
                servicesSection.append("        <h3>").append(signatureGenerator.apply(method)).append("</h3>").append(LS);
                servicesSection.append("        <p>").append(LS);
                servicesSection.append("          ").append(serviceDocumentation.value()).append(LS);
                servicesSection.append("        </p>").append(LS);
                if (serviceDocumentation.examples().length > 0) {
                    Example[] examples;
                    servicesSection.append("        <table class=\"table table-striped table-bordered table-condensed\">").append(LS);
                    servicesSection.append("          <thead>").append(LS);
                    servicesSection.append("            <tr>").append(LS);
                    servicesSection.append("              <th>Expression</th>").append(LS);
                    servicesSection.append("              <th>Result</th>").append(LS);
                    servicesSection.append("            </tr>").append(LS);
                    servicesSection.append("          </thead><colgroup><col width=\"60%\" /><col width=\"40%\" /></colgroup>").append(LS);
                    servicesSection.append("          <tbody>").append(LS);
                    ArrayList<Other> others = new ArrayList<Other>();
                    Example[] exampleArray = examples = serviceDocumentation.examples();
                    int n3 = examples.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        Other[] otherExamples;
                        Example example = exampleArray[n4];
                        servicesSection.append("            <tr>").append(LS);
                        servicesSection.append("              <td>").append(example.expression()).append("</td>").append(LS);
                        servicesSection.append("              <td>").append(example.result()).append("</td>").append(LS);
                        servicesSection.append("            </tr>").append(LS);
                        Other[] otherArray = otherExamples = example.others();
                        int n5 = otherExamples.length;
                        int n6 = 0;
                        while (n6 < n5) {
                            Other otherExample = otherArray[n6];
                            others.add(otherExample);
                            ++n6;
                        }
                        ++n4;
                    }
                    servicesSection.append("          </tbody>").append(LS);
                    servicesSection.append("        </table>").append(LS);
                    servicesSection.append("        <p>").append(LS);
                    servicesSection.append("          ").append(serviceDocumentation.comment()).append(LS);
                    servicesSection.append("        </p>").append(LS);
                    if (others.size() > 0) {
                        servicesSection.append("        <h4>In other languages</h4>").append(LS);
                        servicesSection.append("        <table class=\"table table-striped table-bordered table-condensed\">").append(LS);
                        servicesSection.append("          <thead>").append(LS);
                        servicesSection.append("            <tr>").append(LS);
                        servicesSection.append("              <th>Language</th>").append(LS);
                        servicesSection.append("              <th>Expression</th>").append(LS);
                        servicesSection.append("              <th>Result</th>").append(LS);
                        servicesSection.append("            </tr>").append(LS);
                        servicesSection.append("          </thead><colgroup><col width=\"60%\" /><col width=\"40%\" /></colgroup>").append(LS);
                        servicesSection.append("          <tbody>").append(LS);
                        for (Other alternate : others) {
                            servicesSection.append("            <tr>").append(LS);
                            servicesSection.append("              <td>").append(alternate.language()).append("</td>").append(LS);
                            servicesSection.append("              <td>").append(alternate.expression()).append("</td>").append(LS);
                            servicesSection.append("              <td>").append(alternate.result()).append("</td>").append(LS);
                            servicesSection.append("            </tr>").append(LS);
                        }
                        servicesSection.append("          </tbody>").append(LS);
                        servicesSection.append("        </table>").append(LS);
                    }
                }
                servicesSection.append("        <hr />").append(LS);
            }
            ++n2;
        }
        servicesSection.append("  </section>").append(LS);
        buffers.add(servicesSection);
        return buffers;
    }

    private static boolean isCollection(Class<?> argType) {
        String typeName = argType.getCanonicalName();
        boolean res = "java.util.Set".equals(typeName) ? true : "java.util.List".equals(typeName) || "java.util.Collection".equals(typeName);
        return res;
    }

    public static String prettySimpleName(Class<?> argType) {
        String typeName = argType.getCanonicalName();
        if ("org.eclipse.acceleo.query.runtime.impl.LambdaValue".equals(typeName)) {
            typeName = " x | ... ";
        }
        if (typeName.startsWith("java.lang") || typeName.startsWith("java.util")) {
            typeName = argType.getSimpleName();
        }
        if (typeName.startsWith("org.eclipse.emf")) {
            typeName = argType.getSimpleName();
        }
        if ("List".equals(typeName)) {
            typeName = "Sequence";
        }
        if ("Set".equals(typeName)) {
            typeName = "OrderedSet";
        }
        return typeName;
    }

    public static String getPrettyGenericTypename(Type type, Class<?> argType) {
        Object typename = AQLHelpContentUtils.prettySimpleName(argType);
        if (type instanceof Class) {
            typename = AQLHelpContentUtils.prettySimpleName((Class)type);
        } else if (type instanceof ParameterizedType) {
            String canonical = argType.getCanonicalName();
            Type t = ((ParameterizedType)type).getActualTypeArguments()[0];
            if (t instanceof Class) {
                typename = "java.util.Set".equals(canonical) ? "OrderedSet{" + AQLHelpContentUtils.prettySimpleName((Class)t) + "}" : ("java.util.List".equals(canonical) || "java.util.Collection".equals(canonical) ? "Sequence{" + AQLHelpContentUtils.prettySimpleName((Class)t) + "}" : "{" + AQLHelpContentUtils.prettySimpleName((Class)t) + "}");
            }
        }
        return typename;
    }

    private static final class MethodSignatureGenerator2016
    implements Function<Method, StringBuffer> {
        private MethodSignatureGenerator2016() {
        }

        @Override
        public StringBuffer apply(Method method) {
            Type returnType;
            LinkedHashMap<String, String> methodnamesToOperator = new LinkedHashMap<String, String>();
            methodnamesToOperator.put("add", " + ");
            methodnamesToOperator.put("sub", " - ");
            methodnamesToOperator.put("equals", " = ");
            methodnamesToOperator.put("differs", " <> ");
            methodnamesToOperator.put("greaterThan", " > ");
            methodnamesToOperator.put("greaterThanEqual", " >= ");
            methodnamesToOperator.put("lessThan", " < ");
            methodnamesToOperator.put("lessThanEqual", " <= ");
            StringBuffer result = new StringBuffer();
            boolean isOperator = false;
            boolean first = true;
            ArrayList<String> parameterNames = new ArrayList<String>();
            Documentation documentation = method.getAnnotation(Documentation.class);
            Param[] params = documentation.params();
            if (params != null) {
                Param[] paramArray = params;
                int n = params.length;
                int n2 = 0;
                while (n2 < n) {
                    Param param = paramArray[n2];
                    parameterNames.add(param.name());
                    ++n2;
                }
            }
            Class<?>[] parameterTypes = method.getParameterTypes();
            Type[] genericParameterTypes = method.getGenericParameterTypes();
            int i = 0;
            while (i < parameterTypes.length) {
                Class<?> argType = parameterTypes[i];
                Object typeName = "";
                typeName = argType instanceof Class ? AQLHelpContentUtils.getPrettyGenericTypename(genericParameterTypes[i], argType) : (argType instanceof EClass ? "EClass=" + ((EClass)argType).getName() : "Object=" + ((Object)argType).toString());
                if (first) {
                    String methodName = method.getName();
                    if (methodnamesToOperator.get(methodName) != null) {
                        isOperator = true;
                        methodName = (String)methodnamesToOperator.get(methodName);
                    }
                    result.append((String)typeName);
                    if (!isOperator) {
                        if (AQLHelpContentUtils.isCollection(argType)) {
                            result.append("->");
                        } else {
                            result.append(".");
                        }
                    }
                    result.append(methodName);
                    if (!isOperator) {
                        result.append('(');
                    }
                }
                if (!first) {
                    if (i > 1) {
                        result.append(", ");
                    }
                    result.append((String)typeName);
                } else {
                    first = false;
                }
                ++i;
            }
            if (!isOperator) {
                result.append(')');
            }
            if (Void.class.equals((Object)(returnType = method.getGenericReturnType()))) {
                result.append(" : void");
            } else {
                result.append(" : ");
                result.append(AQLHelpContentUtils.getPrettyGenericTypename(returnType, method.getReturnType()));
            }
            return result;
        }
    }

    private static final class MethodSignatureOldGenerator
    implements Function<Method, StringBuffer> {
        private MethodSignatureOldGenerator() {
        }

        @Override
        public StringBuffer apply(Method method) {
            StringBuffer result = new StringBuffer();
            result.append(method.getName()).append('(');
            boolean first = true;
            ArrayList<String> parameterNames = new ArrayList<String>();
            Documentation documentation = method.getAnnotation(Documentation.class);
            Param[] params = documentation.params();
            if (params != null) {
                Param[] paramArray = params;
                int n = params.length;
                int n2 = 0;
                while (n2 < n) {
                    Param param = paramArray[n2];
                    parameterNames.add(param.name());
                    ++n2;
                }
            }
            Class<?>[] parameterTypes = method.getParameterTypes();
            int i = 0;
            while (i < parameterTypes.length) {
                String paramName;
                Class<?> argType = parameterTypes[i];
                if (!first) {
                    result.append(", ");
                } else {
                    first = false;
                }
                if (parameterNames.size() >= i + 1 && (paramName = (String)parameterNames.get(i)).trim().length() > 0) {
                    result.append(paramName);
                    result.append(": ");
                }
                if (argType instanceof Class) {
                    result.append(argType.getCanonicalName());
                } else if (argType instanceof EClass) {
                    result.append("EClass=" + ((EClass)argType).getName());
                } else {
                    result.append("Object=" + ((Object)argType).toString());
                }
                ++i;
            }
            result.append(')');
            Class<?> returnType = method.getReturnType();
            if (Void.class.equals(returnType)) {
                result.append(" = void");
            } else {
                result.append(" = ");
                result.append(returnType.getSimpleName());
            }
            return result;
        }
    }
}

