/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.query.services.tests;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Set;
import org.eclipse.acceleo.query.runtime.IQueryEnvironment;
import org.eclipse.acceleo.query.runtime.IReadOnlyQueryEnvironment;
import org.eclipse.acceleo.query.runtime.IService;
import org.eclipse.acceleo.query.runtime.ServiceUtils;
import org.eclipse.acceleo.query.services.ResourceServices;
import org.eclipse.acceleo.query.services.tests.AbstractServicesValidationTest;
import org.eclipse.acceleo.query.validation.type.ClassType;
import org.eclipse.acceleo.query.validation.type.EClassifierType;
import org.eclipse.acceleo.query.validation.type.IType;
import org.eclipse.acceleo.query.validation.type.SequenceType;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.junit.Assert;
import org.junit.Test;

public class ResourceServicesValidationTest
extends AbstractServicesValidationTest {
    @Override
    public void before() throws Exception {
        super.before();
        Set services = ServiceUtils.getServices((IReadOnlyQueryEnvironment)this.getQueryEnvironment(), ResourceServices.class);
        ServiceUtils.registerServices((IQueryEnvironment)this.getQueryEnvironment(), (Set)services);
    }

    @Test
    public void testEResource() {
        IService<?> service = this.serviceLookUp("eResource", new Object[]{EcorePackage.eINSTANCE.eClass()});
        Assert.assertTrue((service != null ? 1 : 0) != 0);
        ArrayList<EClassifierType> argTypes = new ArrayList<EClassifierType>();
        argTypes.add(this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getEClass()));
        try {
            this.getQueryEnvironment().registerEPackage((EPackage)EcorePackage.eINSTANCE);
            Set types = service.getType(null, this.getValidationServices(), null, (IReadOnlyQueryEnvironment)this.getQueryEnvironment(), argTypes);
            Assert.assertEquals((long)1L, (long)types.size());
            Iterator it = types.iterator();
            Assert.assertEquals((Object)this.classType(Resource.class), it.next());
            Assert.assertFalse((boolean)it.hasNext());
            LinkedHashMap<ArrayList<EClassifierType>, Set> allTypes = new LinkedHashMap<ArrayList<EClassifierType>, Set>();
            allTypes.put(argTypes, types);
            types = service.validateAllType(this.getValidationServices(), (IReadOnlyQueryEnvironment)this.getQueryEnvironment(), allTypes);
            Assert.assertEquals((long)1L, (long)types.size());
            it = types.iterator();
            Assert.assertEquals((Object)this.classType(Resource.class), it.next());
            Assert.assertFalse((boolean)it.hasNext());
        }
        finally {
            this.getQueryEnvironment().removeEPackage((EPackage)EcorePackage.eINSTANCE);
        }
    }

    @Test
    public void testGetURI() {
        IService<?> service = this.serviceLookUp("getURI", new Object[]{EcorePackage.eINSTANCE.eResource()});
        Assert.assertTrue((service != null ? 1 : 0) != 0);
        ArrayList<EClassifierType> argTypes = new ArrayList<EClassifierType>();
        argTypes.add(this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getEResource()));
        try {
            this.getQueryEnvironment().registerEPackage((EPackage)EcorePackage.eINSTANCE);
            Set types = service.getType(null, this.getValidationServices(), null, (IReadOnlyQueryEnvironment)this.getQueryEnvironment(), argTypes);
            Assert.assertEquals((long)1L, (long)types.size());
            Iterator it = types.iterator();
            Assert.assertEquals((Object)this.classType(URI.class), it.next());
            Assert.assertFalse((boolean)it.hasNext());
            LinkedHashMap<ArrayList<EClassifierType>, Set> allTypes = new LinkedHashMap<ArrayList<EClassifierType>, Set>();
            allTypes.put(argTypes, types);
            types = service.validateAllType(this.getValidationServices(), (IReadOnlyQueryEnvironment)this.getQueryEnvironment(), allTypes);
            Assert.assertEquals((long)1L, (long)types.size());
            it = types.iterator();
            Assert.assertEquals((Object)this.classType(URI.class), it.next());
            Assert.assertFalse((boolean)it.hasNext());
        }
        finally {
            this.getQueryEnvironment().removeEPackage((EPackage)EcorePackage.eINSTANCE);
        }
    }

    @Test
    public void testGetContents() {
        IService<?> service = this.serviceLookUp("getContents", new Object[]{EcorePackage.eINSTANCE.eResource()});
        Assert.assertTrue((service != null ? 1 : 0) != 0);
        ArrayList<EClassifierType> argTypes = new ArrayList<EClassifierType>();
        argTypes.add(this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getEResource()));
        try {
            this.getQueryEnvironment().registerEPackage((EPackage)EcorePackage.eINSTANCE);
            Set types = service.getType(null, this.getValidationServices(), null, (IReadOnlyQueryEnvironment)this.getQueryEnvironment(), argTypes);
            Assert.assertEquals((long)1L, (long)types.size());
            Iterator it = types.iterator();
            Assert.assertEquals((Object)new SequenceType((IReadOnlyQueryEnvironment)this.getQueryEnvironment(), (IType)this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getEObject())), it.next());
            Assert.assertFalse((boolean)it.hasNext());
            LinkedHashMap<ArrayList<EClassifierType>, Set> allTypes = new LinkedHashMap<ArrayList<EClassifierType>, Set>();
            allTypes.put(argTypes, types);
            types = service.validateAllType(this.getValidationServices(), (IReadOnlyQueryEnvironment)this.getQueryEnvironment(), allTypes);
            Assert.assertEquals((long)1L, (long)types.size());
            it = types.iterator();
            Assert.assertEquals((Object)new SequenceType((IReadOnlyQueryEnvironment)this.getQueryEnvironment(), (IType)this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getEObject())), it.next());
            Assert.assertFalse((boolean)it.hasNext());
        }
        finally {
            this.getQueryEnvironment().removeEPackage((EPackage)EcorePackage.eINSTANCE);
        }
    }

    @Test
    public void testGetContentsFiltered() {
        IService<?> service = this.serviceLookUp("getContents", new Object[]{EcorePackage.eINSTANCE.eResource(), EcorePackage.eINSTANCE.getEPackage()});
        Assert.assertTrue((service != null ? 1 : 0) != 0);
        ArrayList<EClassifierType> argTypes = new ArrayList<EClassifierType>();
        argTypes.add(this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getEResource()));
        argTypes.add(this.eClassifierLiteralType((EClassifier)EcorePackage.eINSTANCE.getEPackage()));
        try {
            this.getQueryEnvironment().registerEPackage((EPackage)EcorePackage.eINSTANCE);
            Set types = service.getType(null, this.getValidationServices(), null, (IReadOnlyQueryEnvironment)this.getQueryEnvironment(), argTypes);
            Assert.assertEquals((long)1L, (long)types.size());
            Iterator it = types.iterator();
            Assert.assertEquals((Object)new SequenceType((IReadOnlyQueryEnvironment)this.getQueryEnvironment(), (IType)this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getEPackage())), it.next());
            Assert.assertFalse((boolean)it.hasNext());
            LinkedHashMap<ArrayList<EClassifierType>, Set> allTypes = new LinkedHashMap<ArrayList<EClassifierType>, Set>();
            allTypes.put(argTypes, types);
            types = service.validateAllType(this.getValidationServices(), (IReadOnlyQueryEnvironment)this.getQueryEnvironment(), allTypes);
            Assert.assertEquals((long)1L, (long)types.size());
            it = types.iterator();
            Assert.assertEquals((Object)new SequenceType((IReadOnlyQueryEnvironment)this.getQueryEnvironment(), (IType)this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getEPackage())), it.next());
        }
        finally {
            this.getQueryEnvironment().removeEPackage((EPackage)EcorePackage.eINSTANCE);
        }
    }

    @Test
    public void testLastSegment() {
        IService<?> service = this.serviceLookUp("lastSegment", new Object[]{URI.createURI((String)"")});
        Assert.assertTrue((service != null ? 1 : 0) != 0);
        ArrayList<ClassType> argTypes = new ArrayList<ClassType>();
        argTypes.add(this.classType(URI.class));
        try {
            this.getQueryEnvironment().registerEPackage((EPackage)EcorePackage.eINSTANCE);
            Set types = service.getType(null, this.getValidationServices(), null, (IReadOnlyQueryEnvironment)this.getQueryEnvironment(), argTypes);
            Assert.assertEquals((long)1L, (long)types.size());
            Iterator it = types.iterator();
            Assert.assertEquals((Object)this.classType(String.class), it.next());
            Assert.assertFalse((boolean)it.hasNext());
            LinkedHashMap<ArrayList<ClassType>, Set> allTypes = new LinkedHashMap<ArrayList<ClassType>, Set>();
            allTypes.put(argTypes, types);
            types = service.validateAllType(this.getValidationServices(), (IReadOnlyQueryEnvironment)this.getQueryEnvironment(), allTypes);
            Assert.assertEquals((long)1L, (long)types.size());
            it = types.iterator();
            Assert.assertEquals((Object)this.classType(String.class), it.next());
            Assert.assertFalse((boolean)it.hasNext());
        }
        finally {
            this.getQueryEnvironment().removeEPackage((EPackage)EcorePackage.eINSTANCE);
        }
    }

    @Test
    public void testFileExtension() {
        IService<?> service = this.serviceLookUp("fileExtension", new Object[]{URI.createURI((String)"")});
        Assert.assertTrue((service != null ? 1 : 0) != 0);
        ArrayList<ClassType> argTypes = new ArrayList<ClassType>();
        argTypes.add(new ClassType((IReadOnlyQueryEnvironment)this.getQueryEnvironment(), URI.class));
        try {
            this.getQueryEnvironment().registerEPackage((EPackage)EcorePackage.eINSTANCE);
            Set types = service.getType(null, this.getValidationServices(), null, (IReadOnlyQueryEnvironment)this.getQueryEnvironment(), argTypes);
            Assert.assertEquals((long)1L, (long)types.size());
            Iterator it = types.iterator();
            Assert.assertEquals((Object)this.classType(String.class), it.next());
            Assert.assertFalse((boolean)it.hasNext());
            LinkedHashMap<ArrayList<ClassType>, Set> allTypes = new LinkedHashMap<ArrayList<ClassType>, Set>();
            allTypes.put(argTypes, types);
            types = service.validateAllType(this.getValidationServices(), (IReadOnlyQueryEnvironment)this.getQueryEnvironment(), allTypes);
            Assert.assertEquals((long)1L, (long)types.size());
            it = types.iterator();
            Assert.assertEquals((Object)this.classType(String.class), it.next());
            Assert.assertFalse((boolean)it.hasNext());
        }
        finally {
            this.getQueryEnvironment().removeEPackage((EPackage)EcorePackage.eINSTANCE);
        }
    }

    @Test
    public void testIsPlatformResource() {
        IService<?> service = this.serviceLookUp("isPlatformResource", new Object[]{URI.createURI((String)"")});
        Assert.assertTrue((service != null ? 1 : 0) != 0);
        ArrayList<ClassType> argTypes = new ArrayList<ClassType>();
        argTypes.add(this.classType(URI.class));
        try {
            this.getQueryEnvironment().registerEPackage((EPackage)EcorePackage.eINSTANCE);
            Set types = service.getType(null, this.getValidationServices(), null, (IReadOnlyQueryEnvironment)this.getQueryEnvironment(), argTypes);
            Assert.assertEquals((long)1L, (long)types.size());
            Iterator it = types.iterator();
            Assert.assertEquals((Object)this.classType(Boolean.class), it.next());
            Assert.assertFalse((boolean)it.hasNext());
            LinkedHashMap<ArrayList<ClassType>, Set> allTypes = new LinkedHashMap<ArrayList<ClassType>, Set>();
            allTypes.put(argTypes, types);
            types = service.validateAllType(this.getValidationServices(), (IReadOnlyQueryEnvironment)this.getQueryEnvironment(), allTypes);
            Assert.assertEquals((long)1L, (long)types.size());
            it = types.iterator();
            Assert.assertEquals((Object)this.classType(Boolean.class), it.next());
            Assert.assertFalse((boolean)it.hasNext());
        }
        finally {
            this.getQueryEnvironment().removeEPackage((EPackage)EcorePackage.eINSTANCE);
        }
    }

    @Test
    public void testIsPlatformPlugin() {
        IService<?> service = this.serviceLookUp("isPlatformPlugin", new Object[]{URI.createURI((String)"")});
        Assert.assertTrue((service != null ? 1 : 0) != 0);
        ArrayList<ClassType> argTypes = new ArrayList<ClassType>();
        argTypes.add(this.classType(URI.class));
        try {
            this.getQueryEnvironment().registerEPackage((EPackage)EcorePackage.eINSTANCE);
            Set types = service.getType(null, this.getValidationServices(), null, (IReadOnlyQueryEnvironment)this.getQueryEnvironment(), argTypes);
            Assert.assertEquals((long)1L, (long)types.size());
            Iterator it = types.iterator();
            Assert.assertEquals((Object)this.classType(Boolean.class), it.next());
            Assert.assertFalse((boolean)it.hasNext());
            LinkedHashMap<ArrayList<ClassType>, Set> allTypes = new LinkedHashMap<ArrayList<ClassType>, Set>();
            allTypes.put(argTypes, types);
            types = service.validateAllType(this.getValidationServices(), (IReadOnlyQueryEnvironment)this.getQueryEnvironment(), allTypes);
            Assert.assertEquals((long)1L, (long)types.size());
            it = types.iterator();
            Assert.assertEquals((Object)this.classType(Boolean.class), it.next());
            Assert.assertFalse((boolean)it.hasNext());
        }
        finally {
            this.getQueryEnvironment().removeEPackage((EPackage)EcorePackage.eINSTANCE);
        }
    }
}

