/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.query.services.tests;

import container.ContainerPackage;
import java.lang.reflect.InvocationTargetException;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.StreamSupport;
import org.eclipse.acceleo.query.runtime.IReadOnlyQueryEnvironment;
import org.eclipse.acceleo.query.runtime.IRootEObjectProvider;
import org.eclipse.acceleo.query.runtime.RootEObjectProvider;
import org.eclipse.acceleo.query.runtime.impl.Nothing;
import org.eclipse.acceleo.query.services.EObjectServices;
import org.eclipse.acceleo.query.services.tests.AbstractEngineInitializationWithCrossReferencer;
import org.eclipse.acceleo.query.tests.Setup;
import org.eclipse.acceleo.query.tests.UnitTestModels;
import org.eclipse.acceleo.query.tests.anydsl.AnydslFactory;
import org.eclipse.acceleo.query.tests.anydsl.AnydslPackage;
import org.eclipse.acceleo.query.tests.anydsl.Restaurant;
import org.eclipse.acceleo.query.tests.qmodel.QmodelPackage;
import org.eclipse.acceleo.query.tests.qmodel.Queries;
import org.eclipse.emf.common.util.EMap;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EGenericType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcoreFactory;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceFactoryImpl;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class EObjectServicesTest
extends AbstractEngineInitializationWithCrossReferencer {
    public Resource reverseModel;
    private EClass inverseTestModelClass1;
    private EClass inverseTestModelClass2;

    @Override
    @Before
    public void before() throws Exception {
        super.before();
        this.reverseModel = new UnitTestModels(Setup.createSetupForCurrentEnvironment()).reverse();
    }

    @Test
    public void testEInverse() throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        this.createModelForInverseTests();
        this.setQueryEnvironnementWithCrossReferencer((EObject)this.inverseTestModelClass2);
        EObjectServices eObjectServices = new EObjectServices((IReadOnlyQueryEnvironment)this.queryEnvironment, this.crossReferencer, null);
        Set inversedSequence = eObjectServices.eInverse((EObject)this.inverseTestModelClass2);
        Assert.assertEquals((String)"Unexpected count of inverse references returned", (long)2L, (long)inversedSequence.size());
        Iterator children = inversedSequence.iterator();
        Assert.assertEquals((String)"The first inverse reference on the second EClass should have been the first EClass", (Object)this.inverseTestModelClass1, children.next());
        Assert.assertTrue((String)"The second inverse reference on the second EClass should have been a GenericType", (boolean)(children.next() instanceof EGenericType));
    }

    @Test
    public void testEInverseNullReceiver() throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        this.createModelForInverseTests();
        this.setQueryEnvironnementWithCrossReferencer((EObject)this.inverseTestModelClass2);
        EObjectServices eObjectServices = new EObjectServices((IReadOnlyQueryEnvironment)this.queryEnvironment, this.crossReferencer, null);
        Set inversedSequence = eObjectServices.eInverse(null);
        Assert.assertEquals((String)"Unexpected count of inverse references returned", (long)0L, (long)inversedSequence.size());
    }

    @Test
    public void testEInverseWithFilter() throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        this.createModelForInverseTests();
        this.setQueryEnvironnementWithCrossReferencer((EObject)this.inverseTestModelClass2);
        EObjectServices eObjectServices = new EObjectServices((IReadOnlyQueryEnvironment)this.queryEnvironment, this.crossReferencer, null);
        Set inversedSequence = eObjectServices.eInverse((EObject)this.inverseTestModelClass2, (EClassifier)EcorePackage.eINSTANCE.getEGenericType());
        Assert.assertEquals((String)"Unexpected count of inverse references returned", (long)1L, (long)inversedSequence.size());
        Iterator children = inversedSequence.iterator();
        Assert.assertTrue((String)"The inverse reference on the second EClass should have been a GenericType", (boolean)(children.next() instanceof EGenericType));
    }

    @Test
    public void testEInverseWithFilterImplicitRoot() {
        this.createModelForInverseTests();
        this.setQueryEnvironnementWithCrossReferencer((EObject)this.inverseTestModelClass2);
        EObjectServices eObjectServices = new EObjectServices((IReadOnlyQueryEnvironment)this.queryEnvironment, this.crossReferencer, null);
        Set inversedSequence = eObjectServices.eInverse((EObject)this.inverseTestModelClass2, (EClassifier)EcorePackage.eINSTANCE.getEObject());
        Assert.assertEquals((String)"Unexpected count of inverse references returned", (long)2L, (long)inversedSequence.size());
        Iterator children = inversedSequence.iterator();
        Assert.assertEquals((String)"The first inverse reference on the second EClass should have been the first EClass", (Object)this.inverseTestModelClass1, children.next());
        Assert.assertTrue((String)"The second inverse reference on the second EClass should have been a GenericType", (boolean)(children.next() instanceof EGenericType));
    }

    @Test
    public void testEInverseWithFilterNullReceiver() throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        this.createModelForInverseTests();
        this.setQueryEnvironnementWithCrossReferencer((EObject)this.inverseTestModelClass2);
        EObjectServices eObjectServices = new EObjectServices((IReadOnlyQueryEnvironment)this.queryEnvironment, this.crossReferencer, null);
        Set inversedSequence = eObjectServices.eInverse(null, (EClassifier)EcorePackage.eINSTANCE.getEGenericType());
        Assert.assertEquals((String)"Unexpected count of inverse references returned", (long)0L, (long)inversedSequence.size());
    }

    @Test
    public void testEInverseWithFilterNullFilter() throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        this.createModelForInverseTests();
        this.setQueryEnvironnementWithCrossReferencer((EObject)this.inverseTestModelClass2);
        EObjectServices eObjectServices = new EObjectServices((IReadOnlyQueryEnvironment)this.queryEnvironment, this.crossReferencer, null);
        Set inversedSequence = eObjectServices.eInverse((EObject)this.inverseTestModelClass2, null);
        Assert.assertEquals((String)"Unexpected count of inverse references returned", (long)0L, (long)inversedSequence.size());
    }

    @Test
    public void testEInverseWithFeature() throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        this.createModelForInverseTests();
        this.setQueryEnvironnementWithCrossReferencer((EObject)this.inverseTestModelClass2);
        EObjectServices eObjectServices = new EObjectServices((IReadOnlyQueryEnvironment)this.queryEnvironment, this.crossReferencer, null);
        Set inversedSequence = eObjectServices.eInverse((EObject)this.inverseTestModelClass2, "eRawType");
        Assert.assertEquals((String)"Unexpected count of inverse references returned", (long)1L, (long)inversedSequence.size());
        Iterator children = inversedSequence.iterator();
        Assert.assertTrue((String)"The inverse reference on the second EClass should have been a GenericType", (boolean)(children.next() instanceof EGenericType));
    }

    @Test
    public void testEInverseWithFeatureNullReceiver() throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        this.createModelForInverseTests();
        this.setQueryEnvironnementWithCrossReferencer((EObject)this.inverseTestModelClass2);
        EObjectServices eObjectServices = new EObjectServices((IReadOnlyQueryEnvironment)this.queryEnvironment, this.crossReferencer, null);
        Set inversedSequence = eObjectServices.eInverse(null, "eRawType");
        Assert.assertEquals((String)"Unexpected count of inverse references returned", (long)0L, (long)inversedSequence.size());
    }

    @Test
    public void testEInverseWithFeatureNullFeatureName() throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        this.createModelForInverseTests();
        this.setQueryEnvironnementWithCrossReferencer((EObject)this.inverseTestModelClass2);
        EObjectServices eObjectServices = new EObjectServices((IReadOnlyQueryEnvironment)this.queryEnvironment, this.crossReferencer, null);
        Set inversedSequence = eObjectServices.eInverse((EObject)this.inverseTestModelClass2, null);
        Assert.assertEquals((String)"Unexpected count of inverse references returned", (long)0L, (long)inversedSequence.size());
    }

    @Test
    public void testEInverseWithFeatureNotAFeature() throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        this.createModelForInverseTests();
        this.setQueryEnvironnementWithCrossReferencer((EObject)this.inverseTestModelClass2);
        EObjectServices eObjectServices = new EObjectServices((IReadOnlyQueryEnvironment)this.queryEnvironment, this.crossReferencer, null);
        Set inversedSequence = eObjectServices.eInverse((EObject)this.inverseTestModelClass2, "notAFeaure");
        Assert.assertEquals((String)"Unexpected count of inverse references returned", (long)0L, (long)inversedSequence.size());
    }

    private void createModelForInverseTests() {
        EPackage root = EcoreFactory.eINSTANCE.createEPackage();
        EPackage sub = EcoreFactory.eINSTANCE.createEPackage();
        EPackage subSub = EcoreFactory.eINSTANCE.createEPackage();
        EPackage subSub2 = EcoreFactory.eINSTANCE.createEPackage();
        this.inverseTestModelClass1 = EcoreFactory.eINSTANCE.createEClass();
        this.inverseTestModelClass2 = EcoreFactory.eINSTANCE.createEClass();
        EAttribute attribute = EcoreFactory.eINSTANCE.createEAttribute();
        this.inverseTestModelClass1.getEStructuralFeatures().add((Object)attribute);
        subSub.getEClassifiers().add((Object)this.inverseTestModelClass1);
        sub.getESubpackages().add((Object)subSub);
        subSub2.getEClassifiers().add((Object)this.inverseTestModelClass2);
        sub.getESubpackages().add((Object)subSub2);
        root.getESubpackages().add((Object)sub);
        this.inverseTestModelClass1.getESuperTypes().add((Object)this.inverseTestModelClass2);
    }

    @Test
    public void testEClass() {
        EObject queries = (EObject)this.reverseModel.getContents().get(0);
        queries.eAllContents().next();
        EObject query = (EObject)queries.eAllContents().next();
        EObject resultExpectation = (EObject)query.eAllContents().next();
        EObject eObjectListResult = (EObject)resultExpectation.eAllContents().next();
        EObjectServices eObjectServices = new EObjectServices((IReadOnlyQueryEnvironment)this.getQueryEnvironment(), null, null);
        Assert.assertEquals((Object)queries.eClass(), (Object)eObjectServices.eClass(queries));
        Assert.assertEquals((Object)query.eClass(), (Object)eObjectServices.eClass(query));
        Assert.assertEquals((Object)resultExpectation.eClass(), (Object)eObjectServices.eClass(resultExpectation));
        Assert.assertEquals((Object)eObjectListResult.eClass(), (Object)eObjectServices.eClass(eObjectListResult));
        try {
            eObjectServices.eClass(null);
            Assert.fail((String)"The 'eClass' operation service must throw a NPE.");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @Test
    public void testEContainer() {
        EObject fullSiriusCodePackage = (EObject)this.reverseModel.getContents().get(0);
        fullSiriusCodePackage.eAllContents().next();
        EObject unused = (EObject)fullSiriusCodePackage.eAllContents().next();
        EObjectServices eObjectServices = new EObjectServices((IReadOnlyQueryEnvironment)this.getQueryEnvironment(), null, null);
        Assert.assertEquals((Object)fullSiriusCodePackage, (Object)eObjectServices.eContainer(unused, fullSiriusCodePackage.eClass()));
        unused.eAllContents().next();
        EObject newEReference1 = (EObject)unused.eAllContents().next();
        Assert.assertEquals((Object)unused, (Object)eObjectServices.eContainer(newEReference1, unused.eClass()));
        Assert.assertEquals((Object)fullSiriusCodePackage, (Object)eObjectServices.eContainer(newEReference1, fullSiriusCodePackage.eClass()));
        try {
            eObjectServices.eContainer(newEReference1, null);
            Assert.fail((String)"The 'eClass' operation service must throw a NPE.");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        try {
            eObjectServices.eContainer(null, unused.eClass());
            Assert.fail((String)"The 'eClass' operation service must throw a NPE.");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @Test
    public void testEContainerOrSelf() {
        EObject fullSiriusCodePackage = (EObject)this.reverseModel.getContents().get(0);
        fullSiriusCodePackage.eAllContents().next();
        EObject unused = (EObject)fullSiriusCodePackage.eAllContents().next();
        EObjectServices eObjectServices = new EObjectServices((IReadOnlyQueryEnvironment)this.getQueryEnvironment(), null, null);
        Assert.assertEquals((Object)fullSiriusCodePackage, (Object)eObjectServices.eContainerOrSelf(unused, fullSiriusCodePackage.eClass()));
        unused.eAllContents().next();
        EObject newEReference1 = (EObject)unused.eAllContents().next();
        Assert.assertEquals((Object)unused, (Object)eObjectServices.eContainerOrSelf(newEReference1, unused.eClass()));
        Assert.assertEquals((Object)fullSiriusCodePackage, (Object)eObjectServices.eContainerOrSelf(newEReference1, fullSiriusCodePackage.eClass()));
        try {
            eObjectServices.eContainerOrSelf(newEReference1, null);
            Assert.fail((String)"The 'eClass' operation service must throw a NPE.");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        try {
            eObjectServices.eContainerOrSelf(null, unused.eClass());
            Assert.fail((String)"The 'eClass' operation service must throw a NPE.");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @Test
    public void testEContainerNoEClass() {
        EObject fullSiriusCodePackage = (EObject)this.reverseModel.getContents().get(0);
        fullSiriusCodePackage.eAllContents().next();
        EObject unused = (EObject)fullSiriusCodePackage.eAllContents().next();
        unused.eAllContents().next();
        EObject newEReference1 = (EObject)unused.eAllContents().next();
        EObjectServices eObjectServices = new EObjectServices((IReadOnlyQueryEnvironment)this.getQueryEnvironment(), null, null);
        Assert.assertEquals((Object)fullSiriusCodePackage, (Object)eObjectServices.eContainer(unused));
        Assert.assertEquals((Object)unused, (Object)eObjectServices.eContainer(newEReference1));
        try {
            eObjectServices.eContainer(null);
            Assert.fail((String)"The 'eClass' operation service must throw a NPE.");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @Test
    public void testFilteredEContentsNoEClassFilter() {
        EObject fullSiriusCodePackage = (EObject)this.reverseModel.getContents().get(0);
        fullSiriusCodePackage.eAllContents().next();
        EObject unused = (EObject)fullSiriusCodePackage.eAllContents().next();
        unused.eAllContents().next();
        EObject newEReference1 = (EObject)unused.eAllContents().next();
        EObjectServices eObjectServices = new EObjectServices((IReadOnlyQueryEnvironment)this.getQueryEnvironment(), null, null);
        Assert.assertEquals((Object)unused.eContents(), (Object)eObjectServices.eContents(unused));
        Assert.assertEquals((Object)fullSiriusCodePackage.eContents(), (Object)eObjectServices.eContents(fullSiriusCodePackage));
        Assert.assertEquals((Object)newEReference1.eContents(), (Object)eObjectServices.eContents(newEReference1));
        try {
            eObjectServices.eContents(null);
            Assert.fail((String)"The 'eContents' operation service must throw a NPE.");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @Test
    public void testFilteredEContents() {
        EObject fullSiriusCodePackage = (EObject)this.reverseModel.getContents().get(0);
        fullSiriusCodePackage.eAllContents().next();
        EObject unused = (EObject)fullSiriusCodePackage.eAllContents().next();
        unused.eAllContents().next();
        EObject newEReference1 = (EObject)unused.eAllContents().next();
        EObjectServices eObjectServices = new EObjectServices((IReadOnlyQueryEnvironment)this.getQueryEnvironment(), null, null);
        this.getQueryEnvironment().registerEPackage((EPackage)QmodelPackage.eINSTANCE);
        List contents = eObjectServices.eContents(fullSiriusCodePackage, unused.eClass());
        Assert.assertEquals((long)31L, (long)contents.size());
        contents = eObjectServices.eContents(fullSiriusCodePackage, newEReference1.eClass());
        Assert.assertEquals((long)0L, (long)contents.size());
        contents = eObjectServices.eContents(unused, newEReference1.eClass());
        Assert.assertEquals((long)1L, (long)contents.size());
        try {
            eObjectServices.eContents(null);
            Assert.fail((String)"The 'eContents' operation service must throw a NPE.");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @Test
    public void testEContents() {
        EObject fullSiriusCodePackage = (EObject)this.reverseModel.getContents().get(0);
        this.getQueryEnvironment().registerEPackage((EPackage)QmodelPackage.eINSTANCE);
        EObjectServices eObjectServices = new EObjectServices((IReadOnlyQueryEnvironment)this.getQueryEnvironment(), null, null);
        List contents = eObjectServices.eContents(fullSiriusCodePackage);
        Assert.assertEquals((Object)fullSiriusCodePackage.eContents(), (Object)contents);
        contents.clear();
        Assert.assertFalse((boolean)eObjectServices.eContents(fullSiriusCodePackage).isEmpty());
    }

    @Test(expected=NullPointerException.class)
    public void testEContentsNullReceiver() {
        EObjectServices eObjectServices = new EObjectServices((IReadOnlyQueryEnvironment)this.getQueryEnvironment(), null, null);
        eObjectServices.eContents(null);
    }

    @Test
    public void testEContentsNullAndNullTypeEClassifierSet() {
        EObjectServices eObjectServices = new EObjectServices((IReadOnlyQueryEnvironment)this.getQueryEnvironment(), null, null);
        List contents = eObjectServices.eContents(null, null);
        Assert.assertEquals((long)0L, (long)contents.size());
    }

    @Test(expected=NullPointerException.class)
    public void testEContentsNullTypeEClassifierSet() {
        LinkedHashSet<EClass> types = new LinkedHashSet<EClass>();
        types.add(EcorePackage.eINSTANCE.getEPackage());
        types.add(EcorePackage.eINSTANCE.getEClass());
        this.getQueryEnvironment().registerEPackage((EPackage)EcorePackage.eINSTANCE);
        EObjectServices eObjectServices = new EObjectServices((IReadOnlyQueryEnvironment)this.getQueryEnvironment(), null, null);
        eObjectServices.eContents(null, types);
    }

    @Test
    public void testEContentsEObjectTypeEClassifierSet() {
        LinkedHashSet<EClass> types = new LinkedHashSet<EClass>();
        types.add(EcorePackage.eINSTANCE.getEPackage());
        types.add(EcorePackage.eINSTANCE.getEClass());
        this.getQueryEnvironment().registerEPackage((EPackage)EcorePackage.eINSTANCE);
        EObjectServices eObjectServices = new EObjectServices((IReadOnlyQueryEnvironment)this.getQueryEnvironment(), null, null);
        List contents = eObjectServices.eContents((EObject)EcorePackage.eINSTANCE, types);
        Assert.assertEquals((long)20L, (long)contents.size());
        Assert.assertEquals((Object)EcorePackage.eINSTANCE.getEAttribute(), contents.get(0));
        Assert.assertEquals((Object)EcorePackage.eINSTANCE.getEAnnotation(), contents.get(1));
        Assert.assertEquals((Object)EcorePackage.eINSTANCE.getEClass(), contents.get(2));
        Assert.assertEquals((Object)EcorePackage.eINSTANCE.getEClassifier(), contents.get(3));
        Assert.assertEquals((Object)EcorePackage.eINSTANCE.getEDataType(), contents.get(4));
        Assert.assertEquals((Object)EcorePackage.eINSTANCE.getEEnum(), contents.get(5));
        Assert.assertEquals((Object)EcorePackage.eINSTANCE.getEEnumLiteral(), contents.get(6));
        Assert.assertEquals((Object)EcorePackage.eINSTANCE.getEFactory(), contents.get(7));
        Assert.assertEquals((Object)EcorePackage.eINSTANCE.getEModelElement(), contents.get(8));
        Assert.assertEquals((Object)EcorePackage.eINSTANCE.getENamedElement(), contents.get(9));
        Assert.assertEquals((Object)EcorePackage.eINSTANCE.getEObject(), contents.get(10));
        Assert.assertEquals((Object)EcorePackage.eINSTANCE.getEOperation(), contents.get(11));
        Assert.assertEquals((Object)EcorePackage.eINSTANCE.getEPackage(), contents.get(12));
        Assert.assertEquals((Object)EcorePackage.eINSTANCE.getEParameter(), contents.get(13));
        Assert.assertEquals((Object)EcorePackage.eINSTANCE.getEReference(), contents.get(14));
        Assert.assertEquals((Object)EcorePackage.eINSTANCE.getEStructuralFeature(), contents.get(15));
        Assert.assertEquals((Object)EcorePackage.eINSTANCE.getETypedElement(), contents.get(16));
        Assert.assertEquals((Object)EcorePackage.eINSTANCE.getEStringToStringMapEntry(), contents.get(17));
        Assert.assertEquals((Object)EcorePackage.eINSTANCE.getEGenericType(), contents.get(18));
        Assert.assertEquals((Object)EcorePackage.eINSTANCE.getETypeParameter(), contents.get(19));
    }

    @Test
    public void testEAllContents_classHierarchy() {
        EObject fullSiriusCodePackage = (EObject)this.reverseModel.getContents().get(0);
        this.getQueryEnvironment().registerEPackage((EPackage)QmodelPackage.eINSTANCE);
        EObjectServices eObjectServices = new EObjectServices((IReadOnlyQueryEnvironment)this.getQueryEnvironment(), null, null);
        List contents = eObjectServices.eAllContents(fullSiriusCodePackage, QmodelPackage.eINSTANCE.getQueryEvaluationResult());
        Assert.assertEquals((long)52L, (long)contents.size());
        contents = eObjectServices.eAllContents(fullSiriusCodePackage, QmodelPackage.eINSTANCE.getSetResult());
        Assert.assertEquals((long)1L, (long)contents.size());
    }

    @Test
    public void testEAllContents_implicitRoot() {
        EObject fullSiriusCodePackage = (EObject)this.reverseModel.getContents().get(0);
        this.getQueryEnvironment().registerEPackage((EPackage)QmodelPackage.eINSTANCE);
        EObjectServices eObjectServices = new EObjectServices((IReadOnlyQueryEnvironment)this.getQueryEnvironment(), null, null);
        List contents = eObjectServices.eAllContents(fullSiriusCodePackage, EcorePackage.eINSTANCE.getEObject());
        Iterable iterable = () -> fullSiriusCodePackage.eAllContents();
        Assert.assertEquals((long)StreamSupport.stream(iterable.spliterator(), false).count(), (long)contents.size());
    }

    @Test
    public void testEContents_classHierarchy() {
        EObject fullSiriusCodePackage = (EObject)this.reverseModel.getContents().get(0);
        this.getQueryEnvironment().registerEPackage((EPackage)QmodelPackage.eINSTANCE);
        EObjectServices eObjectServices = new EObjectServices((IReadOnlyQueryEnvironment)this.getQueryEnvironment(), null, null);
        List allContents = eObjectServices.eAllContents(fullSiriusCodePackage, QmodelPackage.eINSTANCE.getExpectation());
        allContents = eObjectServices.eAllContents(fullSiriusCodePackage, QmodelPackage.eINSTANCE.getSetResult());
        Assert.assertEquals((long)1L, (long)allContents.size());
        EObject container = ((EObject)allContents.get(0)).eContainer();
        List contents = eObjectServices.eContents(container, QmodelPackage.eINSTANCE.getQueryEvaluationResult());
        Assert.assertEquals((long)1L, (long)contents.size());
        contents = eObjectServices.eContents(container, QmodelPackage.eINSTANCE.getSetResult());
        Assert.assertEquals((long)1L, (long)contents.size());
    }

    @Test
    public void testEContents_implicitRoot() {
        EObject fullSiriusCodePackage = (EObject)this.reverseModel.getContents().get(0);
        this.getQueryEnvironment().registerEPackage((EPackage)QmodelPackage.eINSTANCE);
        EObjectServices eObjectServices = new EObjectServices((IReadOnlyQueryEnvironment)this.getQueryEnvironment(), null, null);
        List contents = eObjectServices.eContents(fullSiriusCodePackage, EcorePackage.eINSTANCE.getEObject());
        Assert.assertEquals((long)fullSiriusCodePackage.eContents().size(), (long)contents.size());
    }

    @Test
    public void testEContainer_implicitRoot() {
        EObject fullSiriusCodePackage = (EObject)this.reverseModel.getContents().get(0);
        this.getQueryEnvironment().registerEPackage((EPackage)QmodelPackage.eINSTANCE);
        EObjectServices eObjectServices = new EObjectServices((IReadOnlyQueryEnvironment)this.getQueryEnvironment(), null, null);
        EObject container = eObjectServices.eContainer((EObject)fullSiriusCodePackage.eContents().get(0), EcorePackage.eINSTANCE.getEObject());
        Assert.assertEquals((Object)fullSiriusCodePackage, (Object)container);
    }

    private int eAllContentSize(EObject eObject) {
        int result = 0;
        TreeIterator eAllContents = eObject.eAllContents();
        while (eAllContents.hasNext()) {
            ++result;
            eAllContents.next();
        }
        return result;
    }

    @Test
    public void testEAllContentsNoEClassFilter() {
        EObject fullSiriusCodePackage = (EObject)this.reverseModel.getContents().get(0);
        fullSiriusCodePackage.eAllContents().next();
        EObject unused = (EObject)fullSiriusCodePackage.eAllContents().next();
        unused.eAllContents().next();
        EObject newEReference1 = (EObject)unused.eAllContents().next();
        EObjectServices eObjectServices = new EObjectServices((IReadOnlyQueryEnvironment)this.getQueryEnvironment(), null, null);
        Assert.assertEquals((long)this.eAllContentSize(fullSiriusCodePackage), (long)eObjectServices.eAllContents(fullSiriusCodePackage).size());
        Assert.assertEquals((long)this.eAllContentSize(unused), (long)eObjectServices.eAllContents(unused).size());
        Assert.assertEquals((long)1L, (long)eObjectServices.eAllContents(newEReference1).size());
        try {
            eObjectServices.eAllContents(null);
            Assert.fail((String)"The 'eClass' operation service must throw a NPE.");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @Test
    public void testEAllContentsNullAndNullTypeEClassifierSet() {
        EObjectServices eObjectServices = new EObjectServices((IReadOnlyQueryEnvironment)this.getQueryEnvironment(), null, null);
        List contents = eObjectServices.eAllContents(null, null);
        Assert.assertEquals((long)0L, (long)contents.size());
    }

    @Test(expected=NullPointerException.class)
    public void testEAllContentsNullTypeEClassifierSet() {
        LinkedHashSet<EClass> types = new LinkedHashSet<EClass>();
        types.add(EcorePackage.eINSTANCE.getEPackage());
        types.add(EcorePackage.eINSTANCE.getEClass());
        this.getQueryEnvironment().registerEPackage((EPackage)EcorePackage.eINSTANCE);
        EObjectServices eObjectServices = new EObjectServices((IReadOnlyQueryEnvironment)this.getQueryEnvironment(), null, null);
        eObjectServices.eAllContents(null, types);
    }

    @Test
    public void testEAllContentsEObjectTypeEClassifierSet() {
        LinkedHashSet<EClass> types = new LinkedHashSet<EClass>();
        types.add(EcorePackage.eINSTANCE.getEPackage());
        types.add(EcorePackage.eINSTANCE.getEClass());
        this.getQueryEnvironment().registerEPackage((EPackage)EcorePackage.eINSTANCE);
        EObjectServices eObjectServices = new EObjectServices((IReadOnlyQueryEnvironment)this.getQueryEnvironment(), null, null);
        List contents = eObjectServices.eAllContents((EObject)EcorePackage.eINSTANCE, types);
        Assert.assertEquals((long)20L, (long)contents.size());
        Assert.assertEquals((Object)EcorePackage.eINSTANCE.getEAttribute(), contents.get(0));
        Assert.assertEquals((Object)EcorePackage.eINSTANCE.getEAnnotation(), contents.get(1));
        Assert.assertEquals((Object)EcorePackage.eINSTANCE.getEClass(), contents.get(2));
        Assert.assertEquals((Object)EcorePackage.eINSTANCE.getEClassifier(), contents.get(3));
        Assert.assertEquals((Object)EcorePackage.eINSTANCE.getEDataType(), contents.get(4));
        Assert.assertEquals((Object)EcorePackage.eINSTANCE.getEEnum(), contents.get(5));
        Assert.assertEquals((Object)EcorePackage.eINSTANCE.getEEnumLiteral(), contents.get(6));
        Assert.assertEquals((Object)EcorePackage.eINSTANCE.getEFactory(), contents.get(7));
        Assert.assertEquals((Object)EcorePackage.eINSTANCE.getEModelElement(), contents.get(8));
        Assert.assertEquals((Object)EcorePackage.eINSTANCE.getENamedElement(), contents.get(9));
        Assert.assertEquals((Object)EcorePackage.eINSTANCE.getEObject(), contents.get(10));
        Assert.assertEquals((Object)EcorePackage.eINSTANCE.getEOperation(), contents.get(11));
        Assert.assertEquals((Object)EcorePackage.eINSTANCE.getEPackage(), contents.get(12));
        Assert.assertEquals((Object)EcorePackage.eINSTANCE.getEParameter(), contents.get(13));
        Assert.assertEquals((Object)EcorePackage.eINSTANCE.getEReference(), contents.get(14));
        Assert.assertEquals((Object)EcorePackage.eINSTANCE.getEStructuralFeature(), contents.get(15));
        Assert.assertEquals((Object)EcorePackage.eINSTANCE.getETypedElement(), contents.get(16));
        Assert.assertEquals((Object)EcorePackage.eINSTANCE.getEStringToStringMapEntry(), contents.get(17));
        Assert.assertEquals((Object)EcorePackage.eINSTANCE.getEGenericType(), contents.get(18));
        Assert.assertEquals((Object)EcorePackage.eINSTANCE.getETypeParameter(), contents.get(19));
    }

    @Test
    public void testEAllContents() {
        EObject fullSiriusCodePackage = (EObject)this.reverseModel.getContents().get(0);
        fullSiriusCodePackage.eAllContents().next();
        EObject unused = (EObject)fullSiriusCodePackage.eAllContents().next();
        unused.eAllContents().next();
        EObject newEReference1 = (EObject)unused.eAllContents().next();
        this.getQueryEnvironment().registerEPackage((EPackage)QmodelPackage.eINSTANCE);
        EObjectServices eObjectServices = new EObjectServices((IReadOnlyQueryEnvironment)this.getQueryEnvironment(), null, null);
        List contents = eObjectServices.eAllContents(fullSiriusCodePackage, unused.eClass());
        Assert.assertEquals((long)31L, (long)contents.size());
        contents = eObjectServices.eAllContents(fullSiriusCodePackage, newEReference1.eClass());
        Assert.assertEquals((long)31L, (long)contents.size());
        contents = eObjectServices.eAllContents(unused, newEReference1.eClass());
        Assert.assertEquals((long)1L, (long)contents.size());
        try {
            eObjectServices.eAllContents(null);
            Assert.fail((String)"The 'eClass' operation service must throw a NPE.");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @Test
    public void eAllContentFilteredSingleContainementFeature() {
        EPackage ePkg = EcorePackage.eINSTANCE.getEcoreFactory().createEPackage();
        ePkg.setName("testPackage");
        ePkg.setNsPrefix("testPackage");
        ePkg.setNsURI("testPackage");
        EClass eCls = EcorePackage.eINSTANCE.getEcoreFactory().createEClass();
        eCls.setName("TestCls");
        ePkg.getEClassifiers().add((Object)eCls);
        EReference reference = EcorePackage.eINSTANCE.getEcoreFactory().createEReference();
        reference.setName("testReference");
        reference.setContainment(true);
        reference.setEType((EClassifier)eCls);
        reference.setUpperBound(1);
        eCls.getEStructuralFeatures().add((Object)reference);
        EObject eObj1 = EcoreUtil.create((EClass)eCls);
        EObject eObj2 = EcoreUtil.create((EClass)eCls);
        EObject eObj3 = EcoreUtil.create((EClass)eCls);
        eObj1.eSet((EStructuralFeature)reference, (Object)eObj2);
        eObj2.eSet((EStructuralFeature)reference, (Object)eObj3);
        this.getQueryEnvironment().registerEPackage(ePkg);
        EObjectServices eObjectServices = new EObjectServices((IReadOnlyQueryEnvironment)this.getQueryEnvironment(), null, null);
        try {
            List result = eObjectServices.eAllContents(eObj1, eCls);
            Assert.assertEquals((long)2L, (long)result.size());
            Assert.assertEquals((Object)eObj2, result.get(0));
            Assert.assertEquals((Object)eObj3, result.get(1));
        }
        finally {
            this.getQueryEnvironment().removeEPackage(ePkg);
        }
    }

    @Test
    public void eAllContentFilteredMultiContainementFeature() {
        EPackage ePkg = EcorePackage.eINSTANCE.getEcoreFactory().createEPackage();
        ePkg.setName("testPackage");
        ePkg.setNsPrefix("testPackage");
        ePkg.setNsURI("testPackage");
        EClass eCls = EcorePackage.eINSTANCE.getEcoreFactory().createEClass();
        eCls.setName("TestCls");
        ePkg.getEClassifiers().add((Object)eCls);
        EReference reference = EcorePackage.eINSTANCE.getEcoreFactory().createEReference();
        reference.setName("testReference");
        reference.setContainment(true);
        reference.setEType((EClassifier)eCls);
        reference.setUpperBound(-1);
        eCls.getEStructuralFeatures().add((Object)reference);
        EObject eObj1 = EcoreUtil.create((EClass)eCls);
        EObject eObj2 = EcoreUtil.create((EClass)eCls);
        EObject eObj3 = EcoreUtil.create((EClass)eCls);
        EObject eObj4 = EcoreUtil.create((EClass)eCls);
        ((List)eObj1.eGet((EStructuralFeature)reference)).add(eObj2);
        ((List)eObj2.eGet((EStructuralFeature)reference)).add(eObj3);
        ((List)eObj2.eGet((EStructuralFeature)reference)).add(eObj4);
        this.getQueryEnvironment().registerEPackage(ePkg);
        EObjectServices eObjectServices = new EObjectServices((IReadOnlyQueryEnvironment)this.getQueryEnvironment(), null, null);
        try {
            List result = eObjectServices.eAllContents(eObj1, eCls);
            Assert.assertEquals((long)3L, (long)result.size());
            Assert.assertEquals((Object)eObj2, result.get(0));
            Assert.assertEquals((Object)eObj3, result.get(1));
            Assert.assertEquals((Object)eObj4, result.get(2));
        }
        finally {
            this.getQueryEnvironment().removeEPackage(ePkg);
        }
    }

    @Test
    public void testEGet() {
        EObject queries = (EObject)this.reverseModel.getContents().get(0);
        queries.eAllContents().next();
        EObject query = (EObject)queries.eAllContents().next();
        EObject resultExpectation = (EObject)query.eAllContents().next();
        EObject eObjectListResult = (EObject)resultExpectation.eAllContents().next();
        EObjectServices eObjectServices = new EObjectServices((IReadOnlyQueryEnvironment)this.getQueryEnvironment(), null, null);
        Assert.assertEquals(null, (Object)eObjectServices.eGet(queries, "name"));
        Assert.assertEquals(null, (Object)eObjectServices.eGet(query, "name"));
        Assert.assertEquals((Object)"[self/]", (Object)eObjectServices.eGet(query, "expression"));
        Assert.assertEquals(null, (Object)eObjectServices.eGet(eObjectListResult, "query"));
    }

    @Test
    public void testEGetFeature() {
        EObject queries = (EObject)this.reverseModel.getContents().get(0);
        queries.eAllContents().next();
        EObjectServices eObjectServices = new EObjectServices((IReadOnlyQueryEnvironment)this.getQueryEnvironment(), null, null);
        EStructuralFeature nameFeature = queries.eClass().getEStructuralFeature("name");
        Assert.assertEquals(null, (Object)eObjectServices.eGet(queries, nameFeature));
    }

    @Test
    public void testEGetFeatureResolve() {
        EObject queries = (EObject)this.reverseModel.getContents().get(0);
        queries.eAllContents().next();
        EObjectServices eObjectServices = new EObjectServices((IReadOnlyQueryEnvironment)this.getQueryEnvironment(), null, null);
        EStructuralFeature nameFeature = queries.eClass().getEStructuralFeature("name");
        Assert.assertEquals(null, (Object)eObjectServices.eGet(queries, nameFeature, true));
    }

    @Test
    public void testEGetEList() {
        Queries fullSiriusCodePackage = (Queries)this.reverseModel.getContents().get(0);
        this.getQueryEnvironment().registerEPackage((EPackage)QmodelPackage.eINSTANCE);
        EObjectServices eObjectServices = new EObjectServices((IReadOnlyQueryEnvironment)this.getQueryEnvironment(), null, null);
        Object queries = eObjectServices.eGet((EObject)fullSiriusCodePackage, "queries");
        Assert.assertTrue((boolean)(queries instanceof List));
        Assert.assertEquals((Object)fullSiriusCodePackage.getQueries(), (Object)queries);
        ((List)queries).clear();
        Assert.assertFalse((boolean)fullSiriusCodePackage.getQueries().isEmpty());
    }

    @Test
    public void testEGetEMap() {
        this.getQueryEnvironment().registerEPackage((EPackage)AnydslPackage.eINSTANCE);
        Restaurant restaurant = AnydslFactory.eINSTANCE.createRestaurant();
        EMap menu = restaurant.getMenu();
        menu.put((Object)"omelette", (Object)AnydslFactory.eINSTANCE.createRecipe());
        menu.put((Object)"kouign-amann", (Object)AnydslFactory.eINSTANCE.createRecipe());
        EObjectServices eObjectServices = new EObjectServices((IReadOnlyQueryEnvironment)this.getQueryEnvironment(), null, null);
        Object menuFromEGet = eObjectServices.eGet((EObject)restaurant, "menu");
        Assert.assertTrue((boolean)(menuFromEGet instanceof EMap));
        this.assertEqualEMaps(menu, (EMap)menuFromEGet);
        ((EMap)menuFromEGet).clear();
        Assert.assertFalse((boolean)menu.isEmpty());
        menu.clear();
        menuFromEGet = eObjectServices.eGet((EObject)restaurant, "menu");
        Assert.assertTrue((boolean)(menuFromEGet instanceof EMap));
        Assert.assertTrue((boolean)((EMap)menuFromEGet).isEmpty());
    }

    private void assertEqualEMaps(EMap<?, ?> map1, EMap<?, ?> map2) {
        Assert.assertEquals((long)map1.size(), (long)map2.size());
        for (Map.Entry entry : map2.entrySet()) {
            Assert.assertTrue((boolean)map1.containsKey(entry.getKey()));
            Assert.assertEquals((Object)map1.get(entry.getKey()), entry.getValue());
        }
    }

    @Test(expected=NullPointerException.class)
    public void testEGetNullFeature() {
        EObject queries = (EObject)this.reverseModel.getContents().get(0);
        EObjectServices eObjectServices = new EObjectServices((IReadOnlyQueryEnvironment)this.getQueryEnvironment(), null, null);
        eObjectServices.eGet(queries, null);
    }

    @Test(expected=NullPointerException.class)
    public void testEGetNullEObject() {
        EObjectServices eObjectServices = new EObjectServices((IReadOnlyQueryEnvironment)this.getQueryEnvironment(), null, null);
        eObjectServices.eGet(null, "query");
    }

    @Test(expected=NullPointerException.class)
    public void testEGetNullEObjectNullFeature() {
        EObjectServices eObjectServices = new EObjectServices((IReadOnlyQueryEnvironment)this.getQueryEnvironment(), null, null);
        eObjectServices.eGet(null, null);
    }

    @Test
    public void testAllInstancesNoRootProviderEClass() {
        this.getQueryEnvironment().registerEPackage((EPackage)EcorePackage.eINSTANCE);
        EObjectServices eObjectServices = new EObjectServices((IReadOnlyQueryEnvironment)this.getQueryEnvironment(), null, null);
        List result = eObjectServices.allInstances(EcorePackage.eINSTANCE.getEAttribute());
        Assert.assertEquals((long)0L, (long)result.size());
    }

    @Test
    public void testAllInstancesNoRootProviderSet() {
        this.getQueryEnvironment().registerEPackage((EPackage)EcorePackage.eINSTANCE);
        LinkedHashSet<EClass> types = new LinkedHashSet<EClass>();
        types.add(EcorePackage.eINSTANCE.getEAttribute());
        EObjectServices eObjectServices = new EObjectServices((IReadOnlyQueryEnvironment)this.getQueryEnvironment(), null, null);
        List result = eObjectServices.allInstances(types);
        Assert.assertEquals((long)0L, (long)result.size());
    }

    @Test
    public void testAllInstancesNoRootProviderNullEClass() {
        this.getQueryEnvironment().registerEPackage((EPackage)EcorePackage.eINSTANCE);
        EObjectServices eObjectServices = new EObjectServices((IReadOnlyQueryEnvironment)this.getQueryEnvironment(), null, null);
        List result = eObjectServices.allInstances(null);
        Assert.assertEquals((long)0L, (long)result.size());
    }

    @Test
    public void testAllInstancesNoRootProviderNullSet() {
        this.getQueryEnvironment().registerEPackage((EPackage)EcorePackage.eINSTANCE);
        EObjectServices eObjectServices = new EObjectServices((IReadOnlyQueryEnvironment)this.getQueryEnvironment(), null, null);
        List result = eObjectServices.allInstances(null);
        Assert.assertEquals((long)0L, (long)result.size());
    }

    @Test
    public void testAllInstancesEClass() {
        this.getQueryEnvironment().registerEPackage((EPackage)EcorePackage.eINSTANCE);
        EObjectServices eObjectServices = new EObjectServices((IReadOnlyQueryEnvironment)this.getQueryEnvironment(), null, (IRootEObjectProvider)new RootEObjectProvider(new EObject[]{EcorePackage.eINSTANCE, AnydslPackage.eINSTANCE}));
        List result = eObjectServices.allInstances(EcorePackage.eINSTANCE.getEAttribute());
        Assert.assertEquals((long)46L, (long)result.size());
    }

    @Test
    public void testAllInstancesEClassKeepRootElement() {
        this.getQueryEnvironment().registerEPackage((EPackage)EcorePackage.eINSTANCE);
        EObjectServices eObjectServices = new EObjectServices((IReadOnlyQueryEnvironment)this.getQueryEnvironment(), null, (IRootEObjectProvider)new RootEObjectProvider(new EObject[]{EcorePackage.eINSTANCE, AnydslPackage.eINSTANCE}));
        List result = eObjectServices.allInstances(EcorePackage.eINSTANCE.getEPackage());
        Assert.assertEquals((long)2L, (long)result.size());
        Assert.assertEquals((Object)EcorePackage.eINSTANCE, result.get(0));
        Assert.assertEquals((Object)AnydslPackage.eINSTANCE, result.get(1));
    }

    @Test
    public void testAllInstancesSet() {
        this.getQueryEnvironment().registerEPackage((EPackage)EcorePackage.eINSTANCE);
        EObjectServices eObjectServices = new EObjectServices((IReadOnlyQueryEnvironment)this.getQueryEnvironment(), null, (IRootEObjectProvider)new RootEObjectProvider(new EObject[]{EcorePackage.eINSTANCE, AnydslPackage.eINSTANCE}));
        LinkedHashSet<EClass> types = new LinkedHashSet<EClass>();
        types.add(EcorePackage.eINSTANCE.getEAttribute());
        types.add(EcorePackage.eINSTANCE.getEReference());
        List result = eObjectServices.allInstances(types);
        Assert.assertEquals((long)113L, (long)result.size());
    }

    @Test
    public void testAllInstancesNullEClass() {
        this.getQueryEnvironment().registerEPackage((EPackage)EcorePackage.eINSTANCE);
        EObjectServices eObjectServices = new EObjectServices((IReadOnlyQueryEnvironment)this.getQueryEnvironment(), null, (IRootEObjectProvider)new RootEObjectProvider(new EObject[]{EcorePackage.eINSTANCE, AnydslPackage.eINSTANCE}));
        List result = eObjectServices.allInstances(null);
        Assert.assertEquals((long)0L, (long)result.size());
    }

    @Test
    public void testAllInstancesNullSet() {
        this.getQueryEnvironment().registerEPackage((EPackage)EcorePackage.eINSTANCE);
        EObjectServices eObjectServices = new EObjectServices((IReadOnlyQueryEnvironment)this.getQueryEnvironment(), null, (IRootEObjectProvider)new RootEObjectProvider(new EObject[]{EcorePackage.eINSTANCE, AnydslPackage.eINSTANCE}));
        List result = eObjectServices.allInstances(null);
        Assert.assertEquals((long)0L, (long)result.size());
    }

    @Test
    public void aqlFeatureAccessNullNull() {
        this.getQueryEnvironment().registerEPackage((EPackage)EcorePackage.eINSTANCE);
        EObjectServices eObjectServices = new EObjectServices((IReadOnlyQueryEnvironment)this.getQueryEnvironment(), null, null);
        Object result = eObjectServices.aqlFeatureAccess(null, null);
        Assert.assertNull((Object)result);
    }

    @Test
    public void aqlFeatureAccessNullName() {
        this.getQueryEnvironment().registerEPackage((EPackage)EcorePackage.eINSTANCE);
        EObjectServices eObjectServices = new EObjectServices((IReadOnlyQueryEnvironment)this.getQueryEnvironment(), null, null);
        Object result = eObjectServices.aqlFeatureAccess(null, "feature");
        Assert.assertNull((Object)result);
    }

    @Test
    public void aqlFeatureAccessEObjectNull() {
        this.getQueryEnvironment().registerEPackage((EPackage)EcorePackage.eINSTANCE);
        EObjectServices eObjectServices = new EObjectServices((IReadOnlyQueryEnvironment)this.getQueryEnvironment(), null, null);
        Object result = eObjectServices.aqlFeatureAccess((EObject)EcorePackage.eINSTANCE, null);
        Assert.assertTrue((boolean)(result instanceof Nothing));
        Assert.assertEquals((Object)"Feature null not found in EClass EPackage", (Object)((Nothing)result).getMessage());
    }

    @Test
    public void aqlFeatureAccessEObjectNotExistingFeature() {
        this.getQueryEnvironment().registerEPackage((EPackage)EcorePackage.eINSTANCE);
        EObjectServices eObjectServices = new EObjectServices((IReadOnlyQueryEnvironment)this.getQueryEnvironment(), null, null);
        Object result = eObjectServices.aqlFeatureAccess((EObject)EcorePackage.eINSTANCE, "notExistingFeature");
        Assert.assertTrue((boolean)(result instanceof Nothing));
        Assert.assertEquals((Object)"Feature notExistingFeature not found in EClass EPackage", (Object)((Nothing)result).getMessage());
    }

    @Test
    public void aqlFeatureAccess() {
        this.getQueryEnvironment().registerEPackage((EPackage)EcorePackage.eINSTANCE);
        EObjectServices eObjectServices = new EObjectServices((IReadOnlyQueryEnvironment)this.getQueryEnvironment(), null, null);
        Object result = eObjectServices.aqlFeatureAccess((EObject)EcorePackage.eINSTANCE, "name");
        Assert.assertEquals((Object)"ecore", (Object)result);
    }

    @Test
    public void eAllContentsNotContainedSuperClassFilter() {
        this.getQueryEnvironment().registerEPackage((EPackage)EcorePackage.eINSTANCE);
        this.getQueryEnvironment().registerEPackage((EPackage)ContainerPackage.eINSTANCE);
        EObjectServices eObjectServices = new EObjectServices((IReadOnlyQueryEnvironment)this.getQueryEnvironment(), null, null);
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        resourceSet.getResourceFactoryRegistry().getExtensionToFactoryMap().put("xmi", new XMIResourceFactoryImpl());
        Resource resource = resourceSet.getResource(URI.createURI((String)"resources/container/container.xmi"), true);
        EObject root = (EObject)resource.getContents().get(0);
        List result = eObjectServices.eAllContents(root, ContainerPackage.eINSTANCE.getAbstract());
        Assert.assertEquals((long)1L, (long)result.size());
        Assert.assertEquals((Object)ContainerPackage.eINSTANCE.getConcrete(), (Object)((EObject)result.get(0)).eClass());
    }
}

