/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.query.services.tests;

import java.lang.reflect.InvocationTargetException;
import java.util.LinkedHashSet;
import java.util.Properties;
import java.util.Set;
import org.eclipse.acceleo.query.runtime.ILookupEngine;
import org.eclipse.acceleo.query.runtime.IQueryEnvironment;
import org.eclipse.acceleo.query.runtime.IReadOnlyQueryEnvironment;
import org.eclipse.acceleo.query.runtime.IService;
import org.eclipse.acceleo.query.runtime.Query;
import org.eclipse.acceleo.query.runtime.ServiceUtils;
import org.eclipse.acceleo.query.runtime.impl.ValidationServices;
import org.eclipse.acceleo.query.services.AnyServices;
import org.eclipse.acceleo.query.services.BooleanServices;
import org.eclipse.acceleo.query.services.CollectionServices;
import org.eclipse.acceleo.query.services.ComparableServices;
import org.eclipse.acceleo.query.services.EObjectServices;
import org.eclipse.acceleo.query.services.NumberServices;
import org.eclipse.acceleo.query.services.PromptServices;
import org.eclipse.acceleo.query.services.PropertiesServices;
import org.eclipse.acceleo.query.services.ResourceServices;
import org.eclipse.acceleo.query.services.StringServices;
import org.eclipse.acceleo.query.services.XPathServices;
import org.eclipse.acceleo.query.validation.type.ClassType;
import org.eclipse.acceleo.query.validation.type.IType;
import org.junit.Assert;
import org.junit.Before;

public abstract class AbstractServicesTest {
    private ILookupEngine lookupEngine;
    private IQueryEnvironment queryEnvironment;
    private ValidationServices validationServices;

    @Before
    public void before() throws Exception {
        this.queryEnvironment = Query.newEnvironment();
        Set services = ServiceUtils.getServices((IReadOnlyQueryEnvironment)this.queryEnvironment, (Object)new AnyServices((IReadOnlyQueryEnvironment)this.queryEnvironment));
        ServiceUtils.registerServices((IQueryEnvironment)this.queryEnvironment, (Set)services);
        services = ServiceUtils.getServices((IReadOnlyQueryEnvironment)this.queryEnvironment, (Object)new EObjectServices((IReadOnlyQueryEnvironment)this.queryEnvironment, null, null));
        ServiceUtils.registerServices((IQueryEnvironment)this.queryEnvironment, (Set)services);
        services = ServiceUtils.getServices((IReadOnlyQueryEnvironment)this.queryEnvironment, (Object)new XPathServices((IReadOnlyQueryEnvironment)this.queryEnvironment));
        ServiceUtils.registerServices((IQueryEnvironment)this.queryEnvironment, (Set)services);
        services = ServiceUtils.getServices((IReadOnlyQueryEnvironment)this.queryEnvironment, ComparableServices.class);
        ServiceUtils.registerServices((IQueryEnvironment)this.queryEnvironment, (Set)services);
        services = ServiceUtils.getServices((IReadOnlyQueryEnvironment)this.queryEnvironment, NumberServices.class);
        ServiceUtils.registerServices((IQueryEnvironment)this.queryEnvironment, (Set)services);
        services = ServiceUtils.getServices((IReadOnlyQueryEnvironment)this.queryEnvironment, StringServices.class);
        ServiceUtils.registerServices((IQueryEnvironment)this.queryEnvironment, (Set)services);
        services = ServiceUtils.getServices((IReadOnlyQueryEnvironment)this.queryEnvironment, BooleanServices.class);
        ServiceUtils.registerServices((IQueryEnvironment)this.queryEnvironment, (Set)services);
        services = ServiceUtils.getServices((IReadOnlyQueryEnvironment)this.queryEnvironment, CollectionServices.class);
        ServiceUtils.registerServices((IQueryEnvironment)this.queryEnvironment, (Set)services);
        services = ServiceUtils.getServices((IReadOnlyQueryEnvironment)this.queryEnvironment, ResourceServices.class);
        ServiceUtils.registerServices((IQueryEnvironment)this.queryEnvironment, (Set)services);
        services = ServiceUtils.getServices((IReadOnlyQueryEnvironment)this.queryEnvironment, PromptServices.class);
        ServiceUtils.registerServices((IQueryEnvironment)this.queryEnvironment, (Set)services);
        services = ServiceUtils.getServices((IReadOnlyQueryEnvironment)this.queryEnvironment, (Object)new PropertiesServices(new Properties()));
        ServiceUtils.registerServices((IQueryEnvironment)this.queryEnvironment, (Set)services);
        this.lookupEngine = this.queryEnvironment.getLookupEngine();
        this.validationServices = new ValidationServices((IReadOnlyQueryEnvironment)this.queryEnvironment);
    }

    public ILookupEngine getLookupEngine() {
        return this.lookupEngine;
    }

    public IQueryEnvironment getQueryEnvironment() {
        return this.queryEnvironment;
    }

    public void setQueryEnvironment(IQueryEnvironment queryEnvironment) {
        this.queryEnvironment = queryEnvironment;
        this.lookupEngine = queryEnvironment.getLookupEngine();
        this.validationServices = new ValidationServices((IReadOnlyQueryEnvironment)queryEnvironment);
    }

    public ValidationServices getValidationServices() {
        return this.validationServices;
    }

    protected void runTest(String serviceName, Object expectedResult, Object[] arguments) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        IService<?> service = this.serviceLookUp(serviceName, arguments);
        Assert.assertTrue((service != null ? 1 : 0) != 0);
        Assert.assertEquals((Object)expectedResult, (Object)service.invoke(arguments));
    }

    protected Set<IType> createTypeSet(IType ... types) {
        LinkedHashSet<IType> result = new LinkedHashSet<IType>();
        IType[] iTypeArray = types;
        int n = types.length;
        int n2 = 0;
        while (n2 < n) {
            IType type = iTypeArray[n2];
            result.add(type);
            ++n2;
        }
        return result;
    }

    protected IService<?> serviceLookUp(String serviceName, Object[] arguments) {
        IType[] argTypes = new IType[arguments.length];
        int i = 0;
        while (i < arguments.length) {
            argTypes[i] = new ClassType((IReadOnlyQueryEnvironment)this.queryEnvironment, arguments[i].getClass());
            ++i;
        }
        IService service = this.lookupEngine.lookup(serviceName, argTypes);
        return service;
    }
}

