/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.query.parser.tests;

import org.eclipse.acceleo.query.ast.ASTNode;
import org.eclipse.acceleo.query.ast.Or;
import org.eclipse.acceleo.query.ast.VarRef;
import org.eclipse.acceleo.query.ast.VariableDeclaration;
import org.eclipse.acceleo.query.parser.AstResult;
import org.eclipse.acceleo.query.runtime.IQueryEnvironment;
import org.eclipse.acceleo.query.runtime.Query;
import org.eclipse.acceleo.query.runtime.impl.QueryBuilderEngine;
import org.eclipse.acceleo.query.tests.anydsl.AnydslPackage;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EcorePackage;
import org.junit.Assert;
import org.junit.Test;

public class PositionsTests {
    private final QueryBuilderEngine engine;
    private final IQueryEnvironment queryEnvironment = Query.newEnvironmentWithDefaultServices(null);

    public PositionsTests() {
        this.queryEnvironment.registerEPackage((EPackage)EcorePackage.eINSTANCE);
        this.queryEnvironment.registerEPackage((EPackage)AnydslPackage.eINSTANCE);
        this.engine = new QueryBuilderEngine();
    }

    @Test(expected=IllegalArgumentException.class)
    public void getNodeAtPositionOutOfRange() {
        AstResult build = this.engine.build("a or b");
        build.getAstNode(10);
    }

    @Test(expected=IllegalArgumentException.class)
    public void getNodeAtLineColumnOutOfRange() {
        AstResult build = this.engine.build("a or b");
        build.getAstNode(1, 0);
    }

    @Test
    public void getNodeAtPosition() {
        AstResult build = this.engine.build("a or b");
        ASTNode node = build.getAstNode(0);
        Assert.assertTrue((boolean)(node instanceof VarRef));
        Assert.assertEquals((Object)"a", (Object)((VarRef)node).getVariableName());
        node = build.getAstNode(3);
        Assert.assertTrue((boolean)(node instanceof Or));
        node = build.getAstNode(6);
        Assert.assertTrue((boolean)(node instanceof VarRef));
        Assert.assertEquals((Object)"b", (Object)((VarRef)node).getVariableName());
    }

    @Test
    public void getNodeAtPositionLambdaVariableDeclaration() {
        AstResult build = this.engine.build("self->select(aaa | aaa.name = '')");
        ASTNode node = build.getAstNode(14);
        Assert.assertTrue((boolean)(node instanceof VariableDeclaration));
        Assert.assertEquals((Object)"aaa", (Object)((VariableDeclaration)node).getName());
    }
}

