/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.aql.profiler.editor.coverage;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.acceleo.AcceleoASTNode;
import org.eclipse.acceleo.Block;
import org.eclipse.acceleo.Comment;
import org.eclipse.acceleo.CommentBody;
import org.eclipse.acceleo.Import;
import org.eclipse.acceleo.Module;
import org.eclipse.acceleo.ModuleReference;
import org.eclipse.acceleo.Variable;
import org.eclipse.acceleo.aql.parser.AcceleoAstResult;
import org.eclipse.acceleo.aql.profiler.ProfileEntry;
import org.eclipse.acceleo.aql.profiler.ProfileResource;
import org.eclipse.acceleo.aql.profiler.editor.AcceleoEnvResourceFactory;
import org.eclipse.acceleo.query.ast.ASTNode;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.AnnotationModel;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.IAnnotationModelExtension;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;

public class CoverageHelper {
    private static final String FULL_COVERAGE_ANNOTATION_ID = "org.eclipse.acceleo.aql.fullCoverageAnnotation";
    private static final String NO_COVERAGE_ANNOTATION_ID = "org.eclipse.acceleo.aql.noCoverageAnnotation";
    private ProfileResource profileResource;
    private Map<Module, CoverageReport> cache;
    private Set<ITextEditor> textEditors;

    public CoverageHelper(ProfileResource profileResource, AcceleoEnvResourceFactory resourceFactory) {
        this.profileResource = profileResource;
        this.textEditors = new HashSet<ITextEditor>();
        this.cache = new HashMap<Module, CoverageReport>();
    }

    public int computeUsage(Module module) {
        CoverageReport report = this.getCoverageReport(module);
        return report.usedElements.size() * 100 / report.allElements.size();
    }

    private CoverageReport getCoverageReport(Module module) {
        CoverageReport report = this.cache.get(module);
        if (report == null) {
            report = new CoverageReport();
            report.allElements = new HashSet<EObject>();
            TreeIterator iterator = module.eAllContents();
            while (iterator.hasNext()) {
                EObject moduleElement = (EObject)iterator.next();
                if (!CoverageHelper.isRelevant(moduleElement)) continue;
                report.allElements.add(moduleElement);
            }
            report.usedElements = new HashSet<EObject>();
            iterator = this.profileResource.eAllContents();
            while (iterator.hasNext()) {
                EObject monitored;
                EObject profileEntry = (EObject)iterator.next();
                if (!(profileEntry instanceof ProfileEntry) || !report.allElements.contains(monitored = ((ProfileEntry)profileEntry).getMonitored())) continue;
                report.usedElements.add(monitored);
            }
        }
        return report;
    }

    private static boolean isRelevant(EObject moduleElement) {
        return moduleElement instanceof AcceleoASTNode && !(moduleElement instanceof Comment) && !(moduleElement instanceof CommentBody) && !(moduleElement instanceof Import) && !(moduleElement instanceof ModuleReference) && !(moduleElement instanceof Block) && !(moduleElement instanceof Variable);
    }

    public void attach(ITextEditor editor, Module module) {
        IDocumentProvider provider = editor.getDocumentProvider();
        if (provider == null) {
            return;
        }
        IAnnotationModel model = provider.getAnnotationModel((Object)editor.getEditorInput());
        if (!(model instanceof IAnnotationModelExtension)) {
            return;
        }
        IAnnotationModelExtension modelex = (IAnnotationModelExtension)model;
        modelex.removeAnnotationModel(this.getClass());
        modelex.addAnnotationModel(this.getClass(), this.createAnnotationModel(module));
        this.textEditors.add(editor);
    }

    private IAnnotationModel createAnnotationModel(Module module) {
        AnnotationModel res = new AnnotationModel();
        AcceleoAstResult astResult = module.getAst();
        CoverageReport report = this.getCoverageReport(module);
        for (EObject element : report.allElements) {
            if (!(element instanceof AcceleoASTNode)) continue;
            AcceleoASTNode astNode = (AcceleoASTNode)element;
            int offset = astResult.getStartPosition((ASTNode)astNode);
            int length = astResult.getEndPosition((ASTNode)astNode) - offset;
            if (offset <= 0 || length <= 0) continue;
            Position position = new Position(offset, length);
            if (report.usedElements.contains(element)) {
                res.addAnnotation(new Annotation(FULL_COVERAGE_ANNOTATION_ID, false, null), position);
                continue;
            }
            res.addAnnotation(new Annotation(NO_COVERAGE_ANNOTATION_ID, false, null), position);
        }
        return res;
    }

    public void clearAnnotations() {
        for (ITextEditor editor : this.textEditors) {
            IDocumentProvider provider = editor.getDocumentProvider();
            if (provider == null) {
                return;
            }
            IAnnotationModel model = provider.getAnnotationModel((Object)editor.getEditorInput());
            if (!(model instanceof IAnnotationModelExtension)) {
                return;
            }
            IAnnotationModelExtension modelex = (IAnnotationModelExtension)model;
            modelex.removeAnnotationModel(this.getClass());
            modelex.addAnnotationModel(this.getClass(), (IAnnotationModel)new AnnotationModel());
        }
    }

    private class CoverageReport {
        Set<EObject> allElements;
        Set<EObject> usedElements;

        private CoverageReport() {
        }
    }
}

