/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.query.ide.jdt.runtime.impl.namespace.workspace;

import java.util.LinkedHashSet;
import java.util.Set;
import org.eclipse.acceleo.query.ide.jdt.Activator;
import org.eclipse.acceleo.query.ide.runtime.namespace.workspace.IWorkspaceResolverProvider;
import org.eclipse.acceleo.query.runtime.impl.namespace.workspace.QueryWorkspaceQualifiedNameResolver;
import org.eclipse.acceleo.query.runtime.namespace.IQualifiedNameResolver;
import org.eclipse.acceleo.query.runtime.namespace.workspace.IQueryWorkspaceQualifiedNameResolver;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;

public class EclipseJDTWorkspaceQualifiedNameResolver
extends QueryWorkspaceQualifiedNameResolver {
    private final IJavaProject javaProject;
    private final IWorkspaceResolverProvider resolverProvider;

    public EclipseJDTWorkspaceQualifiedNameResolver(IProject project, IQualifiedNameResolver resolver, IWorkspaceResolverProvider resolverProvider) {
        super(resolver);
        this.javaProject = JavaCore.create((IProject)project);
        this.resolverProvider = resolverProvider;
    }

    protected Set<IQueryWorkspaceQualifiedNameResolver> getDependencies() {
        LinkedHashSet<IQueryWorkspaceQualifiedNameResolver> res = new LinkedHashSet<IQueryWorkspaceQualifiedNameResolver>();
        try {
            IClasspathEntry[] iClasspathEntryArray = this.javaProject.getResolvedClasspath(true);
            int n = iClasspathEntryArray.length;
            int n2 = 0;
            while (n2 < n) {
                IProject dependencyProject;
                IQueryWorkspaceQualifiedNameResolver resolver;
                IClasspathEntry entry = iClasspathEntryArray[n2];
                if (entry.getEntryKind() == 2 && (resolver = this.resolverProvider.getResolver(dependencyProject = ResourcesPlugin.getWorkspace().getRoot().getProject(entry.getPath().lastSegment()))) != null) {
                    res.add(resolver);
                }
                ++n2;
            }
        }
        catch (JavaModelException e) {
            Activator.INSTANCE.log(new Status(4, "org.eclipse.acceleo.aql.ide.jdt", "couldn't resolve project dependencies", (Throwable)e));
        }
        return res;
    }

    public Set<IQueryWorkspaceQualifiedNameResolver> getResolversDependOn() {
        LinkedHashSet<IQueryWorkspaceQualifiedNameResolver> res = new LinkedHashSet<IQueryWorkspaceQualifiedNameResolver>();
        IProject[] iProjectArray = this.javaProject.getProject().getReferencingProjects();
        int n = iProjectArray.length;
        int n2 = 0;
        while (n2 < n) {
            IQueryWorkspaceQualifiedNameResolver resolver;
            IProject project = iProjectArray[n2];
            if (project.exists() && (resolver = this.resolverProvider.getResolver(project)) != null) {
                res.add(resolver);
            }
            ++n2;
        }
        return res;
    }
}

