/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.query.cdo;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.acceleo.query.cdo.ShellCredentialsProvider;
import org.eclipse.emf.cdo.common.branch.CDOBranch;
import org.eclipse.emf.cdo.common.branch.CDOBranchHandler;
import org.eclipse.emf.cdo.eresource.CDOResource;
import org.eclipse.emf.cdo.net4j.CDONet4jSession;
import org.eclipse.emf.cdo.net4j.CDONet4jSessionConfiguration;
import org.eclipse.emf.cdo.net4j.CDONet4jUtil;
import org.eclipse.emf.cdo.session.CDOSession;
import org.eclipse.emf.cdo.transaction.CDOTransaction;
import org.eclipse.emf.cdo.view.CDOView;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.net4j.Net4jUtil;
import org.eclipse.net4j.connector.ConnectorException;
import org.eclipse.net4j.connector.IConnector;
import org.eclipse.net4j.tcp.TCPUtil;
import org.eclipse.net4j.util.container.ContainerUtil;
import org.eclipse.net4j.util.container.IManagedContainer;
import org.eclipse.net4j.util.lifecycle.LifecycleUtil;
import org.eclipse.net4j.util.security.IPasswordCredentialsProvider;
import org.eclipse.net4j.util.security.PasswordCredentialsProvider;
import org.eclipse.net4j.util.ui.security.InteractiveCredentialsProvider;
import org.eclipse.swt.SWT;

public final class AqlCDOUtils {
    public static final String PLUGIN_ID = "org.obeonetwork.m2doc.cdo";
    public static final String CDO_SERVER_OPTION = "CDOServer";
    public static final String CDO_REPOSITORY_OPTION = "CDORepository";
    public static final String CDO_BRANCH_OPTION = "CDOBranch";
    public static final String CDO_LOGIN_OPTION = "CDOLogin";
    public static final String CDO_PASSWORD_OPTION = "CDOPassword";

    private AqlCDOUtils() {
    }

    public static IConnector getConnector(String description) {
        IManagedContainer container = AqlCDOUtils.getContainer(description);
        IConnector res = null;
        try {
            res = Net4jUtil.getConnector((IManagedContainer)container, (String)description);
        }
        catch (ConnectorException e) {
            LifecycleUtil.deactivate((Object)container);
            throw e;
        }
        return res;
    }

    public static CDOSession openSession(IConnector connector, String repository) {
        return AqlCDOUtils.openSession(connector, repository, null, null);
    }

    public static CDOSession openSession(IConnector connector, String repository, String login, String password) {
        CDONet4jSessionConfiguration sessionConfiguration = CDONet4jUtil.createNet4jSessionConfiguration();
        sessionConfiguration.setConnector(connector);
        sessionConfiguration.setRepositoryName(repository);
        if (login != null) {
            String pass = password != null ? password : "";
            sessionConfiguration.setCredentialsProvider((IPasswordCredentialsProvider)new PasswordCredentialsProvider(login, pass.toCharArray()));
        } else {
            Object credentialsProvider = SWT.isLoadable() ? new InteractiveCredentialsProvider() : new ShellCredentialsProvider();
            sessionConfiguration.setCredentialsProvider((IPasswordCredentialsProvider)credentialsProvider);
        }
        CDONet4jSession res = sessionConfiguration.openNet4jSession();
        return res;
    }

    public static CDOTransaction openTransaction(CDOSession session) {
        return AqlCDOUtils.openTransaction(session, null);
    }

    public static CDOTransaction openTransaction(CDOSession session, String branchName) {
        CDOBranch branch;
        CDOTransaction res = branchName != null ? ((branch = session.getBranchManager().getBranch(branchName)) != null ? session.openTransaction(branch) : session.openTransaction()) : session.openTransaction();
        return res;
    }

    public static List<CDOResource> getResources(CDOView view) {
        ArrayList<CDOResource> res = new ArrayList<CDOResource>();
        for (EObject eObj : view.getRootResource().eContents()) {
            res.add((CDOResource)eObj);
        }
        return res;
    }

    public static List<CDOBranch> getBranches(CDOSession session) {
        final ArrayList<CDOBranch> res = new ArrayList<CDOBranch>();
        session.getBranchManager().getBranches(Integer.MIN_VALUE, Integer.MAX_VALUE, new CDOBranchHandler(){

            public void handleBranch(CDOBranch branch) {
                res.add(branch);
            }
        });
        return res;
    }

    private static IManagedContainer getContainer(String description) {
        IManagedContainer res = ContainerUtil.createContainer();
        Net4jUtil.prepareContainer((IManagedContainer)res);
        CDONet4jUtil.prepareContainer((IManagedContainer)res);
        TCPUtil.prepareContainer((IManagedContainer)res);
        res.activate();
        return res;
    }
}

