/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.query.tests;

import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Collections;
import org.eclipse.acceleo.query.tests.Setup;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;

public class UnitTestModels {
    private Setup setup;
    private ResourceSet set;

    public UnitTestModels(Setup setupToUse) {
        this.setup = setupToUse;
    }

    public Resource reverse() throws URISyntaxException, IOException {
        String localPath = "ecore/reverse.qmodel";
        return this.loadResource(localPath);
    }

    public Resource reverseEcore() throws URISyntaxException, IOException {
        String localPath = "ecore/reverse.ecore";
        return this.loadResource(localPath);
    }

    public Resource anydsl() throws URISyntaxException, IOException {
        String localPath = "anydsl/anyDSLModel.qmodel";
        return this.loadResource(localPath);
    }

    public Resource uml() throws URISyntaxException, IOException {
        String localPath = "uml/uml.qmodel";
        return this.loadResource(localPath);
    }

    public Resource umlWithFragment() throws URISyntaxException, IOException {
        String localPath = "fragmented/container.uml";
        return this.loadResource(localPath);
    }

    private Resource loadResource(String localPath) throws URISyntaxException, IOException {
        this.set = this.setup.newConfiguredResourceSet();
        URL url = this.getClass().getClassLoader().getResource(localPath);
        URI uri = URI.createURI((String)url.toURI().toString());
        Resource res = this.set.getResource(uri, true);
        res.load(Collections.EMPTY_MAP);
        return res;
    }

    public ResourceSet getResourceSet() {
        return this.set;
    }
}

