/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.query.tests;

import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.acceleo.query.parser.AstEvaluator;
import org.eclipse.acceleo.query.parser.AstResult;
import org.eclipse.acceleo.query.parser.AstValidator;
import org.eclipse.acceleo.query.runtime.EvaluationResult;
import org.eclipse.acceleo.query.runtime.IQueryEnvironment;
import org.eclipse.acceleo.query.runtime.IReadOnlyQueryEnvironment;
import org.eclipse.acceleo.query.runtime.IValidationMessage;
import org.eclipse.acceleo.query.runtime.IValidationResult;
import org.eclipse.acceleo.query.runtime.ServiceUtils;
import org.eclipse.acceleo.query.runtime.impl.EvaluationServices;
import org.eclipse.acceleo.query.runtime.impl.QueryBuilderEngine;
import org.eclipse.acceleo.query.runtime.impl.ValidationServices;
import org.eclipse.acceleo.query.services.tests.AbstractEngineInitializationWithCrossReferencer;
import org.eclipse.acceleo.query.tests.InterpreterUnderTest;
import org.eclipse.acceleo.query.tests.anydsl.AnydslPackage;
import org.eclipse.acceleo.query.tests.qmodel.EObjectVariable;
import org.eclipse.acceleo.query.tests.qmodel.QmodelPackage;
import org.eclipse.acceleo.query.tests.qmodel.Query;
import org.eclipse.acceleo.query.tests.qmodel.QueryEvaluationResult;
import org.eclipse.acceleo.query.tests.qmodel.QueryEvaluationResultFactory;
import org.eclipse.acceleo.query.tests.qmodel.QueryValidationResult;
import org.eclipse.acceleo.query.tests.qmodel.Severity;
import org.eclipse.acceleo.query.tests.qmodel.ValidationMessage;
import org.eclipse.acceleo.query.tests.qmodel.Variable;
import org.eclipse.acceleo.query.tests.qmodel.util.QmodelSwitch;
import org.eclipse.acceleo.query.validation.type.EClassifierType;
import org.eclipse.acceleo.query.validation.type.IType;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.impl.EStringToStringMapEntryImpl;
import org.eclipse.uml2.types.TypesPackage;
import org.eclipse.uml2.uml.UMLPackage;

public class AcceleoQueryInterpreter
extends AbstractEngineInitializationWithCrossReferencer
implements InterpreterUnderTest {
    private Logger logger = Logger.getLogger("AcceleoQueryInterpreter");
    private final String expressionToEvaluate;
    private final EObject startingPoint;
    private final Map<String, Object> variables;
    private AstResult astResult;
    private final QmodelSwitch<EObject> varValueSwitch = new QmodelSwitch<EObject>(){

        public EObject caseVariable(Variable object) {
            throw new UnsupportedOperationException("Unsupported variable kind in Query tests: " + object.eClass().getName());
        }

        public EObject caseEObjectVariable(EObjectVariable object) {
            return object.getValue().getTarget();
        }
    };
    private final QmodelSwitch<Set<IType>> varTypeSwitch = new QmodelSwitch<Set<IType>>(){

        public Set<IType> caseVariable(Variable object) {
            throw new UnsupportedOperationException("Unsupported variable kind in Query tests: " + object.eClass().getName());
        }

        public Set<IType> caseEObjectVariable(EObjectVariable object) {
            LinkedHashSet<IType> types = new LinkedHashSet<IType>();
            types.add((IType)new EClassifierType((IReadOnlyQueryEnvironment)AcceleoQueryInterpreter.this.queryEnvironment, (EClassifier)object.getValue().getTarget().eClass()));
            return types;
        }
    };

    public AcceleoQueryInterpreter(Query q) {
        this.expressionToEvaluate = this.stripQuery(q.getExpression());
        this.startingPoint = q.getStartingPoint().getTarget();
        this.setQueryEnvironnementWithCrossReferencer(this.startingPoint);
        this.queryEnvironment.registerEPackage((EPackage)EcorePackage.eINSTANCE);
        this.queryEnvironment.registerEPackage((EPackage)AnydslPackage.eINSTANCE);
        this.queryEnvironment.registerCustomClassMapping((EClassifier)EcorePackage.eINSTANCE.getEStringToStringMapEntry(), EStringToStringMapEntryImpl.class);
        this.queryEnvironment.registerEPackage((EPackage)UMLPackage.eINSTANCE);
        this.queryEnvironment.registerEPackage((EPackage)TypesPackage.eINSTANCE);
        for (String classToImport : q.getClassesToImport()) {
            try {
                Set services = ServiceUtils.getServices((IReadOnlyQueryEnvironment)this.getQueryEnvironment(), Class.forName(classToImport));
                ServiceUtils.registerServices((IQueryEnvironment)this.queryEnvironment, (Set)services);
            }
            catch (ClassNotFoundException e) {
                this.logger.log(Level.WARNING, "couldn't register class " + classToImport, e);
            }
        }
        this.variables = new HashMap<String, Object>();
        this.variables.put("self", this.startingPoint);
        for (Variable var : q.getVariables()) {
            this.variables.put(var.getName(), this.varValueSwitch.doSwitch((EObject)var));
        }
    }

    private String stripQuery(String query) {
        if (query.startsWith("[")) {
            return query.substring(1, query.length() - 2);
        }
        return query;
    }

    @Override
    public void compileQuery(Query query) {
        AstResult build;
        QueryBuilderEngine builder = new QueryBuilderEngine();
        this.astResult = build = builder.build(this.expressionToEvaluate);
    }

    @Override
    public QueryEvaluationResult computeQuery(Query query) {
        AstEvaluator evaluator = new AstEvaluator(new EvaluationServices((IReadOnlyQueryEnvironment)this.queryEnvironment));
        EvaluationResult result = evaluator.eval(this.variables, this.astResult.getAst());
        QueryEvaluationResultFactory factory = new QueryEvaluationResultFactory();
        return factory.createFromValue((Object)result);
    }

    @Override
    public QueryValidationResult validateQuery(Query q) {
        for (String classToImport : q.getClassesToImport()) {
            try {
                Set services = ServiceUtils.getServices((IReadOnlyQueryEnvironment)this.getQueryEnvironment(), Class.forName(classToImport));
                ServiceUtils.registerServices((IQueryEnvironment)this.queryEnvironment, (Set)services);
            }
            catch (ClassNotFoundException e) {
                this.logger.log(Level.WARNING, "couldn't register class " + classToImport, e);
            }
        }
        HashMap<String, Set> variableTypes = new HashMap<String, Set>();
        LinkedHashSet<EClassifierType> startingTypes = new LinkedHashSet<EClassifierType>();
        startingTypes.add(new EClassifierType((IReadOnlyQueryEnvironment)this.queryEnvironment, (EClassifier)this.startingPoint.eClass()));
        variableTypes.put("self", startingTypes);
        for (Variable var : q.getVariables()) {
            variableTypes.put(var.getName(), (Set)this.varTypeSwitch.doSwitch((EObject)var));
        }
        AstValidator validator = new AstValidator(new ValidationServices((IReadOnlyQueryEnvironment)this.queryEnvironment));
        return this.transformResult(q, validator.validate(variableTypes, this.astResult));
    }

    private QueryValidationResult transformResult(Query query, IValidationResult validationResult) {
        QueryValidationResult result = QmodelPackage.eINSTANCE.getQmodelFactory().createQueryValidationResult();
        result.setInterpreter("aql");
        for (IType possibleType : validationResult.getPossibleTypes(this.astResult.getAst())) {
            result.getPossibleTypes().add((Object)possibleType.toString());
        }
        for (IValidationMessage msg : validationResult.getMessages()) {
            ValidationMessage message = QmodelPackage.eINSTANCE.getQmodelFactory().createValidationMessage();
            switch (msg.getLevel()) {
                case INFO: {
                    message.setSeverity(Severity.INFO);
                    break;
                }
                case WARNING: {
                    message.setSeverity(Severity.WARNING);
                    break;
                }
                case ERROR: {
                    message.setSeverity(Severity.ERROR);
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
            message.setStartPosition(msg.getStartPosition());
            message.setEndPosition(msg.getEndPosition());
            message.setMessage(msg.getMessage());
            result.getValidationMessages().add((Object)message);
        }
        return result;
    }
}

