/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.query.services.tests;

import java.util.ArrayList;
import java.util.Properties;
import java.util.Set;
import org.eclipse.acceleo.query.runtime.IQueryEnvironment;
import org.eclipse.acceleo.query.runtime.IReadOnlyQueryEnvironment;
import org.eclipse.acceleo.query.runtime.ServiceUtils;
import org.eclipse.acceleo.query.services.PropertiesServices;
import org.eclipse.acceleo.query.services.tests.AbstractServicesTest;
import org.junit.Assert;
import org.junit.Test;

public class PropertiesServicesTest
extends AbstractServicesTest {
    private PropertiesServices propertiesServices;

    @Override
    public void before() throws Exception {
        super.before();
        Properties properties = new Properties();
        properties.setProperty("property1", "this is property one.");
        properties.setProperty("property2", "this is property two: {0}.");
        this.propertiesServices = new PropertiesServices(properties);
        Set servicesToRegister = ServiceUtils.getServices((IReadOnlyQueryEnvironment)this.getQueryEnvironment(), (Object)this.propertiesServices);
        ServiceUtils.registerServices((IQueryEnvironment)this.getQueryEnvironment(), (Set)servicesToRegister);
    }

    @Test(expected=NullPointerException.class)
    public void getPropertyStringNull() {
        this.propertiesServices.getProperty(null);
    }

    @Test
    public void getPropertyStringNotExising() {
        Assert.assertEquals((Object)"", (Object)this.propertiesServices.getProperty("notExisting"));
    }

    @Test
    public void getPropertyString() {
        Assert.assertEquals((Object)"this is property one.", (Object)this.propertiesServices.getProperty("property1"));
        Assert.assertEquals((Object)"this is property two: {0}.", (Object)this.propertiesServices.getProperty("property2"));
    }

    @Test(expected=NullPointerException.class)
    public void getPropertyStringListNullNull() {
        this.propertiesServices.getProperty(null, null);
    }

    @Test(expected=NullPointerException.class)
    public void getPropertyStringListStringNull() {
        this.propertiesServices.getProperty("", null);
    }

    @Test(expected=NullPointerException.class)
    public void getPropertyStringListNullList() {
        this.propertiesServices.getProperty(null, new ArrayList());
    }

    @Test
    public void getPropertyStringListNotExising() {
        Assert.assertEquals((Object)"", (Object)this.propertiesServices.getProperty("notExisting", new ArrayList()));
    }

    @Test
    public void getPropertyStrinListg() {
        ArrayList<String> parameters = new ArrayList<String>();
        Assert.assertEquals((Object)"this is property one.", (Object)this.propertiesServices.getProperty("property1", parameters));
        Assert.assertEquals((Object)"this is property two: {0}.", (Object)this.propertiesServices.getProperty("property2", parameters));
        parameters.add("param1");
        parameters.add("param2");
        parameters.add("param3");
        Assert.assertEquals((Object)"this is property one.", (Object)this.propertiesServices.getProperty("property1", parameters));
        Assert.assertEquals((Object)"this is property two: param1.", (Object)this.propertiesServices.getProperty("property2", parameters));
    }
}

