/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.query.services.tests;

import java.util.Collections;
import java.util.Set;
import org.eclipse.acceleo.query.ast.ASTNode;
import org.eclipse.acceleo.query.ast.Call;
import org.eclipse.acceleo.query.ast.Expression;
import org.eclipse.acceleo.query.parser.tests.ValidationTest;
import org.eclipse.acceleo.query.runtime.IValidationMessage;
import org.eclipse.acceleo.query.runtime.IValidationResult;
import org.eclipse.acceleo.query.runtime.ValidationMessageLevel;
import org.eclipse.acceleo.query.services.tests.AbstractServicesValidationTest;
import org.eclipse.acceleo.query.validation.type.IType;
import org.junit.Assert;
import org.junit.Test;

public class ComparableServicesAstValidationTest
extends AbstractServicesValidationTest {
    @Test
    public void testGreaterThanNullNull() {
        IValidationResult validationResult = this.validate("null > null");
        Expression ast = validationResult.getAstResult().getAst();
        Assert.assertEquals((long)0L, (long)validationResult.getMessages().size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)ast).size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Call)ast).getArguments().get(0)).size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Call)ast).getArguments().get(1)).size());
        Set types = validationResult.getPossibleTypes(ast);
        Assert.assertEquals(Collections.singleton(this.classType(Boolean.class)), (Object)types);
    }

    @Test
    public void testGreaterThanNothingNull() {
        AbstractServicesValidationTest.VariableBuilder variables = new AbstractServicesValidationTest.VariableBuilder().addVar("nothing", new IType[]{this.nothingType("Nothing")});
        IValidationResult validationResult = this.validate("nothing > null", variables.build());
        Expression ast = validationResult.getAstResult().getAst();
        Assert.assertEquals((long)1L, (long)validationResult.getMessages().size());
        ValidationTest.assertValidationMessage((IValidationMessage)validationResult.getMessages().get(0), ValidationMessageLevel.ERROR, "Nothing", 0, 7);
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)ast).size());
        Assert.assertEquals((long)1L, (long)validationResult.getMessages((ASTNode)((Call)ast).getArguments().get(0)).size());
        ValidationTest.assertValidationMessage((IValidationMessage)validationResult.getMessages((ASTNode)((Call)ast).getArguments().get(0)).get(0), ValidationMessageLevel.ERROR, "Nothing", 0, 7);
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Call)ast).getArguments().get(1)).size());
        Set types = validationResult.getPossibleTypes(ast);
        Assert.assertTrue((boolean)types.isEmpty());
    }

    @Test
    public void testGreaterThanNullNothing() {
        AbstractServicesValidationTest.VariableBuilder variables = new AbstractServicesValidationTest.VariableBuilder().addVar("nothing", new IType[]{this.nothingType("Nothing")});
        IValidationResult validationResult = this.validate("null > nothing", variables.build());
        Expression ast = validationResult.getAstResult().getAst();
        Assert.assertEquals((long)1L, (long)validationResult.getMessages().size());
        ValidationTest.assertValidationMessage((IValidationMessage)validationResult.getMessages().get(0), ValidationMessageLevel.ERROR, "Nothing", 7, 14);
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)ast).size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Call)ast).getArguments().get(0)).size());
        Assert.assertEquals((long)1L, (long)validationResult.getMessages((ASTNode)((Call)ast).getArguments().get(1)).size());
        ValidationTest.assertValidationMessage((IValidationMessage)validationResult.getMessages((ASTNode)((Call)ast).getArguments().get(1)).get(0), ValidationMessageLevel.ERROR, "Nothing", 7, 14);
        Set types = validationResult.getPossibleTypes(ast);
        Assert.assertTrue((boolean)types.isEmpty());
    }

    @Test
    public void testGreaterThanNullComparable() {
        AbstractServicesValidationTest.VariableBuilder variables = new AbstractServicesValidationTest.VariableBuilder().addVar("comparable", new IType[]{this.classType(Comparable.class)});
        IValidationResult validationResult = this.validate("null > comparable", variables.build());
        Expression ast = validationResult.getAstResult().getAst();
        Assert.assertEquals((long)0L, (long)validationResult.getMessages().size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)ast).size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Call)ast).getArguments().get(0)).size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Call)ast).getArguments().get(1)).size());
        Set types = validationResult.getPossibleTypes(ast);
        Assert.assertEquals(Collections.singleton(this.classType(Boolean.class)), (Object)types);
    }

    @Test
    public void testGreaterThanComparableNull() {
        AbstractServicesValidationTest.VariableBuilder variables = new AbstractServicesValidationTest.VariableBuilder().addVar("comparable", new IType[]{this.classType(Comparable.class)});
        IValidationResult validationResult = this.validate("comparable > null", variables.build());
        Expression ast = validationResult.getAstResult().getAst();
        Assert.assertEquals((long)0L, (long)validationResult.getMessages().size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)ast).size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Call)ast).getArguments().get(0)).size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Call)ast).getArguments().get(1)).size());
        Set types = validationResult.getPossibleTypes(ast);
        Assert.assertEquals(Collections.singleton(this.classType(Boolean.class)), (Object)types);
    }

    @Test
    public void testGreaterThanComparableComparable() {
        AbstractServicesValidationTest.VariableBuilder variables = new AbstractServicesValidationTest.VariableBuilder().addVar("comparable", new IType[]{this.classType(Comparable.class)});
        IValidationResult validationResult = this.validate("comparable > comparable", variables.build());
        Expression ast = validationResult.getAstResult().getAst();
        Assert.assertEquals((long)0L, (long)validationResult.getMessages().size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)ast).size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Call)ast).getArguments().get(0)).size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Call)ast).getArguments().get(1)).size());
        Set types = validationResult.getPossibleTypes(ast);
        Assert.assertEquals(Collections.singleton(this.classType(Boolean.class)), (Object)types);
    }

    @Test
    public void testGreaterThanEqualNullNull() {
        IValidationResult validationResult = this.validate("null >= null");
        Expression ast = validationResult.getAstResult().getAst();
        Assert.assertEquals((long)0L, (long)validationResult.getMessages().size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)ast).size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Call)ast).getArguments().get(0)).size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Call)ast).getArguments().get(1)).size());
        Set types = validationResult.getPossibleTypes(ast);
        Assert.assertEquals(Collections.singleton(this.classType(Boolean.class)), (Object)types);
    }

    @Test
    public void testGreaterThanEqualNothingNull() {
        AbstractServicesValidationTest.VariableBuilder variables = new AbstractServicesValidationTest.VariableBuilder().addVar("nothing", new IType[]{this.nothingType("Nothing")});
        IValidationResult validationResult = this.validate("nothing >= null", variables.build());
        Expression ast = validationResult.getAstResult().getAst();
        Assert.assertEquals((long)1L, (long)validationResult.getMessages().size());
        ValidationTest.assertValidationMessage((IValidationMessage)validationResult.getMessages().get(0), ValidationMessageLevel.ERROR, "Nothing", 0, 7);
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)ast).size());
        Assert.assertEquals((long)1L, (long)validationResult.getMessages((ASTNode)((Call)ast).getArguments().get(0)).size());
        ValidationTest.assertValidationMessage((IValidationMessage)validationResult.getMessages((ASTNode)((Call)ast).getArguments().get(0)).get(0), ValidationMessageLevel.ERROR, "Nothing", 0, 7);
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Call)ast).getArguments().get(1)).size());
        Set types = validationResult.getPossibleTypes(ast);
        Assert.assertTrue((boolean)types.isEmpty());
    }

    @Test
    public void testGreaterThanEqualNullNothing() {
        AbstractServicesValidationTest.VariableBuilder variables = new AbstractServicesValidationTest.VariableBuilder().addVar("nothing", new IType[]{this.nothingType("Nothing")});
        IValidationResult validationResult = this.validate("null >= nothing", variables.build());
        Expression ast = validationResult.getAstResult().getAst();
        Assert.assertEquals((long)1L, (long)validationResult.getMessages().size());
        ValidationTest.assertValidationMessage((IValidationMessage)validationResult.getMessages().get(0), ValidationMessageLevel.ERROR, "Nothing", 8, 15);
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)ast).size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Call)ast).getArguments().get(0)).size());
        Assert.assertEquals((long)1L, (long)validationResult.getMessages((ASTNode)((Call)ast).getArguments().get(1)).size());
        ValidationTest.assertValidationMessage((IValidationMessage)validationResult.getMessages((ASTNode)((Call)ast).getArguments().get(1)).get(0), ValidationMessageLevel.ERROR, "Nothing", 8, 15);
        Set types = validationResult.getPossibleTypes(ast);
        Assert.assertTrue((boolean)types.isEmpty());
    }

    @Test
    public void testGreaterThanEqualNullComparable() {
        AbstractServicesValidationTest.VariableBuilder variables = new AbstractServicesValidationTest.VariableBuilder().addVar("comparable", new IType[]{this.classType(Comparable.class)});
        IValidationResult validationResult = this.validate("null >= comparable", variables.build());
        Expression ast = validationResult.getAstResult().getAst();
        Assert.assertEquals((long)0L, (long)validationResult.getMessages().size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)ast).size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Call)ast).getArguments().get(0)).size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Call)ast).getArguments().get(1)).size());
        Set types = validationResult.getPossibleTypes(ast);
        Assert.assertEquals(Collections.singleton(this.classType(Boolean.class)), (Object)types);
    }

    @Test
    public void testGreaterThanEqualComparableNull() {
        AbstractServicesValidationTest.VariableBuilder variables = new AbstractServicesValidationTest.VariableBuilder().addVar("comparable", new IType[]{this.classType(Comparable.class)});
        IValidationResult validationResult = this.validate("comparable >= null", variables.build());
        Expression ast = validationResult.getAstResult().getAst();
        Assert.assertEquals((long)0L, (long)validationResult.getMessages().size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)ast).size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Call)ast).getArguments().get(0)).size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Call)ast).getArguments().get(1)).size());
        Set types = validationResult.getPossibleTypes(ast);
        Assert.assertEquals(Collections.singleton(this.classType(Boolean.class)), (Object)types);
    }

    @Test
    public void testGreaterThanEqualComparableComparable() {
        AbstractServicesValidationTest.VariableBuilder variables = new AbstractServicesValidationTest.VariableBuilder().addVar("comparable", new IType[]{this.classType(Comparable.class)});
        IValidationResult validationResult = this.validate("comparable >= comparable", variables.build());
        Expression ast = validationResult.getAstResult().getAst();
        Assert.assertEquals((long)0L, (long)validationResult.getMessages().size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)ast).size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Call)ast).getArguments().get(0)).size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Call)ast).getArguments().get(1)).size());
        Set types = validationResult.getPossibleTypes(ast);
        Assert.assertEquals(Collections.singleton(this.classType(Boolean.class)), (Object)types);
    }

    @Test
    public void testLessThanNullNull() {
        IValidationResult validationResult = this.validate("null < null");
        Expression ast = validationResult.getAstResult().getAst();
        Assert.assertEquals((long)0L, (long)validationResult.getMessages().size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)ast).size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Call)ast).getArguments().get(0)).size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Call)ast).getArguments().get(1)).size());
        Set types = validationResult.getPossibleTypes(ast);
        Assert.assertEquals(Collections.singleton(this.classType(Boolean.class)), (Object)types);
    }

    @Test
    public void testLessThanNothingNull() {
        AbstractServicesValidationTest.VariableBuilder variables = new AbstractServicesValidationTest.VariableBuilder().addVar("nothing", new IType[]{this.nothingType("Nothing")});
        IValidationResult validationResult = this.validate("nothing < null", variables.build());
        Expression ast = validationResult.getAstResult().getAst();
        Assert.assertEquals((long)1L, (long)validationResult.getMessages().size());
        ValidationTest.assertValidationMessage((IValidationMessage)validationResult.getMessages().get(0), ValidationMessageLevel.ERROR, "Nothing", 0, 7);
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)ast).size());
        Assert.assertEquals((long)1L, (long)validationResult.getMessages((ASTNode)((Call)ast).getArguments().get(0)).size());
        ValidationTest.assertValidationMessage((IValidationMessage)validationResult.getMessages((ASTNode)((Call)ast).getArguments().get(0)).get(0), ValidationMessageLevel.ERROR, "Nothing", 0, 7);
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Call)ast).getArguments().get(1)).size());
        Set types = validationResult.getPossibleTypes(ast);
        Assert.assertTrue((boolean)types.isEmpty());
    }

    @Test
    public void testLessThanNullNothing() {
        AbstractServicesValidationTest.VariableBuilder variables = new AbstractServicesValidationTest.VariableBuilder().addVar("nothing", new IType[]{this.nothingType("Nothing")});
        IValidationResult validationResult = this.validate("null < nothing", variables.build());
        Expression ast = validationResult.getAstResult().getAst();
        Assert.assertEquals((long)1L, (long)validationResult.getMessages().size());
        ValidationTest.assertValidationMessage((IValidationMessage)validationResult.getMessages().get(0), ValidationMessageLevel.ERROR, "Nothing", 7, 14);
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)ast).size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Call)ast).getArguments().get(0)).size());
        Assert.assertEquals((long)1L, (long)validationResult.getMessages((ASTNode)((Call)ast).getArguments().get(1)).size());
        ValidationTest.assertValidationMessage((IValidationMessage)validationResult.getMessages((ASTNode)((Call)ast).getArguments().get(1)).get(0), ValidationMessageLevel.ERROR, "Nothing", 7, 14);
        Set types = validationResult.getPossibleTypes(ast);
        Assert.assertTrue((boolean)types.isEmpty());
    }

    @Test
    public void testLessThanNullComparable() {
        AbstractServicesValidationTest.VariableBuilder variables = new AbstractServicesValidationTest.VariableBuilder().addVar("comparable", new IType[]{this.classType(Comparable.class)});
        IValidationResult validationResult = this.validate("null < comparable", variables.build());
        Expression ast = validationResult.getAstResult().getAst();
        Assert.assertEquals((long)0L, (long)validationResult.getMessages().size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)ast).size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Call)ast).getArguments().get(0)).size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Call)ast).getArguments().get(1)).size());
        Set types = validationResult.getPossibleTypes(ast);
        Assert.assertEquals(Collections.singleton(this.classType(Boolean.class)), (Object)types);
    }

    @Test
    public void testLessThanComparableNull() {
        AbstractServicesValidationTest.VariableBuilder variables = new AbstractServicesValidationTest.VariableBuilder().addVar("comparable", new IType[]{this.classType(Comparable.class)});
        IValidationResult validationResult = this.validate("comparable < null", variables.build());
        Expression ast = validationResult.getAstResult().getAst();
        Assert.assertEquals((long)0L, (long)validationResult.getMessages().size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)ast).size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Call)ast).getArguments().get(0)).size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Call)ast).getArguments().get(1)).size());
        Set types = validationResult.getPossibleTypes(ast);
        Assert.assertEquals(Collections.singleton(this.classType(Boolean.class)), (Object)types);
    }

    @Test
    public void testLessThanComparableComparable() {
        AbstractServicesValidationTest.VariableBuilder variables = new AbstractServicesValidationTest.VariableBuilder().addVar("comparable", new IType[]{this.classType(Comparable.class)});
        IValidationResult validationResult = this.validate("comparable < comparable", variables.build());
        Expression ast = validationResult.getAstResult().getAst();
        Assert.assertEquals((long)0L, (long)validationResult.getMessages().size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)ast).size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Call)ast).getArguments().get(0)).size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Call)ast).getArguments().get(1)).size());
        Set types = validationResult.getPossibleTypes(ast);
        Assert.assertEquals(Collections.singleton(this.classType(Boolean.class)), (Object)types);
    }

    @Test
    public void testLessThanEqualNullNull() {
        IValidationResult validationResult = this.validate("null <= null");
        Expression ast = validationResult.getAstResult().getAst();
        Assert.assertEquals((long)0L, (long)validationResult.getMessages().size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)ast).size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Call)ast).getArguments().get(0)).size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Call)ast).getArguments().get(1)).size());
        Set types = validationResult.getPossibleTypes(ast);
        Assert.assertEquals(Collections.singleton(this.classType(Boolean.class)), (Object)types);
    }

    @Test
    public void testLessThanEqualNothingNull() {
        AbstractServicesValidationTest.VariableBuilder variables = new AbstractServicesValidationTest.VariableBuilder().addVar("nothing", new IType[]{this.nothingType("Nothing")});
        IValidationResult validationResult = this.validate("nothing <= null", variables.build());
        Expression ast = validationResult.getAstResult().getAst();
        Assert.assertEquals((long)1L, (long)validationResult.getMessages().size());
        ValidationTest.assertValidationMessage((IValidationMessage)validationResult.getMessages().get(0), ValidationMessageLevel.ERROR, "Nothing", 0, 7);
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)ast).size());
        Assert.assertEquals((long)1L, (long)validationResult.getMessages((ASTNode)((Call)ast).getArguments().get(0)).size());
        ValidationTest.assertValidationMessage((IValidationMessage)validationResult.getMessages((ASTNode)((Call)ast).getArguments().get(0)).get(0), ValidationMessageLevel.ERROR, "Nothing", 0, 7);
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Call)ast).getArguments().get(1)).size());
        Set types = validationResult.getPossibleTypes(ast);
        Assert.assertTrue((boolean)types.isEmpty());
    }

    @Test
    public void testLessThanEqualNullNothing() {
        AbstractServicesValidationTest.VariableBuilder variables = new AbstractServicesValidationTest.VariableBuilder().addVar("nothing", new IType[]{this.nothingType("Nothing")});
        IValidationResult validationResult = this.validate("null <= nothing", variables.build());
        Expression ast = validationResult.getAstResult().getAst();
        Assert.assertEquals((long)1L, (long)validationResult.getMessages().size());
        ValidationTest.assertValidationMessage((IValidationMessage)validationResult.getMessages().get(0), ValidationMessageLevel.ERROR, "Nothing", 8, 15);
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)ast).size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Call)ast).getArguments().get(0)).size());
        Assert.assertEquals((long)1L, (long)validationResult.getMessages((ASTNode)((Call)ast).getArguments().get(1)).size());
        ValidationTest.assertValidationMessage((IValidationMessage)validationResult.getMessages((ASTNode)((Call)ast).getArguments().get(1)).get(0), ValidationMessageLevel.ERROR, "Nothing", 8, 15);
        Set types = validationResult.getPossibleTypes(ast);
        Assert.assertTrue((boolean)types.isEmpty());
    }

    @Test
    public void testLessThanEqualNullComparable() {
        AbstractServicesValidationTest.VariableBuilder variables = new AbstractServicesValidationTest.VariableBuilder().addVar("comparable", new IType[]{this.classType(Comparable.class)});
        IValidationResult validationResult = this.validate("null <= comparable", variables.build());
        Expression ast = validationResult.getAstResult().getAst();
        Assert.assertEquals((long)0L, (long)validationResult.getMessages().size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)ast).size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Call)ast).getArguments().get(0)).size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Call)ast).getArguments().get(1)).size());
        Set types = validationResult.getPossibleTypes(ast);
        Assert.assertEquals(Collections.singleton(this.classType(Boolean.class)), (Object)types);
    }

    @Test
    public void testLessThanEqualComparableNull() {
        AbstractServicesValidationTest.VariableBuilder variables = new AbstractServicesValidationTest.VariableBuilder().addVar("comparable", new IType[]{this.classType(Comparable.class)});
        IValidationResult validationResult = this.validate("comparable <= null", variables.build());
        Expression ast = validationResult.getAstResult().getAst();
        Assert.assertEquals((long)0L, (long)validationResult.getMessages().size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)ast).size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Call)ast).getArguments().get(0)).size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Call)ast).getArguments().get(1)).size());
        Set types = validationResult.getPossibleTypes(ast);
        Assert.assertEquals(Collections.singleton(this.classType(Boolean.class)), (Object)types);
    }

    @Test
    public void testLessThanEqualComparableComparable() {
        AbstractServicesValidationTest.VariableBuilder variables = new AbstractServicesValidationTest.VariableBuilder().addVar("comparable", new IType[]{this.classType(Comparable.class)});
        IValidationResult validationResult = this.validate("comparable <= comparable", variables.build());
        Expression ast = validationResult.getAstResult().getAst();
        Assert.assertEquals((long)0L, (long)validationResult.getMessages().size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)ast).size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Call)ast).getArguments().get(0)).size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Call)ast).getArguments().get(1)).size());
        Set types = validationResult.getPossibleTypes(ast);
        Assert.assertEquals(Collections.singleton(this.classType(Boolean.class)), (Object)types);
    }
}

