/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.query.services.tests;

import java.util.Collections;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.acceleo.query.ast.ASTNode;
import org.eclipse.acceleo.query.ast.Call;
import org.eclipse.acceleo.query.ast.Expression;
import org.eclipse.acceleo.query.parser.AstResult;
import org.eclipse.acceleo.query.parser.tests.ValidationTest;
import org.eclipse.acceleo.query.runtime.IValidationMessage;
import org.eclipse.acceleo.query.runtime.IValidationResult;
import org.eclipse.acceleo.query.runtime.ValidationMessageLevel;
import org.eclipse.acceleo.query.services.tests.AbstractServicesValidationTest;
import org.eclipse.acceleo.query.validation.type.IType;
import org.eclipse.acceleo.query.validation.type.NothingType;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EcorePackage;
import org.junit.Assert;
import org.junit.Test;

public class AnyServicesAstValidationTest
extends AbstractServicesValidationTest {
    @Test
    public void testAddNullString() {
        IValidationResult validationResult = this.validate("null + 'string'");
        Expression ast = validationResult.getAstResult().getAst();
        Assert.assertEquals((long)0L, (long)validationResult.getMessages().size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)ast).size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Call)ast).getArguments().get(0)).size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Call)ast).getArguments().get(1)).size());
        AstResult astResult = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(astResult.getAst());
        Assert.assertEquals(Collections.singleton(this.classType(String.class)), (Object)types);
    }

    @Test
    public void testAddStringNull() {
        IValidationResult validationResult = this.validate("'string' + null");
        Expression ast = validationResult.getAstResult().getAst();
        Assert.assertEquals((long)0L, (long)validationResult.getMessages().size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)ast).size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Call)ast).getArguments().get(0)).size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Call)ast).getArguments().get(1)).size());
        AstResult astResult = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(astResult.getAst());
        Assert.assertEquals(Collections.singleton(this.classType(String.class)), (Object)types);
    }

    @Test
    public void testAddNothingString() {
        AbstractServicesValidationTest.VariableBuilder variables = new AbstractServicesValidationTest.VariableBuilder().addVar("nothing", new IType[]{this.nothingType("Nothing")});
        IValidationResult validationResult = this.validate("nothing + 'string'", variables.build());
        Expression ast = validationResult.getAstResult().getAst();
        Assert.assertEquals((long)1L, (long)validationResult.getMessages().size());
        ValidationTest.assertValidationMessage((IValidationMessage)validationResult.getMessages().get(0), ValidationMessageLevel.ERROR, "Nothing", 0, 7);
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)ast).size());
        Assert.assertEquals((long)1L, (long)validationResult.getMessages((ASTNode)((Call)ast).getArguments().get(0)).size());
        ValidationTest.assertValidationMessage((IValidationMessage)validationResult.getMessages((ASTNode)((Call)ast).getArguments().get(0)).get(0), ValidationMessageLevel.ERROR, "Nothing", 0, 7);
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Call)ast).getArguments().get(1)).size());
        AstResult astResult = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(astResult.getAst());
        Assert.assertTrue((boolean)types.isEmpty());
    }

    @Test
    public void testAddStringNothing() {
        AbstractServicesValidationTest.VariableBuilder variables = new AbstractServicesValidationTest.VariableBuilder().addVar("nothing", new IType[]{this.nothingType("Nothing")});
        IValidationResult validationResult = this.validate("'string' + nothing", variables.build());
        Expression ast = validationResult.getAstResult().getAst();
        Assert.assertEquals((long)1L, (long)validationResult.getMessages().size());
        ValidationTest.assertValidationMessage((IValidationMessage)validationResult.getMessages().get(0), ValidationMessageLevel.ERROR, "Nothing", 11, 18);
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)ast).size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Call)ast).getArguments().get(0)).size());
        Assert.assertEquals((long)1L, (long)validationResult.getMessages((ASTNode)((Call)ast).getArguments().get(1)).size());
        ValidationTest.assertValidationMessage((IValidationMessage)validationResult.getMessages((ASTNode)((Call)ast).getArguments().get(1)).get(0), ValidationMessageLevel.ERROR, "Nothing", 11, 18);
        AstResult astResult = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(astResult.getAst());
        Assert.assertTrue((boolean)types.isEmpty());
    }

    @Test
    public void testAddObjectString() {
        AbstractServicesValidationTest.VariableBuilder variables = new AbstractServicesValidationTest.VariableBuilder().addVar("object", new IType[]{this.classType(Object.class)});
        IValidationResult validationResult = this.validate("object + 'string'", variables.build());
        Expression ast = validationResult.getAstResult().getAst();
        Assert.assertEquals((long)0L, (long)validationResult.getMessages().size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)ast).size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Call)ast).getArguments().get(0)).size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Call)ast).getArguments().get(1)).size());
        AstResult astResult = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(astResult.getAst());
        Assert.assertEquals(Collections.singleton(this.classType(String.class)), (Object)types);
    }

    @Test
    public void testAddStringObject() {
        AbstractServicesValidationTest.VariableBuilder variables = new AbstractServicesValidationTest.VariableBuilder().addVar("object", new IType[]{this.classType(Object.class)});
        IValidationResult validationResult = this.validate("'string' + object", variables.build());
        Expression ast = validationResult.getAstResult().getAst();
        Assert.assertEquals((long)0L, (long)validationResult.getMessages().size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)ast).size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Call)ast).getArguments().get(0)).size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Call)ast).getArguments().get(1)).size());
        AstResult astResult = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(astResult.getAst());
        Assert.assertEquals(Collections.singleton(this.classType(String.class)), (Object)types);
    }

    @Test
    public void testDiffersNullNull() {
        IValidationResult validationResult = this.validate("null <> null");
        Expression ast = validationResult.getAstResult().getAst();
        Assert.assertEquals((long)0L, (long)validationResult.getMessages().size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)ast).size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Call)ast).getArguments().get(0)).size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Call)ast).getArguments().get(1)).size());
        AstResult astResult = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(astResult.getAst());
        Assert.assertEquals(Collections.singleton(this.classType(Boolean.class)), (Object)types);
    }

    @Test
    public void testDiffersNullNothing() {
        AbstractServicesValidationTest.VariableBuilder variables = new AbstractServicesValidationTest.VariableBuilder().addVar("nothing", new IType[]{this.nothingType("Nothing")});
        IValidationResult validationResult = this.validate("null <> nothing", variables.build());
        Expression ast = validationResult.getAstResult().getAst();
        Assert.assertEquals((long)1L, (long)validationResult.getMessages().size());
        ValidationTest.assertValidationMessage((IValidationMessage)validationResult.getMessages().get(0), ValidationMessageLevel.ERROR, "Nothing", 8, 15);
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)ast).size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Call)ast).getArguments().get(0)).size());
        Assert.assertEquals((long)1L, (long)validationResult.getMessages((ASTNode)((Call)ast).getArguments().get(1)).size());
        ValidationTest.assertValidationMessage((IValidationMessage)validationResult.getMessages((ASTNode)((Call)ast).getArguments().get(1)).get(0), ValidationMessageLevel.ERROR, "Nothing", 8, 15);
        AstResult astResult = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(astResult.getAst());
        Assert.assertTrue((boolean)types.isEmpty());
    }

    @Test
    public void testDiffersNothingNull() {
        AbstractServicesValidationTest.VariableBuilder variables = new AbstractServicesValidationTest.VariableBuilder().addVar("nothing", new IType[]{this.nothingType("Nothing")});
        IValidationResult validationResult = this.validate("nothing <> null", variables.build());
        Expression ast = validationResult.getAstResult().getAst();
        Assert.assertEquals((long)1L, (long)validationResult.getMessages().size());
        ValidationTest.assertValidationMessage((IValidationMessage)validationResult.getMessages().get(0), ValidationMessageLevel.ERROR, "Nothing", 0, 7);
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)ast).size());
        Assert.assertEquals((long)1L, (long)validationResult.getMessages((ASTNode)((Call)ast).getArguments().get(0)).size());
        ValidationTest.assertValidationMessage((IValidationMessage)validationResult.getMessages((ASTNode)((Call)ast).getArguments().get(0)).get(0), ValidationMessageLevel.ERROR, "Nothing", 0, 7);
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Call)ast).getArguments().get(1)).size());
        AstResult astResult = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(astResult.getAst());
        Assert.assertTrue((boolean)types.isEmpty());
    }

    @Test
    public void testDiffersNullObject() {
        AbstractServicesValidationTest.VariableBuilder variables = new AbstractServicesValidationTest.VariableBuilder().addVar("object", new IType[]{this.classType(Object.class)});
        IValidationResult validationResult = this.validate("null <> object", variables.build());
        Expression ast = validationResult.getAstResult().getAst();
        Assert.assertEquals((long)0L, (long)validationResult.getMessages().size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)ast).size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Call)ast).getArguments().get(0)).size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Call)ast).getArguments().get(1)).size());
        AstResult astResult = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(astResult.getAst());
        Assert.assertEquals(Collections.singleton(this.classType(Boolean.class)), (Object)types);
    }

    @Test
    public void testDiffersObjectNull() {
        AbstractServicesValidationTest.VariableBuilder variables = new AbstractServicesValidationTest.VariableBuilder().addVar("object", new IType[]{this.classType(Object.class)});
        IValidationResult validationResult = this.validate("object <> null", variables.build());
        Expression ast = validationResult.getAstResult().getAst();
        Assert.assertEquals((long)0L, (long)validationResult.getMessages().size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)ast).size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Call)ast).getArguments().get(0)).size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Call)ast).getArguments().get(1)).size());
        AstResult astResult = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(astResult.getAst());
        Assert.assertEquals(Collections.singleton(this.classType(Boolean.class)), (Object)types);
    }

    @Test
    public void testDiffersObjectObject() {
        AbstractServicesValidationTest.VariableBuilder variables = new AbstractServicesValidationTest.VariableBuilder().addVar("object", new IType[]{this.classType(Object.class)});
        IValidationResult validationResult = this.validate("object <> object", variables.build());
        Expression ast = validationResult.getAstResult().getAst();
        Assert.assertEquals((long)0L, (long)validationResult.getMessages().size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)ast).size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Call)ast).getArguments().get(0)).size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Call)ast).getArguments().get(1)).size());
        AstResult astResult = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(astResult.getAst());
        Assert.assertEquals(Collections.singleton(this.classType(Boolean.class)), (Object)types);
    }

    @Test
    public void testEqualsNullNull() {
        IValidationResult validationResult = this.validate("null = null");
        Expression ast = validationResult.getAstResult().getAst();
        Assert.assertEquals((long)0L, (long)validationResult.getMessages().size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)ast).size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Call)ast).getArguments().get(0)).size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Call)ast).getArguments().get(1)).size());
        AstResult astResult = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(astResult.getAst());
        Assert.assertEquals(Collections.singleton(this.classType(Boolean.class)), (Object)types);
    }

    @Test
    public void testEqualsNullNothing() {
        AbstractServicesValidationTest.VariableBuilder variables = new AbstractServicesValidationTest.VariableBuilder().addVar("nothing", new IType[]{this.nothingType("Nothing")});
        IValidationResult validationResult = this.validate("null = nothing", variables.build());
        Expression ast = validationResult.getAstResult().getAst();
        Assert.assertEquals((long)1L, (long)validationResult.getMessages().size());
        ValidationTest.assertValidationMessage((IValidationMessage)validationResult.getMessages().get(0), ValidationMessageLevel.ERROR, "Nothing", 7, 14);
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)ast).size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Call)ast).getArguments().get(0)).size());
        Assert.assertEquals((long)1L, (long)validationResult.getMessages((ASTNode)((Call)ast).getArguments().get(1)).size());
        ValidationTest.assertValidationMessage((IValidationMessage)validationResult.getMessages((ASTNode)((Call)ast).getArguments().get(1)).get(0), ValidationMessageLevel.ERROR, "Nothing", 7, 14);
        AstResult astResult = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(astResult.getAst());
        Assert.assertTrue((boolean)types.isEmpty());
    }

    @Test
    public void testEqualsNothingNull() {
        AbstractServicesValidationTest.VariableBuilder variables = new AbstractServicesValidationTest.VariableBuilder().addVar("nothing", new IType[]{this.nothingType("Nothing")});
        IValidationResult validationResult = this.validate("nothing = null", variables.build());
        Expression ast = validationResult.getAstResult().getAst();
        Assert.assertEquals((long)1L, (long)validationResult.getMessages().size());
        ValidationTest.assertValidationMessage((IValidationMessage)validationResult.getMessages().get(0), ValidationMessageLevel.ERROR, "Nothing", 0, 7);
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)ast).size());
        Assert.assertEquals((long)1L, (long)validationResult.getMessages((ASTNode)((Call)ast).getArguments().get(0)).size());
        ValidationTest.assertValidationMessage((IValidationMessage)validationResult.getMessages((ASTNode)((Call)ast).getArguments().get(0)).get(0), ValidationMessageLevel.ERROR, "Nothing", 0, 7);
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Call)ast).getArguments().get(1)).size());
        AstResult astResult = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(astResult.getAst());
        Assert.assertTrue((boolean)types.isEmpty());
    }

    @Test
    public void testEqualsNullObject() {
        AbstractServicesValidationTest.VariableBuilder variables = new AbstractServicesValidationTest.VariableBuilder().addVar("object", new IType[]{this.classType(Object.class)});
        IValidationResult validationResult = this.validate("null = object", variables.build());
        Expression ast = validationResult.getAstResult().getAst();
        Assert.assertEquals((long)0L, (long)validationResult.getMessages().size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)ast).size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Call)ast).getArguments().get(0)).size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Call)ast).getArguments().get(1)).size());
        AstResult astResult = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(astResult.getAst());
        Assert.assertEquals(Collections.singleton(this.classType(Boolean.class)), (Object)types);
    }

    @Test
    public void testEqualsObjectNull() {
        AbstractServicesValidationTest.VariableBuilder variables = new AbstractServicesValidationTest.VariableBuilder().addVar("object", new IType[]{this.classType(Object.class)});
        IValidationResult validationResult = this.validate("object = null", variables.build());
        Expression ast = validationResult.getAstResult().getAst();
        Assert.assertEquals((long)0L, (long)validationResult.getMessages().size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)ast).size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Call)ast).getArguments().get(0)).size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Call)ast).getArguments().get(1)).size());
        AstResult astResult = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(astResult.getAst());
        Assert.assertEquals(Collections.singleton(this.classType(Boolean.class)), (Object)types);
    }

    @Test
    public void testEqualsObjectObject() {
        AbstractServicesValidationTest.VariableBuilder variables = new AbstractServicesValidationTest.VariableBuilder().addVar("object", new IType[]{this.classType(Object.class)});
        IValidationResult validationResult = this.validate("object = object", variables.build());
        Expression ast = validationResult.getAstResult().getAst();
        Assert.assertEquals((long)0L, (long)validationResult.getMessages().size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)ast).size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Call)ast).getArguments().get(0)).size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Call)ast).getArguments().get(1)).size());
        AstResult astResult = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(astResult.getAst());
        Assert.assertEquals(Collections.singleton(this.classType(Boolean.class)), (Object)types);
    }

    @Test
    public void testOclAsTypeNullNull() {
        IValidationResult validationResult = this.validate("null.oclAsType(null)");
        Expression ast = validationResult.getAstResult().getAst();
        String expectedMessage = "Nothing will be left after calling oclAsType:\nnull is not compatible with type null";
        Assert.assertEquals((long)1L, (long)validationResult.getMessages().size());
        ValidationTest.assertValidationMessage((IValidationMessage)validationResult.getMessages().get(0), ValidationMessageLevel.ERROR, "Nothing will be left after calling oclAsType:\nnull is not compatible with type null", 4, 20);
        Assert.assertEquals((long)1L, (long)validationResult.getMessages((ASTNode)ast).size());
        ValidationTest.assertValidationMessage((IValidationMessage)validationResult.getMessages((ASTNode)ast).get(0), ValidationMessageLevel.ERROR, "Nothing will be left after calling oclAsType:\nnull is not compatible with type null", 4, 20);
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Call)ast).getArguments().get(0)).size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Call)ast).getArguments().get(1)).size());
        AstResult astResult = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(astResult.getAst());
        Assert.assertEquals((long)1L, (long)types.size());
        Iterator it = types.iterator();
        IType type = (IType)it.next();
        Assert.assertTrue((boolean)(type instanceof NothingType));
        Assert.assertEquals((Object)"Nothing will be left after calling oclAsType:\nnull is not compatible with type null", (Object)((NothingType)type).getMessage());
    }

    @Test
    public void testOclAsTypeNothingNull() {
        AbstractServicesValidationTest.VariableBuilder variables = new AbstractServicesValidationTest.VariableBuilder().addVar("nothing", new IType[]{this.nothingType("Nothing")});
        IValidationResult validationResult = this.validate("nothing.oclAsType(null)", variables.build());
        Expression ast = validationResult.getAstResult().getAst();
        Assert.assertEquals((long)1L, (long)validationResult.getMessages().size());
        ValidationTest.assertValidationMessage((IValidationMessage)validationResult.getMessages().get(0), ValidationMessageLevel.ERROR, "Nothing", 0, 7);
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)ast).size());
        Assert.assertEquals((long)1L, (long)validationResult.getMessages((ASTNode)((Call)ast).getArguments().get(0)).size());
        ValidationTest.assertValidationMessage((IValidationMessage)validationResult.getMessages((ASTNode)((Call)ast).getArguments().get(0)).get(0), ValidationMessageLevel.ERROR, "Nothing", 0, 7);
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Call)ast).getArguments().get(1)).size());
        AstResult astResult = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(astResult.getAst());
        Assert.assertTrue((boolean)types.isEmpty());
    }

    @Test
    public void testOclAsTypeNullNothing() {
        AbstractServicesValidationTest.VariableBuilder variables = new AbstractServicesValidationTest.VariableBuilder().addVar("nothing", new IType[]{this.nothingType("Nothing")});
        IValidationResult validationResult = this.validate("null.oclAsType(nothing)", variables.build());
        Expression ast = validationResult.getAstResult().getAst();
        Assert.assertEquals((long)1L, (long)validationResult.getMessages().size());
        ValidationTest.assertValidationMessage((IValidationMessage)validationResult.getMessages().get(0), ValidationMessageLevel.ERROR, "Nothing", 15, 22);
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)ast).size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Call)ast).getArguments().get(0)).size());
        Assert.assertEquals((long)1L, (long)validationResult.getMessages((ASTNode)((Call)ast).getArguments().get(1)).size());
        ValidationTest.assertValidationMessage((IValidationMessage)validationResult.getMessages((ASTNode)((Call)ast).getArguments().get(1)).get(0), ValidationMessageLevel.ERROR, "Nothing", 15, 22);
        AstResult astResult = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(astResult.getAst());
        Assert.assertTrue((boolean)types.isEmpty());
    }

    @Test
    public void testOclAsTypeNothingNothing() {
        AbstractServicesValidationTest.VariableBuilder variables = new AbstractServicesValidationTest.VariableBuilder().addVar("nothing", new IType[]{this.nothingType("Nothing")});
        IValidationResult validationResult = this.validate("nothing.oclAsType(nothing)", variables.build());
        Expression ast = validationResult.getAstResult().getAst();
        Assert.assertEquals((long)2L, (long)validationResult.getMessages().size());
        ValidationTest.assertValidationMessage((IValidationMessage)validationResult.getMessages().get(0), ValidationMessageLevel.ERROR, "Nothing", 0, 7);
        ValidationTest.assertValidationMessage((IValidationMessage)validationResult.getMessages().get(1), ValidationMessageLevel.ERROR, "Nothing", 18, 25);
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)ast).size());
        Assert.assertEquals((long)1L, (long)validationResult.getMessages((ASTNode)((Call)ast).getArguments().get(0)).size());
        ValidationTest.assertValidationMessage((IValidationMessage)validationResult.getMessages((ASTNode)((Call)ast).getArguments().get(0)).get(0), ValidationMessageLevel.ERROR, "Nothing", 0, 7);
        Assert.assertEquals((long)1L, (long)validationResult.getMessages((ASTNode)((Call)ast).getArguments().get(1)).size());
        ValidationTest.assertValidationMessage((IValidationMessage)validationResult.getMessages((ASTNode)((Call)ast).getArguments().get(1)).get(0), ValidationMessageLevel.ERROR, "Nothing", 18, 25);
        AstResult astResult = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(astResult.getAst());
        Assert.assertTrue((boolean)types.isEmpty());
    }

    @Test
    public void testOclAsTypeSameType() {
        this.getQueryEnvironment().registerEPackage((EPackage)EcorePackage.eINSTANCE);
        AbstractServicesValidationTest.VariableBuilder variables = new AbstractServicesValidationTest.VariableBuilder().addVar("eCls", new IType[]{this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getEClass())});
        IValidationResult validationResult = this.validate("eCls.oclAsType(ecore::EClass)", variables.build());
        Expression ast = validationResult.getAstResult().getAst();
        Assert.assertEquals((long)0L, (long)validationResult.getMessages().size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)ast).size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Call)ast).getArguments().get(0)).size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Call)ast).getArguments().get(1)).size());
        AstResult astResult = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(astResult.getAst());
        Assert.assertEquals(Collections.singleton(this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getEClass())), (Object)types);
    }

    @Test
    public void testOclAsTypeSameTypeClass() {
        this.getQueryEnvironment().registerEPackage((EPackage)EcorePackage.eINSTANCE);
        AbstractServicesValidationTest.VariableBuilder variables = new AbstractServicesValidationTest.VariableBuilder().addVar("var", new IType[]{this.classType(String.class)});
        IValidationResult validationResult = this.validate("var.oclAsType(String)", variables.build());
        Expression ast = validationResult.getAstResult().getAst();
        Assert.assertEquals((long)0L, (long)validationResult.getMessages().size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)ast).size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Call)ast).getArguments().get(0)).size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Call)ast).getArguments().get(1)).size());
        AstResult astResult = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(astResult.getAst());
        Assert.assertEquals(Collections.singleton(this.classType(String.class)), (Object)types);
    }

    @Test
    public void testOclAsTypeSameTypeClassLiteral() {
        this.getQueryEnvironment().registerEPackage((EPackage)EcorePackage.eINSTANCE);
        AbstractServicesValidationTest.VariableBuilder variables = new AbstractServicesValidationTest.VariableBuilder().addVar("var", new IType[]{this.classLiteralType(String.class)});
        IValidationResult validationResult = this.validate("var.oclAsType(String)", variables.build());
        Expression ast = validationResult.getAstResult().getAst();
        Assert.assertEquals((long)0L, (long)validationResult.getMessages().size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)ast).size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Call)ast).getArguments().get(0)).size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Call)ast).getArguments().get(1)).size());
        AstResult astResult = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(astResult.getAst());
        Assert.assertEquals(Collections.singleton(this.classType(String.class)), (Object)types);
    }

    @Test
    public void testOclAsTypeSameTypeEClassifierLiteral() {
        this.getQueryEnvironment().registerEPackage((EPackage)EcorePackage.eINSTANCE);
        AbstractServicesValidationTest.VariableBuilder variables = new AbstractServicesValidationTest.VariableBuilder().addVar("eCls", new IType[]{this.eClassifierLiteralType((EClassifier)EcorePackage.eINSTANCE.getEClass())});
        IValidationResult validationResult = this.validate("eCls.oclAsType(ecore::EClass)", variables.build());
        Expression ast = validationResult.getAstResult().getAst();
        Assert.assertEquals((long)0L, (long)validationResult.getMessages().size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)ast).size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Call)ast).getArguments().get(0)).size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Call)ast).getArguments().get(1)).size());
        AstResult astResult = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(astResult.getAst());
        Assert.assertEquals(Collections.singleton(this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getEClass())), (Object)types);
    }

    @Test
    public void testOclAsTypeNotCompatibleTypeClassLiteral() {
        this.getQueryEnvironment().registerEPackage((EPackage)EcorePackage.eINSTANCE);
        AbstractServicesValidationTest.VariableBuilder variables = new AbstractServicesValidationTest.VariableBuilder().addVar("var", new IType[]{this.classLiteralType(String.class)});
        IValidationResult validationResult = this.validate("var.oclAsType(Integer)", variables.build());
        Expression ast = validationResult.getAstResult().getAst();
        String expectedMessage = "Nothing will be left after calling oclAsType:\nClassLiteral=java.lang.String is not compatible with type ClassLiteral=java.lang.Integer";
        Assert.assertEquals((long)1L, (long)validationResult.getMessages().size());
        ValidationTest.assertValidationMessage((IValidationMessage)validationResult.getMessages().get(0), ValidationMessageLevel.ERROR, "Nothing will be left after calling oclAsType:\nClassLiteral=java.lang.String is not compatible with type ClassLiteral=java.lang.Integer", 3, 22);
        Assert.assertEquals((long)1L, (long)validationResult.getMessages((ASTNode)ast).size());
        ValidationTest.assertValidationMessage((IValidationMessage)validationResult.getMessages((ASTNode)ast).get(0), ValidationMessageLevel.ERROR, "Nothing will be left after calling oclAsType:\nClassLiteral=java.lang.String is not compatible with type ClassLiteral=java.lang.Integer", 3, 22);
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Call)ast).getArguments().get(0)).size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Call)ast).getArguments().get(1)).size());
        AstResult astResult = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(astResult.getAst());
        Assert.assertEquals((long)1L, (long)types.size());
        Iterator it = types.iterator();
        IType type = (IType)it.next();
        Assert.assertTrue((boolean)(type instanceof NothingType));
        Assert.assertEquals((Object)"Nothing will be left after calling oclAsType:\nClassLiteral=java.lang.String is not compatible with type ClassLiteral=java.lang.Integer", (Object)((NothingType)type).getMessage());
    }

    @Test
    public void testOclAsTypeNotCompatibleType() {
        this.getQueryEnvironment().registerEPackage((EPackage)EcorePackage.eINSTANCE);
        AbstractServicesValidationTest.VariableBuilder variables = new AbstractServicesValidationTest.VariableBuilder().addVar("eCls", new IType[]{this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getEClass())});
        IValidationResult validationResult = this.validate("eCls.oclAsType(ecore::EPackage)", variables.build());
        Expression ast = validationResult.getAstResult().getAst();
        String expectedMessage = "Nothing will be left after calling oclAsType:\nEClassifier=EClass is not compatible with type EClassifierLiteral=EPackage";
        Assert.assertEquals((long)1L, (long)validationResult.getMessages().size());
        ValidationTest.assertValidationMessage((IValidationMessage)validationResult.getMessages().get(0), ValidationMessageLevel.ERROR, "Nothing will be left after calling oclAsType:\nEClassifier=EClass is not compatible with type EClassifierLiteral=EPackage", 4, 31);
        Assert.assertEquals((long)1L, (long)validationResult.getMessages((ASTNode)ast).size());
        ValidationTest.assertValidationMessage((IValidationMessage)validationResult.getMessages((ASTNode)ast).get(0), ValidationMessageLevel.ERROR, "Nothing will be left after calling oclAsType:\nEClassifier=EClass is not compatible with type EClassifierLiteral=EPackage", 4, 31);
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Call)ast).getArguments().get(0)).size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Call)ast).getArguments().get(1)).size());
        AstResult astResult = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(astResult.getAst());
        Assert.assertEquals((long)1L, (long)types.size());
        Iterator it = types.iterator();
        IType type = (IType)it.next();
        Assert.assertTrue((boolean)(type instanceof NothingType));
        Assert.assertEquals((Object)"Nothing will be left after calling oclAsType:\nEClassifier=EClass is not compatible with type EClassifierLiteral=EPackage", (Object)((NothingType)type).getMessage());
    }

    @Test
    public void testOclAsTypeNotCompatibleTypeClass() {
        this.getQueryEnvironment().registerEPackage((EPackage)EcorePackage.eINSTANCE);
        AbstractServicesValidationTest.VariableBuilder variables = new AbstractServicesValidationTest.VariableBuilder().addVar("eCls", new IType[]{this.classType(EClass.class)});
        IValidationResult validationResult = this.validate("eCls.oclAsType(ecore::EPackage)", variables.build());
        Expression ast = validationResult.getAstResult().getAst();
        String expectedMessage = "Nothing will be left after calling oclAsType:\norg.eclipse.emf.ecore.EClass is not compatible with type EClassifierLiteral=EPackage";
        Assert.assertEquals((long)1L, (long)validationResult.getMessages().size());
        ValidationTest.assertValidationMessage((IValidationMessage)validationResult.getMessages().get(0), ValidationMessageLevel.ERROR, "Nothing will be left after calling oclAsType:\norg.eclipse.emf.ecore.EClass is not compatible with type EClassifierLiteral=EPackage", 4, 31);
        Assert.assertEquals((long)1L, (long)validationResult.getMessages((ASTNode)ast).size());
        ValidationTest.assertValidationMessage((IValidationMessage)validationResult.getMessages((ASTNode)ast).get(0), ValidationMessageLevel.ERROR, "Nothing will be left after calling oclAsType:\norg.eclipse.emf.ecore.EClass is not compatible with type EClassifierLiteral=EPackage", 4, 31);
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Call)ast).getArguments().get(0)).size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Call)ast).getArguments().get(1)).size());
        AstResult astResult = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(astResult.getAst());
        Assert.assertEquals((long)1L, (long)types.size());
        Iterator it = types.iterator();
        IType type = (IType)it.next();
        Assert.assertTrue((boolean)(type instanceof NothingType));
        Assert.assertEquals((Object)"Nothing will be left after calling oclAsType:\norg.eclipse.emf.ecore.EClass is not compatible with type EClassifierLiteral=EPackage", (Object)((NothingType)type).getMessage());
    }

    @Test
    public void testOclAsTypeNotCompatibleTypeECLassifierLiteral() {
        this.getQueryEnvironment().registerEPackage((EPackage)EcorePackage.eINSTANCE);
        AbstractServicesValidationTest.VariableBuilder variables = new AbstractServicesValidationTest.VariableBuilder().addVar("eCls", new IType[]{this.eClassifierLiteralType((EClassifier)EcorePackage.eINSTANCE.getEClass())});
        IValidationResult validationResult = this.validate("eCls.oclAsType(ecore::EPackage)", variables.build());
        Expression ast = validationResult.getAstResult().getAst();
        String expectedMessage = "Nothing will be left after calling oclAsType:\nEClassifierLiteral=EClass is not compatible with type EClassifierLiteral=EPackage";
        Assert.assertEquals((long)1L, (long)validationResult.getMessages().size());
        ValidationTest.assertValidationMessage((IValidationMessage)validationResult.getMessages().get(0), ValidationMessageLevel.ERROR, "Nothing will be left after calling oclAsType:\nEClassifierLiteral=EClass is not compatible with type EClassifierLiteral=EPackage", 4, 31);
        Assert.assertEquals((long)1L, (long)validationResult.getMessages((ASTNode)ast).size());
        ValidationTest.assertValidationMessage((IValidationMessage)validationResult.getMessages((ASTNode)ast).get(0), ValidationMessageLevel.ERROR, "Nothing will be left after calling oclAsType:\nEClassifierLiteral=EClass is not compatible with type EClassifierLiteral=EPackage", 4, 31);
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Call)ast).getArguments().get(0)).size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Call)ast).getArguments().get(1)).size());
        AstResult astResult = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(astResult.getAst());
        Assert.assertEquals((long)1L, (long)types.size());
        Iterator it = types.iterator();
        IType type = (IType)it.next();
        Assert.assertTrue((boolean)(type instanceof NothingType));
        Assert.assertEquals((Object)"Nothing will be left after calling oclAsType:\nEClassifierLiteral=EClass is not compatible with type EClassifierLiteral=EPackage", (Object)((NothingType)type).getMessage());
    }

    @Test
    public void testOclAsTypeMayBeCompatibleType() {
        this.getQueryEnvironment().registerEPackage((EPackage)EcorePackage.eINSTANCE);
        AbstractServicesValidationTest.VariableBuilder variables = new AbstractServicesValidationTest.VariableBuilder().addVar("eClasssifier", new IType[]{this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getEClassifier())});
        IValidationResult validationResult = this.validate("eClasssifier.oclAsType(ecore::EClass)", variables.build());
        Expression ast = validationResult.getAstResult().getAst();
        Assert.assertEquals((long)0L, (long)validationResult.getMessages().size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)ast).size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Call)ast).getArguments().get(0)).size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Call)ast).getArguments().get(1)).size());
        AstResult astResult = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(astResult.getAst());
        Assert.assertEquals(Collections.singleton(this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getEClass())), (Object)types);
    }

    @Test
    public void testOclAsTypeMayBeCompatibleTypeClass() {
        this.getQueryEnvironment().registerEPackage((EPackage)EcorePackage.eINSTANCE);
        AbstractServicesValidationTest.VariableBuilder variables = new AbstractServicesValidationTest.VariableBuilder().addVar("eClasssifier", new IType[]{this.classType(EClassifier.class)});
        IValidationResult validationResult = this.validate("eClasssifier.oclAsType(ecore::EClass)", variables.build());
        Expression ast = validationResult.getAstResult().getAst();
        Assert.assertEquals((long)0L, (long)validationResult.getMessages().size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)ast).size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Call)ast).getArguments().get(0)).size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Call)ast).getArguments().get(1)).size());
        AstResult astResult = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(astResult.getAst());
        Assert.assertEquals(Collections.singleton(this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getEClass())), (Object)types);
    }

    @Test
    public void testOclAsTypeMayBeCompatibleTypeECLassifierLiteral() {
        this.getQueryEnvironment().registerEPackage((EPackage)EcorePackage.eINSTANCE);
        AbstractServicesValidationTest.VariableBuilder variables = new AbstractServicesValidationTest.VariableBuilder().addVar("eClasssifier", new IType[]{this.eClassifierLiteralType((EClassifier)EcorePackage.eINSTANCE.getEClassifier())});
        IValidationResult validationResult = this.validate("eClasssifier.oclAsType(ecore::EClass)", variables.build());
        Expression ast = validationResult.getAstResult().getAst();
        Assert.assertEquals((long)0L, (long)validationResult.getMessages().size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)ast).size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Call)ast).getArguments().get(0)).size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Call)ast).getArguments().get(1)).size());
        AstResult astResult = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(astResult.getAst());
        Assert.assertEquals(Collections.singleton(this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getEClass())), (Object)types);
    }

    @Test
    public void testOclIsKindOfNullNull() {
        IValidationResult validationResult = this.validate("null.oclIsKindOf(null)");
        Expression ast = validationResult.getAstResult().getAst();
        Assert.assertEquals((long)0L, (long)validationResult.getMessages().size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)ast).size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Call)ast).getArguments().get(0)).size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Call)ast).getArguments().get(1)).size());
        AstResult astResult = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(astResult.getAst());
        Assert.assertEquals(Collections.singleton(this.classType(Boolean.class)), (Object)types);
    }

    @Test
    public void testOclIsKindOfNothingNull() {
        AbstractServicesValidationTest.VariableBuilder variables = new AbstractServicesValidationTest.VariableBuilder().addVar("nothing", new IType[]{this.nothingType("Nothing")});
        IValidationResult validationResult = this.validate("nothing.oclIsKindOf(null)", variables.build());
        Expression ast = validationResult.getAstResult().getAst();
        Assert.assertEquals((long)2L, (long)validationResult.getMessages().size());
        ValidationTest.assertValidationMessage((IValidationMessage)validationResult.getMessages().get(0), ValidationMessageLevel.ERROR, "Nothing", 0, 7);
        ValidationTest.assertValidationMessage((IValidationMessage)validationResult.getMessages().get(1), ValidationMessageLevel.INFO, "Always false:\nNothing inferred when nothing (Nothing(Nothing)) is kind of null", 0, 25);
        Assert.assertEquals((long)1L, (long)validationResult.getMessages((ASTNode)ast).size());
        ValidationTest.assertValidationMessage((IValidationMessage)validationResult.getMessages((ASTNode)ast).get(0), ValidationMessageLevel.INFO, "Always false:\nNothing inferred when nothing (Nothing(Nothing)) is kind of null", 0, 25);
        Assert.assertEquals((long)1L, (long)validationResult.getMessages((ASTNode)((Call)ast).getArguments().get(0)).size());
        ValidationTest.assertValidationMessage((IValidationMessage)validationResult.getMessages((ASTNode)((Call)ast).getArguments().get(0)).get(0), ValidationMessageLevel.ERROR, "Nothing", 0, 7);
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Call)ast).getArguments().get(1)).size());
        AstResult astResult = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(astResult.getAst());
        Assert.assertTrue((boolean)types.isEmpty());
    }

    @Test
    public void testOclIsKindOfNullNothing() {
        AbstractServicesValidationTest.VariableBuilder variables = new AbstractServicesValidationTest.VariableBuilder().addVar("nothing", new IType[]{this.nothingType("Nothing")});
        IValidationResult validationResult = this.validate("null.oclIsKindOf(nothing)", variables.build());
        Expression ast = validationResult.getAstResult().getAst();
        Assert.assertEquals((long)1L, (long)validationResult.getMessages().size());
        ValidationTest.assertValidationMessage((IValidationMessage)validationResult.getMessages().get(0), ValidationMessageLevel.ERROR, "Nothing", 17, 24);
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)ast).size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Call)ast).getArguments().get(0)).size());
        Assert.assertEquals((long)1L, (long)validationResult.getMessages((ASTNode)((Call)ast).getArguments().get(1)).size());
        ValidationTest.assertValidationMessage((IValidationMessage)validationResult.getMessages((ASTNode)((Call)ast).getArguments().get(1)).get(0), ValidationMessageLevel.ERROR, "Nothing", 17, 24);
        AstResult astResult = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(astResult.getAst());
        Assert.assertTrue((boolean)types.isEmpty());
    }

    @Test
    public void testOclIsKindOfNothingNothing() {
        AbstractServicesValidationTest.VariableBuilder variables = new AbstractServicesValidationTest.VariableBuilder().addVar("nothing", new IType[]{this.nothingType("Nothing")});
        IValidationResult validationResult = this.validate("nothing.oclIsKindOf(nothing)", variables.build());
        Expression ast = validationResult.getAstResult().getAst();
        Assert.assertEquals((long)2L, (long)validationResult.getMessages().size());
        ValidationTest.assertValidationMessage((IValidationMessage)validationResult.getMessages().get(0), ValidationMessageLevel.ERROR, "Nothing", 0, 7);
        ValidationTest.assertValidationMessage((IValidationMessage)validationResult.getMessages().get(1), ValidationMessageLevel.ERROR, "Nothing", 20, 27);
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)ast).size());
        Assert.assertEquals((long)1L, (long)validationResult.getMessages((ASTNode)((Call)ast).getArguments().get(0)).size());
        ValidationTest.assertValidationMessage((IValidationMessage)validationResult.getMessages((ASTNode)((Call)ast).getArguments().get(0)).get(0), ValidationMessageLevel.ERROR, "Nothing", 0, 7);
        Assert.assertEquals((long)1L, (long)validationResult.getMessages((ASTNode)((Call)ast).getArguments().get(1)).size());
        ValidationTest.assertValidationMessage((IValidationMessage)validationResult.getMessages((ASTNode)((Call)ast).getArguments().get(1)).get(0), ValidationMessageLevel.ERROR, "Nothing", 20, 27);
        AstResult astResult = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(astResult.getAst());
        Assert.assertTrue((boolean)types.isEmpty());
    }

    @Test
    public void testOclIsKindOfSameTypeClass() {
        this.getQueryEnvironment().registerEPackage((EPackage)EcorePackage.eINSTANCE);
        AbstractServicesValidationTest.VariableBuilder variables = new AbstractServicesValidationTest.VariableBuilder().addVar("var", new IType[]{this.classType(String.class)});
        IValidationResult validationResult = this.validate("var.oclIsKindOf(String)", variables.build());
        Expression ast = validationResult.getAstResult().getAst();
        String expectedMessage = "Always true:\nNothing inferred when var (java.lang.String) is not kind of ClassLiteral=java.lang.String";
        Assert.assertEquals((long)1L, (long)validationResult.getMessages().size());
        ValidationTest.assertValidationMessage((IValidationMessage)validationResult.getMessages().get(0), ValidationMessageLevel.INFO, "Always true:\nNothing inferred when var (java.lang.String) is not kind of ClassLiteral=java.lang.String", 0, 23);
        Assert.assertEquals((long)1L, (long)validationResult.getMessages((ASTNode)ast).size());
        ValidationTest.assertValidationMessage((IValidationMessage)validationResult.getMessages((ASTNode)ast).get(0), ValidationMessageLevel.INFO, "Always true:\nNothing inferred when var (java.lang.String) is not kind of ClassLiteral=java.lang.String", 0, 23);
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Call)ast).getArguments().get(0)).size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Call)ast).getArguments().get(1)).size());
        AstResult astResult = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(astResult.getAst());
        Assert.assertEquals(Collections.singleton(this.classType(Boolean.class)), (Object)types);
    }

    @Test
    public void testOclIsKindOfSameTypeClassLiteral() {
        this.getQueryEnvironment().registerEPackage((EPackage)EcorePackage.eINSTANCE);
        AbstractServicesValidationTest.VariableBuilder variables = new AbstractServicesValidationTest.VariableBuilder().addVar("var", new IType[]{this.classLiteralType(String.class)});
        IValidationResult validationResult = this.validate("var.oclIsKindOf(String)", variables.build());
        Expression ast = validationResult.getAstResult().getAst();
        String expectedMessage = "Always true:\nNothing inferred when var (ClassLiteral=java.lang.String) is not kind of ClassLiteral=java.lang.String";
        Assert.assertEquals((long)1L, (long)validationResult.getMessages().size());
        ValidationTest.assertValidationMessage((IValidationMessage)validationResult.getMessages().get(0), ValidationMessageLevel.INFO, "Always true:\nNothing inferred when var (ClassLiteral=java.lang.String) is not kind of ClassLiteral=java.lang.String", 0, 23);
        Assert.assertEquals((long)1L, (long)validationResult.getMessages((ASTNode)ast).size());
        ValidationTest.assertValidationMessage((IValidationMessage)validationResult.getMessages((ASTNode)ast).get(0), ValidationMessageLevel.INFO, "Always true:\nNothing inferred when var (ClassLiteral=java.lang.String) is not kind of ClassLiteral=java.lang.String", 0, 23);
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Call)ast).getArguments().get(0)).size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Call)ast).getArguments().get(1)).size());
        AstResult astResult = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(astResult.getAst());
        Assert.assertEquals(Collections.singleton(this.classType(Boolean.class)), (Object)types);
    }

    @Test
    public void testOclIsKindOfSameType() {
        this.getQueryEnvironment().registerEPackage((EPackage)EcorePackage.eINSTANCE);
        AbstractServicesValidationTest.VariableBuilder variables = new AbstractServicesValidationTest.VariableBuilder().addVar("eCls", new IType[]{this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getEClass())});
        IValidationResult validationResult = this.validate("eCls.oclIsKindOf(ecore::EClass)", variables.build());
        Expression ast = validationResult.getAstResult().getAst();
        String expectedMessage = "Always true:\nNothing inferred when eCls (EClassifier=EClass) is not kind of EClassifierLiteral=EClass";
        Assert.assertEquals((long)1L, (long)validationResult.getMessages().size());
        ValidationTest.assertValidationMessage((IValidationMessage)validationResult.getMessages().get(0), ValidationMessageLevel.INFO, "Always true:\nNothing inferred when eCls (EClassifier=EClass) is not kind of EClassifierLiteral=EClass", 0, 31);
        Assert.assertEquals((long)1L, (long)validationResult.getMessages((ASTNode)ast).size());
        ValidationTest.assertValidationMessage((IValidationMessage)validationResult.getMessages((ASTNode)ast).get(0), ValidationMessageLevel.INFO, "Always true:\nNothing inferred when eCls (EClassifier=EClass) is not kind of EClassifierLiteral=EClass", 0, 31);
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Call)ast).getArguments().get(0)).size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Call)ast).getArguments().get(1)).size());
        AstResult astResult = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(astResult.getAst());
        Assert.assertEquals(Collections.singleton(this.classType(Boolean.class)), (Object)types);
    }

    @Test
    public void testOclIsKindOfSameTypeEClassifierLiteral() {
        this.getQueryEnvironment().registerEPackage((EPackage)EcorePackage.eINSTANCE);
        AbstractServicesValidationTest.VariableBuilder variables = new AbstractServicesValidationTest.VariableBuilder().addVar("eCls", new IType[]{this.eClassifierLiteralType((EClassifier)EcorePackage.eINSTANCE.getEClass())});
        IValidationResult validationResult = this.validate("eCls.oclIsKindOf(ecore::EClass)", variables.build());
        Expression ast = validationResult.getAstResult().getAst();
        String expectedMessage = "Always true:\nNothing inferred when eCls (EClassifierLiteral=EClass) is not kind of EClassifierLiteral=EClass";
        Assert.assertEquals((long)1L, (long)validationResult.getMessages().size());
        ValidationTest.assertValidationMessage((IValidationMessage)validationResult.getMessages().get(0), ValidationMessageLevel.INFO, "Always true:\nNothing inferred when eCls (EClassifierLiteral=EClass) is not kind of EClassifierLiteral=EClass", 0, 31);
        Assert.assertEquals((long)1L, (long)validationResult.getMessages((ASTNode)ast).size());
        ValidationTest.assertValidationMessage((IValidationMessage)validationResult.getMessages((ASTNode)ast).get(0), ValidationMessageLevel.INFO, "Always true:\nNothing inferred when eCls (EClassifierLiteral=EClass) is not kind of EClassifierLiteral=EClass", 0, 31);
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Call)ast).getArguments().get(0)).size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Call)ast).getArguments().get(1)).size());
        AstResult astResult = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(astResult.getAst());
        Assert.assertEquals(Collections.singleton(this.classType(Boolean.class)), (Object)types);
    }

    @Test
    public void testOclIsKindOfNotCompatibleTypeClass() {
        this.getQueryEnvironment().registerEPackage((EPackage)EcorePackage.eINSTANCE);
        AbstractServicesValidationTest.VariableBuilder variables = new AbstractServicesValidationTest.VariableBuilder().addVar("var", new IType[]{this.classType(String.class)});
        IValidationResult validationResult = this.validate("var.oclIsKindOf(Integer)", variables.build());
        Expression ast = validationResult.getAstResult().getAst();
        String expectedMessage = "Always false:\nNothing inferred when var (java.lang.String) is kind of ClassLiteral=java.lang.Integer";
        Assert.assertEquals((long)1L, (long)validationResult.getMessages().size());
        ValidationTest.assertValidationMessage((IValidationMessage)validationResult.getMessages().get(0), ValidationMessageLevel.INFO, "Always false:\nNothing inferred when var (java.lang.String) is kind of ClassLiteral=java.lang.Integer", 0, 24);
        Assert.assertEquals((long)1L, (long)validationResult.getMessages((ASTNode)ast).size());
        ValidationTest.assertValidationMessage((IValidationMessage)validationResult.getMessages((ASTNode)ast).get(0), ValidationMessageLevel.INFO, "Always false:\nNothing inferred when var (java.lang.String) is kind of ClassLiteral=java.lang.Integer", 0, 24);
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Call)ast).getArguments().get(0)).size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Call)ast).getArguments().get(1)).size());
        AstResult astResult = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(astResult.getAst());
        Assert.assertEquals(Collections.singleton(this.classType(Boolean.class)), (Object)types);
    }

    @Test
    public void testOclIsKindOfNotCompatibleTypeClassLiteral() {
        this.getQueryEnvironment().registerEPackage((EPackage)EcorePackage.eINSTANCE);
        AbstractServicesValidationTest.VariableBuilder variables = new AbstractServicesValidationTest.VariableBuilder().addVar("var", new IType[]{this.classLiteralType(String.class)});
        IValidationResult validationResult = this.validate("var.oclIsKindOf(Integer)", variables.build());
        Expression ast = validationResult.getAstResult().getAst();
        String expectedMessage = "Always false:\nNothing inferred when var (ClassLiteral=java.lang.String) is kind of ClassLiteral=java.lang.Integer";
        Assert.assertEquals((long)1L, (long)validationResult.getMessages().size());
        ValidationTest.assertValidationMessage((IValidationMessage)validationResult.getMessages().get(0), ValidationMessageLevel.INFO, "Always false:\nNothing inferred when var (ClassLiteral=java.lang.String) is kind of ClassLiteral=java.lang.Integer", 0, 24);
        Assert.assertEquals((long)1L, (long)validationResult.getMessages((ASTNode)ast).size());
        ValidationTest.assertValidationMessage((IValidationMessage)validationResult.getMessages((ASTNode)ast).get(0), ValidationMessageLevel.INFO, "Always false:\nNothing inferred when var (ClassLiteral=java.lang.String) is kind of ClassLiteral=java.lang.Integer", 0, 24);
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Call)ast).getArguments().get(0)).size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Call)ast).getArguments().get(1)).size());
        AstResult astResult = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(astResult.getAst());
        Assert.assertEquals(Collections.singleton(this.classType(Boolean.class)), (Object)types);
    }

    @Test
    public void testOclIsKindOfNotCompatibleType() {
        this.getQueryEnvironment().registerEPackage((EPackage)EcorePackage.eINSTANCE);
        AbstractServicesValidationTest.VariableBuilder variables = new AbstractServicesValidationTest.VariableBuilder().addVar("eCls", new IType[]{this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getEClass())});
        IValidationResult validationResult = this.validate("eCls.oclIsKindOf(ecore::EPackage)", variables.build());
        Expression ast = validationResult.getAstResult().getAst();
        String expectedMessage = "Always false:\nNothing inferred when eCls (EClassifier=EClass) is kind of EClassifierLiteral=EPackage";
        Assert.assertEquals((long)1L, (long)validationResult.getMessages().size());
        ValidationTest.assertValidationMessage((IValidationMessage)validationResult.getMessages().get(0), ValidationMessageLevel.INFO, "Always false:\nNothing inferred when eCls (EClassifier=EClass) is kind of EClassifierLiteral=EPackage", 0, 33);
        Assert.assertEquals((long)1L, (long)validationResult.getMessages((ASTNode)ast).size());
        ValidationTest.assertValidationMessage((IValidationMessage)validationResult.getMessages((ASTNode)ast).get(0), ValidationMessageLevel.INFO, "Always false:\nNothing inferred when eCls (EClassifier=EClass) is kind of EClassifierLiteral=EPackage", 0, 33);
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Call)ast).getArguments().get(0)).size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Call)ast).getArguments().get(1)).size());
        AstResult astResult = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(astResult.getAst());
        Assert.assertEquals(Collections.singleton(this.classType(Boolean.class)), (Object)types);
    }

    @Test
    public void testOclIsKindOfNotCompatibleTypeClassClass() {
        this.getQueryEnvironment().registerEPackage((EPackage)EcorePackage.eINSTANCE);
        AbstractServicesValidationTest.VariableBuilder variables = new AbstractServicesValidationTest.VariableBuilder().addVar("eCls", new IType[]{this.classType(EClass.class)});
        IValidationResult validationResult = this.validate("eCls.oclIsKindOf(ecore::EPackage)", variables.build());
        Expression ast = validationResult.getAstResult().getAst();
        String expectedMessage = "Always false:\nNothing inferred when eCls (org.eclipse.emf.ecore.EClass) is kind of EClassifierLiteral=EPackage";
        Assert.assertEquals((long)1L, (long)validationResult.getMessages().size());
        ValidationTest.assertValidationMessage((IValidationMessage)validationResult.getMessages().get(0), ValidationMessageLevel.INFO, "Always false:\nNothing inferred when eCls (org.eclipse.emf.ecore.EClass) is kind of EClassifierLiteral=EPackage", 0, 33);
        Assert.assertEquals((long)1L, (long)validationResult.getMessages((ASTNode)ast).size());
        ValidationTest.assertValidationMessage((IValidationMessage)validationResult.getMessages((ASTNode)ast).get(0), ValidationMessageLevel.INFO, "Always false:\nNothing inferred when eCls (org.eclipse.emf.ecore.EClass) is kind of EClassifierLiteral=EPackage", 0, 33);
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Call)ast).getArguments().get(0)).size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Call)ast).getArguments().get(1)).size());
        AstResult astResult = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(astResult.getAst());
        Assert.assertEquals(Collections.singleton(this.classType(Boolean.class)), (Object)types);
    }

    @Test
    public void testOclIsKindOfNotCompatibleTypeEClassifierLiteral() {
        this.getQueryEnvironment().registerEPackage((EPackage)EcorePackage.eINSTANCE);
        AbstractServicesValidationTest.VariableBuilder variables = new AbstractServicesValidationTest.VariableBuilder().addVar("eCls", new IType[]{this.eClassifierLiteralType((EClassifier)EcorePackage.eINSTANCE.getEClass())});
        IValidationResult validationResult = this.validate("eCls.oclIsKindOf(ecore::EPackage)", variables.build());
        Expression ast = validationResult.getAstResult().getAst();
        String expectedMessage = "Always false:\nNothing inferred when eCls (EClassifierLiteral=EClass) is kind of EClassifierLiteral=EPackage";
        Assert.assertEquals((long)1L, (long)validationResult.getMessages().size());
        ValidationTest.assertValidationMessage((IValidationMessage)validationResult.getMessages().get(0), ValidationMessageLevel.INFO, "Always false:\nNothing inferred when eCls (EClassifierLiteral=EClass) is kind of EClassifierLiteral=EPackage", 0, 33);
        Assert.assertEquals((long)1L, (long)validationResult.getMessages((ASTNode)ast).size());
        ValidationTest.assertValidationMessage((IValidationMessage)validationResult.getMessages((ASTNode)ast).get(0), ValidationMessageLevel.INFO, "Always false:\nNothing inferred when eCls (EClassifierLiteral=EClass) is kind of EClassifierLiteral=EPackage", 0, 33);
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Call)ast).getArguments().get(0)).size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Call)ast).getArguments().get(1)).size());
        AstResult astResult = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(astResult.getAst());
        Assert.assertEquals(Collections.singleton(this.classType(Boolean.class)), (Object)types);
    }

    @Test
    public void testOclIsKindOfMayBeCompatibleType() {
        this.getQueryEnvironment().registerEPackage((EPackage)EcorePackage.eINSTANCE);
        AbstractServicesValidationTest.VariableBuilder variables = new AbstractServicesValidationTest.VariableBuilder().addVar("eClasssifier", new IType[]{this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getEClassifier())});
        IValidationResult validationResult = this.validate("eClasssifier.oclIsKindOf(ecore::EClass)", variables.build());
        Expression ast = validationResult.getAstResult().getAst();
        Assert.assertEquals((long)0L, (long)validationResult.getMessages().size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)ast).size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Call)ast).getArguments().get(0)).size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Call)ast).getArguments().get(1)).size());
        AstResult astResult = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(astResult.getAst());
        Assert.assertEquals(Collections.singleton(this.classType(Boolean.class)), (Object)types);
    }

    @Test
    public void testOclIsKindOfMayBeCompatibleTypeClass() {
        this.getQueryEnvironment().registerEPackage((EPackage)EcorePackage.eINSTANCE);
        AbstractServicesValidationTest.VariableBuilder variables = new AbstractServicesValidationTest.VariableBuilder().addVar("eClasssifier", new IType[]{this.classType(EClassifier.class)});
        IValidationResult validationResult = this.validate("eClasssifier.oclIsKindOf(ecore::EClass)", variables.build());
        Expression ast = validationResult.getAstResult().getAst();
        Assert.assertEquals((long)0L, (long)validationResult.getMessages().size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)ast).size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Call)ast).getArguments().get(0)).size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Call)ast).getArguments().get(1)).size());
        AstResult astResult = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(astResult.getAst());
        Assert.assertEquals(Collections.singleton(this.classType(Boolean.class)), (Object)types);
    }

    @Test
    public void testOclIsKindOfMayBeCompatibleTypeEClassifierLiteral() {
        this.getQueryEnvironment().registerEPackage((EPackage)EcorePackage.eINSTANCE);
        AbstractServicesValidationTest.VariableBuilder variables = new AbstractServicesValidationTest.VariableBuilder().addVar("eClasssifier", new IType[]{this.eClassifierLiteralType((EClassifier)EcorePackage.eINSTANCE.getEClassifier())});
        IValidationResult validationResult = this.validate("eClasssifier.oclIsKindOf(ecore::EClass)", variables.build());
        Expression ast = validationResult.getAstResult().getAst();
        Assert.assertEquals((long)0L, (long)validationResult.getMessages().size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)ast).size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Call)ast).getArguments().get(0)).size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Call)ast).getArguments().get(1)).size());
        AstResult astResult = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(astResult.getAst());
        Assert.assertEquals(Collections.singleton(this.classType(Boolean.class)), (Object)types);
    }

    @Test
    public void testOclIsTypeOfNullNull() {
        IValidationResult validationResult = this.validate("null.oclIsTypeOf(null)");
        Expression ast = validationResult.getAstResult().getAst();
        Assert.assertEquals((long)0L, (long)validationResult.getMessages().size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)ast).size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Call)ast).getArguments().get(0)).size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Call)ast).getArguments().get(1)).size());
        AstResult astResult = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(astResult.getAst());
        Assert.assertEquals(Collections.singleton(this.classType(Boolean.class)), (Object)types);
    }

    @Test
    public void testOclIsTypeOfNothingNull() {
        AbstractServicesValidationTest.VariableBuilder variables = new AbstractServicesValidationTest.VariableBuilder().addVar("nothing", new IType[]{this.nothingType("Nothing")});
        IValidationResult validationResult = this.validate("nothing.oclIsTypeOf(null)", variables.build());
        Expression ast = validationResult.getAstResult().getAst();
        Assert.assertEquals((long)2L, (long)validationResult.getMessages().size());
        ValidationTest.assertValidationMessage((IValidationMessage)validationResult.getMessages().get(0), ValidationMessageLevel.ERROR, "Nothing", 0, 7);
        ValidationTest.assertValidationMessage((IValidationMessage)validationResult.getMessages().get(1), ValidationMessageLevel.INFO, "Always false:\nNothing inferred when nothing (Nothing(Nothing)) is type of null", 0, 25);
        Assert.assertEquals((long)1L, (long)validationResult.getMessages((ASTNode)ast).size());
        ValidationTest.assertValidationMessage((IValidationMessage)validationResult.getMessages((ASTNode)ast).get(0), ValidationMessageLevel.INFO, "Always false:\nNothing inferred when nothing (Nothing(Nothing)) is type of null", 0, 25);
        Assert.assertEquals((long)1L, (long)validationResult.getMessages((ASTNode)((Call)ast).getArguments().get(0)).size());
        ValidationTest.assertValidationMessage((IValidationMessage)validationResult.getMessages((ASTNode)((Call)ast).getArguments().get(0)).get(0), ValidationMessageLevel.ERROR, "Nothing", 0, 7);
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Call)ast).getArguments().get(1)).size());
        AstResult astResult = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(astResult.getAst());
        Assert.assertTrue((boolean)types.isEmpty());
    }

    @Test
    public void testOclIsTypeOfNullNothing() {
        AbstractServicesValidationTest.VariableBuilder variables = new AbstractServicesValidationTest.VariableBuilder().addVar("nothing", new IType[]{this.nothingType("Nothing")});
        IValidationResult validationResult = this.validate("null.oclIsTypeOf(nothing)", variables.build());
        Expression ast = validationResult.getAstResult().getAst();
        Assert.assertEquals((long)1L, (long)validationResult.getMessages().size());
        ValidationTest.assertValidationMessage((IValidationMessage)validationResult.getMessages().get(0), ValidationMessageLevel.ERROR, "Nothing", 17, 24);
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)ast).size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Call)ast).getArguments().get(0)).size());
        Assert.assertEquals((long)1L, (long)validationResult.getMessages((ASTNode)((Call)ast).getArguments().get(1)).size());
        ValidationTest.assertValidationMessage((IValidationMessage)validationResult.getMessages((ASTNode)((Call)ast).getArguments().get(1)).get(0), ValidationMessageLevel.ERROR, "Nothing", 17, 24);
        AstResult astResult = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(astResult.getAst());
        Assert.assertTrue((boolean)types.isEmpty());
    }

    @Test
    public void testOclIsTypeOfNothingNothing() {
        AbstractServicesValidationTest.VariableBuilder variables = new AbstractServicesValidationTest.VariableBuilder().addVar("nothing", new IType[]{this.nothingType("Nothing")});
        IValidationResult validationResult = this.validate("nothing.oclIsTypeOf(nothing)", variables.build());
        Expression ast = validationResult.getAstResult().getAst();
        Assert.assertEquals((long)2L, (long)validationResult.getMessages().size());
        ValidationTest.assertValidationMessage((IValidationMessage)validationResult.getMessages().get(0), ValidationMessageLevel.ERROR, "Nothing", 0, 7);
        ValidationTest.assertValidationMessage((IValidationMessage)validationResult.getMessages().get(1), ValidationMessageLevel.ERROR, "Nothing", 20, 27);
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)ast).size());
        Assert.assertEquals((long)1L, (long)validationResult.getMessages((ASTNode)((Call)ast).getArguments().get(0)).size());
        ValidationTest.assertValidationMessage((IValidationMessage)validationResult.getMessages((ASTNode)((Call)ast).getArguments().get(0)).get(0), ValidationMessageLevel.ERROR, "Nothing", 0, 7);
        Assert.assertEquals((long)1L, (long)validationResult.getMessages((ASTNode)((Call)ast).getArguments().get(1)).size());
        ValidationTest.assertValidationMessage((IValidationMessage)validationResult.getMessages((ASTNode)((Call)ast).getArguments().get(1)).get(0), ValidationMessageLevel.ERROR, "Nothing", 20, 27);
        AstResult astResult = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(astResult.getAst());
        Assert.assertTrue((boolean)types.isEmpty());
    }

    @Test
    public void testOclIsTypeOfSameTypeClass() {
        this.getQueryEnvironment().registerEPackage((EPackage)EcorePackage.eINSTANCE);
        AbstractServicesValidationTest.VariableBuilder variables = new AbstractServicesValidationTest.VariableBuilder().addVar("var", new IType[]{this.classType(String.class)});
        IValidationResult validationResult = this.validate("var.oclIsTypeOf(String)", variables.build());
        Expression ast = validationResult.getAstResult().getAst();
        String expectedMessage = "Always true:\nNothing inferred when var (java.lang.String) is not type of ClassLiteral=java.lang.String";
        Assert.assertEquals((long)1L, (long)validationResult.getMessages().size());
        ValidationTest.assertValidationMessage((IValidationMessage)validationResult.getMessages().get(0), ValidationMessageLevel.INFO, "Always true:\nNothing inferred when var (java.lang.String) is not type of ClassLiteral=java.lang.String", 0, 23);
        Assert.assertEquals((long)1L, (long)validationResult.getMessages((ASTNode)ast).size());
        ValidationTest.assertValidationMessage((IValidationMessage)validationResult.getMessages((ASTNode)ast).get(0), ValidationMessageLevel.INFO, "Always true:\nNothing inferred when var (java.lang.String) is not type of ClassLiteral=java.lang.String", 0, 23);
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Call)ast).getArguments().get(0)).size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Call)ast).getArguments().get(1)).size());
        AstResult astResult = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(astResult.getAst());
        Assert.assertEquals(Collections.singleton(this.classType(Boolean.class)), (Object)types);
    }

    @Test
    public void testOclIsTypeOfSameTypeClassLiteral() {
        this.getQueryEnvironment().registerEPackage((EPackage)EcorePackage.eINSTANCE);
        AbstractServicesValidationTest.VariableBuilder variables = new AbstractServicesValidationTest.VariableBuilder().addVar("var", new IType[]{this.classLiteralType(String.class)});
        IValidationResult validationResult = this.validate("var.oclIsTypeOf(String)", variables.build());
        Expression ast = validationResult.getAstResult().getAst();
        String expectedMessage = "Always true:\nNothing inferred when var (ClassLiteral=java.lang.String) is not type of ClassLiteral=java.lang.String";
        Assert.assertEquals((long)1L, (long)validationResult.getMessages().size());
        ValidationTest.assertValidationMessage((IValidationMessage)validationResult.getMessages().get(0), ValidationMessageLevel.INFO, "Always true:\nNothing inferred when var (ClassLiteral=java.lang.String) is not type of ClassLiteral=java.lang.String", 0, 23);
        Assert.assertEquals((long)1L, (long)validationResult.getMessages((ASTNode)ast).size());
        ValidationTest.assertValidationMessage((IValidationMessage)validationResult.getMessages((ASTNode)ast).get(0), ValidationMessageLevel.INFO, "Always true:\nNothing inferred when var (ClassLiteral=java.lang.String) is not type of ClassLiteral=java.lang.String", 0, 23);
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Call)ast).getArguments().get(0)).size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Call)ast).getArguments().get(1)).size());
        AstResult astResult = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(astResult.getAst());
        Assert.assertEquals(Collections.singleton(this.classType(Boolean.class)), (Object)types);
    }

    @Test
    public void testOclIsTypeOfSameType() {
        this.getQueryEnvironment().registerEPackage((EPackage)EcorePackage.eINSTANCE);
        AbstractServicesValidationTest.VariableBuilder variables = new AbstractServicesValidationTest.VariableBuilder().addVar("eCls", new IType[]{this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getEClass())});
        IValidationResult validationResult = this.validate("eCls.oclIsTypeOf(ecore::EClass)", variables.build());
        Expression ast = validationResult.getAstResult().getAst();
        String expectedMessage = "Always true:\nNothing inferred when eCls (EClassifier=EClass) is not type of EClassifierLiteral=EClass";
        Assert.assertEquals((long)1L, (long)validationResult.getMessages().size());
        ValidationTest.assertValidationMessage((IValidationMessage)validationResult.getMessages().get(0), ValidationMessageLevel.INFO, "Always true:\nNothing inferred when eCls (EClassifier=EClass) is not type of EClassifierLiteral=EClass", 0, 31);
        Assert.assertEquals((long)1L, (long)validationResult.getMessages((ASTNode)ast).size());
        ValidationTest.assertValidationMessage((IValidationMessage)validationResult.getMessages((ASTNode)ast).get(0), ValidationMessageLevel.INFO, "Always true:\nNothing inferred when eCls (EClassifier=EClass) is not type of EClassifierLiteral=EClass", 0, 31);
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Call)ast).getArguments().get(0)).size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Call)ast).getArguments().get(1)).size());
        AstResult astResult = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(astResult.getAst());
        Assert.assertEquals(Collections.singleton(this.classType(Boolean.class)), (Object)types);
    }

    @Test
    public void testOclIsTypeOfSameTypeClassClass() {
        this.getQueryEnvironment().registerEPackage((EPackage)EcorePackage.eINSTANCE);
        AbstractServicesValidationTest.VariableBuilder variables = new AbstractServicesValidationTest.VariableBuilder().addVar("eCls", new IType[]{this.classType(EClass.class)});
        IValidationResult validationResult = this.validate("eCls.oclIsTypeOf(ecore::EClass)", variables.build());
        Expression ast = validationResult.getAstResult().getAst();
        String expectedMessage = "Always true:\nNothing inferred when eCls (org.eclipse.emf.ecore.EClass) is not type of EClassifierLiteral=EClass";
        Assert.assertEquals((long)1L, (long)validationResult.getMessages().size());
        ValidationTest.assertValidationMessage((IValidationMessage)validationResult.getMessages().get(0), ValidationMessageLevel.INFO, "Always true:\nNothing inferred when eCls (org.eclipse.emf.ecore.EClass) is not type of EClassifierLiteral=EClass", 0, 31);
        Assert.assertEquals((long)1L, (long)validationResult.getMessages((ASTNode)ast).size());
        ValidationTest.assertValidationMessage((IValidationMessage)validationResult.getMessages((ASTNode)ast).get(0), ValidationMessageLevel.INFO, "Always true:\nNothing inferred when eCls (org.eclipse.emf.ecore.EClass) is not type of EClassifierLiteral=EClass", 0, 31);
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Call)ast).getArguments().get(0)).size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Call)ast).getArguments().get(1)).size());
        AstResult astResult = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(astResult.getAst());
        Assert.assertEquals(Collections.singleton(this.classType(Boolean.class)), (Object)types);
    }

    @Test
    public void testOclIsTypeOfSameTypeEClassifierLiteral() {
        this.getQueryEnvironment().registerEPackage((EPackage)EcorePackage.eINSTANCE);
        AbstractServicesValidationTest.VariableBuilder variables = new AbstractServicesValidationTest.VariableBuilder().addVar("eCls", new IType[]{this.eClassifierLiteralType((EClassifier)EcorePackage.eINSTANCE.getEClass())});
        IValidationResult validationResult = this.validate("eCls.oclIsTypeOf(ecore::EClass)", variables.build());
        Expression ast = validationResult.getAstResult().getAst();
        String expectedMessage = "Always true:\nNothing inferred when eCls (EClassifierLiteral=EClass) is not type of EClassifierLiteral=EClass";
        Assert.assertEquals((long)1L, (long)validationResult.getMessages().size());
        ValidationTest.assertValidationMessage((IValidationMessage)validationResult.getMessages().get(0), ValidationMessageLevel.INFO, "Always true:\nNothing inferred when eCls (EClassifierLiteral=EClass) is not type of EClassifierLiteral=EClass", 0, 31);
        Assert.assertEquals((long)1L, (long)validationResult.getMessages((ASTNode)ast).size());
        ValidationTest.assertValidationMessage((IValidationMessage)validationResult.getMessages((ASTNode)ast).get(0), ValidationMessageLevel.INFO, "Always true:\nNothing inferred when eCls (EClassifierLiteral=EClass) is not type of EClassifierLiteral=EClass", 0, 31);
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Call)ast).getArguments().get(0)).size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Call)ast).getArguments().get(1)).size());
        AstResult astResult = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(astResult.getAst());
        Assert.assertEquals(Collections.singleton(this.classType(Boolean.class)), (Object)types);
    }

    @Test
    public void testOclIsTypeOfNotCompatibleTypeClass() {
        this.getQueryEnvironment().registerEPackage((EPackage)EcorePackage.eINSTANCE);
        AbstractServicesValidationTest.VariableBuilder variables = new AbstractServicesValidationTest.VariableBuilder().addVar("var", new IType[]{this.classType(String.class)});
        IValidationResult validationResult = this.validate("var.oclIsTypeOf(Integer)", variables.build());
        Expression ast = validationResult.getAstResult().getAst();
        String expectedMessage = "Always false:\nNothing inferred when var (java.lang.String) is type of ClassLiteral=java.lang.Integer";
        Assert.assertEquals((long)1L, (long)validationResult.getMessages().size());
        ValidationTest.assertValidationMessage((IValidationMessage)validationResult.getMessages().get(0), ValidationMessageLevel.INFO, "Always false:\nNothing inferred when var (java.lang.String) is type of ClassLiteral=java.lang.Integer", 0, 24);
        Assert.assertEquals((long)1L, (long)validationResult.getMessages((ASTNode)ast).size());
        ValidationTest.assertValidationMessage((IValidationMessage)validationResult.getMessages((ASTNode)ast).get(0), ValidationMessageLevel.INFO, "Always false:\nNothing inferred when var (java.lang.String) is type of ClassLiteral=java.lang.Integer", 0, 24);
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Call)ast).getArguments().get(0)).size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Call)ast).getArguments().get(1)).size());
        AstResult astResult = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(astResult.getAst());
        Assert.assertEquals(Collections.singleton(this.classType(Boolean.class)), (Object)types);
    }

    @Test
    public void testOclIsTypeOfNotCompatibleTypeClassLiteral() {
        this.getQueryEnvironment().registerEPackage((EPackage)EcorePackage.eINSTANCE);
        AbstractServicesValidationTest.VariableBuilder variables = new AbstractServicesValidationTest.VariableBuilder().addVar("var", new IType[]{this.classLiteralType(String.class)});
        IValidationResult validationResult = this.validate("var.oclIsTypeOf(Integer)", variables.build());
        Expression ast = validationResult.getAstResult().getAst();
        String expectedMessage = "Always false:\nNothing inferred when var (ClassLiteral=java.lang.String) is type of ClassLiteral=java.lang.Integer";
        Assert.assertEquals((long)1L, (long)validationResult.getMessages().size());
        ValidationTest.assertValidationMessage((IValidationMessage)validationResult.getMessages().get(0), ValidationMessageLevel.INFO, "Always false:\nNothing inferred when var (ClassLiteral=java.lang.String) is type of ClassLiteral=java.lang.Integer", 0, 24);
        Assert.assertEquals((long)1L, (long)validationResult.getMessages((ASTNode)ast).size());
        ValidationTest.assertValidationMessage((IValidationMessage)validationResult.getMessages((ASTNode)ast).get(0), ValidationMessageLevel.INFO, "Always false:\nNothing inferred when var (ClassLiteral=java.lang.String) is type of ClassLiteral=java.lang.Integer", 0, 24);
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Call)ast).getArguments().get(0)).size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Call)ast).getArguments().get(1)).size());
        AstResult astResult = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(astResult.getAst());
        Assert.assertEquals(Collections.singleton(this.classType(Boolean.class)), (Object)types);
    }

    @Test
    public void testOclIsTypeOfNotCompatibleType() {
        this.getQueryEnvironment().registerEPackage((EPackage)EcorePackage.eINSTANCE);
        AbstractServicesValidationTest.VariableBuilder variables = new AbstractServicesValidationTest.VariableBuilder().addVar("eCls", new IType[]{this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getEClass())});
        IValidationResult validationResult = this.validate("eCls.oclIsTypeOf(ecore::EPackage)", variables.build());
        Expression ast = validationResult.getAstResult().getAst();
        String expectedMessage = "Always false:\nNothing inferred when eCls (EClassifier=EClass) is type of EClassifierLiteral=EPackage";
        Assert.assertEquals((long)1L, (long)validationResult.getMessages().size());
        ValidationTest.assertValidationMessage((IValidationMessage)validationResult.getMessages().get(0), ValidationMessageLevel.INFO, "Always false:\nNothing inferred when eCls (EClassifier=EClass) is type of EClassifierLiteral=EPackage", 0, 33);
        Assert.assertEquals((long)1L, (long)validationResult.getMessages((ASTNode)ast).size());
        ValidationTest.assertValidationMessage((IValidationMessage)validationResult.getMessages((ASTNode)ast).get(0), ValidationMessageLevel.INFO, "Always false:\nNothing inferred when eCls (EClassifier=EClass) is type of EClassifierLiteral=EPackage", 0, 33);
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Call)ast).getArguments().get(0)).size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Call)ast).getArguments().get(1)).size());
        AstResult astResult = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(astResult.getAst());
        Assert.assertEquals(Collections.singleton(this.classType(Boolean.class)), (Object)types);
    }

    @Test
    public void testOclIsTypeOfNotCompatibleTypeEClassifierLiteral() {
        this.getQueryEnvironment().registerEPackage((EPackage)EcorePackage.eINSTANCE);
        AbstractServicesValidationTest.VariableBuilder variables = new AbstractServicesValidationTest.VariableBuilder().addVar("eCls", new IType[]{this.eClassifierLiteralType((EClassifier)EcorePackage.eINSTANCE.getEClass())});
        IValidationResult validationResult = this.validate("eCls.oclIsTypeOf(ecore::EPackage)", variables.build());
        Expression ast = validationResult.getAstResult().getAst();
        String expectedMessage = "Always false:\nNothing inferred when eCls (EClassifierLiteral=EClass) is type of EClassifierLiteral=EPackage";
        Assert.assertEquals((long)1L, (long)validationResult.getMessages().size());
        ValidationTest.assertValidationMessage((IValidationMessage)validationResult.getMessages().get(0), ValidationMessageLevel.INFO, "Always false:\nNothing inferred when eCls (EClassifierLiteral=EClass) is type of EClassifierLiteral=EPackage", 0, 33);
        Assert.assertEquals((long)1L, (long)validationResult.getMessages((ASTNode)ast).size());
        ValidationTest.assertValidationMessage((IValidationMessage)validationResult.getMessages((ASTNode)ast).get(0), ValidationMessageLevel.INFO, "Always false:\nNothing inferred when eCls (EClassifierLiteral=EClass) is type of EClassifierLiteral=EPackage", 0, 33);
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Call)ast).getArguments().get(0)).size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Call)ast).getArguments().get(1)).size());
        AstResult astResult = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(astResult.getAst());
        Assert.assertEquals(Collections.singleton(this.classType(Boolean.class)), (Object)types);
    }

    @Test
    public void testOclIsTypeOfMayBeCompatibleType() {
        this.getQueryEnvironment().registerEPackage((EPackage)EcorePackage.eINSTANCE);
        AbstractServicesValidationTest.VariableBuilder variables = new AbstractServicesValidationTest.VariableBuilder().addVar("eClasssifier", new IType[]{this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getEClassifier())});
        IValidationResult validationResult = this.validate("eClasssifier.oclIsTypeOf(ecore::EClass)", variables.build());
        Expression ast = validationResult.getAstResult().getAst();
        Assert.assertEquals((long)0L, (long)validationResult.getMessages().size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)ast).size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Call)ast).getArguments().get(0)).size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Call)ast).getArguments().get(1)).size());
        AstResult astResult = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(astResult.getAst());
        Assert.assertEquals(Collections.singleton(this.classType(Boolean.class)), (Object)types);
    }

    @Test
    public void testOclIsTypeOfMayBeCompatibleTypeClass() {
        this.getQueryEnvironment().registerEPackage((EPackage)EcorePackage.eINSTANCE);
        AbstractServicesValidationTest.VariableBuilder variables = new AbstractServicesValidationTest.VariableBuilder().addVar("eClasssifier", new IType[]{this.classType(EClassifier.class)});
        IValidationResult validationResult = this.validate("eClasssifier.oclIsTypeOf(ecore::EClass)", variables.build());
        Expression ast = validationResult.getAstResult().getAst();
        Assert.assertEquals((long)0L, (long)validationResult.getMessages().size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)ast).size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Call)ast).getArguments().get(0)).size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Call)ast).getArguments().get(1)).size());
        AstResult astResult = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(astResult.getAst());
        Assert.assertEquals(Collections.singleton(this.classType(Boolean.class)), (Object)types);
    }

    @Test
    public void testOclIsTypeOfMayBeCompatibleTypeEClassifierLiteral() {
        this.getQueryEnvironment().registerEPackage((EPackage)EcorePackage.eINSTANCE);
        AbstractServicesValidationTest.VariableBuilder variables = new AbstractServicesValidationTest.VariableBuilder().addVar("eClasssifier", new IType[]{this.eClassifierLiteralType((EClassifier)EcorePackage.eINSTANCE.getEClassifier())});
        IValidationResult validationResult = this.validate("eClasssifier.oclIsTypeOf(ecore::EClass)", variables.build());
        Expression ast = validationResult.getAstResult().getAst();
        Assert.assertEquals((long)0L, (long)validationResult.getMessages().size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)ast).size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Call)ast).getArguments().get(0)).size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Call)ast).getArguments().get(1)).size());
        AstResult astResult = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(astResult.getAst());
        Assert.assertEquals(Collections.singleton(this.classType(Boolean.class)), (Object)types);
    }

    @Test
    public void testToStringNull() {
        IValidationResult validationResult = this.validate("null.toString()");
        Expression ast = validationResult.getAstResult().getAst();
        Assert.assertEquals((long)0L, (long)validationResult.getMessages().size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)ast).size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Call)ast).getArguments().get(0)).size());
        AstResult astResult = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(astResult.getAst());
        Assert.assertEquals(Collections.singleton(this.classType(String.class)), (Object)types);
    }

    @Test
    public void testToStringNothing() {
        AbstractServicesValidationTest.VariableBuilder variables = new AbstractServicesValidationTest.VariableBuilder().addVar("nothing", new IType[]{this.nothingType("Nothing")});
        IValidationResult validationResult = this.validate("nothing.toString()", variables.build());
        Expression ast = validationResult.getAstResult().getAst();
        Assert.assertEquals((long)1L, (long)validationResult.getMessages().size());
        ValidationTest.assertValidationMessage((IValidationMessage)validationResult.getMessages().get(0), ValidationMessageLevel.ERROR, "Nothing", 0, 7);
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)ast).size());
        Assert.assertEquals((long)1L, (long)validationResult.getMessages((ASTNode)((Call)ast).getArguments().get(0)).size());
        ValidationTest.assertValidationMessage((IValidationMessage)validationResult.getMessages((ASTNode)((Call)ast).getArguments().get(0)).get(0), ValidationMessageLevel.ERROR, "Nothing", 0, 7);
    }

    @Test
    public void testToStringObject() {
        AbstractServicesValidationTest.VariableBuilder variables = new AbstractServicesValidationTest.VariableBuilder().addVar("object", new IType[]{this.classType(Object.class)});
        IValidationResult validationResult = this.validate("object.trace()", variables.build());
        Expression ast = validationResult.getAstResult().getAst();
        Assert.assertEquals((long)0L, (long)validationResult.getMessages().size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)ast).size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Call)ast).getArguments().get(0)).size());
        AstResult astResult = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(astResult.getAst());
        Assert.assertEquals(Collections.singleton(this.classType(String.class)), (Object)types);
    }

    @Test
    public void testTraceNull() {
        IValidationResult validationResult = this.validate("null.trace()");
        Expression ast = validationResult.getAstResult().getAst();
        Assert.assertEquals((long)0L, (long)validationResult.getMessages().size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)ast).size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Call)ast).getArguments().get(0)).size());
        AstResult astResult = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(astResult.getAst());
        Assert.assertEquals(Collections.singleton(this.classType(String.class)), (Object)types);
    }

    @Test
    public void testTraceNothing() {
        AbstractServicesValidationTest.VariableBuilder variables = new AbstractServicesValidationTest.VariableBuilder().addVar("nothing", new IType[]{this.nothingType("Nothing")});
        IValidationResult validationResult = this.validate("nothing.trace()", variables.build());
        Expression ast = validationResult.getAstResult().getAst();
        Assert.assertEquals((long)1L, (long)validationResult.getMessages().size());
        ValidationTest.assertValidationMessage((IValidationMessage)validationResult.getMessages().get(0), ValidationMessageLevel.ERROR, "Nothing", 0, 7);
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)ast).size());
        Assert.assertEquals((long)1L, (long)validationResult.getMessages((ASTNode)((Call)ast).getArguments().get(0)).size());
        ValidationTest.assertValidationMessage((IValidationMessage)validationResult.getMessages((ASTNode)((Call)ast).getArguments().get(0)).get(0), ValidationMessageLevel.ERROR, "Nothing", 0, 7);
    }

    @Test
    public void testTraceObject() {
        AbstractServicesValidationTest.VariableBuilder variables = new AbstractServicesValidationTest.VariableBuilder().addVar("object", new IType[]{this.classType(Object.class)});
        IValidationResult validationResult = this.validate("object.trace()", variables.build());
        Expression ast = validationResult.getAstResult().getAst();
        Assert.assertEquals((long)0L, (long)validationResult.getMessages().size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)ast).size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Call)ast).getArguments().get(0)).size());
        AstResult astResult = validationResult.getAstResult();
        Set types = validationResult.getPossibleTypes(astResult.getAst());
        Assert.assertEquals(Collections.singleton(this.classType(String.class)), (Object)types);
    }
}

