/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.query.parser.tests;

import inference.A;
import inference.B;
import inference.C;
import inference.InferencePackage;
import inference.Z;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.acceleo.query.ast.ASTNode;
import org.eclipse.acceleo.query.ast.Call;
import org.eclipse.acceleo.query.ast.Conditional;
import org.eclipse.acceleo.query.ast.Expression;
import org.eclipse.acceleo.query.ast.Lambda;
import org.eclipse.acceleo.query.parser.tests.ValidationTest;
import org.eclipse.acceleo.query.runtime.IQueryEnvironment;
import org.eclipse.acceleo.query.runtime.IReadOnlyQueryEnvironment;
import org.eclipse.acceleo.query.runtime.IValidationMessage;
import org.eclipse.acceleo.query.runtime.IValidationResult;
import org.eclipse.acceleo.query.runtime.Query;
import org.eclipse.acceleo.query.runtime.ValidationMessageLevel;
import org.eclipse.acceleo.query.runtime.impl.QueryValidationEngine;
import org.eclipse.acceleo.query.validation.type.ClassType;
import org.eclipse.acceleo.query.validation.type.EClassifierType;
import org.eclipse.acceleo.query.validation.type.IType;
import org.eclipse.acceleo.query.validation.type.NothingType;
import org.eclipse.acceleo.query.validation.type.SetType;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EcorePackage;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ValidationInferenceTest {
    private final EPackage ePackage = InferencePackage.eINSTANCE;
    private final EClass a = InferencePackage.eINSTANCE.getA();
    private final EClass b = InferencePackage.eINSTANCE.getB();
    private final EClass c = InferencePackage.eINSTANCE.getC();
    private final EClass y = InferencePackage.eINSTANCE.getY();
    private final EClass z = InferencePackage.eINSTANCE.getZ();
    QueryValidationEngine engine;
    IQueryEnvironment queryEnvironment;
    Map<String, Set<IType>> variableTypes = new LinkedHashMap<String, Set<IType>>();

    @Before
    public void setup() {
        this.queryEnvironment = Query.newEnvironmentWithDefaultServices(null);
        this.queryEnvironment.registerEPackage(this.ePackage);
        this.engine = new QueryValidationEngine((IReadOnlyQueryEnvironment)this.queryEnvironment);
        this.variableTypes.clear();
        LinkedHashSet<EClassifierType> varATypes = new LinkedHashSet<EClassifierType>();
        varATypes.add(new EClassifierType((IReadOnlyQueryEnvironment)this.queryEnvironment, (EClassifier)this.a));
        this.variableTypes.put("varA", varATypes);
        LinkedHashSet<EClassifierType> varBTypes = new LinkedHashSet<EClassifierType>();
        varBTypes.add(new EClassifierType((IReadOnlyQueryEnvironment)this.queryEnvironment, (EClassifier)this.b));
        this.variableTypes.put("varB", varBTypes);
        LinkedHashSet<EClassifierType> varCTypes = new LinkedHashSet<EClassifierType>();
        varCTypes.add(new EClassifierType((IReadOnlyQueryEnvironment)this.queryEnvironment, (EClassifier)this.c));
        this.variableTypes.put("varC", varCTypes);
        LinkedHashSet<EClassifierType> varZTypes = new LinkedHashSet<EClassifierType>();
        varZTypes.add(new EClassifierType((IReadOnlyQueryEnvironment)this.queryEnvironment, (EClassifier)this.z));
        this.variableTypes.put("varZ", varZTypes);
        LinkedHashSet<ClassType> varAClassTypes = new LinkedHashSet<ClassType>();
        varAClassTypes.add(new ClassType((IReadOnlyQueryEnvironment)this.queryEnvironment, A.class));
        this.variableTypes.put("varAClass", varAClassTypes);
        LinkedHashSet<ClassType> varBClassTypes = new LinkedHashSet<ClassType>();
        varBClassTypes.add(new ClassType((IReadOnlyQueryEnvironment)this.queryEnvironment, B.class));
        this.variableTypes.put("varBClass", varBClassTypes);
        LinkedHashSet<ClassType> varCClassTypes = new LinkedHashSet<ClassType>();
        varCClassTypes.add(new ClassType((IReadOnlyQueryEnvironment)this.queryEnvironment, C.class));
        this.variableTypes.put("varCClass", varCClassTypes);
        LinkedHashSet<ClassType> varZClassTypes = new LinkedHashSet<ClassType>();
        varZClassTypes.add(new ClassType((IReadOnlyQueryEnvironment)this.queryEnvironment, Z.class));
        this.variableTypes.put("varZClass", varZClassTypes);
        LinkedHashSet<NothingType> varNothing = new LinkedHashSet<NothingType>();
        varNothing.add(new NothingType("Nothing"));
        this.variableTypes.put("varNothing", varNothing);
    }

    @Test
    public void oclIsKindOf_varNothing_B() {
        String varName = "varNothing";
        IValidationResult validationResult = this.engine.validate(varName + ".oclIsKindOf(inference::B)", this.variableTypes);
        Expression ast = validationResult.getAstResult().getAst();
        Set inferredWhenTrue = (Set)validationResult.getInferredVariableTypes(ast, Boolean.TRUE).get(varName);
        Set inferredWhenFalse = (Set)validationResult.getInferredVariableTypes(ast, Boolean.FALSE).get(varName);
        Assert.assertNull((Object)inferredWhenTrue);
        Assert.assertNotNull((Object)inferredWhenFalse);
        Assert.assertEquals((long)1L, (long)inferredWhenFalse.size());
        Iterator it = inferredWhenFalse.iterator();
        IType type = (IType)it.next();
        Assert.assertTrue((boolean)(type instanceof NothingType));
        Assert.assertEquals((Object)"Nothing", (Object)((NothingType)type).getMessage());
        Assert.assertEquals((long)2L, (long)validationResult.getMessages().size());
        ValidationTest.assertValidationMessage((IValidationMessage)validationResult.getMessages().get(0), ValidationMessageLevel.ERROR, "Nothing", 0, 10);
        ValidationTest.assertValidationMessage((IValidationMessage)validationResult.getMessages().get(1), ValidationMessageLevel.INFO, "Always false:\nNothing inferred when varNothing (Nothing(Nothing)) is kind of EClassifierLiteral=B", 0, 36);
        Assert.assertEquals((long)1L, (long)validationResult.getMessages((ASTNode)ast).size());
        ValidationTest.assertValidationMessage((IValidationMessage)validationResult.getMessages((ASTNode)ast).get(0), ValidationMessageLevel.INFO, "Always false:\nNothing inferred when varNothing (Nothing(Nothing)) is kind of EClassifierLiteral=B", 0, 36);
        Assert.assertEquals((long)1L, (long)validationResult.getMessages((ASTNode)((Call)ast).getArguments().get(0)).size());
        ValidationTest.assertValidationMessage((IValidationMessage)validationResult.getMessages((ASTNode)((Call)ast).getArguments().get(0)).get(0), ValidationMessageLevel.ERROR, "Nothing", 0, 10);
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Call)ast).getArguments().get(1)).size());
    }

    @Test
    public void oclIsKindOf_varEObject_B() {
        this.queryEnvironment.registerEPackage((EPackage)EcorePackage.eINSTANCE);
        String varName = "container";
        LinkedHashMap<String, HashSet<IType>> variableTypes = new LinkedHashMap<String, HashSet<IType>>();
        EClassifierType eObjectType = new EClassifierType((IReadOnlyQueryEnvironment)this.queryEnvironment, (EClassifier)EcorePackage.eINSTANCE.getEObject());
        variableTypes.put(varName, new HashSet<IType>(Arrays.asList(eObjectType)));
        IValidationResult validationResult = this.engine.validate(varName + ".oclIsKindOf(inference::B)", variableTypes);
        Expression ast = validationResult.getAstResult().getAst();
        Set inferredWhenTrue = (Set)validationResult.getInferredVariableTypes(ast, Boolean.TRUE).get(varName);
        Set inferredWhenFalse = (Set)validationResult.getInferredVariableTypes(ast, Boolean.FALSE).get(varName);
        Assert.assertNotNull((Object)inferredWhenTrue);
        Assert.assertNotNull((Object)inferredWhenFalse);
        this.assertDisjointTypes(inferredWhenTrue, inferredWhenFalse);
        Assert.assertEquals((long)1L, (long)inferredWhenTrue.size());
        Iterator it = inferredWhenTrue.iterator();
        IType type = (IType)it.next();
        Assert.assertTrue((boolean)(type instanceof EClassifierType));
        Assert.assertEquals((Object)this.b, (Object)((EClassifierType)type).getType());
        Assert.assertEquals((long)1L, (long)inferredWhenFalse.size());
        it = inferredWhenFalse.iterator();
        type = (IType)it.next();
        Assert.assertTrue((boolean)(type instanceof EClassifierType));
        Assert.assertEquals((Object)EcorePackage.eINSTANCE.getEObject(), (Object)((EClassifierType)type).getType());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages().size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)ast).size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Call)ast).getArguments().get(0)).size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Call)ast).getArguments().get(1)).size());
    }

    @Test
    public void oclIsKindOf_varEObjectClass_B() {
        this.queryEnvironment.registerEPackage((EPackage)EcorePackage.eINSTANCE);
        String varName = "container";
        LinkedHashMap<String, HashSet<IType>> variableTypes = new LinkedHashMap<String, HashSet<IType>>();
        ClassType eObjectType = new ClassType((IReadOnlyQueryEnvironment)this.queryEnvironment, EObject.class);
        variableTypes.put(varName, new HashSet<IType>(Arrays.asList(eObjectType)));
        IValidationResult validationResult = this.engine.validate(varName + ".oclIsKindOf(inference::B)", variableTypes);
        Expression ast = validationResult.getAstResult().getAst();
        Set inferredWhenTrue = (Set)validationResult.getInferredVariableTypes(ast, Boolean.TRUE).get(varName);
        Set inferredWhenFalse = (Set)validationResult.getInferredVariableTypes(ast, Boolean.FALSE).get(varName);
        Assert.assertNotNull((Object)inferredWhenTrue);
        Assert.assertNotNull((Object)inferredWhenFalse);
        this.assertDisjointTypes(inferredWhenTrue, inferredWhenFalse);
        Assert.assertEquals((long)1L, (long)inferredWhenTrue.size());
        Iterator it = inferredWhenTrue.iterator();
        IType type = (IType)it.next();
        Assert.assertTrue((boolean)(type instanceof EClassifierType));
        Assert.assertEquals((Object)this.b, (Object)((EClassifierType)type).getType());
        Assert.assertEquals((long)1L, (long)inferredWhenFalse.size());
        it = inferredWhenFalse.iterator();
        type = (IType)it.next();
        Assert.assertTrue((boolean)(type instanceof ClassType));
        Assert.assertEquals(EObject.class, (Object)((ClassType)type).getType());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages().size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)ast).size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Call)ast).getArguments().get(0)).size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Call)ast).getArguments().get(1)).size());
    }

    @Test
    public void oclIsKindOf_varA_B() {
        String varName = "varA";
        IValidationResult validationResult = this.engine.validate(varName + ".oclIsKindOf(inference::B)", this.variableTypes);
        Expression ast = validationResult.getAstResult().getAst();
        Set inferredWhenTrue = (Set)validationResult.getInferredVariableTypes(ast, Boolean.TRUE).get(varName);
        Set inferredWhenFalse = (Set)validationResult.getInferredVariableTypes(ast, Boolean.FALSE).get(varName);
        Assert.assertNotNull((Object)inferredWhenTrue);
        Assert.assertNotNull((Object)inferredWhenFalse);
        this.assertDisjointTypes(inferredWhenTrue, inferredWhenFalse);
        Assert.assertEquals((long)1L, (long)inferredWhenTrue.size());
        Iterator it = inferredWhenTrue.iterator();
        IType type = (IType)it.next();
        Assert.assertTrue((boolean)(type instanceof EClassifierType));
        Assert.assertEquals((Object)this.b, (Object)((EClassifierType)type).getType());
        Assert.assertEquals((long)1L, (long)inferredWhenFalse.size());
        it = inferredWhenFalse.iterator();
        type = (IType)it.next();
        Assert.assertTrue((boolean)(type instanceof EClassifierType));
        Assert.assertEquals((Object)this.a, (Object)((EClassifierType)type).getType());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages().size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)ast).size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Call)ast).getArguments().get(0)).size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Call)ast).getArguments().get(1)).size());
    }

    @Test
    public void oclIsKindOf_varAClass_B() {
        String varName = "varAClass";
        IValidationResult validationResult = this.engine.validate(varName + ".oclIsKindOf(inference::B)", this.variableTypes);
        Expression ast = validationResult.getAstResult().getAst();
        Set inferredWhenTrue = (Set)validationResult.getInferredVariableTypes(ast, Boolean.TRUE).get(varName);
        Set inferredWhenFalse = (Set)validationResult.getInferredVariableTypes(ast, Boolean.FALSE).get(varName);
        Assert.assertNotNull((Object)inferredWhenTrue);
        Assert.assertNotNull((Object)inferredWhenFalse);
        this.assertDisjointTypes(inferredWhenTrue, inferredWhenFalse);
        Assert.assertEquals((long)1L, (long)inferredWhenTrue.size());
        Iterator it = inferredWhenTrue.iterator();
        IType type = (IType)it.next();
        Assert.assertTrue((boolean)(type instanceof EClassifierType));
        Assert.assertEquals((Object)this.b, (Object)((EClassifierType)type).getType());
        Assert.assertEquals((long)1L, (long)inferredWhenFalse.size());
        it = inferredWhenFalse.iterator();
        type = (IType)it.next();
        Assert.assertTrue((boolean)(type instanceof ClassType));
        Assert.assertEquals(A.class, (Object)((ClassType)type).getType());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages().size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)ast).size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Call)ast).getArguments().get(0)).size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Call)ast).getArguments().get(1)).size());
    }

    @Test
    public void oclIsKindOf_varB_B() {
        String varName = "varB";
        IValidationResult validationResult = this.engine.validate(varName + ".oclIsKindOf(inference::B)", this.variableTypes);
        Expression ast = validationResult.getAstResult().getAst();
        Set inferredWhenTrue = (Set)validationResult.getInferredVariableTypes(ast, Boolean.TRUE).get(varName);
        Set inferredWhenFalse = (Set)validationResult.getInferredVariableTypes(ast, Boolean.FALSE).get(varName);
        Assert.assertNotNull((Object)inferredWhenTrue);
        Assert.assertNull((Object)inferredWhenFalse);
        Assert.assertEquals((long)1L, (long)inferredWhenTrue.size());
        Iterator it = inferredWhenTrue.iterator();
        IType type = (IType)it.next();
        Assert.assertTrue((boolean)(type instanceof EClassifierType));
        Assert.assertEquals((Object)this.b, (Object)((EClassifierType)type).getType());
        Assert.assertEquals((long)1L, (long)validationResult.getMessages().size());
        ValidationTest.assertValidationMessage((IValidationMessage)validationResult.getMessages().get(0), ValidationMessageLevel.INFO, "Always true:\nNothing inferred when varB (EClassifier=B) is not kind of EClassifierLiteral=B", 0, 30);
        Assert.assertEquals((long)1L, (long)validationResult.getMessages((ASTNode)ast).size());
        ValidationTest.assertValidationMessage((IValidationMessage)validationResult.getMessages((ASTNode)ast).get(0), ValidationMessageLevel.INFO, "Always true:\nNothing inferred when varB (EClassifier=B) is not kind of EClassifierLiteral=B", 0, 30);
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Call)ast).getArguments().get(0)).size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Call)ast).getArguments().get(1)).size());
    }

    @Test
    public void oclIsKindOf_varBClass_B() {
        String varName = "varBClass";
        IValidationResult validationResult = this.engine.validate(varName + ".oclIsKindOf(inference::B)", this.variableTypes);
        Expression ast = validationResult.getAstResult().getAst();
        Set inferredWhenTrue = (Set)validationResult.getInferredVariableTypes(ast, Boolean.TRUE).get(varName);
        Set inferredWhenFalse = (Set)validationResult.getInferredVariableTypes(ast, Boolean.FALSE).get(varName);
        Assert.assertNotNull((Object)inferredWhenTrue);
        Assert.assertNull((Object)inferredWhenFalse);
        Assert.assertEquals((long)1L, (long)inferredWhenTrue.size());
        Iterator it = inferredWhenTrue.iterator();
        IType type = (IType)it.next();
        Assert.assertTrue((boolean)(type instanceof ClassType));
        Assert.assertEquals(B.class, (Object)((ClassType)type).getType());
        Assert.assertEquals((long)1L, (long)validationResult.getMessages().size());
        ValidationTest.assertValidationMessage((IValidationMessage)validationResult.getMessages().get(0), ValidationMessageLevel.INFO, "Always true:\nNothing inferred when varBClass (inference.B) is not kind of EClassifierLiteral=B", 0, 35);
        Assert.assertEquals((long)1L, (long)validationResult.getMessages((ASTNode)ast).size());
        ValidationTest.assertValidationMessage((IValidationMessage)validationResult.getMessages((ASTNode)ast).get(0), ValidationMessageLevel.INFO, "Always true:\nNothing inferred when varBClass (inference.B) is not kind of EClassifierLiteral=B", 0, 35);
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Call)ast).getArguments().get(0)).size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Call)ast).getArguments().get(1)).size());
    }

    @Test
    public void oclIsKindOf_varC_B() {
        String varName = "varC";
        IValidationResult validationResult = this.engine.validate(varName + ".oclIsKindOf(inference::B)", this.variableTypes);
        Expression ast = validationResult.getAstResult().getAst();
        Set inferredWhenTrue = (Set)validationResult.getInferredVariableTypes(ast, Boolean.TRUE).get(varName);
        Set inferredWhenFalse = (Set)validationResult.getInferredVariableTypes(ast, Boolean.FALSE).get(varName);
        Assert.assertNotNull((Object)inferredWhenTrue);
        Assert.assertNull((Object)inferredWhenFalse);
        Assert.assertEquals((long)1L, (long)inferredWhenTrue.size());
        Iterator it = inferredWhenTrue.iterator();
        IType type = (IType)it.next();
        Assert.assertTrue((boolean)(type instanceof EClassifierType));
        Assert.assertEquals((Object)this.c, (Object)((EClassifierType)type).getType());
        Assert.assertEquals((long)1L, (long)validationResult.getMessages().size());
        ValidationTest.assertValidationMessage((IValidationMessage)validationResult.getMessages().get(0), ValidationMessageLevel.INFO, "Always true:\nNothing inferred when varC (EClassifier=C) is not kind of EClassifierLiteral=B", 0, 30);
        Assert.assertEquals((long)1L, (long)validationResult.getMessages((ASTNode)ast).size());
        ValidationTest.assertValidationMessage((IValidationMessage)validationResult.getMessages((ASTNode)ast).get(0), ValidationMessageLevel.INFO, "Always true:\nNothing inferred when varC (EClassifier=C) is not kind of EClassifierLiteral=B", 0, 30);
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Call)ast).getArguments().get(0)).size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Call)ast).getArguments().get(1)).size());
    }

    @Test
    public void oclIsKindOf_varCClass_B() {
        String varName = "varCClass";
        IValidationResult validationResult = this.engine.validate(varName + ".oclIsKindOf(inference::B)", this.variableTypes);
        Expression ast = validationResult.getAstResult().getAst();
        Set inferredWhenTrue = (Set)validationResult.getInferredVariableTypes(ast, Boolean.TRUE).get(varName);
        Set inferredWhenFalse = (Set)validationResult.getInferredVariableTypes(ast, Boolean.FALSE).get(varName);
        Assert.assertNotNull((Object)inferredWhenTrue);
        Assert.assertNull((Object)inferredWhenFalse);
        Assert.assertEquals((long)1L, (long)inferredWhenTrue.size());
        Iterator it = inferredWhenTrue.iterator();
        IType type = (IType)it.next();
        Assert.assertTrue((boolean)(type instanceof ClassType));
        Assert.assertEquals(C.class, (Object)((ClassType)type).getType());
        Assert.assertEquals((long)1L, (long)validationResult.getMessages().size());
        ValidationTest.assertValidationMessage((IValidationMessage)validationResult.getMessages().get(0), ValidationMessageLevel.INFO, "Always true:\nNothing inferred when varCClass (inference.C) is not kind of EClassifierLiteral=B", 0, 35);
        Assert.assertEquals((long)1L, (long)validationResult.getMessages((ASTNode)ast).size());
        ValidationTest.assertValidationMessage((IValidationMessage)validationResult.getMessages((ASTNode)ast).get(0), ValidationMessageLevel.INFO, "Always true:\nNothing inferred when varCClass (inference.C) is not kind of EClassifierLiteral=B", 0, 35);
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Call)ast).getArguments().get(0)).size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Call)ast).getArguments().get(1)).size());
    }

    @Test
    public void oclIsKindOf_varC_O() {
        String varName = "varC";
        IValidationResult validationResult = this.engine.validate(varName + ".oclIsKindOf(inference::O)", this.variableTypes);
        Expression ast = validationResult.getAstResult().getAst();
        Set inferredWhenTrue = (Set)validationResult.getInferredVariableTypes(ast, Boolean.TRUE).get(varName);
        Set inferredWhenFalse = (Set)validationResult.getInferredVariableTypes(ast, Boolean.FALSE).get(varName);
        Assert.assertNull((Object)inferredWhenTrue);
        Assert.assertNotNull((Object)inferredWhenFalse);
        Assert.assertEquals((long)1L, (long)inferredWhenFalse.size());
        Iterator it = inferredWhenFalse.iterator();
        IType type = (IType)it.next();
        Assert.assertTrue((boolean)(type instanceof EClassifierType));
        Assert.assertEquals((Object)this.c, (Object)((EClassifierType)type).getType());
        Assert.assertEquals((long)1L, (long)validationResult.getMessages().size());
        ValidationTest.assertValidationMessage((IValidationMessage)validationResult.getMessages().get(0), ValidationMessageLevel.INFO, "Always false:\nNothing inferred when varC (EClassifier=C) is kind of EClassifierLiteral=O", 0, 30);
        Assert.assertEquals((long)1L, (long)validationResult.getMessages((ASTNode)ast).size());
        ValidationTest.assertValidationMessage((IValidationMessage)validationResult.getMessages((ASTNode)ast).get(0), ValidationMessageLevel.INFO, "Always false:\nNothing inferred when varC (EClassifier=C) is kind of EClassifierLiteral=O", 0, 30);
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Call)ast).getArguments().get(0)).size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Call)ast).getArguments().get(1)).size());
    }

    @Test
    public void oclIsKindOf_varCClass_O() {
        String varName = "varCClass";
        IValidationResult validationResult = this.engine.validate(varName + ".oclIsKindOf(inference::O)", this.variableTypes);
        Expression ast = validationResult.getAstResult().getAst();
        Set inferredWhenTrue = (Set)validationResult.getInferredVariableTypes(ast, Boolean.TRUE).get(varName);
        Set inferredWhenFalse = (Set)validationResult.getInferredVariableTypes(ast, Boolean.FALSE).get(varName);
        Assert.assertNull((Object)inferredWhenTrue);
        Assert.assertNotNull((Object)inferredWhenFalse);
        Assert.assertEquals((long)1L, (long)inferredWhenFalse.size());
        Iterator it = inferredWhenFalse.iterator();
        IType type = (IType)it.next();
        Assert.assertTrue((boolean)(type instanceof ClassType));
        Assert.assertEquals(C.class, (Object)((ClassType)type).getType());
        Assert.assertEquals((long)1L, (long)validationResult.getMessages().size());
        ValidationTest.assertValidationMessage((IValidationMessage)validationResult.getMessages().get(0), ValidationMessageLevel.INFO, "Always false:\nNothing inferred when varCClass (inference.C) is kind of EClassifierLiteral=O", 0, 35);
        Assert.assertEquals((long)1L, (long)validationResult.getMessages((ASTNode)ast).size());
        ValidationTest.assertValidationMessage((IValidationMessage)validationResult.getMessages((ASTNode)ast).get(0), ValidationMessageLevel.INFO, "Always false:\nNothing inferred when varCClass (inference.C) is kind of EClassifierLiteral=O", 0, 35);
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Call)ast).getArguments().get(0)).size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Call)ast).getArguments().get(1)).size());
    }

    @Test
    public void oclIsTypeOf_varNothing_B() {
        String varName = "varNothing";
        IValidationResult validationResult = this.engine.validate(varName + ".oclIsTypeOf(inference::B)", this.variableTypes);
        Expression ast = validationResult.getAstResult().getAst();
        Set inferredWhenTrue = (Set)validationResult.getInferredVariableTypes(ast, Boolean.TRUE).get(varName);
        Set inferredWhenFalse = (Set)validationResult.getInferredVariableTypes(ast, Boolean.FALSE).get(varName);
        Assert.assertNull((Object)inferredWhenTrue);
        Assert.assertNotNull((Object)inferredWhenFalse);
        Assert.assertEquals((long)1L, (long)inferredWhenFalse.size());
        Iterator it = inferredWhenFalse.iterator();
        IType type = (IType)it.next();
        Assert.assertTrue((boolean)(type instanceof NothingType));
        Assert.assertEquals((Object)"Nothing", (Object)((NothingType)type).getMessage());
        Assert.assertEquals((long)2L, (long)validationResult.getMessages().size());
        ValidationTest.assertValidationMessage((IValidationMessage)validationResult.getMessages().get(0), ValidationMessageLevel.ERROR, "Nothing", 0, 10);
        ValidationTest.assertValidationMessage((IValidationMessage)validationResult.getMessages().get(1), ValidationMessageLevel.INFO, "Always false:\nNothing inferred when varNothing (Nothing(Nothing)) is type of EClassifierLiteral=B", 0, 36);
        Assert.assertEquals((long)1L, (long)validationResult.getMessages((ASTNode)ast).size());
        ValidationTest.assertValidationMessage((IValidationMessage)validationResult.getMessages((ASTNode)ast).get(0), ValidationMessageLevel.INFO, "Always false:\nNothing inferred when varNothing (Nothing(Nothing)) is type of EClassifierLiteral=B", 0, 36);
        Assert.assertEquals((long)1L, (long)validationResult.getMessages((ASTNode)((Call)ast).getArguments().get(0)).size());
        ValidationTest.assertValidationMessage((IValidationMessage)validationResult.getMessages((ASTNode)((Call)ast).getArguments().get(0)).get(0), ValidationMessageLevel.ERROR, "Nothing", 0, 10);
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Call)ast).getArguments().get(1)).size());
    }

    @Test
    public void oclIsTypeOf_varEObject_B() {
        this.queryEnvironment.registerEPackage((EPackage)EcorePackage.eINSTANCE);
        String varName = "container";
        LinkedHashMap<String, HashSet<IType>> variableTypes = new LinkedHashMap<String, HashSet<IType>>();
        EClassifierType eObjectType = new EClassifierType((IReadOnlyQueryEnvironment)this.queryEnvironment, (EClassifier)EcorePackage.eINSTANCE.getEObject());
        variableTypes.put(varName, new HashSet<IType>(Arrays.asList(eObjectType)));
        IValidationResult validationResult = this.engine.validate(varName + ".oclIsTypeOf(inference::B)", variableTypes);
        Expression ast = validationResult.getAstResult().getAst();
        Set inferredWhenTrue = (Set)validationResult.getInferredVariableTypes(ast, Boolean.TRUE).get(varName);
        Set inferredWhenFalse = (Set)validationResult.getInferredVariableTypes(ast, Boolean.FALSE).get(varName);
        Assert.assertNotNull((Object)inferredWhenTrue);
        Assert.assertNotNull((Object)inferredWhenFalse);
        this.assertDisjointTypes(inferredWhenTrue, inferredWhenFalse);
        Assert.assertEquals((long)1L, (long)inferredWhenTrue.size());
        Iterator it = inferredWhenTrue.iterator();
        IType type = (IType)it.next();
        Assert.assertTrue((boolean)(type instanceof EClassifierType));
        Assert.assertEquals((Object)this.b, (Object)((EClassifierType)type).getType());
        Assert.assertEquals((long)1L, (long)inferredWhenFalse.size());
        it = inferredWhenFalse.iterator();
        type = (IType)it.next();
        Assert.assertTrue((boolean)(type instanceof EClassifierType));
        Assert.assertEquals((Object)EcorePackage.eINSTANCE.getEObject(), (Object)((EClassifierType)type).getType());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages().size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)ast).size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Call)ast).getArguments().get(0)).size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Call)ast).getArguments().get(1)).size());
    }

    @Test
    public void oclIsTypeOf_varEObjectClass_B() {
        this.queryEnvironment.registerEPackage((EPackage)EcorePackage.eINSTANCE);
        String varName = "container";
        LinkedHashMap<String, HashSet<IType>> variableTypes = new LinkedHashMap<String, HashSet<IType>>();
        ClassType eObjectType = new ClassType((IReadOnlyQueryEnvironment)this.queryEnvironment, EObject.class);
        variableTypes.put(varName, new HashSet<IType>(Arrays.asList(eObjectType)));
        IValidationResult validationResult = this.engine.validate(varName + ".oclIsTypeOf(inference::B)", variableTypes);
        Expression ast = validationResult.getAstResult().getAst();
        Set inferredWhenTrue = (Set)validationResult.getInferredVariableTypes(ast, Boolean.TRUE).get(varName);
        Set inferredWhenFalse = (Set)validationResult.getInferredVariableTypes(ast, Boolean.FALSE).get(varName);
        Assert.assertNotNull((Object)inferredWhenTrue);
        Assert.assertNotNull((Object)inferredWhenFalse);
        this.assertDisjointTypes(inferredWhenTrue, inferredWhenFalse);
        Assert.assertEquals((long)1L, (long)inferredWhenTrue.size());
        Iterator it = inferredWhenTrue.iterator();
        IType type = (IType)it.next();
        Assert.assertTrue((boolean)(type instanceof EClassifierType));
        Assert.assertEquals((Object)this.b, (Object)((EClassifierType)type).getType());
        Assert.assertEquals((long)1L, (long)inferredWhenFalse.size());
        it = inferredWhenFalse.iterator();
        type = (IType)it.next();
        Assert.assertTrue((boolean)(type instanceof ClassType));
        Assert.assertEquals(EObject.class, (Object)((ClassType)type).getType());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages().size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)ast).size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Call)ast).getArguments().get(0)).size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Call)ast).getArguments().get(1)).size());
    }

    @Test
    public void oclIsTypeOf_varA_B() {
        String varName = "varA";
        IValidationResult validationResult = this.engine.validate(varName + ".oclIsTypeOf(inference::B)", this.variableTypes);
        Expression ast = validationResult.getAstResult().getAst();
        Set inferredWhenTrue = (Set)validationResult.getInferredVariableTypes(ast, Boolean.TRUE).get(varName);
        Set inferredWhenFalse = (Set)validationResult.getInferredVariableTypes(ast, Boolean.FALSE).get(varName);
        Assert.assertNotNull((Object)inferredWhenTrue);
        Assert.assertNotNull((Object)inferredWhenFalse);
        Assert.assertEquals((long)1L, (long)inferredWhenTrue.size());
        Iterator it = inferredWhenTrue.iterator();
        IType type = (IType)it.next();
        Assert.assertTrue((boolean)(type instanceof EClassifierType));
        Assert.assertEquals((Object)this.b, (Object)((EClassifierType)type).getType());
        Assert.assertEquals((long)1L, (long)inferredWhenFalse.size());
        it = inferredWhenFalse.iterator();
        type = (IType)it.next();
        Assert.assertTrue((boolean)(type instanceof EClassifierType));
        Assert.assertEquals((Object)this.a, (Object)((EClassifierType)type).getType());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages().size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)ast).size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Call)ast).getArguments().get(0)).size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Call)ast).getArguments().get(1)).size());
    }

    @Test
    public void oclIsTypeOf_varAClass_B() {
        String varName = "varAClass";
        IValidationResult validationResult = this.engine.validate(varName + ".oclIsTypeOf(inference::B)", this.variableTypes);
        Expression ast = validationResult.getAstResult().getAst();
        Set inferredWhenTrue = (Set)validationResult.getInferredVariableTypes(ast, Boolean.TRUE).get(varName);
        Set inferredWhenFalse = (Set)validationResult.getInferredVariableTypes(ast, Boolean.FALSE).get(varName);
        Assert.assertNotNull((Object)inferredWhenTrue);
        Assert.assertNotNull((Object)inferredWhenFalse);
        Assert.assertEquals((long)1L, (long)inferredWhenTrue.size());
        Iterator it = inferredWhenTrue.iterator();
        IType type = (IType)it.next();
        Assert.assertTrue((boolean)(type instanceof EClassifierType));
        Assert.assertEquals((Object)this.b, (Object)((EClassifierType)type).getType());
        Assert.assertEquals((long)1L, (long)inferredWhenFalse.size());
        it = inferredWhenFalse.iterator();
        type = (IType)it.next();
        Assert.assertTrue((boolean)(type instanceof ClassType));
        Assert.assertEquals(A.class, (Object)((ClassType)type).getType());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages().size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)ast).size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Call)ast).getArguments().get(0)).size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Call)ast).getArguments().get(1)).size());
    }

    @Test
    public void oclIsTypeOf_varA_X() {
        String varName = "varA";
        IValidationResult validationResult = this.engine.validate(varName + ".oclIsTypeOf(inference::X)", this.variableTypes);
        Expression ast = validationResult.getAstResult().getAst();
        Set inferredWhenTrue = (Set)validationResult.getInferredVariableTypes(ast, Boolean.TRUE).get(varName);
        Set inferredWhenFalse = (Set)validationResult.getInferredVariableTypes(ast, Boolean.FALSE).get(varName);
        Assert.assertNull((Object)inferredWhenTrue);
        Assert.assertNotNull((Object)inferredWhenFalse);
        Assert.assertEquals((long)1L, (long)inferredWhenFalse.size());
        Iterator it = inferredWhenFalse.iterator();
        IType type = (IType)it.next();
        Assert.assertTrue((boolean)(type instanceof EClassifierType));
        Assert.assertEquals((Object)this.a, (Object)((EClassifierType)type).getType());
        Assert.assertEquals((long)1L, (long)validationResult.getMessages().size());
        ValidationTest.assertValidationMessage((IValidationMessage)validationResult.getMessages().get(0), ValidationMessageLevel.INFO, "Always false:\nNothing inferred when varA (EClassifier=A) is type of EClassifierLiteral=X", 0, 30);
        Assert.assertEquals((long)1L, (long)validationResult.getMessages((ASTNode)ast).size());
        ValidationTest.assertValidationMessage((IValidationMessage)validationResult.getMessages((ASTNode)ast).get(0), ValidationMessageLevel.INFO, "Always false:\nNothing inferred when varA (EClassifier=A) is type of EClassifierLiteral=X", 0, 30);
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Call)ast).getArguments().get(0)).size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Call)ast).getArguments().get(1)).size());
    }

    @Test
    public void oclIsTypeOf_varAClass_X() {
        String varName = "varAClass";
        IValidationResult validationResult = this.engine.validate(varName + ".oclIsTypeOf(inference::X)", this.variableTypes);
        Expression ast = validationResult.getAstResult().getAst();
        Set inferredWhenTrue = (Set)validationResult.getInferredVariableTypes(ast, Boolean.TRUE).get(varName);
        Set inferredWhenFalse = (Set)validationResult.getInferredVariableTypes(ast, Boolean.FALSE).get(varName);
        Assert.assertNull((Object)inferredWhenTrue);
        Assert.assertNotNull((Object)inferredWhenFalse);
        Assert.assertEquals((long)1L, (long)inferredWhenFalse.size());
        Iterator it = inferredWhenFalse.iterator();
        IType type = (IType)it.next();
        Assert.assertTrue((boolean)(type instanceof ClassType));
        Assert.assertEquals(A.class, (Object)((ClassType)type).getType());
        Assert.assertEquals((long)1L, (long)validationResult.getMessages().size());
        ValidationTest.assertValidationMessage((IValidationMessage)validationResult.getMessages().get(0), ValidationMessageLevel.INFO, "Always false:\nNothing inferred when varAClass (inference.A) is type of EClassifierLiteral=X", 0, 35);
        Assert.assertEquals((long)1L, (long)validationResult.getMessages((ASTNode)ast).size());
        ValidationTest.assertValidationMessage((IValidationMessage)validationResult.getMessages((ASTNode)ast).get(0), ValidationMessageLevel.INFO, "Always false:\nNothing inferred when varAClass (inference.A) is type of EClassifierLiteral=X", 0, 35);
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Call)ast).getArguments().get(0)).size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Call)ast).getArguments().get(1)).size());
    }

    @Test
    public void oclIsTypeOf_varB_B() {
        String varName = "varB";
        IValidationResult validationResult = this.engine.validate(varName + ".oclIsTypeOf(inference::B)", this.variableTypes);
        Expression ast = validationResult.getAstResult().getAst();
        Set inferredWhenTrue = (Set)validationResult.getInferredVariableTypes(ast, Boolean.TRUE).get(varName);
        Set inferredWhenFalse = (Set)validationResult.getInferredVariableTypes(ast, Boolean.FALSE).get(varName);
        Assert.assertNotNull((Object)inferredWhenTrue);
        Assert.assertNotNull((Object)inferredWhenFalse);
        Assert.assertEquals((long)1L, (long)inferredWhenTrue.size());
        Iterator it = inferredWhenTrue.iterator();
        IType type = (IType)it.next();
        Assert.assertTrue((boolean)(type instanceof EClassifierType));
        Assert.assertEquals((Object)this.b, (Object)((EClassifierType)type).getType());
        Assert.assertEquals((long)2L, (long)inferredWhenFalse.size());
        it = inferredWhenFalse.iterator();
        type = (IType)it.next();
        Assert.assertTrue((boolean)(type instanceof EClassifierType));
        Assert.assertEquals((Object)this.c, (Object)((EClassifierType)type).getType());
        type = (IType)it.next();
        Assert.assertTrue((boolean)(type instanceof EClassifierType));
        Assert.assertEquals((Object)this.y, (Object)((EClassifierType)type).getType());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages().size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)ast).size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Call)ast).getArguments().get(0)).size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Call)ast).getArguments().get(1)).size());
    }

    @Test
    public void oclIsTypeOf_varBClass_B() {
        String varName = "varBClass";
        IValidationResult validationResult = this.engine.validate(varName + ".oclIsTypeOf(inference::B)", this.variableTypes);
        Expression ast = validationResult.getAstResult().getAst();
        Set inferredWhenTrue = (Set)validationResult.getInferredVariableTypes(ast, Boolean.TRUE).get(varName);
        Set inferredWhenFalse = (Set)validationResult.getInferredVariableTypes(ast, Boolean.FALSE).get(varName);
        Assert.assertNotNull((Object)inferredWhenTrue);
        Assert.assertNotNull((Object)inferredWhenFalse);
        Assert.assertEquals((long)1L, (long)inferredWhenTrue.size());
        Iterator it = inferredWhenTrue.iterator();
        IType type = (IType)it.next();
        Assert.assertTrue((boolean)(type instanceof EClassifierType));
        Assert.assertEquals((Object)this.b, (Object)((EClassifierType)type).getType());
        Assert.assertEquals((long)2L, (long)inferredWhenFalse.size());
        it = inferredWhenFalse.iterator();
        type = (IType)it.next();
        Assert.assertTrue((boolean)(type instanceof EClassifierType));
        Assert.assertEquals((Object)this.c, (Object)((EClassifierType)type).getType());
        type = (IType)it.next();
        Assert.assertTrue((boolean)(type instanceof EClassifierType));
        Assert.assertEquals((Object)this.y, (Object)((EClassifierType)type).getType());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages().size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)ast).size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Call)ast).getArguments().get(0)).size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Call)ast).getArguments().get(1)).size());
    }

    @Test
    public void oclIsTypeOf_varZ_Z() {
        String varName = "varZ";
        IValidationResult validationResult = this.engine.validate(varName + ".oclIsTypeOf(inference::Z)", this.variableTypes);
        Expression ast = validationResult.getAstResult().getAst();
        Set inferredWhenTrue = (Set)validationResult.getInferredVariableTypes(ast, Boolean.TRUE).get(varName);
        Set inferredWhenFalse = (Set)validationResult.getInferredVariableTypes(ast, Boolean.FALSE).get(varName);
        Assert.assertNotNull((Object)inferredWhenTrue);
        Assert.assertNull((Object)inferredWhenFalse);
        Assert.assertEquals((long)1L, (long)inferredWhenTrue.size());
        Iterator it = inferredWhenTrue.iterator();
        IType type = (IType)it.next();
        Assert.assertTrue((boolean)(type instanceof EClassifierType));
        Assert.assertEquals((Object)this.z, (Object)((EClassifierType)type).getType());
        Assert.assertEquals((long)1L, (long)validationResult.getMessages().size());
        ValidationTest.assertValidationMessage((IValidationMessage)validationResult.getMessages().get(0), ValidationMessageLevel.INFO, "Always true:\nNothing inferred when varZ (EClassifier=Z) is not type of EClassifierLiteral=Z", 0, 30);
        Assert.assertEquals((long)1L, (long)validationResult.getMessages((ASTNode)ast).size());
        ValidationTest.assertValidationMessage((IValidationMessage)validationResult.getMessages((ASTNode)ast).get(0), ValidationMessageLevel.INFO, "Always true:\nNothing inferred when varZ (EClassifier=Z) is not type of EClassifierLiteral=Z", 0, 30);
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Call)ast).getArguments().get(0)).size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Call)ast).getArguments().get(1)).size());
    }

    @Test
    public void oclIsTypeOf_varZClass_Z() {
        String varName = "varZClass";
        IValidationResult validationResult = this.engine.validate(varName + ".oclIsTypeOf(inference::Z)", this.variableTypes);
        Expression ast = validationResult.getAstResult().getAst();
        Set inferredWhenTrue = (Set)validationResult.getInferredVariableTypes(ast, Boolean.TRUE).get(varName);
        Set inferredWhenFalse = (Set)validationResult.getInferredVariableTypes(ast, Boolean.FALSE).get(varName);
        Assert.assertNotNull((Object)inferredWhenTrue);
        Assert.assertNull((Object)inferredWhenFalse);
        Assert.assertEquals((long)1L, (long)inferredWhenTrue.size());
        Iterator it = inferredWhenTrue.iterator();
        IType type = (IType)it.next();
        Assert.assertTrue((boolean)(type instanceof EClassifierType));
        Assert.assertEquals((Object)this.z, (Object)((EClassifierType)type).getType());
        Assert.assertEquals((long)1L, (long)validationResult.getMessages().size());
        ValidationTest.assertValidationMessage((IValidationMessage)validationResult.getMessages().get(0), ValidationMessageLevel.INFO, "Always true:\nNothing inferred when varZClass (inference.Z) is not type of EClassifierLiteral=Z", 0, 35);
        Assert.assertEquals((long)1L, (long)validationResult.getMessages((ASTNode)ast).size());
        ValidationTest.assertValidationMessage((IValidationMessage)validationResult.getMessages((ASTNode)ast).get(0), ValidationMessageLevel.INFO, "Always true:\nNothing inferred when varZClass (inference.Z) is not type of EClassifierLiteral=Z", 0, 35);
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Call)ast).getArguments().get(0)).size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Call)ast).getArguments().get(1)).size());
    }

    @Test
    public void oclIsTypeOf_varC_B() {
        String varName = "varC";
        IValidationResult validationResult = this.engine.validate(varName + ".oclIsTypeOf(inference::B)", this.variableTypes);
        Expression ast = validationResult.getAstResult().getAst();
        Set inferredWhenTrue = (Set)validationResult.getInferredVariableTypes(ast, Boolean.TRUE).get(varName);
        Set inferredWhenFalse = (Set)validationResult.getInferredVariableTypes(ast, Boolean.FALSE).get(varName);
        Assert.assertNull((Object)inferredWhenTrue);
        Assert.assertNotNull((Object)inferredWhenFalse);
        Assert.assertEquals((long)1L, (long)inferredWhenFalse.size());
        Iterator it = inferredWhenFalse.iterator();
        IType type = (IType)it.next();
        Assert.assertTrue((boolean)(type instanceof EClassifierType));
        Assert.assertEquals((Object)this.c, (Object)((EClassifierType)type).getType());
        Assert.assertEquals((long)1L, (long)validationResult.getMessages().size());
        ValidationTest.assertValidationMessage((IValidationMessage)validationResult.getMessages().get(0), ValidationMessageLevel.INFO, "Always false:\nNothing inferred when varC (EClassifier=C) is type of EClassifierLiteral=B", 0, 30);
        Assert.assertEquals((long)1L, (long)validationResult.getMessages((ASTNode)ast).size());
        ValidationTest.assertValidationMessage((IValidationMessage)validationResult.getMessages((ASTNode)ast).get(0), ValidationMessageLevel.INFO, "Always false:\nNothing inferred when varC (EClassifier=C) is type of EClassifierLiteral=B", 0, 30);
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Call)ast).getArguments().get(0)).size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Call)ast).getArguments().get(1)).size());
    }

    @Test
    public void oclIsTypeOf_varCClass_B() {
        String varName = "varCClass";
        IValidationResult validationResult = this.engine.validate(varName + ".oclIsTypeOf(inference::B)", this.variableTypes);
        Expression ast = validationResult.getAstResult().getAst();
        Set inferredWhenTrue = (Set)validationResult.getInferredVariableTypes(ast, Boolean.TRUE).get(varName);
        Set inferredWhenFalse = (Set)validationResult.getInferredVariableTypes(ast, Boolean.FALSE).get(varName);
        Assert.assertNull((Object)inferredWhenTrue);
        Assert.assertNotNull((Object)inferredWhenFalse);
        Assert.assertEquals((long)1L, (long)inferredWhenFalse.size());
        Iterator it = inferredWhenFalse.iterator();
        IType type = (IType)it.next();
        Assert.assertTrue((boolean)(type instanceof ClassType));
        Assert.assertEquals(C.class, (Object)((ClassType)type).getType());
        Assert.assertEquals((long)1L, (long)validationResult.getMessages().size());
        ValidationTest.assertValidationMessage((IValidationMessage)validationResult.getMessages().get(0), ValidationMessageLevel.INFO, "Always false:\nNothing inferred when varCClass (inference.C) is type of EClassifierLiteral=B", 0, 35);
        Assert.assertEquals((long)1L, (long)validationResult.getMessages((ASTNode)ast).size());
        ValidationTest.assertValidationMessage((IValidationMessage)validationResult.getMessages((ASTNode)ast).get(0), ValidationMessageLevel.INFO, "Always false:\nNothing inferred when varCClass (inference.C) is type of EClassifierLiteral=B", 0, 35);
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Call)ast).getArguments().get(0)).size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Call)ast).getArguments().get(1)).size());
    }

    @Test
    public void oclIsTypeOf_varC_O() {
        String varName = "varC";
        IValidationResult validationResult = this.engine.validate(varName + ".oclIsTypeOf(inference::O)", this.variableTypes);
        Expression ast = validationResult.getAstResult().getAst();
        Set inferredWhenTrue = (Set)validationResult.getInferredVariableTypes(ast, Boolean.TRUE).get(varName);
        Set inferredWhenFalse = (Set)validationResult.getInferredVariableTypes(ast, Boolean.FALSE).get(varName);
        Assert.assertNull((Object)inferredWhenTrue);
        Assert.assertNotNull((Object)inferredWhenFalse);
        Assert.assertEquals((long)1L, (long)inferredWhenFalse.size());
        Iterator it = inferredWhenFalse.iterator();
        IType type = (IType)it.next();
        Assert.assertTrue((boolean)(type instanceof EClassifierType));
        Assert.assertEquals((Object)this.c, (Object)((EClassifierType)type).getType());
        Assert.assertEquals((long)1L, (long)validationResult.getMessages().size());
        ValidationTest.assertValidationMessage((IValidationMessage)validationResult.getMessages().get(0), ValidationMessageLevel.INFO, "Always false:\nNothing inferred when varC (EClassifier=C) is type of EClassifierLiteral=O", 0, 30);
        Assert.assertEquals((long)1L, (long)validationResult.getMessages((ASTNode)ast).size());
        ValidationTest.assertValidationMessage((IValidationMessage)validationResult.getMessages((ASTNode)ast).get(0), ValidationMessageLevel.INFO, "Always false:\nNothing inferred when varC (EClassifier=C) is type of EClassifierLiteral=O", 0, 30);
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Call)ast).getArguments().get(0)).size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Call)ast).getArguments().get(1)).size());
    }

    @Test
    public void oclIsTypeOf_varCClass_O() {
        String varName = "varCClass";
        IValidationResult validationResult = this.engine.validate(varName + ".oclIsTypeOf(inference::O)", this.variableTypes);
        Expression ast = validationResult.getAstResult().getAst();
        Set inferredWhenTrue = (Set)validationResult.getInferredVariableTypes(ast, Boolean.TRUE).get(varName);
        Set inferredWhenFalse = (Set)validationResult.getInferredVariableTypes(ast, Boolean.FALSE).get(varName);
        Assert.assertNull((Object)inferredWhenTrue);
        Assert.assertNotNull((Object)inferredWhenFalse);
        Assert.assertEquals((long)1L, (long)inferredWhenFalse.size());
        Iterator it = inferredWhenFalse.iterator();
        IType type = (IType)it.next();
        Assert.assertTrue((boolean)(type instanceof ClassType));
        Assert.assertEquals(C.class, (Object)((ClassType)type).getType());
        Assert.assertEquals((long)1L, (long)validationResult.getMessages().size());
        ValidationTest.assertValidationMessage((IValidationMessage)validationResult.getMessages().get(0), ValidationMessageLevel.INFO, "Always false:\nNothing inferred when varCClass (inference.C) is type of EClassifierLiteral=O", 0, 35);
        Assert.assertEquals((long)1L, (long)validationResult.getMessages((ASTNode)ast).size());
        ValidationTest.assertValidationMessage((IValidationMessage)validationResult.getMessages((ASTNode)ast).get(0), ValidationMessageLevel.INFO, "Always false:\nNothing inferred when varCClass (inference.C) is type of EClassifierLiteral=O", 0, 35);
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Call)ast).getArguments().get(0)).size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Call)ast).getArguments().get(1)).size());
    }

    @Test
    public void not_oclIsKindOf_varNothing_B() {
        String varName = "varNothing";
        IValidationResult validationResult = this.engine.validate("not " + varName + ".oclIsKindOf(inference::B)", this.variableTypes);
        Expression ast = validationResult.getAstResult().getAst();
        Set inferredWhenTrue = (Set)validationResult.getInferredVariableTypes(ast, Boolean.TRUE).get(varName);
        Set inferredWhenFalse = (Set)validationResult.getInferredVariableTypes(ast, Boolean.FALSE).get(varName);
        Assert.assertNotNull((Object)inferredWhenTrue);
        Assert.assertEquals((long)1L, (long)inferredWhenTrue.size());
        Iterator it = inferredWhenTrue.iterator();
        IType type = (IType)it.next();
        Assert.assertTrue((boolean)(type instanceof NothingType));
        Assert.assertEquals((Object)"Nothing", (Object)((NothingType)type).getMessage());
        Assert.assertNull((Object)inferredWhenFalse);
        Assert.assertEquals((long)2L, (long)validationResult.getMessages().size());
        ValidationTest.assertValidationMessage((IValidationMessage)validationResult.getMessages().get(0), ValidationMessageLevel.ERROR, "Nothing", 4, 14);
        ValidationTest.assertValidationMessage((IValidationMessage)validationResult.getMessages().get(1), ValidationMessageLevel.INFO, "Always false:\nNothing inferred when varNothing (Nothing(Nothing)) is kind of EClassifierLiteral=B", 4, 40);
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)ast).size());
        Assert.assertEquals((long)1L, (long)validationResult.getMessages((ASTNode)((Call)ast).getArguments().get(0)).size());
        ValidationTest.assertValidationMessage((IValidationMessage)validationResult.getMessages((ASTNode)((Call)ast).getArguments().get(0)).get(0), ValidationMessageLevel.INFO, "Always false:\nNothing inferred when varNothing (Nothing(Nothing)) is kind of EClassifierLiteral=B", 4, 40);
        Assert.assertEquals((long)1L, (long)validationResult.getMessages((ASTNode)((Call)((Call)ast).getArguments().get(0)).getArguments().get(0)).size());
        ValidationTest.assertValidationMessage((IValidationMessage)validationResult.getMessages((ASTNode)((Call)((Call)ast).getArguments().get(0)).getArguments().get(0)).get(0), ValidationMessageLevel.ERROR, "Nothing", 4, 14);
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Call)((Call)ast).getArguments().get(0)).getArguments().get(1)).size());
    }

    @Test
    public void not_oclIsKindOf_varA_B() {
        String varName = "varA";
        IValidationResult validationResult = this.engine.validate("not " + varName + ".oclIsKindOf(inference::B)", this.variableTypes);
        Expression ast = validationResult.getAstResult().getAst();
        Set inferredWhenTrue = (Set)validationResult.getInferredVariableTypes(ast, Boolean.TRUE).get(varName);
        Set inferredWhenFalse = (Set)validationResult.getInferredVariableTypes(ast, Boolean.FALSE).get(varName);
        Assert.assertNotNull((Object)inferredWhenTrue);
        Assert.assertNotNull((Object)inferredWhenFalse);
        this.assertDisjointTypes(inferredWhenTrue, inferredWhenFalse);
        Assert.assertEquals((long)1L, (long)inferredWhenTrue.size());
        Iterator it = inferredWhenTrue.iterator();
        IType type = (IType)it.next();
        Assert.assertTrue((boolean)(type instanceof EClassifierType));
        Assert.assertEquals((Object)this.a, (Object)((EClassifierType)type).getType());
        Assert.assertEquals((long)1L, (long)inferredWhenFalse.size());
        it = inferredWhenFalse.iterator();
        type = (IType)it.next();
        Assert.assertTrue((boolean)(type instanceof EClassifierType));
        Assert.assertEquals((Object)this.b, (Object)((EClassifierType)type).getType());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages().size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)ast).size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Call)ast).getArguments().get(0)).size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Call)((Call)ast).getArguments().get(0)).getArguments().get(0)).size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Call)((Call)ast).getArguments().get(0)).getArguments().get(1)).size());
    }

    @Test
    public void not_oclIsKindOf_varAClass_B() {
        String varName = "varAClass";
        IValidationResult validationResult = this.engine.validate("not " + varName + ".oclIsKindOf(inference::B)", this.variableTypes);
        Expression ast = validationResult.getAstResult().getAst();
        Set inferredWhenTrue = (Set)validationResult.getInferredVariableTypes(ast, Boolean.TRUE).get(varName);
        Set inferredWhenFalse = (Set)validationResult.getInferredVariableTypes(ast, Boolean.FALSE).get(varName);
        Assert.assertNotNull((Object)inferredWhenTrue);
        Assert.assertNotNull((Object)inferredWhenFalse);
        this.assertDisjointTypes(inferredWhenTrue, inferredWhenFalse);
        Assert.assertEquals((long)1L, (long)inferredWhenTrue.size());
        Iterator it = inferredWhenTrue.iterator();
        IType type = (IType)it.next();
        Assert.assertTrue((boolean)(type instanceof ClassType));
        Assert.assertEquals(A.class, (Object)((ClassType)type).getType());
        Assert.assertEquals((long)1L, (long)inferredWhenFalse.size());
        it = inferredWhenFalse.iterator();
        type = (IType)it.next();
        Assert.assertTrue((boolean)(type instanceof EClassifierType));
        Assert.assertEquals((Object)this.b, (Object)((EClassifierType)type).getType());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages().size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)ast).size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Call)ast).getArguments().get(0)).size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Call)((Call)ast).getArguments().get(0)).getArguments().get(0)).size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Call)((Call)ast).getArguments().get(0)).getArguments().get(1)).size());
    }

    @Test
    public void oclIsKindOf_varA_X() {
        String varName = "varA";
        IValidationResult validationResult = this.engine.validate(varName + ".oclIsKindOf(inference::X)", this.variableTypes);
        Expression ast = validationResult.getAstResult().getAst();
        Set inferredWhenTrue = (Set)validationResult.getInferredVariableTypes(ast, Boolean.TRUE).get(varName);
        Set inferredWhenFalse = (Set)validationResult.getInferredVariableTypes(ast, Boolean.FALSE).get(varName);
        Assert.assertNotNull((Object)inferredWhenTrue);
        Assert.assertNotNull((Object)inferredWhenFalse);
        this.assertDisjointTypes(inferredWhenTrue, inferredWhenFalse);
        Assert.assertEquals((long)1L, (long)inferredWhenTrue.size());
        Iterator it = inferredWhenTrue.iterator();
        IType type = (IType)it.next();
        Assert.assertTrue((boolean)(type instanceof EClassifierType));
        Assert.assertEquals((Object)this.b, (Object)((EClassifierType)type).getType());
        Assert.assertEquals((long)1L, (long)inferredWhenFalse.size());
        it = inferredWhenFalse.iterator();
        type = (IType)it.next();
        Assert.assertTrue((boolean)(type instanceof EClassifierType));
        Assert.assertEquals((Object)this.a, (Object)((EClassifierType)type).getType());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages().size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)ast).size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Call)ast).getArguments().get(0)).size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Call)ast).getArguments().get(1)).size());
    }

    @Test
    public void oclIsKindOf_varAClass_X() {
        String varName = "varAClass";
        IValidationResult validationResult = this.engine.validate(varName + ".oclIsKindOf(inference::X)", this.variableTypes);
        Expression ast = validationResult.getAstResult().getAst();
        Set inferredWhenTrue = (Set)validationResult.getInferredVariableTypes(ast, Boolean.TRUE).get(varName);
        Set inferredWhenFalse = (Set)validationResult.getInferredVariableTypes(ast, Boolean.FALSE).get(varName);
        Assert.assertNotNull((Object)inferredWhenTrue);
        Assert.assertNotNull((Object)inferredWhenFalse);
        this.assertDisjointTypes(inferredWhenTrue, inferredWhenFalse);
        Assert.assertEquals((long)1L, (long)inferredWhenTrue.size());
        Iterator it = inferredWhenTrue.iterator();
        IType type = (IType)it.next();
        Assert.assertTrue((boolean)(type instanceof EClassifierType));
        Assert.assertEquals((Object)this.b, (Object)((EClassifierType)type).getType());
        Assert.assertEquals((long)1L, (long)inferredWhenFalse.size());
        it = inferredWhenFalse.iterator();
        type = (IType)it.next();
        Assert.assertTrue((boolean)(type instanceof ClassType));
        Assert.assertEquals(A.class, (Object)((ClassType)type).getType());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages().size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)ast).size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Call)ast).getArguments().get(0)).size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Call)ast).getArguments().get(1)).size());
    }

    @Test
    public void not_oclIsKindOf_varB_B() {
        String varName = "varB";
        IValidationResult validationResult = this.engine.validate("not " + varName + ".oclIsKindOf(inference::B)", this.variableTypes);
        Expression ast = validationResult.getAstResult().getAst();
        Set inferredWhenTrue = (Set)validationResult.getInferredVariableTypes(ast, Boolean.TRUE).get(varName);
        Set inferredWhenFalse = (Set)validationResult.getInferredVariableTypes(ast, Boolean.FALSE).get(varName);
        Assert.assertNull((Object)inferredWhenTrue);
        Assert.assertNotNull((Object)inferredWhenFalse);
        Assert.assertEquals((long)1L, (long)inferredWhenFalse.size());
        Iterator it = inferredWhenFalse.iterator();
        IType type = (IType)it.next();
        Assert.assertTrue((boolean)(type instanceof EClassifierType));
        Assert.assertEquals((Object)this.b, (Object)((EClassifierType)type).getType());
        Assert.assertEquals((long)1L, (long)validationResult.getMessages().size());
        ValidationTest.assertValidationMessage((IValidationMessage)validationResult.getMessages().get(0), ValidationMessageLevel.INFO, "Always true:\nNothing inferred when varB (EClassifier=B) is not kind of EClassifierLiteral=B", 4, 34);
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)ast).size());
        Assert.assertEquals((long)1L, (long)validationResult.getMessages((ASTNode)((Call)ast).getArguments().get(0)).size());
        ValidationTest.assertValidationMessage((IValidationMessage)validationResult.getMessages((ASTNode)((Call)ast).getArguments().get(0)).get(0), ValidationMessageLevel.INFO, "Always true:\nNothing inferred when varB (EClassifier=B) is not kind of EClassifierLiteral=B", 4, 34);
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Call)((Call)ast).getArguments().get(0)).getArguments().get(0)).size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Call)((Call)ast).getArguments().get(0)).getArguments().get(1)).size());
    }

    @Test
    public void not_oclIsKindOf_varBClass_B() {
        String varName = "varBClass";
        IValidationResult validationResult = this.engine.validate("not " + varName + ".oclIsKindOf(inference::B)", this.variableTypes);
        Expression ast = validationResult.getAstResult().getAst();
        Set inferredWhenTrue = (Set)validationResult.getInferredVariableTypes(ast, Boolean.TRUE).get(varName);
        Set inferredWhenFalse = (Set)validationResult.getInferredVariableTypes(ast, Boolean.FALSE).get(varName);
        Assert.assertNull((Object)inferredWhenTrue);
        Assert.assertNotNull((Object)inferredWhenFalse);
        Assert.assertEquals((long)1L, (long)inferredWhenFalse.size());
        Iterator it = inferredWhenFalse.iterator();
        IType type = (IType)it.next();
        Assert.assertTrue((boolean)(type instanceof ClassType));
        Assert.assertEquals(B.class, (Object)((ClassType)type).getType());
        Assert.assertEquals((long)1L, (long)validationResult.getMessages().size());
        ValidationTest.assertValidationMessage((IValidationMessage)validationResult.getMessages().get(0), ValidationMessageLevel.INFO, "Always true:\nNothing inferred when varBClass (inference.B) is not kind of EClassifierLiteral=B", 4, 39);
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)ast).size());
        Assert.assertEquals((long)1L, (long)validationResult.getMessages((ASTNode)((Call)ast).getArguments().get(0)).size());
        ValidationTest.assertValidationMessage((IValidationMessage)validationResult.getMessages((ASTNode)((Call)ast).getArguments().get(0)).get(0), ValidationMessageLevel.INFO, "Always true:\nNothing inferred when varBClass (inference.B) is not kind of EClassifierLiteral=B", 4, 39);
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Call)((Call)ast).getArguments().get(0)).getArguments().get(0)).size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Call)((Call)ast).getArguments().get(0)).getArguments().get(1)).size());
    }

    @Test
    public void not_oclIsKindOf_varC_B() {
        String varName = "varC";
        IValidationResult validationResult = this.engine.validate("not " + varName + ".oclIsKindOf(inference::B)", this.variableTypes);
        Expression ast = validationResult.getAstResult().getAst();
        Set inferredWhenTrue = (Set)validationResult.getInferredVariableTypes(ast, Boolean.TRUE).get(varName);
        Set inferredWhenFalse = (Set)validationResult.getInferredVariableTypes(ast, Boolean.FALSE).get(varName);
        Assert.assertNull((Object)inferredWhenTrue);
        Assert.assertNotNull((Object)inferredWhenFalse);
        Assert.assertEquals((long)1L, (long)inferredWhenFalse.size());
        Iterator it = inferredWhenFalse.iterator();
        IType type = (IType)it.next();
        Assert.assertTrue((boolean)(type instanceof EClassifierType));
        Assert.assertEquals((Object)this.c, (Object)((EClassifierType)type).getType());
        Assert.assertEquals((long)1L, (long)validationResult.getMessages().size());
        ValidationTest.assertValidationMessage((IValidationMessage)validationResult.getMessages().get(0), ValidationMessageLevel.INFO, "Always true:\nNothing inferred when varC (EClassifier=C) is not kind of EClassifierLiteral=B", 4, 34);
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)ast).size());
        Assert.assertEquals((long)1L, (long)validationResult.getMessages((ASTNode)((Call)ast).getArguments().get(0)).size());
        ValidationTest.assertValidationMessage((IValidationMessage)validationResult.getMessages((ASTNode)((Call)ast).getArguments().get(0)).get(0), ValidationMessageLevel.INFO, "Always true:\nNothing inferred when varC (EClassifier=C) is not kind of EClassifierLiteral=B", 4, 34);
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Call)((Call)ast).getArguments().get(0)).getArguments().get(0)).size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Call)((Call)ast).getArguments().get(0)).getArguments().get(1)).size());
    }

    @Test
    public void not_oclIsKindOf_varCClass_B() {
        String varName = "varCClass";
        IValidationResult validationResult = this.engine.validate("not " + varName + ".oclIsKindOf(inference::B)", this.variableTypes);
        Expression ast = validationResult.getAstResult().getAst();
        Set inferredWhenTrue = (Set)validationResult.getInferredVariableTypes(ast, Boolean.TRUE).get(varName);
        Set inferredWhenFalse = (Set)validationResult.getInferredVariableTypes(ast, Boolean.FALSE).get(varName);
        Assert.assertNull((Object)inferredWhenTrue);
        Assert.assertNotNull((Object)inferredWhenFalse);
        Assert.assertEquals((long)1L, (long)inferredWhenFalse.size());
        Iterator it = inferredWhenFalse.iterator();
        IType type = (IType)it.next();
        Assert.assertTrue((boolean)(type instanceof ClassType));
        Assert.assertEquals(C.class, (Object)((ClassType)type).getType());
        Assert.assertEquals((long)1L, (long)validationResult.getMessages().size());
        ValidationTest.assertValidationMessage((IValidationMessage)validationResult.getMessages().get(0), ValidationMessageLevel.INFO, "Always true:\nNothing inferred when varCClass (inference.C) is not kind of EClassifierLiteral=B", 4, 39);
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)ast).size());
        Assert.assertEquals((long)1L, (long)validationResult.getMessages((ASTNode)((Call)ast).getArguments().get(0)).size());
        ValidationTest.assertValidationMessage((IValidationMessage)validationResult.getMessages((ASTNode)((Call)ast).getArguments().get(0)).get(0), ValidationMessageLevel.INFO, "Always true:\nNothing inferred when varCClass (inference.C) is not kind of EClassifierLiteral=B", 4, 39);
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Call)((Call)ast).getArguments().get(0)).getArguments().get(0)).size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Call)((Call)ast).getArguments().get(0)).getArguments().get(1)).size());
    }

    @Test
    public void not_oclIsKindOf_varC_O() {
        String varName = "varC";
        IValidationResult validationResult = this.engine.validate("not " + varName + ".oclIsKindOf(inference::O)", this.variableTypes);
        Expression ast = validationResult.getAstResult().getAst();
        Set inferredWhenTrue = (Set)validationResult.getInferredVariableTypes(ast, Boolean.TRUE).get(varName);
        Set inferredWhenFalse = (Set)validationResult.getInferredVariableTypes(ast, Boolean.FALSE).get(varName);
        Assert.assertNotNull((Object)inferredWhenTrue);
        Assert.assertNull((Object)inferredWhenFalse);
        Assert.assertEquals((long)1L, (long)inferredWhenTrue.size());
        Iterator it = inferredWhenTrue.iterator();
        IType type = (IType)it.next();
        Assert.assertTrue((boolean)(type instanceof EClassifierType));
        Assert.assertEquals((Object)this.c, (Object)((EClassifierType)type).getType());
        Assert.assertEquals((long)1L, (long)validationResult.getMessages().size());
        ValidationTest.assertValidationMessage((IValidationMessage)validationResult.getMessages().get(0), ValidationMessageLevel.INFO, "Always false:\nNothing inferred when varC (EClassifier=C) is kind of EClassifierLiteral=O", 4, 34);
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)ast).size());
        Assert.assertEquals((long)1L, (long)validationResult.getMessages((ASTNode)((Call)ast).getArguments().get(0)).size());
        ValidationTest.assertValidationMessage((IValidationMessage)validationResult.getMessages((ASTNode)((Call)ast).getArguments().get(0)).get(0), ValidationMessageLevel.INFO, "Always false:\nNothing inferred when varC (EClassifier=C) is kind of EClassifierLiteral=O", 4, 34);
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Call)((Call)ast).getArguments().get(0)).getArguments().get(0)).size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Call)((Call)ast).getArguments().get(0)).getArguments().get(1)).size());
    }

    @Test
    public void not_oclIsKindOf_varCClass_O() {
        String varName = "varCClass";
        IValidationResult validationResult = this.engine.validate("not " + varName + ".oclIsKindOf(inference::O)", this.variableTypes);
        Expression ast = validationResult.getAstResult().getAst();
        Set inferredWhenTrue = (Set)validationResult.getInferredVariableTypes(ast, Boolean.TRUE).get(varName);
        Set inferredWhenFalse = (Set)validationResult.getInferredVariableTypes(ast, Boolean.FALSE).get(varName);
        Assert.assertNotNull((Object)inferredWhenTrue);
        Assert.assertNull((Object)inferredWhenFalse);
        Assert.assertEquals((long)1L, (long)inferredWhenTrue.size());
        Iterator it = inferredWhenTrue.iterator();
        IType type = (IType)it.next();
        Assert.assertTrue((boolean)(type instanceof ClassType));
        Assert.assertEquals(C.class, (Object)((ClassType)type).getType());
        Assert.assertEquals((long)1L, (long)validationResult.getMessages().size());
        ValidationTest.assertValidationMessage((IValidationMessage)validationResult.getMessages().get(0), ValidationMessageLevel.INFO, "Always false:\nNothing inferred when varCClass (inference.C) is kind of EClassifierLiteral=O", 4, 39);
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)ast).size());
        Assert.assertEquals((long)1L, (long)validationResult.getMessages((ASTNode)((Call)ast).getArguments().get(0)).size());
        ValidationTest.assertValidationMessage((IValidationMessage)validationResult.getMessages((ASTNode)((Call)ast).getArguments().get(0)).get(0), ValidationMessageLevel.INFO, "Always false:\nNothing inferred when varCClass (inference.C) is kind of EClassifierLiteral=O", 4, 39);
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Call)((Call)ast).getArguments().get(0)).getArguments().get(0)).size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Call)((Call)ast).getArguments().get(0)).getArguments().get(1)).size());
    }

    @Test
    public void not_oclIsTypeOf_varNothing_B() {
        String varName = "varNothing";
        IValidationResult validationResult = this.engine.validate("not " + varName + ".oclIsTypeOf(inference::B)", this.variableTypes);
        Expression ast = validationResult.getAstResult().getAst();
        Set inferredWhenTrue = (Set)validationResult.getInferredVariableTypes(ast, Boolean.TRUE).get(varName);
        Set inferredWhenFalse = (Set)validationResult.getInferredVariableTypes(ast, Boolean.FALSE).get(varName);
        Assert.assertNotNull((Object)inferredWhenTrue);
        Assert.assertNull((Object)inferredWhenFalse);
        Assert.assertEquals((long)1L, (long)inferredWhenTrue.size());
        Iterator it = inferredWhenTrue.iterator();
        IType type = (IType)it.next();
        Assert.assertTrue((boolean)(type instanceof NothingType));
        Assert.assertEquals((Object)"Nothing", (Object)((NothingType)type).getMessage());
        Assert.assertEquals((long)2L, (long)validationResult.getMessages().size());
        ValidationTest.assertValidationMessage((IValidationMessage)validationResult.getMessages().get(0), ValidationMessageLevel.ERROR, "Nothing", 4, 14);
        ValidationTest.assertValidationMessage((IValidationMessage)validationResult.getMessages().get(1), ValidationMessageLevel.INFO, "Always false:\nNothing inferred when varNothing (Nothing(Nothing)) is type of EClassifierLiteral=B", 4, 40);
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)ast).size());
        Assert.assertEquals((long)1L, (long)validationResult.getMessages((ASTNode)((Call)ast).getArguments().get(0)).size());
        ValidationTest.assertValidationMessage((IValidationMessage)validationResult.getMessages((ASTNode)((Call)ast).getArguments().get(0)).get(0), ValidationMessageLevel.INFO, "Always false:\nNothing inferred when varNothing (Nothing(Nothing)) is type of EClassifierLiteral=B", 4, 40);
        Assert.assertEquals((long)1L, (long)validationResult.getMessages((ASTNode)((Call)((Call)ast).getArguments().get(0)).getArguments().get(0)).size());
        ValidationTest.assertValidationMessage((IValidationMessage)validationResult.getMessages((ASTNode)((Call)((Call)ast).getArguments().get(0)).getArguments().get(0)).get(0), ValidationMessageLevel.ERROR, "Nothing", 4, 14);
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Call)((Call)ast).getArguments().get(0)).getArguments().get(1)).size());
    }

    @Test
    public void not_oclIsTypeOf_varA_B() {
        String varName = "varA";
        IValidationResult validationResult = this.engine.validate("not " + varName + ".oclIsTypeOf(inference::B)", this.variableTypes);
        Expression ast = validationResult.getAstResult().getAst();
        Set inferredWhenTrue = (Set)validationResult.getInferredVariableTypes(ast, Boolean.TRUE).get(varName);
        Set inferredWhenFalse = (Set)validationResult.getInferredVariableTypes(ast, Boolean.FALSE).get(varName);
        Assert.assertNotNull((Object)inferredWhenTrue);
        Assert.assertNotNull((Object)inferredWhenFalse);
        Assert.assertEquals((long)1L, (long)inferredWhenTrue.size());
        Iterator it = inferredWhenTrue.iterator();
        IType type = (IType)it.next();
        Assert.assertTrue((boolean)(type instanceof EClassifierType));
        Assert.assertEquals((Object)this.a, (Object)((EClassifierType)type).getType());
        Assert.assertEquals((long)1L, (long)inferredWhenFalse.size());
        it = inferredWhenFalse.iterator();
        type = (IType)it.next();
        Assert.assertTrue((boolean)(type instanceof EClassifierType));
        Assert.assertEquals((Object)this.b, (Object)((EClassifierType)type).getType());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages().size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)ast).size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Call)ast).getArguments().get(0)).size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Call)((Call)ast).getArguments().get(0)).getArguments().get(0)).size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Call)((Call)ast).getArguments().get(0)).getArguments().get(1)).size());
    }

    @Test
    public void not_oclIsTypeOf_varAClass_B() {
        String varName = "varAClass";
        IValidationResult validationResult = this.engine.validate("not " + varName + ".oclIsTypeOf(inference::B)", this.variableTypes);
        Expression ast = validationResult.getAstResult().getAst();
        Set inferredWhenTrue = (Set)validationResult.getInferredVariableTypes(ast, Boolean.TRUE).get(varName);
        Set inferredWhenFalse = (Set)validationResult.getInferredVariableTypes(ast, Boolean.FALSE).get(varName);
        Assert.assertNotNull((Object)inferredWhenTrue);
        Assert.assertNotNull((Object)inferredWhenFalse);
        Assert.assertEquals((long)1L, (long)inferredWhenTrue.size());
        Iterator it = inferredWhenTrue.iterator();
        IType type = (IType)it.next();
        Assert.assertTrue((boolean)(type instanceof ClassType));
        Assert.assertEquals(A.class, (Object)((ClassType)type).getType());
        Assert.assertEquals((long)1L, (long)inferredWhenFalse.size());
        it = inferredWhenFalse.iterator();
        type = (IType)it.next();
        Assert.assertTrue((boolean)(type instanceof EClassifierType));
        Assert.assertEquals((Object)this.b, (Object)((EClassifierType)type).getType());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages().size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)ast).size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Call)ast).getArguments().get(0)).size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Call)((Call)ast).getArguments().get(0)).getArguments().get(0)).size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Call)((Call)ast).getArguments().get(0)).getArguments().get(1)).size());
    }

    @Test
    public void not_oclIsTypeOf_varB_B() {
        String varName = "varB";
        IValidationResult validationResult = this.engine.validate("not " + varName + ".oclIsTypeOf(inference::B)", this.variableTypes);
        Expression ast = validationResult.getAstResult().getAst();
        Set inferredWhenTrue = (Set)validationResult.getInferredVariableTypes(ast, Boolean.TRUE).get(varName);
        Set inferredWhenFalse = (Set)validationResult.getInferredVariableTypes(ast, Boolean.FALSE).get(varName);
        Assert.assertNotNull((Object)inferredWhenTrue);
        Assert.assertNotNull((Object)inferredWhenFalse);
        Assert.assertEquals((long)2L, (long)inferredWhenTrue.size());
        Iterator it = inferredWhenTrue.iterator();
        IType type = (IType)it.next();
        Assert.assertTrue((boolean)(type instanceof EClassifierType));
        Assert.assertEquals((Object)this.c, (Object)((EClassifierType)type).getType());
        type = (IType)it.next();
        Assert.assertTrue((boolean)(type instanceof EClassifierType));
        Assert.assertEquals((Object)this.y, (Object)((EClassifierType)type).getType());
        Assert.assertEquals((long)1L, (long)inferredWhenFalse.size());
        it = inferredWhenFalse.iterator();
        type = (IType)it.next();
        Assert.assertTrue((boolean)(type instanceof EClassifierType));
        Assert.assertEquals((Object)this.b, (Object)((EClassifierType)type).getType());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages().size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)ast).size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Call)ast).getArguments().get(0)).size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Call)((Call)ast).getArguments().get(0)).getArguments().get(0)).size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Call)((Call)ast).getArguments().get(0)).getArguments().get(1)).size());
    }

    @Test
    public void not_oclIsTypeOf_varBClass_B() {
        String varName = "varBClass";
        IValidationResult validationResult = this.engine.validate("not " + varName + ".oclIsTypeOf(inference::B)", this.variableTypes);
        Expression ast = validationResult.getAstResult().getAst();
        Set inferredWhenTrue = (Set)validationResult.getInferredVariableTypes(ast, Boolean.TRUE).get(varName);
        Set inferredWhenFalse = (Set)validationResult.getInferredVariableTypes(ast, Boolean.FALSE).get(varName);
        Assert.assertNotNull((Object)inferredWhenTrue);
        Assert.assertNotNull((Object)inferredWhenFalse);
        Assert.assertEquals((long)2L, (long)inferredWhenTrue.size());
        Iterator it = inferredWhenTrue.iterator();
        IType type = (IType)it.next();
        Assert.assertTrue((boolean)(type instanceof EClassifierType));
        Assert.assertEquals((Object)this.c, (Object)((EClassifierType)type).getType());
        type = (IType)it.next();
        Assert.assertTrue((boolean)(type instanceof EClassifierType));
        Assert.assertEquals((Object)this.y, (Object)((EClassifierType)type).getType());
        Assert.assertEquals((long)1L, (long)inferredWhenFalse.size());
        it = inferredWhenFalse.iterator();
        type = (IType)it.next();
        Assert.assertTrue((boolean)(type instanceof EClassifierType));
        Assert.assertEquals((Object)this.b, (Object)((EClassifierType)type).getType());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages().size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)ast).size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Call)ast).getArguments().get(0)).size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Call)((Call)ast).getArguments().get(0)).getArguments().get(0)).size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Call)((Call)ast).getArguments().get(0)).getArguments().get(1)).size());
    }

    @Test
    public void not_oclIsTypeOf_varZ_Z() {
        String varName = "varZ";
        IValidationResult validationResult = this.engine.validate("not " + varName + ".oclIsTypeOf(inference::Z)", this.variableTypes);
        Expression ast = validationResult.getAstResult().getAst();
        Set inferredWhenTrue = (Set)validationResult.getInferredVariableTypes(ast, Boolean.TRUE).get(varName);
        Set inferredWhenFalse = (Set)validationResult.getInferredVariableTypes(ast, Boolean.FALSE).get(varName);
        Assert.assertNull((Object)inferredWhenTrue);
        Assert.assertNotNull((Object)inferredWhenFalse);
        Assert.assertEquals((long)1L, (long)inferredWhenFalse.size());
        Iterator it = inferredWhenFalse.iterator();
        IType type = (IType)it.next();
        Assert.assertTrue((boolean)(type instanceof EClassifierType));
        Assert.assertEquals((Object)this.z, (Object)((EClassifierType)type).getType());
        Assert.assertEquals((long)1L, (long)validationResult.getMessages().size());
        ValidationTest.assertValidationMessage((IValidationMessage)validationResult.getMessages().get(0), ValidationMessageLevel.INFO, "Always true:\nNothing inferred when varZ (EClassifier=Z) is not type of EClassifierLiteral=Z", 4, 34);
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)ast).size());
        Assert.assertEquals((long)1L, (long)validationResult.getMessages((ASTNode)((Call)ast).getArguments().get(0)).size());
        ValidationTest.assertValidationMessage((IValidationMessage)validationResult.getMessages((ASTNode)((Call)ast).getArguments().get(0)).get(0), ValidationMessageLevel.INFO, "Always true:\nNothing inferred when varZ (EClassifier=Z) is not type of EClassifierLiteral=Z", 4, 34);
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Call)((Call)ast).getArguments().get(0)).getArguments().get(0)).size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Call)((Call)ast).getArguments().get(0)).getArguments().get(1)).size());
    }

    @Test
    public void not_oclIsTypeOf_varZClass_Z() {
        String varName = "varZClass";
        IValidationResult validationResult = this.engine.validate("not " + varName + ".oclIsTypeOf(inference::Z)", this.variableTypes);
        Expression ast = validationResult.getAstResult().getAst();
        Set inferredWhenTrue = (Set)validationResult.getInferredVariableTypes(ast, Boolean.TRUE).get(varName);
        Set inferredWhenFalse = (Set)validationResult.getInferredVariableTypes(ast, Boolean.FALSE).get(varName);
        Assert.assertNull((Object)inferredWhenTrue);
        Assert.assertNotNull((Object)inferredWhenFalse);
        Assert.assertEquals((long)1L, (long)inferredWhenFalse.size());
        Iterator it = inferredWhenFalse.iterator();
        IType type = (IType)it.next();
        Assert.assertTrue((boolean)(type instanceof EClassifierType));
        Assert.assertEquals((Object)this.z, (Object)((EClassifierType)type).getType());
        Assert.assertEquals((long)1L, (long)validationResult.getMessages().size());
        ValidationTest.assertValidationMessage((IValidationMessage)validationResult.getMessages().get(0), ValidationMessageLevel.INFO, "Always true:\nNothing inferred when varZClass (inference.Z) is not type of EClassifierLiteral=Z", 4, 39);
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)ast).size());
        Assert.assertEquals((long)1L, (long)validationResult.getMessages((ASTNode)((Call)ast).getArguments().get(0)).size());
        ValidationTest.assertValidationMessage((IValidationMessage)validationResult.getMessages((ASTNode)((Call)ast).getArguments().get(0)).get(0), ValidationMessageLevel.INFO, "Always true:\nNothing inferred when varZClass (inference.Z) is not type of EClassifierLiteral=Z", 4, 39);
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Call)((Call)ast).getArguments().get(0)).getArguments().get(0)).size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Call)((Call)ast).getArguments().get(0)).getArguments().get(1)).size());
    }

    @Test
    public void not_oclIsTypeOf_varC_B() {
        String varName = "varC";
        IValidationResult validationResult = this.engine.validate("not " + varName + ".oclIsTypeOf(inference::B)", this.variableTypes);
        Expression ast = validationResult.getAstResult().getAst();
        Set inferredWhenTrue = (Set)validationResult.getInferredVariableTypes(ast, Boolean.TRUE).get(varName);
        Set inferredWhenFalse = (Set)validationResult.getInferredVariableTypes(ast, Boolean.FALSE).get(varName);
        Assert.assertNotNull((Object)inferredWhenTrue);
        Assert.assertNull((Object)inferredWhenFalse);
        Assert.assertEquals((long)1L, (long)inferredWhenTrue.size());
        Iterator it = inferredWhenTrue.iterator();
        IType type = (IType)it.next();
        Assert.assertTrue((boolean)(type instanceof EClassifierType));
        Assert.assertEquals((Object)this.c, (Object)((EClassifierType)type).getType());
        Assert.assertEquals((long)1L, (long)validationResult.getMessages().size());
        ValidationTest.assertValidationMessage((IValidationMessage)validationResult.getMessages().get(0), ValidationMessageLevel.INFO, "Always false:\nNothing inferred when varC (EClassifier=C) is type of EClassifierLiteral=B", 4, 34);
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)ast).size());
        Assert.assertEquals((long)1L, (long)validationResult.getMessages((ASTNode)((Call)ast).getArguments().get(0)).size());
        ValidationTest.assertValidationMessage((IValidationMessage)validationResult.getMessages((ASTNode)((Call)ast).getArguments().get(0)).get(0), ValidationMessageLevel.INFO, "Always false:\nNothing inferred when varC (EClassifier=C) is type of EClassifierLiteral=B", 4, 34);
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Call)((Call)ast).getArguments().get(0)).getArguments().get(0)).size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Call)((Call)ast).getArguments().get(0)).getArguments().get(1)).size());
    }

    @Test
    public void not_oclIsTypeOf_varCClass_B() {
        String varName = "varCClass";
        IValidationResult validationResult = this.engine.validate("not " + varName + ".oclIsTypeOf(inference::B)", this.variableTypes);
        Expression ast = validationResult.getAstResult().getAst();
        Set inferredWhenTrue = (Set)validationResult.getInferredVariableTypes(ast, Boolean.TRUE).get(varName);
        Set inferredWhenFalse = (Set)validationResult.getInferredVariableTypes(ast, Boolean.FALSE).get(varName);
        Assert.assertNotNull((Object)inferredWhenTrue);
        Assert.assertNull((Object)inferredWhenFalse);
        Assert.assertEquals((long)1L, (long)inferredWhenTrue.size());
        Iterator it = inferredWhenTrue.iterator();
        IType type = (IType)it.next();
        Assert.assertTrue((boolean)(type instanceof ClassType));
        Assert.assertEquals(C.class, (Object)((ClassType)type).getType());
        Assert.assertEquals((long)1L, (long)validationResult.getMessages().size());
        ValidationTest.assertValidationMessage((IValidationMessage)validationResult.getMessages().get(0), ValidationMessageLevel.INFO, "Always false:\nNothing inferred when varCClass (inference.C) is type of EClassifierLiteral=B", 4, 39);
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)ast).size());
        Assert.assertEquals((long)1L, (long)validationResult.getMessages((ASTNode)((Call)ast).getArguments().get(0)).size());
        ValidationTest.assertValidationMessage((IValidationMessage)validationResult.getMessages((ASTNode)((Call)ast).getArguments().get(0)).get(0), ValidationMessageLevel.INFO, "Always false:\nNothing inferred when varCClass (inference.C) is type of EClassifierLiteral=B", 4, 39);
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Call)((Call)ast).getArguments().get(0)).getArguments().get(0)).size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Call)((Call)ast).getArguments().get(0)).getArguments().get(1)).size());
    }

    @Test
    public void not_oclIsTypeOf_varC_O() {
        String varName = "varC";
        IValidationResult validationResult = this.engine.validate("not " + varName + ".oclIsTypeOf(inference::O)", this.variableTypes);
        Expression ast = validationResult.getAstResult().getAst();
        Set inferredWhenTrue = (Set)validationResult.getInferredVariableTypes(ast, Boolean.TRUE).get(varName);
        Set inferredWhenFalse = (Set)validationResult.getInferredVariableTypes(ast, Boolean.FALSE).get(varName);
        Assert.assertNotNull((Object)inferredWhenTrue);
        Assert.assertNull((Object)inferredWhenFalse);
        Assert.assertEquals((long)1L, (long)inferredWhenTrue.size());
        Iterator it = inferredWhenTrue.iterator();
        IType type = (IType)it.next();
        Assert.assertTrue((boolean)(type instanceof EClassifierType));
        Assert.assertEquals((Object)this.c, (Object)((EClassifierType)type).getType());
        Assert.assertEquals((long)1L, (long)validationResult.getMessages().size());
        ValidationTest.assertValidationMessage((IValidationMessage)validationResult.getMessages().get(0), ValidationMessageLevel.INFO, "Always false:\nNothing inferred when varC (EClassifier=C) is type of EClassifierLiteral=O", 4, 34);
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)ast).size());
        Assert.assertEquals((long)1L, (long)validationResult.getMessages((ASTNode)((Call)ast).getArguments().get(0)).size());
        ValidationTest.assertValidationMessage((IValidationMessage)validationResult.getMessages((ASTNode)((Call)ast).getArguments().get(0)).get(0), ValidationMessageLevel.INFO, "Always false:\nNothing inferred when varC (EClassifier=C) is type of EClassifierLiteral=O", 4, 34);
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Call)((Call)ast).getArguments().get(0)).getArguments().get(0)).size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Call)((Call)ast).getArguments().get(0)).getArguments().get(1)).size());
    }

    @Test
    public void not_oclIsTypeOf_varCClass_O() {
        String varName = "varCClass";
        IValidationResult validationResult = this.engine.validate("not " + varName + ".oclIsTypeOf(inference::O)", this.variableTypes);
        Expression ast = validationResult.getAstResult().getAst();
        Set inferredWhenTrue = (Set)validationResult.getInferredVariableTypes(ast, Boolean.TRUE).get(varName);
        Set inferredWhenFalse = (Set)validationResult.getInferredVariableTypes(ast, Boolean.FALSE).get(varName);
        Assert.assertNotNull((Object)inferredWhenTrue);
        Assert.assertNull((Object)inferredWhenFalse);
        Assert.assertEquals((long)1L, (long)inferredWhenTrue.size());
        Iterator it = inferredWhenTrue.iterator();
        IType type = (IType)it.next();
        Assert.assertTrue((boolean)(type instanceof ClassType));
        Assert.assertEquals(C.class, (Object)((ClassType)type).getType());
        Assert.assertEquals((long)1L, (long)validationResult.getMessages().size());
        ValidationTest.assertValidationMessage((IValidationMessage)validationResult.getMessages().get(0), ValidationMessageLevel.INFO, "Always false:\nNothing inferred when varCClass (inference.C) is type of EClassifierLiteral=O", 4, 39);
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)ast).size());
        Assert.assertEquals((long)1L, (long)validationResult.getMessages((ASTNode)((Call)ast).getArguments().get(0)).size());
        ValidationTest.assertValidationMessage((IValidationMessage)validationResult.getMessages((ASTNode)((Call)ast).getArguments().get(0)).get(0), ValidationMessageLevel.INFO, "Always false:\nNothing inferred when varCClass (inference.C) is type of EClassifierLiteral=O", 4, 39);
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Call)((Call)ast).getArguments().get(0)).getArguments().get(0)).size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Call)((Call)ast).getArguments().get(0)).getArguments().get(1)).size());
    }

    @Test
    public void or() {
        String varName = "varB";
        IValidationResult validationResult = this.engine.validate(varName + ".oclIsKindOf(inference::C) or " + varName + ".oclIsKindOf(inference::Y)", this.variableTypes);
        Expression ast = validationResult.getAstResult().getAst();
        Set inferredWhenTrue = (Set)validationResult.getInferredVariableTypes(ast, Boolean.TRUE).get(varName);
        Set inferredWhenFalse = (Set)validationResult.getInferredVariableTypes(ast, Boolean.FALSE).get(varName);
        Assert.assertNotNull((Object)inferredWhenTrue);
        Assert.assertNotNull((Object)inferredWhenFalse);
        this.assertDisjointTypes(inferredWhenTrue, inferredWhenFalse);
        Assert.assertEquals((long)2L, (long)inferredWhenTrue.size());
        Iterator it = inferredWhenTrue.iterator();
        IType type = (IType)it.next();
        Assert.assertTrue((boolean)(type instanceof EClassifierType));
        Assert.assertEquals((Object)this.c, (Object)((EClassifierType)type).getType());
        type = (IType)it.next();
        Assert.assertTrue((boolean)(type instanceof EClassifierType));
        Assert.assertEquals((Object)this.y, (Object)((EClassifierType)type).getType());
        Assert.assertEquals((long)1L, (long)inferredWhenFalse.size());
        it = inferredWhenFalse.iterator();
        type = (IType)it.next();
        Assert.assertTrue((boolean)(type instanceof EClassifierType));
        Assert.assertEquals((Object)this.b, (Object)((EClassifierType)type).getType());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages().size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)ast).size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Call)ast).getArguments().get(0)).size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Call)((Call)ast).getArguments().get(0)).getArguments().get(0)).size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Call)((Call)ast).getArguments().get(0)).getArguments().get(1)).size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Call)ast).getArguments().get(1)).size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Call)((Call)ast).getArguments().get(1)).getArguments().get(0)).size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Call)((Call)ast).getArguments().get(1)).getArguments().get(1)).size());
    }

    @Test
    public void orClass() {
        String varName = "varBClass";
        IValidationResult validationResult = this.engine.validate(varName + ".oclIsKindOf(inference::C) or " + varName + ".oclIsKindOf(inference::Y)", this.variableTypes);
        Expression ast = validationResult.getAstResult().getAst();
        Set inferredWhenTrue = (Set)validationResult.getInferredVariableTypes(ast, Boolean.TRUE).get(varName);
        Set inferredWhenFalse = (Set)validationResult.getInferredVariableTypes(ast, Boolean.FALSE).get(varName);
        Assert.assertNotNull((Object)inferredWhenTrue);
        Assert.assertNotNull((Object)inferredWhenFalse);
        this.assertDisjointTypes(inferredWhenTrue, inferredWhenFalse);
        Assert.assertEquals((long)2L, (long)inferredWhenTrue.size());
        Iterator it = inferredWhenTrue.iterator();
        IType type = (IType)it.next();
        Assert.assertTrue((boolean)(type instanceof EClassifierType));
        Assert.assertEquals((Object)this.c, (Object)((EClassifierType)type).getType());
        type = (IType)it.next();
        Assert.assertTrue((boolean)(type instanceof EClassifierType));
        Assert.assertEquals((Object)this.y, (Object)((EClassifierType)type).getType());
        Assert.assertEquals((long)1L, (long)inferredWhenFalse.size());
        it = inferredWhenFalse.iterator();
        type = (IType)it.next();
        Assert.assertTrue((boolean)(type instanceof ClassType));
        Assert.assertEquals(B.class, (Object)((ClassType)type).getType());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages().size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)ast).size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Call)ast).getArguments().get(0)).size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Call)((Call)ast).getArguments().get(0)).getArguments().get(0)).size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Call)((Call)ast).getArguments().get(0)).getArguments().get(1)).size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Call)ast).getArguments().get(1)).size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Call)((Call)ast).getArguments().get(1)).getArguments().get(0)).size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Call)((Call)ast).getArguments().get(1)).getArguments().get(1)).size());
    }

    @Test
    public void xor() {
        String varName = "varB";
        IValidationResult validationResult = this.engine.validate(varName + ".oclIsKindOf(inference::C) xor " + varName + ".oclIsKindOf(inference::Y)", this.variableTypes);
        Expression ast = validationResult.getAstResult().getAst();
        Set inferredWhenTrue = (Set)validationResult.getInferredVariableTypes(ast, Boolean.TRUE).get(varName);
        Set inferredWhenFalse = (Set)validationResult.getInferredVariableTypes(ast, Boolean.FALSE).get(varName);
        Assert.assertNull((Object)inferredWhenTrue);
        Assert.assertNull((Object)inferredWhenFalse);
        Assert.assertEquals((long)0L, (long)validationResult.getMessages().size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)ast).size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Call)ast).getArguments().get(0)).size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Call)((Call)ast).getArguments().get(0)).getArguments().get(0)).size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Call)((Call)ast).getArguments().get(0)).getArguments().get(1)).size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Call)ast).getArguments().get(1)).size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Call)((Call)ast).getArguments().get(1)).getArguments().get(0)).size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Call)((Call)ast).getArguments().get(1)).getArguments().get(1)).size());
    }

    @Test
    public void xorClass() {
        String varName = "varBClass";
        IValidationResult validationResult = this.engine.validate(varName + ".oclIsKindOf(inference::C) xor " + varName + ".oclIsKindOf(inference::Y)", this.variableTypes);
        Expression ast = validationResult.getAstResult().getAst();
        Set inferredWhenTrue = (Set)validationResult.getInferredVariableTypes(ast, Boolean.TRUE).get(varName);
        Set inferredWhenFalse = (Set)validationResult.getInferredVariableTypes(ast, Boolean.FALSE).get(varName);
        Assert.assertNull((Object)inferredWhenTrue);
        Assert.assertNull((Object)inferredWhenFalse);
        Assert.assertEquals((long)0L, (long)validationResult.getMessages().size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)ast).size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Call)ast).getArguments().get(0)).size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Call)((Call)ast).getArguments().get(0)).getArguments().get(0)).size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Call)((Call)ast).getArguments().get(0)).getArguments().get(1)).size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Call)ast).getArguments().get(1)).size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Call)((Call)ast).getArguments().get(1)).getArguments().get(0)).size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Call)((Call)ast).getArguments().get(1)).getArguments().get(1)).size());
    }

    @Test
    public void and() {
        String varName = "varB";
        IValidationResult validationResult = this.engine.validate(varName + ".oclIsKindOf(inference::C) and " + varName + ".oclIsKindOf(inference::Y)", this.variableTypes);
        Expression ast = validationResult.getAstResult().getAst();
        Set inferredWhenTrue = (Set)validationResult.getInferredVariableTypes(ast, Boolean.TRUE).get(varName);
        Set inferredWhenFalse = (Set)validationResult.getInferredVariableTypes(ast, Boolean.FALSE).get(varName);
        Assert.assertNotNull((Object)inferredWhenTrue);
        Assert.assertNotNull((Object)inferredWhenFalse);
        this.assertDisjointTypes(inferredWhenTrue, inferredWhenFalse);
        Assert.assertEquals((long)1L, (long)inferredWhenTrue.size());
        Iterator it = inferredWhenTrue.iterator();
        IType type = (IType)it.next();
        Assert.assertTrue((boolean)(type instanceof EClassifierType));
        Assert.assertEquals((Object)this.z, (Object)((EClassifierType)type).getType());
        Assert.assertEquals((long)1L, (long)inferredWhenFalse.size());
        it = inferredWhenFalse.iterator();
        type = (IType)it.next();
        Assert.assertTrue((boolean)(type instanceof EClassifierType));
        Assert.assertEquals((Object)this.b, (Object)((EClassifierType)type).getType());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages().size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)ast).size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Call)ast).getArguments().get(0)).size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Call)((Call)ast).getArguments().get(0)).getArguments().get(0)).size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Call)((Call)ast).getArguments().get(0)).getArguments().get(1)).size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Call)ast).getArguments().get(1)).size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Call)((Call)ast).getArguments().get(1)).getArguments().get(0)).size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Call)((Call)ast).getArguments().get(1)).getArguments().get(1)).size());
    }

    @Test
    public void andClass() {
        String varName = "varBClass";
        IValidationResult validationResult = this.engine.validate(varName + ".oclIsKindOf(inference::C) and " + varName + ".oclIsKindOf(inference::Y)", this.variableTypes);
        Expression ast = validationResult.getAstResult().getAst();
        Set inferredWhenTrue = (Set)validationResult.getInferredVariableTypes(ast, Boolean.TRUE).get(varName);
        Set inferredWhenFalse = (Set)validationResult.getInferredVariableTypes(ast, Boolean.FALSE).get(varName);
        Assert.assertNotNull((Object)inferredWhenTrue);
        Assert.assertNotNull((Object)inferredWhenFalse);
        this.assertDisjointTypes(inferredWhenTrue, inferredWhenFalse);
        Assert.assertEquals((long)1L, (long)inferredWhenTrue.size());
        Iterator it = inferredWhenTrue.iterator();
        IType type = (IType)it.next();
        Assert.assertTrue((boolean)(type instanceof EClassifierType));
        Assert.assertEquals((Object)this.z, (Object)((EClassifierType)type).getType());
        Assert.assertEquals((long)1L, (long)inferredWhenFalse.size());
        it = inferredWhenFalse.iterator();
        type = (IType)it.next();
        Assert.assertTrue((boolean)(type instanceof ClassType));
        Assert.assertEquals(B.class, (Object)((ClassType)type).getType());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages().size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)ast).size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Call)ast).getArguments().get(0)).size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Call)((Call)ast).getArguments().get(0)).getArguments().get(0)).size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Call)((Call)ast).getArguments().get(0)).getArguments().get(1)).size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Call)ast).getArguments().get(1)).size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Call)((Call)ast).getArguments().get(1)).getArguments().get(0)).size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Call)((Call)ast).getArguments().get(1)).getArguments().get(1)).size());
    }

    @Test
    public void conditionnalTrueBranch() {
        String varName = "varB";
        IValidationResult validationResult = this.engine.validate("if " + varName + ".oclIsKindOf(inference::C) then " + varName + " else " + varName + " endif", this.variableTypes);
        Expression ast = validationResult.getAstResult().getAst();
        Assert.assertTrue((boolean)(ast instanceof Conditional));
        Conditional conditional = (Conditional)ast;
        Set types = validationResult.getPossibleTypes(conditional.getTrueBranch());
        Assert.assertEquals((long)1L, (long)types.size());
        Iterator it = types.iterator();
        IType type = (IType)it.next();
        Assert.assertTrue((boolean)(type instanceof EClassifierType));
        Assert.assertEquals((Object)this.c, (Object)((EClassifierType)type).getType());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages().size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)ast).size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Conditional)ast).getPredicate()).size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Call)((Conditional)ast).getPredicate()).getArguments().get(0)).size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Call)((Conditional)ast).getPredicate()).getArguments().get(1)).size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Conditional)ast).getTrueBranch()).size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Conditional)ast).getFalseBranch()).size());
    }

    @Test
    public void conditionnalTrueBranchClass() {
        String varName = "varBClass";
        IValidationResult validationResult = this.engine.validate("if " + varName + ".oclIsKindOf(inference::C) then " + varName + " else " + varName + " endif", this.variableTypes);
        Expression ast = validationResult.getAstResult().getAst();
        Assert.assertTrue((boolean)(ast instanceof Conditional));
        Conditional conditional = (Conditional)ast;
        Set types = validationResult.getPossibleTypes(conditional.getTrueBranch());
        Assert.assertEquals((long)1L, (long)types.size());
        Iterator it = types.iterator();
        IType type = (IType)it.next();
        Assert.assertTrue((boolean)(type instanceof EClassifierType));
        Assert.assertEquals((Object)this.c, (Object)((EClassifierType)type).getType());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages().size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)ast).size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Conditional)ast).getPredicate()).size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Call)((Conditional)ast).getPredicate()).getArguments().get(0)).size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Call)((Conditional)ast).getPredicate()).getArguments().get(1)).size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Conditional)ast).getTrueBranch()).size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Conditional)ast).getFalseBranch()).size());
    }

    @Test
    public void conditionnalFalseBranch() {
        String varName = "varB";
        IValidationResult validationResult = this.engine.validate("if not " + varName + ".oclIsKindOf(inference::C) then " + varName + " else " + varName + " endif", this.variableTypes);
        Expression ast = validationResult.getAstResult().getAst();
        Assert.assertTrue((boolean)(ast instanceof Conditional));
        Conditional conditional = (Conditional)ast;
        Set types = validationResult.getPossibleTypes(conditional.getFalseBranch());
        Assert.assertEquals((long)1L, (long)types.size());
        Iterator it = types.iterator();
        IType type = (IType)it.next();
        Assert.assertTrue((boolean)(type instanceof EClassifierType));
        Assert.assertEquals((Object)this.c, (Object)((EClassifierType)type).getType());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages().size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)ast).size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Conditional)ast).getPredicate()).size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Call)((Conditional)ast).getPredicate()).getArguments().get(0)).size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Call)((Call)((Conditional)ast).getPredicate()).getArguments().get(0)).getArguments().get(0)).size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Call)((Call)((Conditional)ast).getPredicate()).getArguments().get(0)).getArguments().get(1)).size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Conditional)ast).getTrueBranch()).size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Conditional)ast).getFalseBranch()).size());
    }

    @Test
    public void conditionnalFalseBranchClass() {
        String varName = "varBClass";
        IValidationResult validationResult = this.engine.validate("if not " + varName + ".oclIsKindOf(inference::C) then " + varName + " else " + varName + " endif", this.variableTypes);
        Expression ast = validationResult.getAstResult().getAst();
        Assert.assertTrue((boolean)(ast instanceof Conditional));
        Conditional conditional = (Conditional)ast;
        Set types = validationResult.getPossibleTypes(conditional.getFalseBranch());
        Assert.assertEquals((long)1L, (long)types.size());
        Iterator it = types.iterator();
        IType type = (IType)it.next();
        Assert.assertTrue((boolean)(type instanceof EClassifierType));
        Assert.assertEquals((Object)this.c, (Object)((EClassifierType)type).getType());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages().size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)ast).size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Conditional)ast).getPredicate()).size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Call)((Conditional)ast).getPredicate()).getArguments().get(0)).size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Call)((Call)((Conditional)ast).getPredicate()).getArguments().get(0)).getArguments().get(0)).size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Call)((Call)((Conditional)ast).getPredicate()).getArguments().get(0)).getArguments().get(1)).size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Conditional)ast).getTrueBranch()).size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Conditional)ast).getFalseBranch()).size());
    }

    @Test
    public void any() {
        String varName = "varB";
        IValidationResult validationResult = this.engine.validate(varName + "->any(i | i.oclIsKindOf(inference::C))", this.variableTypes);
        Expression ast = validationResult.getAstResult().getAst();
        Set types = validationResult.getPossibleTypes(ast);
        Assert.assertEquals((long)1L, (long)types.size());
        Iterator it = types.iterator();
        IType type = (IType)it.next();
        Assert.assertTrue((boolean)(type instanceof EClassifierType));
        Assert.assertEquals((Object)this.c, (Object)((EClassifierType)type).getType());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages().size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)ast).size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Call)ast).getArguments().get(0)).size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Call)ast).getArguments().get(1)).size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Lambda)((Call)ast).getArguments().get(1)).getParameters().get(0)).size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Lambda)((Call)ast).getArguments().get(1)).getExpression()).size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Call)((Lambda)((Call)ast).getArguments().get(1)).getExpression()).getArguments().get(0)).size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Call)((Lambda)((Call)ast).getArguments().get(1)).getExpression()).getArguments().get(1)).size());
    }

    @Test
    public void anyClass() {
        String varName = "varBClass";
        IValidationResult validationResult = this.engine.validate(varName + "->any(i | i.oclIsKindOf(inference::C))", this.variableTypes);
        Expression ast = validationResult.getAstResult().getAst();
        Set types = validationResult.getPossibleTypes(ast);
        Assert.assertEquals((long)1L, (long)types.size());
        Iterator it = types.iterator();
        IType type = (IType)it.next();
        Assert.assertTrue((boolean)(type instanceof EClassifierType));
        Assert.assertEquals((Object)this.c, (Object)((EClassifierType)type).getType());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages().size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)ast).size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Call)ast).getArguments().get(0)).size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Call)ast).getArguments().get(1)).size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Lambda)((Call)ast).getArguments().get(1)).getParameters().get(0)).size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Lambda)((Call)ast).getArguments().get(1)).getExpression()).size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Call)((Lambda)((Call)ast).getArguments().get(1)).getExpression()).getArguments().get(0)).size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Call)((Lambda)((Call)ast).getArguments().get(1)).getExpression()).getArguments().get(1)).size());
    }

    @Test
    public void select() {
        String varName = "varB";
        IValidationResult validationResult = this.engine.validate(varName + "->select(i | i.oclIsKindOf(inference::C))", this.variableTypes);
        Expression ast = validationResult.getAstResult().getAst();
        Set types = validationResult.getPossibleTypes(ast);
        Assert.assertEquals((long)1L, (long)types.size());
        Iterator it = types.iterator();
        IType type = (IType)it.next();
        Assert.assertTrue((boolean)(type instanceof SetType));
        IType rawType = ((SetType)type).getCollectionType();
        Assert.assertTrue((boolean)(rawType instanceof EClassifierType));
        Assert.assertEquals((Object)this.c, (Object)((EClassifierType)rawType).getType());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages().size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)ast).size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Call)ast).getArguments().get(0)).size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Call)ast).getArguments().get(1)).size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Lambda)((Call)ast).getArguments().get(1)).getParameters().get(0)).size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Lambda)((Call)ast).getArguments().get(1)).getExpression()).size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Call)((Lambda)((Call)ast).getArguments().get(1)).getExpression()).getArguments().get(0)).size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Call)((Lambda)((Call)ast).getArguments().get(1)).getExpression()).getArguments().get(1)).size());
    }

    @Test
    public void selectClass() {
        String varName = "varBClass";
        IValidationResult validationResult = this.engine.validate(varName + "->select(i | i.oclIsKindOf(inference::C))", this.variableTypes);
        Expression ast = validationResult.getAstResult().getAst();
        Set types = validationResult.getPossibleTypes(ast);
        Assert.assertEquals((long)1L, (long)types.size());
        Iterator it = types.iterator();
        IType type = (IType)it.next();
        Assert.assertTrue((boolean)(type instanceof SetType));
        IType rawType = ((SetType)type).getCollectionType();
        Assert.assertTrue((boolean)(rawType instanceof EClassifierType));
        Assert.assertEquals((Object)this.c, (Object)((EClassifierType)rawType).getType());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages().size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)ast).size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Call)ast).getArguments().get(0)).size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Call)ast).getArguments().get(1)).size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Lambda)((Call)ast).getArguments().get(1)).getParameters().get(0)).size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Lambda)((Call)ast).getArguments().get(1)).getExpression()).size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Call)((Lambda)((Call)ast).getArguments().get(1)).getExpression()).getArguments().get(0)).size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Call)((Lambda)((Call)ast).getArguments().get(1)).getExpression()).getArguments().get(1)).size());
    }

    @Test
    public void reject() {
        String varName = "varB";
        IValidationResult validationResult = this.engine.validate(varName + "->reject(i | not i.oclIsKindOf(inference::C))", this.variableTypes);
        Expression ast = validationResult.getAstResult().getAst();
        Set types = validationResult.getPossibleTypes(ast);
        Assert.assertEquals((long)1L, (long)types.size());
        Iterator it = types.iterator();
        IType type = (IType)it.next();
        Assert.assertTrue((boolean)(type instanceof SetType));
        IType rawType = ((SetType)type).getCollectionType();
        Assert.assertTrue((boolean)(rawType instanceof EClassifierType));
        Assert.assertEquals((Object)this.c, (Object)((EClassifierType)rawType).getType());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages().size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)ast).size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Call)ast).getArguments().get(0)).size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Call)ast).getArguments().get(1)).size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Lambda)((Call)ast).getArguments().get(1)).getParameters().get(0)).size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Lambda)((Call)ast).getArguments().get(1)).getExpression()).size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Call)((Lambda)((Call)ast).getArguments().get(1)).getExpression()).getArguments().get(0)).size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Call)((Call)((Lambda)((Call)ast).getArguments().get(1)).getExpression()).getArguments().get(0)).getArguments().get(0)).size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Call)((Call)((Lambda)((Call)ast).getArguments().get(1)).getExpression()).getArguments().get(0)).getArguments().get(1)).size());
    }

    @Test
    public void rejectClass() {
        String varName = "varBClass";
        IValidationResult validationResult = this.engine.validate(varName + "->reject(i | not i.oclIsKindOf(inference::C))", this.variableTypes);
        Expression ast = validationResult.getAstResult().getAst();
        Set types = validationResult.getPossibleTypes(ast);
        Assert.assertEquals((long)1L, (long)types.size());
        Iterator it = types.iterator();
        IType type = (IType)it.next();
        Assert.assertTrue((boolean)(type instanceof SetType));
        IType rawType = ((SetType)type).getCollectionType();
        Assert.assertTrue((boolean)(rawType instanceof EClassifierType));
        Assert.assertEquals((Object)this.c, (Object)((EClassifierType)rawType).getType());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages().size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)ast).size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Call)ast).getArguments().get(0)).size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Call)ast).getArguments().get(1)).size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Lambda)((Call)ast).getArguments().get(1)).getParameters().get(0)).size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Lambda)((Call)ast).getArguments().get(1)).getExpression()).size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Call)((Lambda)((Call)ast).getArguments().get(1)).getExpression()).getArguments().get(0)).size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Call)((Call)((Lambda)((Call)ast).getArguments().get(1)).getExpression()).getArguments().get(0)).getArguments().get(0)).size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Call)((Call)((Lambda)((Call)ast).getArguments().get(1)).getExpression()).getArguments().get(0)).getArguments().get(1)).size());
    }

    @Test
    public void andWithSubTypeAttribute() {
        IValidationResult validationResult = this.engine.validate("varB.oclIsKindOf(inference::C) and varB.cAttr = null", this.variableTypes);
        Expression ast = validationResult.getAstResult().getAst();
        Assert.assertEquals((long)0L, (long)validationResult.getMessages().size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)ast).size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Call)ast).getArguments().get(0)).size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Call)((Call)ast).getArguments().get(0)).getArguments().get(0)).size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Call)((Call)ast).getArguments().get(0)).getArguments().get(1)).size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Call)ast).getArguments().get(1)).size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Call)((Call)ast).getArguments().get(1)).getArguments().get(0)).size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Call)((Call)((Call)ast).getArguments().get(1)).getArguments().get(0)).getArguments().get(0)).size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Call)((Call)((Call)ast).getArguments().get(1)).getArguments().get(0)).getArguments().get(1)).size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Call)((Call)ast).getArguments().get(1)).getArguments().get(1)).size());
    }

    @Test
    public void andWithSubTypeAttributeClass() {
        IValidationResult validationResult = this.engine.validate("varBClass.oclIsKindOf(inference::C) and varBClass.cAttr = null", this.variableTypes);
        Expression ast = validationResult.getAstResult().getAst();
        Assert.assertEquals((long)0L, (long)validationResult.getMessages().size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)ast).size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Call)ast).getArguments().get(0)).size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Call)((Call)ast).getArguments().get(0)).getArguments().get(0)).size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Call)((Call)ast).getArguments().get(0)).getArguments().get(1)).size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Call)ast).getArguments().get(1)).size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Call)((Call)ast).getArguments().get(1)).getArguments().get(0)).size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Call)((Call)((Call)ast).getArguments().get(1)).getArguments().get(0)).getArguments().get(0)).size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Call)((Call)((Call)ast).getArguments().get(1)).getArguments().get(0)).getArguments().get(1)).size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Call)((Call)ast).getArguments().get(1)).getArguments().get(1)).size());
    }

    @Test
    public void orWithSubTypeAttribute() {
        IValidationResult validationResult = this.engine.validate("not varB.oclIsKindOf(inference::C) or varB.cAttr = null", this.variableTypes);
        Expression ast = validationResult.getAstResult().getAst();
        Assert.assertEquals((long)0L, (long)validationResult.getMessages().size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)ast).size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Call)ast).getArguments().get(0)).size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Call)((Call)ast).getArguments().get(0)).getArguments().get(0)).size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Call)((Call)((Call)ast).getArguments().get(0)).getArguments().get(0)).getArguments().get(0)).size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Call)((Call)((Call)ast).getArguments().get(0)).getArguments().get(0)).getArguments().get(1)).size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Call)ast).getArguments().get(1)).size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Call)((Call)ast).getArguments().get(1)).getArguments().get(0)).size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Call)((Call)((Call)ast).getArguments().get(1)).getArguments().get(0)).getArguments().get(0)).size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Call)((Call)((Call)ast).getArguments().get(1)).getArguments().get(0)).getArguments().get(1)).size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Call)((Call)ast).getArguments().get(1)).getArguments().get(1)).size());
    }

    @Test
    public void orWithSubTypeAttributeClass() {
        IValidationResult validationResult = this.engine.validate("not varBClass.oclIsKindOf(inference::C) or varBClass.cAttr = null", this.variableTypes);
        Expression ast = validationResult.getAstResult().getAst();
        Assert.assertEquals((long)0L, (long)validationResult.getMessages().size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)ast).size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Call)ast).getArguments().get(0)).size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Call)((Call)ast).getArguments().get(0)).getArguments().get(0)).size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Call)((Call)((Call)ast).getArguments().get(0)).getArguments().get(0)).getArguments().get(0)).size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Call)((Call)((Call)ast).getArguments().get(0)).getArguments().get(0)).getArguments().get(1)).size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Call)ast).getArguments().get(1)).size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Call)((Call)ast).getArguments().get(1)).getArguments().get(0)).size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Call)((Call)((Call)ast).getArguments().get(1)).getArguments().get(0)).getArguments().get(0)).size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Call)((Call)((Call)ast).getArguments().get(1)).getArguments().get(0)).getArguments().get(1)).size());
        Assert.assertEquals((long)0L, (long)validationResult.getMessages((ASTNode)((Call)((Call)ast).getArguments().get(1)).getArguments().get(1)).size());
    }

    private void assertDisjointTypes(Set<IType> inferredWhenTrue, Set<IType> inferredWhenFalse) {
        for (IType type : inferredWhenTrue) {
            Assert.assertFalse((boolean)inferredWhenFalse.contains(type));
        }
        for (IType type : inferredWhenFalse) {
            Assert.assertFalse((boolean)inferredWhenTrue.contains(type));
        }
    }
}

