/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.query.ast.test.delegates;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.acceleo.query.delegates.DelegateUtils;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.junit.Assert;
import org.junit.Test;

public class DelegateUtilsTests {
    @Test(expected=NullPointerException.class)
    public void setSettingDelegatesNull() {
        DelegateUtils.setSettingDelegates(null);
    }

    @Test
    public void setSettingDelegatesNotExisting() {
        EPackage ePkg = EcorePackage.eINSTANCE.getEcoreFactory().createEPackage();
        EcoreUtil.setSettingDelegates((EPackage)ePkg, new ArrayList<String>(Arrays.asList("uri")));
        DelegateUtils.setSettingDelegates((EPackage)ePkg);
        List delegates = EcoreUtil.getSettingDelegates((EPackage)ePkg);
        Assert.assertEquals((long)2L, (long)delegates.size());
        Assert.assertEquals((Object)"uri", delegates.get(0));
        Assert.assertEquals((Object)"http://www.eclipse.org/acceleo/query/1.0", delegates.get(1));
    }

    @Test
    public void setSettingDelegatesExisting() {
        EPackage ePkg = EcorePackage.eINSTANCE.getEcoreFactory().createEPackage();
        EcoreUtil.setSettingDelegates((EPackage)ePkg, new ArrayList<String>(Arrays.asList("uri", "http://www.eclipse.org/acceleo/query/1.0")));
        DelegateUtils.setSettingDelegates((EPackage)ePkg);
        List delegates = EcoreUtil.getSettingDelegates((EPackage)ePkg);
        Assert.assertEquals((long)2L, (long)delegates.size());
        Assert.assertEquals((Object)"uri", delegates.get(0));
        Assert.assertEquals((Object)"http://www.eclipse.org/acceleo/query/1.0", delegates.get(1));
    }

    @Test(expected=NullPointerException.class)
    public void setInvocationDelegatesNull() {
        DelegateUtils.setInvocationDelegates(null);
    }

    @Test
    public void setInvocationDelegatesNotExisting() {
        EPackage ePkg = EcorePackage.eINSTANCE.getEcoreFactory().createEPackage();
        EcoreUtil.setInvocationDelegates((EPackage)ePkg, new ArrayList<String>(Arrays.asList("uri")));
        DelegateUtils.setInvocationDelegates((EPackage)ePkg);
        List delegates = EcoreUtil.getInvocationDelegates((EPackage)ePkg);
        Assert.assertEquals((long)2L, (long)delegates.size());
        Assert.assertEquals((Object)"uri", delegates.get(0));
        Assert.assertEquals((Object)"http://www.eclipse.org/acceleo/query/1.0", delegates.get(1));
    }

    @Test
    public void setInvocationDelegatesExisting() {
        EPackage ePkg = EcorePackage.eINSTANCE.getEcoreFactory().createEPackage();
        EcoreUtil.setInvocationDelegates((EPackage)ePkg, new ArrayList<String>(Arrays.asList("uri", "http://www.eclipse.org/acceleo/query/1.0")));
        DelegateUtils.setInvocationDelegates((EPackage)ePkg);
        List delegates = EcoreUtil.getInvocationDelegates((EPackage)ePkg);
        Assert.assertEquals((long)2L, (long)delegates.size());
        Assert.assertEquals((Object)"uri", delegates.get(0));
        Assert.assertEquals((Object)"http://www.eclipse.org/acceleo/query/1.0", delegates.get(1));
    }

    @Test(expected=NullPointerException.class)
    public void setValidationDelegatesNull() {
        DelegateUtils.setValidationDelegates(null);
    }

    @Test
    public void setValidationDelegatesNotExisting() {
        EPackage ePkg = EcorePackage.eINSTANCE.getEcoreFactory().createEPackage();
        EcoreUtil.setValidationDelegates((EPackage)ePkg, new ArrayList<String>(Arrays.asList("uri")));
        DelegateUtils.setValidationDelegates((EPackage)ePkg);
        List delegates = EcoreUtil.getValidationDelegates((EPackage)ePkg);
        Assert.assertEquals((long)2L, (long)delegates.size());
        Assert.assertEquals((Object)"uri", delegates.get(0));
        Assert.assertEquals((Object)"http://www.eclipse.org/acceleo/query/1.0", delegates.get(1));
    }

    @Test
    public void setValidationDelegatesExisting() {
        EPackage ePkg = EcorePackage.eINSTANCE.getEcoreFactory().createEPackage();
        EcoreUtil.setValidationDelegates((EPackage)ePkg, new ArrayList<String>(Arrays.asList("uri", "http://www.eclipse.org/acceleo/query/1.0")));
        DelegateUtils.setValidationDelegates((EPackage)ePkg);
        List delegates = EcoreUtil.getValidationDelegates((EPackage)ePkg);
        Assert.assertEquals((long)2L, (long)delegates.size());
        Assert.assertEquals((Object)"uri", delegates.get(0));
        Assert.assertEquals((Object)"http://www.eclipse.org/acceleo/query/1.0", delegates.get(1));
    }

    @Test(expected=NullPointerException.class)
    public void getConstraintNull() {
        DelegateUtils.getConstraint(null, (String)"someConstraint");
    }

    @Test
    public void getConstraintNotSetted() {
        EClass eCls = EcorePackage.eINSTANCE.getEcoreFactory().createEClass();
        Assert.assertEquals(null, (Object)DelegateUtils.getConstraint((EModelElement)eCls, (String)"someConstraint"));
    }

    @Test
    public void getConstraintSetted() {
        EClass eCls = EcorePackage.eINSTANCE.getEcoreFactory().createEClass();
        DelegateUtils.setConstraint((EModelElement)eCls, (String)"someConstraint", (String)"self");
        Assert.assertEquals((Object)"self", (Object)DelegateUtils.getConstraint((EModelElement)eCls, (String)"someConstraint"));
    }

    @Test(expected=NullPointerException.class)
    public void setConstraintNull() {
        DelegateUtils.setConstraint(null, (String)"someConstraint", (String)"");
    }

    @Test
    public void setConstraintNotExisting() {
        EClass eCls = EcorePackage.eINSTANCE.getEcoreFactory().createEClass();
        EcoreUtil.setConstraints((EModelElement)eCls, new ArrayList<String>(Arrays.asList("someOtherConstraint")));
        DelegateUtils.setConstraint((EModelElement)eCls, (String)"someConstraint", (String)"true");
        List constraints = EcoreUtil.getConstraints((EModelElement)eCls);
        Assert.assertEquals((long)2L, (long)constraints.size());
        Assert.assertEquals((Object)"someOtherConstraint", constraints.get(0));
        Assert.assertEquals((Object)"someConstraint", constraints.get(1));
        String expression = EcoreUtil.getAnnotation((EModelElement)eCls, (String)"http://www.eclipse.org/acceleo/query/1.0", (String)"someConstraint");
        Assert.assertEquals((Object)"true", (Object)expression);
    }

    @Test
    public void setConstraintExisting() {
        EClass eCls = EcorePackage.eINSTANCE.getEcoreFactory().createEClass();
        EcoreUtil.setConstraints((EModelElement)eCls, new ArrayList<String>(Arrays.asList("someConstraint", "someOtherConstraint")));
        DelegateUtils.setConstraint((EModelElement)eCls, (String)"someConstraint", (String)"true");
        List constraints = EcoreUtil.getConstraints((EModelElement)eCls);
        Assert.assertEquals((long)2L, (long)constraints.size());
        Assert.assertEquals((Object)"someConstraint", constraints.get(0));
        Assert.assertEquals((Object)"someOtherConstraint", constraints.get(1));
        String expression = EcoreUtil.getAnnotation((EModelElement)eCls, (String)"http://www.eclipse.org/acceleo/query/1.0", (String)"someConstraint");
        Assert.assertEquals((Object)"true", (Object)expression);
    }

    @Test(expected=NullPointerException.class)
    public void getBodyNull() {
        DelegateUtils.getBody(null);
    }

    @Test
    public void getBodyNotSetted() {
        EOperation eOperation = EcorePackage.eINSTANCE.getEcoreFactory().createEOperation();
        Assert.assertEquals(null, (Object)DelegateUtils.getBody((EOperation)eOperation));
    }

    @Test
    public void getBodySetted() {
        EOperation eOperation = EcorePackage.eINSTANCE.getEcoreFactory().createEOperation();
        DelegateUtils.setBody((EOperation)eOperation, (String)"self");
        Assert.assertEquals((Object)"self", (Object)DelegateUtils.getBody((EOperation)eOperation));
    }

    @Test(expected=NullPointerException.class)
    public void setBodyNull() {
        DelegateUtils.setBody(null, (String)"true");
    }

    @Test
    public void setBody() {
        EOperation eOperation = EcorePackage.eINSTANCE.getEcoreFactory().createEOperation();
        DelegateUtils.setBody((EOperation)eOperation, (String)"true");
        String expression = EcoreUtil.getAnnotation((EModelElement)eOperation, (String)"http://www.eclipse.org/acceleo/query/1.0", (String)"body");
        Assert.assertEquals((Object)"true", (Object)expression);
    }

    @Test(expected=NullPointerException.class)
    public void getDerivationNull() {
        DelegateUtils.getDerivation(null);
    }

    @Test
    public void getDerivationNotSetted() {
        EAttribute eFeature = EcorePackage.eINSTANCE.getEcoreFactory().createEAttribute();
        Assert.assertEquals(null, (Object)DelegateUtils.getDerivation((EStructuralFeature)eFeature));
    }

    @Test
    public void getDerivationSetted() {
        EAttribute eFeature = EcorePackage.eINSTANCE.getEcoreFactory().createEAttribute();
        DelegateUtils.setDerivation((EStructuralFeature)eFeature, (String)"self");
        Assert.assertEquals((Object)"self", (Object)DelegateUtils.getDerivation((EStructuralFeature)eFeature));
    }

    @Test(expected=NullPointerException.class)
    public void setDerivationNull() {
        DelegateUtils.setDerivation(null, (String)"true");
    }

    @Test
    public void setDerivation() {
        EAttribute eFeature = EcorePackage.eINSTANCE.getEcoreFactory().createEAttribute();
        DelegateUtils.setDerivation((EStructuralFeature)eFeature, (String)"true");
        String expression = EcoreUtil.getAnnotation((EModelElement)eFeature, (String)"http://www.eclipse.org/acceleo/query/1.0", (String)"derivation");
        Assert.assertEquals((Object)"true", (Object)expression);
    }
}

