/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.aql.completion.proposals.templates;

import org.eclipse.acceleo.OpenModeKind;
import org.eclipse.acceleo.VisibilityKind;

public final class AcceleoCodeTemplates {
    public static final String SPACE = " ";
    public static final String TABULATION = "\t";
    public static final String STAR = "*";
    public static final String DEFAULT_EXPRESSION = "expression";
    public static final String DEFAULT_NEW_MODULE_ELEMENT_VARIABLE_NAME = "myParameter";
    public static final VisibilityKind DEFAULT_NEW_QUERY_VISIBILITY = VisibilityKind.PUBLIC;
    public static final String DEFAULT_NEW_QUERY_NAME = "myQuery";
    public static final String DEFAULT_NEW_QUERY_PARAMETER_NAME = "myParameter";
    public static final String DEFAULT_NEW_QUERY_PARAMETER_TYPE = "ecore::EJavaObject";
    public static final String DEFAULT_NEW_QUERY_RETURN_TYPE = "String";
    public static final String DEFAULT_NEW_QUERY_BODY = "myParameter.toString()";
    public static final VisibilityKind DEFAULT_NEW_TEMPLATE_VISIBILITY = VisibilityKind.PUBLIC;
    public static final String DEFAULT_NEW_TEMPLATE_NAME = "myTemplate";
    public static final String DEFAULT_NEW_TEMPLATE_PARAMETER_NAME = "myParameter";
    public static final String DEFAULT_NEW_TEMPLATE_PARAMETER_TYPE = "MyParameterType";
    public static final String DEFAULT_NEW_TEMPLATE_BODY = "My template with a static text.";
    public static final String DEFAULT_NEW_COMMENT_BODY = "My comment.";
    public static final String DEFAULT_NEW_MODULE_DOCUMENTATION_BODY = "My module documentation.";
    public static final String DEFAULT_NEW_MODULE_DOCUMENTATION_AUTHOR = System.getProperty("user.name");
    public static final String DEFAULT_NEW_MODULE_DOCUMENTATION_VERSION = "0.0.1";
    public static final String DEFAULT_NEW_MODULE_DOCUMENTATION_SINCE = "0.0.1";
    public static final String DEFAULT_NEW_MODULE_ELEMENT_DOCUMENTATION_BODY = "My Query or Template documentation.";
    public static final String DEFAULT_NEW_MODULE_ELEMENT_DOCUMENTATION_PARAM_BODY = "the parameter.";
    public static final String DEFAULT_NEW_IMPORT_BODY = "imported::qualified::name";
    public static final String DEFAULT_NEW_MODULE_NSURI = "http://www.eclipse.org/emf/2002/Ecore";
    public static final String DEFAULT_NEW_BINDING_VARIABLE_NAME = "myVariable";
    public static final String DEFAULT_NEW_BINDING_VARIABLE_TYPE = "String";
    public static final String NEW_QUERY = "[query " + String.valueOf((Object)DEFAULT_NEW_QUERY_VISIBILITY) + " myQuery(myParameter : ecore::EJavaObject) : String = myParameter.toString()/]";
    public static final String NEW_COMMENT = "[comment My comment./]";
    public static final String NEW_COMMENT_MAIN = "[comment @main/]";
    private final String newLine;
    public static final String NEW_IMPORT = "[import imported::qualified::name/]";

    public AcceleoCodeTemplates(String newLine) {
        this.newLine = newLine;
    }

    public String newTemplate() {
        return "[template " + String.valueOf((Object)DEFAULT_NEW_TEMPLATE_VISIBILITY) + " myTemplate(myParameter : MyParameterType)]" + this.newLine + "\tMy template with a static text." + this.newLine + "[/template]";
    }

    public String newBlockComment() {
        return "[comment]" + this.newLine + DEFAULT_NEW_COMMENT_BODY + this.newLine + "[/comment]";
    }

    public String newForStatement() {
        return "[for (myVariable | expression)]" + this.newLine + "  " + this.newLine + "[/for]";
    }

    public String newIfStatement() {
        return "[if (expression)]" + this.newLine + "  " + this.newLine + "[/if]";
    }

    public String newFileStatement() {
        return "[file (expression, " + OpenModeKind.OVERWRITE.getName() + ", 'UTF-8')]" + this.newLine + "  " + this.newLine + "[/file]";
    }

    public String newProtectedAreaStatement() {
        return "[protected (expression)]" + this.newLine + "  " + this.newLine + "[/protected]";
    }

    public String newLetStatement() {
        return "[let myVariable = expression]" + this.newLine + "  " + this.newLine + "[/let]";
    }

    public String newModuleDocumentation() {
        return "[**" + this.newLine + " * My module documentation." + this.newLine + " * " + this.newLine + " * @author " + DEFAULT_NEW_MODULE_DOCUMENTATION_AUTHOR + this.newLine + " * @version 0.0.1" + this.newLine + " * @since 0.0.1" + this.newLine + "*/]";
    }

    public String newModuleElementDocumentation() {
        return "[**" + this.newLine + " * My Query or Template documentation." + this.newLine + " * " + this.newLine + " * @param myParameter the parameter." + this.newLine + "*/]";
    }

    public static String getModuleCodeTemplate(String computedTemplateName) {
        return "[module " + computedTemplateName + "('http://www.eclipse.org/emf/2002/Ecore')/]";
    }
}

