/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.aql.migration.tests.utils;

import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import org.eclipse.acceleo.AcceleoASTNode;
import org.eclipse.acceleo.Module;
import org.eclipse.acceleo.aql.AcceleoUtil;
import org.eclipse.acceleo.aql.migration.IModuleResolver;
import org.eclipse.acceleo.aql.migration.ModuleMigrator;
import org.eclipse.acceleo.aql.parser.AcceleoAstSerializer;
import org.eclipse.acceleo.tests.utils.AbstractLanguageTestSuite;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public abstract class AbstractMigrationTestSuite {
    public static final String UTF_8 = "UTF-8";
    private static final ModuleMigrator MODULE_MIGRATOR = new ModuleMigrator(new IModuleResolver(){

        public String getQualifiedName(org.eclipse.acceleo.model.mtl.Module module, org.eclipse.acceleo.model.mtl.Module refModule) {
            String moduleUri = EcoreUtil.getURI((EObject)refModule).toString();
            String qualifiedName = moduleUri.substring(moduleUri.indexOf("misc/"), moduleUri.lastIndexOf("#")).replaceAll("/", "::").replaceAll(".emtl", "");
            return qualifiedName;
        }
    }, null);
    protected final File testFolder;
    private final Module module;
    private String moduleContent;

    public AbstractMigrationTestSuite(String testFolderPath) throws IOException {
        this.testFolder = new File(testFolderPath);
        String newLine = "\n";
        this.module = MODULE_MIGRATOR.migrate(this.getFile(".emtl"), this.getFile("-origin.mtl"), "\n");
        try {
            this.moduleContent = new AcceleoAstSerializer("\n").serialize((AcceleoASTNode)this.module);
        }
        catch (Exception e) {
            System.err.println("Serialization issue:");
            e.printStackTrace();
        }
    }

    @Test
    public void migrate() throws FileNotFoundException, IOException {
        File actualMTLFile = this.getFile(".mtl");
        if (!actualMTLFile.exists()) {
            actualMTLFile.createNewFile();
        }
        AbstractLanguageTestSuite.setContent((OutputStream)new FileOutputStream(actualMTLFile), (String)UTF_8, (String)this.moduleContent);
        File expectedMTLFile = AbstractMigrationTestSuite.getFile(this.testFolder, "-expected.mtl");
        if (!expectedMTLFile.exists()) {
            Assert.fail((String)"Expected migrated MTL file doesn't exist.");
        }
        Throwable throwable = null;
        Object var4_5 = null;
        try (FileInputStream stream = new FileInputStream(expectedMTLFile);){
            String expectedMtl = AcceleoUtil.getContent((InputStream)stream, (String)UTF_8);
            stream.close();
            Assert.assertEquals((Object)expectedMtl, (Object)this.moduleContent);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private File getFile(String extension) {
        return AbstractMigrationTestSuite.getFile(this.testFolder, extension);
    }

    private static File getFile(File folder, String extension) {
        return new File(String.valueOf(folder) + File.separator + folder.getName() + extension);
    }

    protected static Collection<Object[]> retrieveTestFolders(String folderPath, final String ... excludedTests) {
        ArrayList<Object[]> parameters = new ArrayList<Object[]>();
        File folder = new File(folderPath);
        Object[] children = folder.listFiles(new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                boolean res = pathname.isDirectory() && pathname.canRead() && !Arrays.asList(excludedTests).contains(pathname.getName()) ? AbstractMigrationTestSuite.getFile(pathname, ".emtl").exists() : false;
                return res;
            }
        });
        Arrays.sort(children);
        Object[] objectArray = children;
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            Object child = objectArray[n2];
            parameters.add(new Object[]{((File)child).getPath()});
            ++n2;
        }
        return parameters;
    }
}

