/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.query.sirius.services.configurator;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.acceleo.query.runtime.IReadOnlyQueryEnvironment;
import org.eclipse.acceleo.query.services.configurator.IResourceSetConfigurator;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectNature;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.sirius.business.api.modelingproject.ModelingProject;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.business.api.session.SessionManager;
import org.eclipse.sirius.business.internal.session.SessionTransientAttachment;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class SiriusResourceSetConfigurator
implements IResourceSetConfigurator {
    public static final List<String> OPTIONS = SiriusResourceSetConfigurator.initOptions();
    private final Map<Object, Session> sessions = new HashMap<Object, Session>();
    private final Set<Session> sessionToClose = new HashSet<Session>();
    private final Map<Session, SessionTransientAttachment> transientAttachments = new HashMap<Session, SessionTransientAttachment>();

    private static List<String> initOptions() {
        ArrayList<String> res = new ArrayList<String>();
        res.add("SiriusSession");
        return res;
    }

    public Map<String, String> getInitializedOptions(Map<String, String> options) {
        String baseURIStr;
        String sessionURIStr;
        HashMap<String, String> res = new HashMap<String, String>();
        if (!options.containsKey("SiriusSession") && (sessionURIStr = this.getSessionString(baseURIStr = options.get("BaseURI"))) != null) {
            res.put("SiriusSession", sessionURIStr);
        }
        return res;
    }

    protected String getSessionString(String baseURIStr) {
        URI baseURI;
        String res = baseURIStr != null ? ((baseURI = URI.createURI((String)baseURIStr, (boolean)true)).isPlatformResource() ? this.getSessionFromPlatformResource(baseURI) : null) : null;
        return res;
    }

    private String getSessionFromPlatformResource(URI basePlatformResourceURI) {
        String res;
        String filePath = basePlatformResourceURI.toPlatformString(true);
        IFile baseResource = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(filePath));
        IProject project = baseResource.getProject();
        ModelingProject modelingProject = this.getModelingProject(project);
        if (modelingProject != null) {
            Session session = modelingProject.getSession();
            if (session != null) {
                URI sessionURI = session.getSessionResource().getURI();
                res = URI.decode((String)sessionURI.deresolve(basePlatformResourceURI, false, true, true).toString());
            } else {
                res = this.getSessionFile(basePlatformResourceURI, (IContainer)project);
            }
        } else {
            res = null;
        }
        return res;
    }

    private String getSessionFile(URI basefPlatformResourceURI, IContainer container) {
        String res = null;
        try {
            IResource[] iResourceArray = container.members();
            int n = iResourceArray.length;
            int n2 = 0;
            while (n2 < n) {
                Session session;
                IResource member = iResourceArray[n2];
                if (member instanceof IContainer) {
                    res = this.getSessionFile(basefPlatformResourceURI, (IContainer)member);
                    if (res != null) {
                        break;
                    }
                } else if (member instanceof IFile && "aird".equals(member.getFileExtension()) && (session = SessionManager.INSTANCE.getSession(URI.createPlatformResourceURI((String)member.getFullPath().toString(), (boolean)true), (IProgressMonitor)new NullProgressMonitor())) != null) {
                    URI sessionURI = session.getSessionResource().getURI();
                    res = URI.decode((String)sessionURI.deresolve(basefPlatformResourceURI, false, true, true).toString());
                    break;
                }
                ++n2;
            }
        }
        catch (CoreException coreException) {
            // empty catch block
        }
        return res;
    }

    private ModelingProject getModelingProject(IProject project) {
        ModelingProject modelingProject = null;
        try {
            String[] stringArray = project.getDescription().getNatureIds();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String natureId = stringArray[n2];
                IProjectNature nature = project.getNature(natureId);
                if (nature instanceof ModelingProject) {
                    modelingProject = (ModelingProject)nature;
                    break;
                }
                ++n2;
            }
        }
        catch (CoreException coreException) {
            // empty catch block
        }
        return modelingProject;
    }

    public List<String> getOptions() {
        return OPTIONS;
    }

    public Map<String, List<Diagnostic>> validate(IReadOnlyQueryEnvironment queryEnvironment, Map<String, String> options) {
        HashMap<String, List<Diagnostic>> res = new HashMap<String, List<Diagnostic>>();
        String sessionURIStr = options.get("SiriusSession");
        if (sessionURIStr != null) {
            URI sessionURI = URI.createURI((String)sessionURIStr, (boolean)false);
            String basefURIStr = options.get("BaseURI");
            if (basefURIStr != null) {
                sessionURI = sessionURI.resolve(URI.createURI((String)basefURIStr, (boolean)false));
            }
            if (!URIConverter.INSTANCE.exists(sessionURI, Collections.emptyMap())) {
                ArrayList<BasicDiagnostic> diagnostics = new ArrayList<BasicDiagnostic>();
                res.put("SiriusSession", diagnostics);
                diagnostics.add(new BasicDiagnostic(4, "org.eclipse.acceleo.query.sirius", 0, "The Sirius session doesn't exist: " + sessionURI.toString(), new Object[]{sessionURI}));
            }
        }
        return res;
    }

    public ResourceSet createResourceSetForModels(Object context, Map<String, String> options) {
        ResourceSet created = null;
        String sessionURIStr = options.get("SiriusSession");
        if (sessionURIStr != null && !sessionURIStr.isEmpty()) {
            URI sessionURI = URI.createURI((String)sessionURIStr, (boolean)false);
            String baseURIStr = options.get("BaseURI");
            if (baseURIStr != null) {
                sessionURI = sessionURI.resolve(URI.createURI((String)baseURIStr));
            }
            if (URIConverter.INSTANCE.exists(sessionURI, Collections.emptyMap())) {
                try {
                    Session session = SessionManager.INSTANCE.getSession(sessionURI, (IProgressMonitor)new NullProgressMonitor());
                    this.sessions.put(context, session);
                    if (!session.isOpen()) {
                        session.open((IProgressMonitor)new NullProgressMonitor());
                        this.sessionToClose.add(session);
                    }
                    created = session.getTransactionalEditingDomain().getResourceSet();
                    SessionTransientAttachment transiantAttachment = new SessionTransientAttachment(session);
                    created.eAdapters().add((Object)transiantAttachment);
                    this.transientAttachments.put(session, transiantAttachment);
                }
                catch (Exception e) {
                    if (PlatformUI.isWorkbenchRunning()) {
                        MessageDialog.openWarning((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)"Unable to open Sirius Session", (String)("Check the SiriusSession option or try to open the session manually by double clicking the .aird file:\n" + e.getMessage()));
                    }
                }
            } else {
                throw new IllegalArgumentException("The Sirius session doesn't exist: " + String.valueOf(sessionURI));
            }
        }
        return created;
    }

    public void cleanResourceSetForModels(Object context) {
        Session session = this.sessions.remove(context);
        if (session != null) {
            if (session.isOpen()) {
                session.getTransactionalEditingDomain().getResourceSet().eAdapters().remove((Object)this.transientAttachments.remove(session));
            }
            if (this.sessionToClose.remove(session)) {
                session.close((IProgressMonitor)new NullProgressMonitor());
            }
        }
    }
}

