/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.aql.ide.ui.module.main;

import java.io.File;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.acceleo.Module;
import org.eclipse.acceleo.Template;
import org.eclipse.acceleo.Variable;
import org.eclipse.acceleo.aql.AcceleoUtil;
import org.eclipse.acceleo.aql.evaluation.AcceleoEvaluator;
import org.eclipse.acceleo.aql.evaluation.GenerationResult;
import org.eclipse.acceleo.aql.evaluation.strategy.DefaultGenerationStrategy;
import org.eclipse.acceleo.aql.evaluation.strategy.IAcceleoGenerationStrategy;
import org.eclipse.acceleo.aql.evaluation.strategy.IWriterFactory;
import org.eclipse.acceleo.aql.ide.evaluation.strategy.AcceleoWorkspaceWriterFactory;
import org.eclipse.acceleo.aql.ide.ui.Activator;
import org.eclipse.acceleo.aql.ide.ui.module.main.AbstractGenerator;
import org.eclipse.acceleo.aql.ide.ui.module.services.Services;
import org.eclipse.acceleo.aql.parser.AcceleoParser;
import org.eclipse.acceleo.aql.parser.ModuleLoader;
import org.eclipse.acceleo.query.ide.QueryPlugin;
import org.eclipse.acceleo.query.runtime.IReadOnlyQueryEnvironment;
import org.eclipse.acceleo.query.runtime.impl.namespace.ClassLoaderQualifiedNameResolver;
import org.eclipse.acceleo.query.runtime.impl.namespace.JavaLoader;
import org.eclipse.acceleo.query.runtime.namespace.ILoader;
import org.eclipse.acceleo.query.runtime.namespace.IQualifiedNameQueryEnvironment;
import org.eclipse.acceleo.query.runtime.namespace.IQualifiedNameResolver;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;

public class EclipseUIProjectGenerator
extends AbstractGenerator {
    private final List<IFile> projectModuleFiles;
    private final String projectUIName;
    private final String destinationFolder;
    protected Set<String> dependencyBundleNames;

    public EclipseUIProjectGenerator(List<IFile> projectModuleFiles) {
        this.projectModuleFiles = projectModuleFiles;
        this.projectUIName = projectModuleFiles.get(0).getProject().getName() + ".ide.ui";
        this.destinationFolder = projectModuleFiles.get(0).getProject().getLocation().toFile().getParentFile().getAbsolutePath();
    }

    private static void registerEPackage(IQualifiedNameQueryEnvironment environment, EPackage ePackage) {
        environment.registerEPackage(ePackage);
        for (EPackage child : ePackage.getESubpackages()) {
            EclipseUIProjectGenerator.registerEPackage(environment, child);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void generate() {
        String moduleQualifiedName = this.getModuleQualifiedName();
        URI targetURI = URI.createFileURI((String)(this.destinationFolder + "/"));
        Map<String, String> options = this.getOptions();
        ArrayList exceptions = new ArrayList();
        ResourceSetImpl resourceSetForModels = new ResourceSetImpl();
        IQualifiedNameResolver resolver = this.createResolver();
        IQualifiedNameQueryEnvironment queryEnvironment = this.createAcceleoQueryEnvironment(options, resolver, (ResourceSet)resourceSetForModels);
        AcceleoEvaluator evaluator = this.createAcceleoEvaluator(resolver, queryEnvironment);
        IAcceleoGenerationStrategy strategy = this.createGenerationStrategy((ResourceSet)resourceSetForModels);
        Module module = (Module)resolver.resolve(moduleQualifiedName);
        Template main = (Template)AcceleoUtil.getMainTemplates((Module)module).iterator().next();
        URI logURI = AcceleoUtil.getlogURI((URI)targetURI, (String)options.get("logURI"));
        IQualifiedNameResolver workspaceResolver = QueryPlugin.getPlugin().createQualifiedNameResolver(this.getClass().getClassLoader(), this.projectModuleFiles.get(0).getProject(), "::", true);
        ArrayList<Module> modelModules = new ArrayList<Module>();
        this.dependencyBundleNames = new LinkedHashSet<String>();
        for (IFile file : this.projectModuleFiles) {
            java.net.URI binaryURI = workspaceResolver.getBinaryURI(file.getLocation().toFile().toURI());
            workspaceResolver.addLoader((ILoader)new ModuleLoader(new AcceleoParser(), null));
            String modelModuleQualifiedName = workspaceResolver.getQualifiedName(binaryURI);
            Module modelModule = (Module)workspaceResolver.resolve(modelModuleQualifiedName);
            modelModules.add(modelModule);
            this.dependencyBundleNames.addAll(this.getDependencyBundleNames(queryEnvironment, modelModule));
        }
        EclipseUIProjectGenerator eclipseUIProjectGenerator = this;
        synchronized (eclipseUIProjectGenerator) {
            this.beforeGeneration(queryEnvironment, workspaceResolver);
            try {
                LinkedHashMap<String, Object> variables = new LinkedHashMap<String, Object>();
                variables.put(((Variable)main.getParameters().get(0)).getName(), modelModules);
                variables.put(((Variable)main.getParameters().get(1)).getName(), this.projectUIName);
                AcceleoUtil.generate((Template)main, variables, (AcceleoEvaluator)evaluator, (IQualifiedNameQueryEnvironment)queryEnvironment, (IAcceleoGenerationStrategy)strategy, (URI)targetURI, (URI)logURI);
            }
            finally {
                AcceleoUtil.cleanServices((IReadOnlyQueryEnvironment)queryEnvironment, (ResourceSet)resourceSetForModels);
                this.printDiagnostics(evaluator.getGenerationResult());
                this.afterGeneration(evaluator.getGenerationResult());
            }
        }
    }

    protected String getModuleQualifiedName() {
        return "org::eclipse::acceleo::aql::ide::ui::module::main::eclipseUIProject";
    }

    protected Map<String, String> getOptions() {
        LinkedHashMap<String, String> res = new LinkedHashMap<String, String>();
        res.put("logURI", "acceleo.log");
        res.put("newLine", System.lineSeparator());
        return res;
    }

    protected IQualifiedNameResolver createResolver() {
        ClassLoaderQualifiedNameResolver resolver = new ClassLoaderQualifiedNameResolver(this.getClass().getClassLoader(), "::");
        return resolver;
    }

    protected IQualifiedNameQueryEnvironment createAcceleoQueryEnvironment(Map<String, String> options, IQualifiedNameResolver resolver, ResourceSet resourceSetForModels) {
        IQualifiedNameQueryEnvironment queryEnvironment = AcceleoUtil.newAcceleoQueryEnvironment(options, (IQualifiedNameResolver)resolver, (ResourceSet)resourceSetForModels, (boolean)false);
        for (String nsURI : new ArrayList(EPackage.Registry.INSTANCE.keySet())) {
            EclipseUIProjectGenerator.registerEPackage(queryEnvironment, EPackage.Registry.INSTANCE.getEPackage(nsURI));
        }
        return queryEnvironment;
    }

    protected AcceleoEvaluator createAcceleoEvaluator(IQualifiedNameResolver resolver, IQualifiedNameQueryEnvironment queryEnvironment) {
        AcceleoEvaluator evaluator = new AcceleoEvaluator(queryEnvironment.getLookupEngine(), System.lineSeparator());
        resolver.addLoader((ILoader)new ModuleLoader(new AcceleoParser(), evaluator));
        resolver.addLoader((ILoader)new JavaLoader("::", false));
        return evaluator;
    }

    protected IAcceleoGenerationStrategy createGenerationStrategy(ResourceSet resourceSetForModels) {
        DefaultGenerationStrategy strategy = new DefaultGenerationStrategy(resourceSetForModels.getURIConverter(), (IWriterFactory)new AcceleoWorkspaceWriterFactory());
        return strategy;
    }

    protected void beforeGeneration(IQualifiedNameQueryEnvironment queryEnvironment, IQualifiedNameResolver workspaceResolver) {
        Services.initialize(queryEnvironment, workspaceResolver);
    }

    protected void printDiagnostics(GenerationResult generationResult) {
        if (generationResult.getDiagnostic().getSeverity() > 1) {
            this.printDiagnostic(generationResult.getDiagnostic());
        }
        this.printSummary(generationResult);
    }

    protected void printDiagnostic(Diagnostic diagnostic) {
        if (diagnostic.getMessage() != null) {
            switch (diagnostic.getSeverity()) {
                case 1: {
                    Activator.getDefault().getLog().log((IStatus)new Status(1, diagnostic.getSource(), diagnostic.getMessage(), diagnostic.getException()));
                    break;
                }
                case 2: {
                    Activator.getDefault().getLog().log((IStatus)new Status(2, diagnostic.getSource(), diagnostic.getMessage(), diagnostic.getException()));
                    break;
                }
                case 4: {
                    Activator.getDefault().getLog().log((IStatus)new Status(4, diagnostic.getSource(), diagnostic.getMessage(), diagnostic.getException()));
                }
            }
        }
        for (Diagnostic child : diagnostic.getChildren()) {
            this.printDiagnostic(child);
        }
    }

    protected void printSummary(GenerationResult result) {
        int nbErrors = 0;
        int nbWarnings = 0;
        int nbInfos = 0;
        for (Diagnostic diagnostic : result.getDiagnostic().getChildren()) {
            switch (diagnostic.getSeverity()) {
                case 4: {
                    ++nbErrors;
                    break;
                }
                case 2: {
                    ++nbWarnings;
                    break;
                }
                case 1: {
                    ++nbInfos;
                    break;
                }
            }
        }
        String message = "Files: " + result.getGeneratedFiles().size() + ", Lost Files: " + result.getLostFiles().size() + ", Errors: " + nbErrors + ", Warnings: " + nbWarnings + ", Infos: " + nbInfos + ".";
        Activator.getDefault().getLog().log((IStatus)new Status(1, this.getClass(), message));
    }

    protected void afterGeneration(GenerationResult generationResult) {
        Services.initialize(null, null);
        IProject existingProject = ResourcesPlugin.getWorkspace().getRoot().getProject(this.projectUIName);
        if (existingProject != null && existingProject.exists()) {
            if (existingProject.isOpen()) {
                try {
                    existingProject.getParent().refreshLocal(2, (IProgressMonitor)new NullProgressMonitor());
                }
                catch (CoreException e) {
                    Activator.getDefault().getLog().log((IStatus)new Status(4, this.getClass(), "could not refresh " + String.valueOf(existingProject.getParent().getFullPath()), (Throwable)e));
                }
            }
        } else {
            String projectUIAbsolutePath = this.destinationFolder + File.separatorChar + this.projectUIName;
            try {
                String projectFilePath = projectUIAbsolutePath + File.separatorChar + ".project";
                IProjectDescription description = ResourcesPlugin.getWorkspace().loadProjectDescription((IPath)new Path(projectFilePath));
                IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(description.getName());
                project.create(description, null);
                project.open(null);
                this.addPluginDependencies(project, this.dependencyBundleNames);
            }
            catch (CoreException e) {
                Activator.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.acceleo.aql.ide.ui", "couldn't import project " + projectUIAbsolutePath, (Throwable)e));
            }
        }
    }
}

