/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.tests.parser;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.acceleo.AcceleoASTNode;
import org.eclipse.acceleo.aql.AcceleoUtil;
import org.eclipse.acceleo.aql.parser.AcceleoAstResult;
import org.eclipse.acceleo.aql.parser.AcceleoAstSerializer;
import org.eclipse.acceleo.aql.parser.AcceleoParser;
import org.eclipse.acceleo.tests.utils.AbstractLanguageTestSuite;
import org.eclipse.emf.codegen.ecore.genmodel.GenModelPackage;
import org.eclipse.emf.ecore.EcorePackage;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class AcceleoAstSerializerTests {
    private static final String ROOT = "resources";
    private final AcceleoAstResult ast;
    private final String source;
    private String modulePath;

    public AcceleoAstSerializerTests(String modulePath) throws FileNotFoundException, IOException {
        String encoding;
        FileInputStream stream;
        this.modulePath = modulePath;
        EcorePackage.eINSTANCE.getName();
        GenModelPackage.eINSTANCE.getName();
        AcceleoParser parser = new AcceleoParser();
        Throwable throwable = null;
        Object var5_6 = null;
        try {
            stream = new FileInputStream(ROOT + File.separator + modulePath);
            try {
                encoding = parser.parseEncoding((InputStream)stream);
            }
            finally {
                if (stream != null) {
                    ((InputStream)stream).close();
                }
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        throwable = null;
        var5_6 = null;
        try {
            stream = new FileInputStream(ROOT + File.separator + modulePath);
            try {
                this.source = AcceleoUtil.getContent((InputStream)stream, (String)encoding);
                this.ast = parser.parse(this.source, encoding, "org::eclipse::acceleo::tests::test");
            }
            finally {
                if (stream != null) {
                    ((InputStream)stream).close();
                }
            }
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
            } else if (throwable != throwable3) {
                throwable.addSuppressed(throwable3);
            }
            throw throwable;
        }
    }

    @Test
    public void serialize() throws FileNotFoundException, IOException {
        AcceleoAstSerializer serializer = new AcceleoAstSerializer("\n");
        String actualSerializedModule = serializer.serialize((AcceleoASTNode)this.ast.getModule());
        File expectedSerializedFile = new File(ROOT + File.separator + "serialization" + File.separator + this.modulePath + "-expected.txt");
        this.createActualFileIfNeeded(actualSerializedModule, this.ast.getModule().getEncoding(), expectedSerializedFile);
        Throwable throwable = null;
        Object var5_6 = null;
        try (FileInputStream stream = new FileInputStream(expectedSerializedFile);){
            String expectedSerializedModule = AcceleoUtil.getContent((InputStream)stream, (String)this.ast.getModule().getEncoding());
            Assert.assertEquals((Object)expectedSerializedModule, (Object)actualSerializedModule);
            stream.close();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private void createActualFileIfNeeded(String actualSerializedModule, String encoding, File expectedSerializedFile) throws IOException, UnsupportedEncodingException, FileNotFoundException {
        if (!expectedSerializedFile.exists()) {
            File actualSerializedFile = new File(ROOT + File.separator + "serialization" + File.separator + this.modulePath + "-actual.txt");
            if (!actualSerializedFile.exists()) {
                File parentFile = actualSerializedFile.getParentFile();
                if (!parentFile.exists()) {
                    parentFile.mkdirs();
                }
                actualSerializedFile.createNewFile();
            }
            AbstractLanguageTestSuite.setContent(new FileOutputStream(actualSerializedFile), encoding, actualSerializedModule);
            Assert.fail((String)"file doesn't exist.");
        }
    }

    @Parameterized.Parameters(name="{0}")
    public static Collection<Object[]> retrieveTests() {
        ArrayList<Object[]> res = new ArrayList<Object[]>();
        ArrayList<String> modules = new ArrayList<String>();
        File root = new File(ROOT);
        modules.addAll(AcceleoAstSerializerTests.findModuleFiles(root));
        Path currentPath = new File(ROOT).toPath().toAbsolutePath();
        for (String module : modules) {
            Path relativePath = currentPath.relativize(new File(module).toPath().toAbsolutePath());
            res.add(new Object[]{relativePath.toString()});
        }
        return res;
    }

    private static List<String> findModuleFiles(File root) {
        ArrayList<String> res = new ArrayList<String>();
        File[] fileArray = root.listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File child = fileArray[n2];
            if (child.isFile()) {
                if (child.getName().endsWith(".mtl")) {
                    res.add(child.getAbsolutePath());
                }
            } else {
                res.addAll(AcceleoAstSerializerTests.findModuleFiles(child));
            }
            ++n2;
        }
        return res;
    }
}

