/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.tests.completion;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.acceleo.Module;
import org.eclipse.acceleo.aql.AcceleoUtil;
import org.eclipse.acceleo.aql.completion.AcceleoCompletor;
import org.eclipse.acceleo.aql.completion.proposals.AcceleoCompletionProposal;
import org.eclipse.acceleo.aql.evaluation.AcceleoEvaluator;
import org.eclipse.acceleo.aql.parser.AcceleoAstResult;
import org.eclipse.acceleo.aql.parser.AcceleoParser;
import org.eclipse.acceleo.aql.parser.ModuleLoader;
import org.eclipse.acceleo.query.AQLUtils;
import org.eclipse.acceleo.query.runtime.IReadOnlyQueryEnvironment;
import org.eclipse.acceleo.query.runtime.impl.namespace.ClassLoaderQualifiedNameResolver;
import org.eclipse.acceleo.query.runtime.impl.namespace.JavaLoader;
import org.eclipse.acceleo.query.runtime.namespace.ILoader;
import org.eclipse.acceleo.query.runtime.namespace.IQualifiedNameQueryEnvironment;
import org.eclipse.acceleo.query.runtime.namespace.IQualifiedNameResolver;
import org.eclipse.acceleo.query.services.StringServices;
import org.eclipse.acceleo.tests.utils.AbstractLanguageTestSuite;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class CompletionTests {
    private static final Pattern TEST_PATTERN = Pattern.compile("<<([a-zA-Z0-9_]+)>>");
    private static final String ROOT = "resources" + File.separator + "completion";
    private static final String MODULE_NAME = "completion";
    private static final String MODULE = "resources" + File.separator + "completion" + File.separator + "completion.mtl";
    private final String testName;
    private final String source;
    private final int position;

    public CompletionTests(String testName, String source, Integer position) {
        this.testName = testName;
        this.source = source;
        this.position = position;
    }

    @Test
    public void completion() throws FileNotFoundException, IOException {
        AcceleoCompletor completor = new AcceleoCompletor("\n");
        ClassLoaderQualifiedNameResolver resolver = new ClassLoaderQualifiedNameResolver(this.getClass().getClassLoader(), "::");
        LinkedHashMap options = new LinkedHashMap();
        ArrayList exceptions = new ArrayList();
        ResourceSet resourceSetForModels = AQLUtils.createResourceSetForModels(exceptions, (Object)resolver, (ResourceSet)new ResourceSetImpl(), options);
        IQualifiedNameQueryEnvironment queryEnvironment = AcceleoUtil.newAcceleoQueryEnvironment(options, (IQualifiedNameResolver)resolver, (ResourceSet)resourceSetForModels, (boolean)true);
        try {
            Throwable throwable;
            String newLine = options.getOrDefault("newLine", System.lineSeparator());
            AcceleoEvaluator evaluator = new AcceleoEvaluator(queryEnvironment.getLookupEngine(), newLine);
            AcceleoParser parser = new AcceleoParser();
            resolver.addLoader((ILoader)new ModuleLoader(parser, evaluator));
            resolver.addLoader((ILoader)new JavaLoader("::", true));
            AcceleoAstResult parsingResult = parser.parse(this.source, null, "org::eclipse::acceleo::tests::");
            Module module = parsingResult.getModule();
            resolver.register("org::eclipse::acceleo::tests::completion", (Object)module);
            List completionProposals = completor.getProposals(queryEnvironment, MODULE_NAME, this.source, this.position);
            String actualCompletion = this.serialize(completionProposals);
            File expectedCompletionFile = this.getExpectedCompletionFile();
            if (!expectedCompletionFile.exists()) {
                File actualCompletionFile = this.getActualCompletionFile();
                if (!actualCompletionFile.exists()) {
                    actualCompletionFile.createNewFile();
                }
                throwable = null;
                Object var17_20 = null;
                try (FileOutputStream stream = new FileOutputStream(actualCompletionFile);){
                    AbstractLanguageTestSuite.setContent(stream, "UTF-8", actualCompletion);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                Assert.fail((String)"file doesn't exist.");
            }
            Throwable throwable3 = null;
            throwable = null;
            try (FileInputStream stream = new FileInputStream(expectedCompletionFile);){
                String expectedCompletion = AcceleoUtil.getContent((InputStream)stream, (String)"UTF-8");
                Assert.assertEquals((Object)this.getPortableString(expectedCompletion), (Object)this.getPortableString(actualCompletion));
            }
            catch (Throwable throwable4) {
                if (throwable3 == null) {
                    throwable3 = throwable4;
                } else if (throwable3 != throwable4) {
                    throwable3.addSuppressed(throwable4);
                }
                throw throwable3;
            }
        }
        finally {
            AQLUtils.cleanResourceSetForModels((Object)resolver, (ResourceSet)resourceSetForModels);
            AcceleoUtil.cleanServices((IReadOnlyQueryEnvironment)queryEnvironment, (ResourceSet)resourceSetForModels);
        }
    }

    private String getPortableString(String textContent) {
        String res = textContent.replaceAll("@author [a-zA-Z0-9-_ ]+", "@author ...");
        return res;
    }

    private String serialize(List<AcceleoCompletionProposal> proposals) {
        StringBuilder builder = new StringBuilder();
        for (AcceleoCompletionProposal proposal : proposals) {
            builder.append("* Label:\n");
            builder.append(proposal.getLabel());
            builder.append('\n');
            builder.append("* Description:\n");
            builder.append(proposal.getDescription());
            builder.append('\n');
            builder.append("* Text:\n");
            builder.append(proposal.getText());
            builder.append('\n');
            builder.append("* Type (optional):\n");
            String typeAsString = "null";
            if (proposal.getAcceleoType() != null) {
                typeAsString = EcoreUtil.getURI((EObject)proposal.getAcceleoType()).toString();
            }
            builder.append(typeAsString);
            builder.append('\n');
            builder.append('\n');
        }
        return StringServices.NEW_LINE_PATTERN.matcher(builder.toString()).replaceAll(Character.toString('\n'));
    }

    protected File getExpectedCompletionFile() {
        return new File(ROOT + File.separator + this.testName + "-expected-completion.txt");
    }

    protected File getActualCompletionFile() {
        return new File(ROOT + File.separator + this.testName + "-actual-completion.txt");
    }

    @Parameterized.Parameters(name="{0}")
    public static Collection<Object[]> retrieveTests() throws FileNotFoundException, IOException {
        ArrayList<Object[]> res = new ArrayList<Object[]>();
        TreeMap<String, Integer> testToPosition = new TreeMap<String, Integer>();
        StringBuilder builder = new StringBuilder();
        Throwable throwable = null;
        Object var4_5 = null;
        try (FileInputStream stream = new FileInputStream(MODULE);){
            String content = AcceleoUtil.getContent((InputStream)stream, (String)"UTF-8");
            Matcher matcher = TEST_PATTERN.matcher(content);
            int lastMatchEnd = 0;
            while (matcher.find()) {
                builder.append(content.substring(lastMatchEnd, matcher.start()));
                lastMatchEnd = matcher.end();
                testToPosition.put(matcher.group(1), builder.length());
            }
            builder.append(content.substring(lastMatchEnd, content.length()));
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        String source = builder.toString();
        for (Map.Entry entry : testToPosition.entrySet()) {
            res.add(new Object[]{entry.getKey(), source, entry.getValue()});
        }
        return res;
    }
}

