/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.util;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.ui.util.ProjectFactory;
import org.eclipse.xtext.xbase.lib.StringExtensions;

public class FeatureProjectFactory
extends ProjectFactory {
    private static String MANIFEST_FILENAME = "feature.xml";
    private static String CATEGORY_FILE_NAME = "category.xml";
    private static String BUILD_PROPS_FILE_NAME = "build.properties";
    private static String SOURCE_FEAT_ENDING = ".source";
    private static String FEAT_ENDING = ".feature";
    private List<String> containedBundles = new ArrayList<String>();
    private List<String> includedFeatures = new ArrayList<String>();
    private String mainCategoryName;
    private String featureLabel;

    public void setFeatureLabel(String label) {
        this.featureLabel = label;
    }

    public FeatureProjectFactory addBundle(String bundleId) {
        this.containedBundles.add(bundleId);
        return this;
    }

    public FeatureProjectFactory addFeature(String featureId) {
        this.includedFeatures.add(featureId);
        return this;
    }

    public FeatureProjectFactory withCategoryFile(String mainCategoryName) {
        this.mainCategoryName = mainCategoryName;
        return this;
    }

    @Override
    protected void enhanceProject(IProject project, SubMonitor subMonitor, Shell shell) throws CoreException {
        boolean _not;
        super.enhanceProject(project, subMonitor, shell);
        this.createManifest(project, (IProgressMonitor)subMonitor.newChild(1));
        this.createBuildProperties(project, (IProgressMonitor)subMonitor.newChild(1));
        boolean _isNullOrEmpty = StringExtensions.isNullOrEmpty((String)this.mainCategoryName);
        boolean bl = _not = !_isNullOrEmpty;
        if (_not) {
            this.createCategoryFile(project, this.mainCategoryName, (IProgressMonitor)subMonitor.newChild(1));
        }
    }

    private void createBuildProperties(IProject project, IProgressMonitor monitor) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("bin.includes =");
        _builder.append(MANIFEST_FILENAME);
        _builder.newLineIfNotEmpty();
        this.writeToFile((CharSequence)_builder, BUILD_PROPS_FILE_NAME, project, monitor);
    }

    private void createManifest(IProject project, IProgressMonitor monitor) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        _builder.newLine();
        _builder.append("<feature id=\"");
        _builder.append(this.projectName);
        _builder.append("\"");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("label=\"");
        String _xifexpression = null;
        boolean _isNullOrEmpty = StringExtensions.isNullOrEmpty((String)this.featureLabel);
        boolean _not = !_isNullOrEmpty;
        _xifexpression = _not ? this.featureLabel : String.valueOf(this.projectName) + " Feature";
        _builder.append(_xifexpression, "\t");
        _builder.append("\"");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("version=\"1.0.0.qualifier\">");
        _builder.newLine();
        for (String includedFeature : this.includedFeatures) {
            _builder.append("\t");
            _builder.append("<includes");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("\t");
            _builder.append("id=\"");
            _builder.append(includedFeature, "\t\t");
            _builder.append("\"");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("\t");
            _builder.append("version=\"0.0.0\"/>");
            _builder.newLine();
        }
        for (String containedBundle : this.containedBundles) {
            _builder.append("\t");
            _builder.append("<plugin");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("\t\t");
            _builder.append("id=\"");
            _builder.append(containedBundle, "\t\t\t");
            _builder.append("\"");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("\t\t");
            _builder.append("download-size=\"0\"");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("\t\t");
            _builder.append("install-size=\"0\"");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("\t\t");
            _builder.append("version=\"0.0.0\"");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("\t\t");
            _builder.append("unpack=\"false\"/>");
            _builder.newLine();
        }
        _builder.append("</feature>");
        _builder.newLine();
        this.writeToFile((CharSequence)_builder, MANIFEST_FILENAME, project, monitor);
    }

    private void createCategoryFile(IProject project, String categoryName, IProgressMonitor monitor) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        _builder.newLine();
        _builder.append("<site>");
        _builder.newLine();
        for (String includedFeature : this.includedFeatures) {
            _builder.append("\t");
            _builder.append("<feature id=\"");
            _builder.append(includedFeature, "\t");
            _builder.append("\" version=\"0.0.0\">");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("\t");
            _builder.append("<category name=\"main\"/>");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("</feature>");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("<feature id=\"");
            String _sourceFeatureName = null;
            if (includedFeature != null) {
                _sourceFeatureName = this.sourceFeatureName(includedFeature);
            }
            _builder.append(_sourceFeatureName, "\t");
            _builder.append("\" version=\"0.0.0\">");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("\t");
            _builder.append("<category name=\"main.source\"/>");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("</feature>");
            _builder.newLine();
        }
        _builder.append("   ");
        _builder.append("<category-def name=\"main\" label=\"");
        _builder.append(categoryName, "   ");
        _builder.append("\"/>");
        _builder.newLineIfNotEmpty();
        _builder.append("   ");
        _builder.append("<category-def name=\"main.source\" label=\"Source for ");
        _builder.append(categoryName, "   ");
        _builder.append("\"/>");
        _builder.newLineIfNotEmpty();
        _builder.append("</site>");
        _builder.newLine();
        this.writeToFile((CharSequence)_builder, CATEGORY_FILE_NAME, project, monitor);
    }

    private String sourceFeatureName(String featureId) {
        String _xblockexpression = null;
        boolean _endsWith = featureId.endsWith(FEAT_ENDING);
        if (_endsWith) {
            return featureId.replaceAll("\\" + FEAT_ENDING + "$", String.valueOf(SOURCE_FEAT_ENDING) + FEAT_ENDING);
        }
        _xblockexpression = String.valueOf(featureId) + SOURCE_FEAT_ENDING;
        return _xblockexpression;
    }
}

