/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.editor.utils;

import org.apache.log4j.Logger;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IStorage;
import org.eclipse.jdt.core.IJarEntryResource;
import org.eclipse.jdt.internal.ui.javaeditor.JarEntryEditorInput;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.resource.DataFormatException;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.StringConverter;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.xtext.ui.editor.XtextEditor;
import org.eclipse.xtext.ui.editor.XtextReadonlyEditorInput;

public class EditorUtils {
    private static final Logger log = Logger.getLogger(EditorUtils.class);

    public static Font fontFromFontData(FontData[] fontDataArray) {
        if (fontDataArray != null && fontDataArray.length > 0) {
            String fontData = PreferenceConverter.getStoredRepresentation((FontData[])fontDataArray);
            if (!JFaceResources.getFontRegistry().hasValueFor(fontData)) {
                FontData[] fData = PreferenceConverter.basicGetFontData((String)fontData);
                JFaceResources.getFontRegistry().put(fontData, fData);
            }
            Font font = JFaceResources.getFontRegistry().get(fontData);
            return font;
        }
        return null;
    }

    public static Color colorFromString(String rgbString) {
        if (rgbString != null && rgbString.trim().length() > 0) {
            Color col = JFaceResources.getColorRegistry().get(rgbString);
            try {
                if (col == null) {
                    RGB rgb = StringConverter.asRGB((String)rgbString);
                    JFaceResources.getColorRegistry().put(rgbString, rgb);
                    col = JFaceResources.getColorRegistry().get(rgbString);
                }
            }
            catch (DataFormatException e) {
                log.error((Object)("Corrupt color value: " + rgbString), (Throwable)e);
            }
            return col;
        }
        return null;
    }

    public static Color colorFromRGB(RGB rgb) {
        if (rgb == null) {
            return null;
        }
        return EditorUtils.colorFromString(StringConverter.asString((RGB)rgb));
    }

    public static XtextEditor getActiveXtextEditor(ExecutionEvent event) {
        IEditorPart activeEditor = HandlerUtil.getActiveEditor((ExecutionEvent)event);
        if (activeEditor == null) {
            return null;
        }
        XtextEditor xtextEditor = (XtextEditor)activeEditor.getAdapter(XtextEditor.class);
        return xtextEditor;
    }

    public static XtextEditor getActiveXtextEditor() {
        IWorkbench workbench = PlatformUI.getWorkbench();
        IWorkbenchWindow workbenchWindow = workbench.getActiveWorkbenchWindow();
        if (workbenchWindow == null) {
            return null;
        }
        IWorkbenchPage activePage = workbenchWindow.getActivePage();
        if (activePage == null) {
            return null;
        }
        IEditorPart activeEditor = activePage.getActiveEditor();
        if (activeEditor == null) {
            return null;
        }
        XtextEditor xtextEditor = (XtextEditor)activeEditor.getAdapter(XtextEditor.class);
        return xtextEditor;
    }

    public static XtextEditor getXtextEditor(IEditorPart openEditor) {
        if (openEditor != null) {
            return (XtextEditor)openEditor.getAdapter(XtextEditor.class);
        }
        return null;
    }

    public static IEditorInput createEditorInput(IStorage storage) {
        if (storage instanceof IFile) {
            return new FileEditorInput((IFile)storage);
        }
        try {
            if (storage instanceof IJarEntryResource) {
                return new JarEntryEditorInput(storage);
            }
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            // empty catch block
        }
        return new XtextReadonlyEditorInput(storage);
    }
}

