/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.editor.outline.actions;

import com.google.inject.Inject;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.xtext.ui.XtextUIMessages;
import org.eclipse.xtext.ui.editor.outline.IOutlineNode;
import org.eclipse.xtext.ui.editor.outline.actions.AbstractToggleOutlineContribution;
import org.eclipse.xtext.ui.editor.outline.impl.OutlineFilterAndSorter;
import org.eclipse.xtext.ui.editor.outline.impl.OutlinePage;
import org.eclipse.xtext.ui.editor.preferences.IPreferenceStoreAccess;
import org.eclipse.xtext.ui.internal.XtextPluginImages;

public class SortOutlineContribution
extends AbstractToggleOutlineContribution {
    public static final String PREFERENCE_KEY = "ui.outline.sort2";
    private TreeViewer treeViewer;
    private OutlineFilterAndSorter outlineFilterAndSorter;
    @Inject
    private OutlineFilterAndSorter.IComparator comparator;

    @Override
    public String getPreferenceKey() {
        return PREFERENCE_KEY;
    }

    @Override
    protected void stateChanged(boolean newState) {
        if (this.treeViewer != null && !this.treeViewer.getTree().isDisposed()) {
            this.treeViewer.getControl().setRedraw(false);
            try {
                this.treeViewer.refresh();
            }
            finally {
                this.treeViewer.getControl().setRedraw(true);
            }
        }
    }

    @Override
    protected void configureAction(Action action) {
        action.setText(XtextUIMessages.LexicalSortingAction_label);
        action.setToolTipText(XtextUIMessages.LexicalSortingAction_tooltip);
        action.setDescription(XtextUIMessages.LexicalSortingAction_description);
        action.setImageDescriptor(XtextPluginImages.DESC_ALPHAB_SORT_CO);
        action.setDisabledImageDescriptor(XtextPluginImages.DESC_ALPHAB_SORT_CO_DISABLED);
    }

    @Override
    public void register(OutlinePage outlinePage) {
        super.register(outlinePage);
        this.outlineFilterAndSorter = outlinePage.getFilterAndSorter();
        this.treeViewer = outlinePage.getTreeViewer();
        this.outlineFilterAndSorter.setComparator(this.comparator);
    }

    @Override
    public void deregister(OutlinePage outlinePage) {
        this.outlineFilterAndSorter = null;
        this.treeViewer = null;
        super.deregister(outlinePage);
    }

    public static class DefaultComparator
    implements OutlineFilterAndSorter.IComparator {
        @Inject
        private IPreferenceStoreAccess preferenceStoreAccess;

        @Override
        public int compare(IOutlineNode o1, IOutlineNode o2) {
            int category2;
            int category1 = this.getCategory(o1);
            if (category1 != (category2 = this.getCategory(o2))) {
                return category1 - category2;
            }
            return o1.getText().toString().compareTo(o2.getText().toString());
        }

        @Override
        public boolean isEnabled() {
            return this.preferenceStoreAccess.getPreferenceStore().getBoolean(SortOutlineContribution.PREFERENCE_KEY);
        }

        public int getCategory(IOutlineNode node) {
            return 0;
        }
    }
}

