/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.editor.hover;

import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationHover;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.xtext.ui.XtextUIMessages;
import org.eclipse.xtext.ui.editor.hover.AbstractProblemHover;

public class ProblemAnnotationHover
extends AbstractProblemHover
implements IAnnotationHover {
    public String getHoverInfo(ISourceViewer sourceViewer, int lineNumber) {
        Object o = this.getHoverInfoInternal((ITextViewer)sourceViewer, lineNumber, -1);
        if (o != null) {
            return o.toString();
        }
        return null;
    }

    protected Region getHoverRegionInternal(int lineNumber, int offset) {
        List<Annotation> annotations = this.getAnnotations(lineNumber, offset);
        for (Annotation annotation : annotations) {
            Position position = this.sourceViewer.getAnnotationModel().getPosition(annotation);
            if (position == null) continue;
            int start = position.getOffset();
            return new Region(start, position.getLength());
        }
        return null;
    }

    @Override
    protected Object getHoverInfoInternal(ITextViewer textViewer, int lineNumber, int offset) {
        LinkedHashSet messages = Sets.newLinkedHashSet();
        List<Annotation> annotations = this.getAnnotations(lineNumber, offset);
        for (Annotation annotation : annotations) {
            String text = annotation.getText();
            if (text == null) continue;
            messages.add(text.trim());
        }
        if (messages.size() > 0) {
            return this.formatInfo(messages);
        }
        return null;
    }

    protected String formatInfo(Collection<String> messages) {
        StringBuilder buffer = new StringBuilder();
        if (messages.size() > 1) {
            buffer.append(XtextUIMessages.AbstractHover_MultipleMarkers);
            Iterator<String> e = messages.iterator();
            while (e.hasNext()) {
                this.splitInfo("- " + e.next() + "\n", buffer);
            }
            buffer.deleteCharAt(buffer.length() - 1);
        } else if (messages.size() == 1) {
            this.splitInfo(messages.iterator().next(), buffer);
        }
        return buffer.toString();
    }

    private String splitInfo(String message, StringBuilder buffer) {
        int pos;
        String msg = message;
        String prefix = "";
        do {
            if ((pos = msg.indexOf(" ", 60)) > -1) {
                buffer.append(String.valueOf(prefix) + msg.substring(0, pos) + "\n");
                msg = msg.substring(pos);
                prefix = "  ";
                continue;
            }
            buffer.append(String.valueOf(prefix) + msg);
        } while (pos > -1);
        return buffer.toString();
    }
}

