/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.util.comm.datatypes;

import java.io.DataInputStream;
import java.util.Calendar;
import java.util.Date;
import org.eclipse.fordiac.ide.util.comm.datatypes.IEC_ANY;
import org.eclipse.fordiac.ide.util.comm.datatypes.IEC_ANY_DATE;
import org.eclipse.fordiac.ide.util.comm.exceptions.DataTypeValueOutOfBoundsException;

public class IEC_DATE_AND_TIME
extends IEC_ANY_DATE {
    public IEC_DATE_AND_TIME() {
        this.value = System.currentTimeMillis();
    }

    public IEC_DATE_AND_TIME(long initial) {
        this.value = initial;
    }

    public IEC_DATE_AND_TIME(Date initial) {
        this.value = initial.getTime();
    }

    public IEC_DATE_AND_TIME(String initial) {
        this.fromString(initial);
    }

    private void fromString(String paValueString) throws DataTypeValueOutOfBoundsException, NumberFormatException {
        String valueString = paValueString.toLowerCase();
        if (!valueString.startsWith("dt#") && !valueString.startsWith("date_and_time#")) {
            throw new DataTypeValueOutOfBoundsException("Illegal value");
        }
        String[] temp = (valueString = valueString.split("#")[1]).split("-");
        if (temp.length != 4) {
            throw new DataTypeValueOutOfBoundsException("Illegal value");
        }
        Calendar c = Calendar.getInstance();
        c.clear();
        c.set(Integer.parseInt(temp[0]), Integer.parseInt(temp[1]) - 1, Integer.parseInt(temp[2]));
        String[] time = temp[3].split(":");
        if (time.length != 3) {
            throw new DataTypeValueOutOfBoundsException("Illegal value");
        }
        c.set(11, Integer.parseInt(time[0]));
        c.set(12, Integer.parseInt(time[1]));
        float seconds = Float.parseFloat(time[2]);
        c.set(13, (int)seconds);
        c.set(14, (int)(seconds - (float)((int)seconds)) * 1000);
        this.value = c.getTimeInMillis();
    }

    public IEC_DATE_AND_TIME(DataInputStream in) {
        super(in);
    }

    @Override
    public byte[] encodeTag() {
        byte[] retval = new byte[]{79};
        return retval;
    }

    @Override
    public boolean setValue(IEC_ANY source) {
        boolean retval = false;
        if (source.getClass().equals(this.getClass())) {
            this.value = ((IEC_DATE_AND_TIME)source).getValue();
            retval = true;
        }
        return retval;
    }

    @Override
    public boolean setValue(String source) {
        try {
            this.fromString(source);
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }
}

