/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.systemimport;

import java.io.File;
import org.eclipse.fordiac.ide.ui.controls.DirectoryChooserControl;
import org.eclipse.fordiac.ide.ui.controls.FileChooserControl;
import org.eclipse.fordiac.ide.ui.controls.IDirectoryChanged;
import org.eclipse.fordiac.ide.ui.controls.IFileChanged;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class IEC61499_2ImportWizardPage
extends WizardPage {
    private DirectoryChooserControl dcc;
    private FileChooserControl fcc;
    private boolean includeDefaultLibrary = false;

    public boolean isIncludeDefaultLibrary() {
        return this.includeDefaultLibrary;
    }

    protected IEC61499_2ImportWizardPage(String pageName) {
        super(pageName);
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setFont(parent.getFont());
        this.initializeDialogUnits((Control)parent);
        composite.setLayout((Layout)new GridLayout());
        composite.setLayoutData((Object)new GridData(1808));
        this.createSysFileSourceGroup(composite);
        this.createLibDirectoryGroup(composite);
        this.setPageComplete(this.validatePage());
        this.setControl((Control)composite);
    }

    private void createLibDirectoryGroup(Composite composite) {
        GridData stretch = new GridData();
        stretch.grabExcessHorizontalSpace = true;
        stretch.horizontalAlignment = 4;
        Label typeDirectory = new Label(composite, 0);
        typeDirectory.setText("Specify the directory with the required FBTypes (e.g. the src directory of FBDK)");
        this.dcc = new DirectoryChooserControl(composite, 0, "Types directory");
        this.dcc.setLayoutData((Object)stretch);
        this.dcc.addDirectoryChangedListener(new IDirectoryChanged(){

            public void directoryChanged(String newDirectory) {
                IEC61499_2ImportWizardPage.this.setPageComplete(IEC61499_2ImportWizardPage.this.validatePage());
            }
        });
    }

    private void createSysFileSourceGroup(Composite composite) {
        GridData strechFcc = new GridData();
        strechFcc.grabExcessHorizontalSpace = true;
        strechFcc.horizontalAlignment = 4;
        Label systemFile = new Label(composite, 0);
        systemFile.setText("Select a *.sys file");
        this.fcc = new FileChooserControl(composite, 0, "System", new String[]{"System"}, new String[]{"*.sys"});
        this.fcc.setLayoutData((Object)strechFcc);
        this.fcc.addFileChangedListener(new IFileChanged(){

            public void fileChanged(String newFile) {
                IEC61499_2ImportWizardPage.this.setPageComplete(IEC61499_2ImportWizardPage.this.validatePage());
            }
        });
    }

    protected boolean validatePage() {
        if (this.fcc.getFile() == null || this.fcc.getFile().equals("")) {
            this.setErrorMessage("No File choosen!");
            return false;
        }
        if (this.dcc.getDirectory() == null || this.dcc.getDirectory().equals("")) {
            this.setErrorMessage("No type directory choosen!");
            return false;
        }
        if (!new File(this.fcc.getFile()).exists()) {
            this.setErrorMessage("The selected File does not exist!");
            return false;
        }
        this.setErrorMessage(null);
        return true;
    }

    public File getSelectedSystemFile() {
        return new File(this.fcc.getFile());
    }

    public String getProjectName() {
        String[] val1 = this.fcc.getFile().split(File.separatorChar == '\\' ? "\\\\" : File.separator);
        String[] val2 = val1[val1.length - 1].split("\\.");
        return val2[0];
    }
}

