/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.monitoring;

import java.lang.reflect.InvocationTargetException;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.EList;
import org.eclipse.fordiac.ide.model.libraryElement.Device;
import org.eclipse.fordiac.ide.model.libraryElement.VarDeclaration;
import org.eclipse.fordiac.ide.model.monitoring.MonitoringBaseElement;
import org.eclipse.fordiac.ide.model.monitoring.MonitoringElement;
import org.eclipse.fordiac.ide.monitoring.DevicePolling;
import org.eclipse.fordiac.ide.monitoring.SystemMonitoringData;
import org.eclipse.fordiac.ide.monitoring.communication.MonitorInformation;
import org.eclipse.fordiac.ide.monitoring.communication.TCPCommunicationObject;
import org.eclipse.fordiac.ide.systemmanagement.Activator;
import org.eclipse.fordiac.ide.systemmanagement.SystemManager;
import org.eclipse.jface.operation.IRunnableWithProgress;

class EnableSystemMonitoringRunnable
implements IRunnableWithProgress {
    private final SystemMonitoringData systemMonitoringData;

    public EnableSystemMonitoringRunnable(SystemMonitoringData systemMonitoringData) {
        this.systemMonitoringData = systemMonitoringData;
    }

    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        EList devices = this.systemMonitoringData.getSystem().getSystemConfiguration().getDevices();
        int count = devices.size() * 2;
        monitor.beginTask("Enable monitoring for system", count += this.systemMonitoringData.getMonitoredElements().size());
        this.connectToDevices((List<Device>)devices, monitor);
        this.addWatches(monitor);
        this.startPollingThreads(monitor);
        monitor.done();
    }

    private void connectToDevices(List<Device> devices, IProgressMonitor monitor) {
        monitor.subTask("Connecting to the devices");
        for (Device dev : devices) {
            if (monitor.isCanceled()) break;
            MonitorInformation monitorInfo = EnableSystemMonitoringRunnable.getMonitoringInfo(dev);
            if (monitorInfo != null) {
                TCPCommunicationObject commObject = this.systemMonitoringData.getCommObject(dev);
                if (commObject == null) {
                    commObject = new TCPCommunicationObject(monitorInfo);
                    this.systemMonitoringData.addCommObject(dev, commObject);
                }
                commObject.enable();
            } else {
                Activator.getDefault().logInfo(String.valueOf(dev.getName()) + " has no monitoring resource.");
            }
            monitor.worked(1);
        }
    }

    private void addWatches(IProgressMonitor monitor) {
        monitor.subTask("Adding the watches");
        for (MonitoringBaseElement element : this.systemMonitoringData.getMonitoredElements()) {
            if (monitor.isCanceled()) break;
            if (!(element instanceof MonitoringElement)) continue;
            monitor.subTask("Add watch for: " + element.getPortString());
            this.systemMonitoringData.sendAddWatch(element);
            monitor.worked(1);
        }
    }

    private void startPollingThreads(IProgressMonitor monitor) {
        monitor.subTask("Enabling the polling threads");
        for (Device dev : this.systemMonitoringData.getSystem().getSystemConfiguration().getDevices()) {
            if (monitor.isCanceled()) break;
            TCPCommunicationObject commObject = this.systemMonitoringData.getCommObject(dev);
            if (commObject != null) {
                DevicePolling t = this.systemMonitoringData.getPollingThread(dev);
                if (t == null) {
                    t = new DevicePolling(this.systemMonitoringData.getSystem(), dev, commObject);
                    this.systemMonitoringData.addPollingThread(dev, t);
                }
                t.setRunning(true);
                t.getThread().start();
            }
            monitor.worked(1);
        }
    }

    private static MonitorInformation getMonitoringInfo(Device dev) {
        for (VarDeclaration varDecl : dev.getVarDeclarations()) {
            if (!varDecl.getName().equalsIgnoreCase("MGR_ID") || varDecl.getValue() == null) continue;
            String val = varDecl.getValue().getValue();
            if (val.startsWith("%")) {
                val = SystemManager.INSTANCE.getReplacedString(dev.getAutomationSystem(), val);
            }
            return new MonitorInformation(val);
        }
        return null;
    }
}

