/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.client.fluent;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.http.entity.AbstractHttpEntity;
import org.apache.http.entity.ContentType;
import org.apache.http.util.Args;

class InternalByteArrayEntity
extends AbstractHttpEntity
implements Cloneable {
    private final byte[] b;
    private final int off;
    private final int len;

    public InternalByteArrayEntity(byte[] b, ContentType contentType) {
        Args.notNull((Object)b, (String)"Source byte array");
        this.b = b;
        this.off = 0;
        this.len = this.b.length;
        if (contentType != null) {
            this.setContentType(contentType.toString());
        }
    }

    public InternalByteArrayEntity(byte[] b, int off, int len, ContentType contentType) {
        Args.notNull((Object)b, (String)"Source byte array");
        if (off < 0 || off > b.length || len < 0 || off + len < 0 || off + len > b.length) {
            throw new IndexOutOfBoundsException("off: " + off + " len: " + len + " b.length: " + b.length);
        }
        this.b = b;
        this.off = off;
        this.len = len;
        if (contentType != null) {
            this.setContentType(contentType.toString());
        }
    }

    public InternalByteArrayEntity(byte[] b) {
        this(b, null);
    }

    public InternalByteArrayEntity(byte[] b, int off, int len) {
        this(b, off, len, null);
    }

    public boolean isRepeatable() {
        return true;
    }

    public long getContentLength() {
        return this.len;
    }

    public InputStream getContent() {
        return new ByteArrayInputStream(this.b, this.off, this.len);
    }

    public void writeTo(OutputStream outstream) throws IOException {
        Args.notNull((Object)outstream, (String)"Output stream");
        outstream.write(this.b, this.off, this.len);
        outstream.flush();
    }

    public boolean isStreaming() {
        return false;
    }
}

