/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSUint8Array.h"

#include "ExceptionCode.h"
#include "JSDOMBinding.h"
#include "JSUint8Array.h"
#include "Uint8Array.h"
#include <runtime/Error.h>
#include <runtime/PropertyNameArray.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

ASSERT_CLASS_FITS_IN_CELL(JSUint8Array);

/* Hash table */
#if ENABLE(JIT)
#define THUNK_GENERATOR(generator) , generator
#else
#define THUNK_GENERATOR(generator)
#endif

static const HashTableValue JSUint8ArrayTableValues[3] =
{
    { "length", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsUint8ArrayLength), (intptr_t)0 THUNK_GENERATOR(0) },
    { "constructor", DontEnum | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsUint8ArrayConstructor), (intptr_t)0 THUNK_GENERATOR(0) },
    { 0, 0, 0, 0 THUNK_GENERATOR(0) }
};

#undef THUNK_GENERATOR
static JSC_CONST_HASHTABLE HashTable JSUint8ArrayTable = { 5, 3, JSUint8ArrayTableValues, 0 };
/* Hash table for constructor */
#if ENABLE(JIT)
#define THUNK_GENERATOR(generator) , generator
#else
#define THUNK_GENERATOR(generator)
#endif

static const HashTableValue JSUint8ArrayConstructorTableValues[2] =
{
    { "BYTES_PER_ELEMENT", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsUint8ArrayBYTES_PER_ELEMENT), (intptr_t)0 THUNK_GENERATOR(0) },
    { 0, 0, 0, 0 THUNK_GENERATOR(0) }
};

#undef THUNK_GENERATOR
static JSC_CONST_HASHTABLE HashTable JSUint8ArrayConstructorTable = { 2, 1, JSUint8ArrayConstructorTableValues, 0 };
const ClassInfo JSUint8ArrayConstructor::s_info = { "Uint8ArrayConstructor", &DOMConstructorObject::s_info, &JSUint8ArrayConstructorTable, 0 };

JSUint8ArrayConstructor::JSUint8ArrayConstructor(ExecState* exec, Structure* structure, JSDOMGlobalObject* globalObject)
    : DOMConstructorObject(structure, globalObject)
{
    ASSERT(inherits(&s_info));
    putDirect(exec->globalData(), exec->propertyNames().prototype, JSUint8ArrayPrototype::self(exec, globalObject), DontDelete | ReadOnly);
}

bool JSUint8ArrayConstructor::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSUint8ArrayConstructor, JSDOMWrapper>(exec, &JSUint8ArrayConstructorTable, this, propertyName, slot);
}

bool JSUint8ArrayConstructor::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSUint8ArrayConstructor, JSDOMWrapper>(exec, &JSUint8ArrayConstructorTable, this, propertyName, descriptor);
}

ConstructType JSUint8ArrayConstructor::getConstructData(ConstructData& constructData)
{
    constructData.native.function = constructJSUint8Array;
    return ConstructTypeHost;
}

/* Hash table for prototype */
#if ENABLE(JIT)
#define THUNK_GENERATOR(generator) , generator
#else
#define THUNK_GENERATOR(generator)
#endif

static const HashTableValue JSUint8ArrayPrototypeTableValues[4] =
{
    { "BYTES_PER_ELEMENT", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsUint8ArrayBYTES_PER_ELEMENT), (intptr_t)0 THUNK_GENERATOR(0) },
    { "subarray", DontDelete | Function, (intptr_t)static_cast<NativeFunction>(jsUint8ArrayPrototypeFunctionSubarray), (intptr_t)2 THUNK_GENERATOR(0) },
    { "set", DontDelete | Function, (intptr_t)static_cast<NativeFunction>(jsUint8ArrayPrototypeFunctionSet), (intptr_t)0 THUNK_GENERATOR(0) },
    { 0, 0, 0, 0 THUNK_GENERATOR(0) }
};

#undef THUNK_GENERATOR
static JSC_CONST_HASHTABLE HashTable JSUint8ArrayPrototypeTable = { 8, 7, JSUint8ArrayPrototypeTableValues, 0 };
static const HashTable* getJSUint8ArrayPrototypeTable(ExecState* exec)
{
    return getHashTableForGlobalData(exec->globalData(), &JSUint8ArrayPrototypeTable);
}

const ClassInfo JSUint8ArrayPrototype::s_info = { "Uint8ArrayPrototype", &JSC::JSObjectWithGlobalObject::s_info, 0, getJSUint8ArrayPrototypeTable };

JSObject* JSUint8ArrayPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSUint8Array>(exec, globalObject);
}

bool JSUint8ArrayPrototype::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticPropertySlot<JSUint8ArrayPrototype, JSObject>(exec, getJSUint8ArrayPrototypeTable(exec), this, propertyName, slot);
}

bool JSUint8ArrayPrototype::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticPropertyDescriptor<JSUint8ArrayPrototype, JSObject>(exec, getJSUint8ArrayPrototypeTable(exec), this, propertyName, descriptor);
}

static const HashTable* getJSUint8ArrayTable(ExecState* exec)
{
    return getHashTableForGlobalData(exec->globalData(), &JSUint8ArrayTable);
}

const ClassInfo JSUint8Array::s_info = { "Uint8Array", &JSArrayBufferView::s_info, 0, getJSUint8ArrayTable };

JSUint8Array::JSUint8Array(Structure* structure, JSDOMGlobalObject* globalObject, PassRefPtr<Uint8Array> impl)
    : JSArrayBufferView(structure, globalObject, impl)
{
    ASSERT(inherits(&s_info));
}

JSObject* JSUint8Array::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return new (exec) JSUint8ArrayPrototype(exec->globalData(), globalObject, JSUint8ArrayPrototype::createStructure(exec->globalData(), JSArrayBufferViewPrototype::self(exec, globalObject)));
}

bool JSUint8Array::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    bool ok;
    unsigned index = propertyName.toUInt32(ok);
    if (ok && index < static_cast<Uint8Array*>(impl())->length()) {
        slot.setValue(getByIndex(exec, index));
        return true;
    }
    return getStaticValueSlot<JSUint8Array, Base>(exec, getJSUint8ArrayTable(exec), this, propertyName, slot);
}

bool JSUint8Array::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    bool ok;
    unsigned index = propertyName.toUInt32(ok);
    if (ok && index < static_cast<Uint8Array*>(impl())->length()) {
        descriptor.setDescriptor(getByIndex(exec, index), DontDelete);
        return true;
    }
    return getStaticValueDescriptor<JSUint8Array, Base>(exec, getJSUint8ArrayTable(exec), this, propertyName, descriptor);
}

bool JSUint8Array::getOwnPropertySlot(ExecState* exec, unsigned propertyName, PropertySlot& slot)
{
    if (propertyName < static_cast<Uint8Array*>(impl())->length()) {
        slot.setValue(getByIndex(exec, propertyName));
        return true;
    }
    return getOwnPropertySlot(exec, Identifier::from(exec, propertyName), slot);
}

JSValue jsUint8ArrayLength(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSUint8Array* castedThis = static_cast<JSUint8Array*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    Uint8Array* imp = static_cast<Uint8Array*>(castedThis->impl());
    JSValue result = jsNumber(imp->length());
    return result;
}


JSValue jsUint8ArrayConstructor(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSUint8Array* domObject = static_cast<JSUint8Array*>(asObject(slotBase));
    return JSUint8Array::getConstructor(exec, domObject->globalObject());
}

void JSUint8Array::put(ExecState* exec, const Identifier& propertyName, JSValue value, PutPropertySlot& slot)
{
    bool ok;
    unsigned index = propertyName.toUInt32(ok);
    if (ok) {
        indexSetter(exec, index, value);
        return;
    }
    Base::put(exec, propertyName, value, slot);
}

void JSUint8Array::put(ExecState* exec, unsigned propertyName, JSValue value)
{
    indexSetter(exec, propertyName, value);
    return;
}

void JSUint8Array::getOwnPropertyNames(ExecState* exec, PropertyNameArray& propertyNames, EnumerationMode mode)
{
    for (unsigned i = 0; i < static_cast<Uint8Array*>(impl())->length(); ++i)
        propertyNames.add(Identifier::from(exec, i));
     Base::getOwnPropertyNames(exec, propertyNames, mode);
}

JSValue JSUint8Array::getConstructor(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSUint8ArrayConstructor>(exec, static_cast<JSDOMGlobalObject*>(globalObject));
}

EncodedJSValue JSC_HOST_CALL jsUint8ArrayPrototypeFunctionSubarray(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSUint8Array::s_info))
        return throwVMTypeError(exec);
    JSUint8Array* castedThis = static_cast<JSUint8Array*>(asObject(thisValue));
    Uint8Array* imp = static_cast<Uint8Array*>(castedThis->impl());
    int start(exec->argument(0).toInt32(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    int argsCount = exec->argumentCount();
    if (argsCount <= 1) {

        JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(imp->subarray(start)));
        return JSValue::encode(result);
    }

    int end(exec->argument(1).toInt32(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());


    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(imp->subarray(start, end)));
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsUint8ArrayPrototypeFunctionSet(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSUint8Array::s_info))
        return throwVMTypeError(exec);
    JSUint8Array* castedThis = static_cast<JSUint8Array*>(asObject(thisValue));
    return JSValue::encode(castedThis->set(exec));
}

// Constant getters

JSValue jsUint8ArrayBYTES_PER_ELEMENT(ExecState* exec, JSValue, const Identifier&)
{
    UNUSED_PARAM(exec);
    return jsNumber(static_cast<int>(1));
}


JSValue JSUint8Array::getByIndex(ExecState*, unsigned index)
{
    return jsNumber(static_cast<Uint8Array*>(impl())->item(index));
}

Uint8Array* toUint8Array(JSC::JSValue value)
{
    return value.inherits(&JSUint8Array::s_info) ? static_cast<JSUint8Array*>(asObject(value))->impl() : 0;
}

}
