/*
 * Decompiled with CFR 0.152.
 */
package nts.align;

import java.util.Vector;
import nts.align.Preamble;
import nts.base.Glue;
import nts.command.BaseToksChecker;
import nts.command.BraceNesting;
import nts.command.CommandBase;
import nts.command.RightBraceToken;
import nts.command.Token;
import nts.command.TokenList;

public class PreambleScanning
extends BaseToksChecker
implements BraceNesting {
    private Vector entries = new Vector();
    private TokenList.Buffer buf = new TokenList.Buffer();
    private TokenList uPart = null;
    private int loopIndex = -1;
    private int braceNesting = 0;
    private final TokenList crAndBrace;

    public boolean balanced() {
        return this.braceNesting == 0;
    }

    public void append(Token tok) {
        this.buf.append(tok);
    }

    public void finishHalf() {
        this.uPart = this.buf.toTokenList();
        this.buf = new TokenList.Buffer();
    }

    public void finishRecord(Glue skip) {
        this.entries.add(new Preamble.Entry(this.uPart, this.buf.toTokenList(), skip));
        this.uPart = null;
        this.buf = new TokenList.Buffer();
    }

    public boolean setLoopIndex() {
        if (this.loopIndex >= 0) {
            return false;
        }
        this.loopIndex = this.entries.size();
        return true;
    }

    public Preamble toPreamble(Glue firstSkip, String skipName, Token endTemplate) {
        Object[] records = new Preamble.Entry[this.entries.size()];
        this.entries.copyInto(records);
        return new Preamble(firstSkip, skipName, endTemplate, (Preamble.Entry[])records, this.loopIndex);
    }

    public void adjust(int count) {
        this.braceNesting += count;
    }

    protected void tryToFix() {
        CommandBase.insertList(this.crAndBrace);
    }

    protected void reportRunAway() {
        CommandBase.runAway("preamble", this.buf);
    }

    public PreambleScanning(Token source, Token frozenCr) {
        super("OuterInPreamble", "EOFinPreamble", source);
        Token[] toks = new Token[]{frozenCr, RightBraceToken.TOKEN};
        this.crAndBrace = new TokenList(toks);
    }
}

