
open XNum;
open Unicode.Types;
open Unicode.SymbolTable;
open Runtime;
open VM;
open Types;

value sym_Accent               : symbol;
value sym_AddToGalley          : symbol;
value sym_AdjDemerits          : symbol;
value sym_Adjustments          : symbol;
value sym_Alignment            : symbol;
value sym_AutoLigatures        : symbol;
value sym_Base                 : symbol;
value sym_BaselineSkip         : symbol;
value sym_BeginGroup           : symbol;
value sym_Bevel                : symbol;
value sym_BinOp                : symbol;
value sym_BinOpPenalty         : symbol;
value sym_Bitmap               : symbol;
value sym_Bmp                  : symbol;
value sym_Bool                 : symbol;
value sym_BorderKern           : symbol;
value sym_Bottom               : symbol;
value sym_BottomSkip           : symbol;
value sym_Break                : symbol;
value sym_Butt                 : symbol;
value sym_Circle               : symbol;
value sym_Clip                 : symbol;
value sym_Close                : symbol;
value sym_ClubPenalty          : symbol;
value sym_CMYK                 : symbol;
value sym_Command              : symbol;
value sym_CommandBox           : symbol;
value sym_CrampedDisplay       : symbol;
value sym_CrampedScript        : symbol;
value sym_CrampedScript2       : symbol;
value sym_CrampedText          : symbol;
value sym_Default              : symbol;
value sym_DelimiterFactor      : symbol;
value sym_DelimiterShortfall   : symbol;
value sym_Direct               : symbol;
value sym_Display              : symbol;
value sym_DoubleHyphenDemerits : symbol;
value sym_Dpi                  : symbol;
value sym_EmergencyStretch     : symbol;
value sym_Encoding             : symbol;
value sym_EndGroup             : symbol;
value sym_ExHyphenPenalty      : symbol;
value sym_Family               : symbol;
value sym_Fill                 : symbol;
value sym_FinalHyphenDemerits  : symbol;
value sym_Fixed                : symbol;
value sym_Float                : symbol;
value sym_FloatSep             : symbol;
value sym_Footnote             : symbol;
value sym_Fraction             : symbol;
value sym_Galley               : symbol;
value sym_GfxCommand           : symbol;
value sym_Glyph                : symbol;
value sym_Glue                 : symbol;
value sym_Grey                 : symbol;
value sym_GridSize             : symbol;
value sym_HBox                 : symbol;
value sym_HBoxSpread           : symbol;
value sym_HBoxTo               : symbol;
value sym_Height               : symbol;
value sym_HLeaders             : symbol;
value sym_Hyphen               : symbol;
value sym_HyphenGlyph          : symbol;
value sym_HyphenParams         : symbol;
value sym_HyphenPenalty        : symbol;
value sym_HyphenTable          : symbol;
value sym_Image                : symbol;
value sym_IndexPosition        : symbol;
value sym_Inner                : symbol;
value sym_Kern                 : symbol;
value sym_Leading              : symbol;
value sym_Left                 : symbol;
value sym_LeftHyphenMin        : symbol;
value sym_LeftRight            : symbol;
value sym_LeftSkip             : symbol;
value sym_Letter               : symbol;
value sym_LetterSpacing        : symbol;
value sym_Ligature             : symbol;
value sym_LineBreakParams      : symbol;
value sym_LineParams           : symbol;
value sym_LinePenalty          : symbol;
value sym_LineSkip             : symbol;
value sym_LineSkipLimit        : symbol;
value sym_Looseness            : symbol;
value sym_LR                   : symbol;
value sym_LRBox                : symbol;
value sym_Mandantory           : symbol;
value sym_Math                 : symbol;
value sym_MathAccent           : symbol;
value sym_MathChar             : symbol;
value sym_MathCode             : symbol;
value sym_MathFamily           : symbol;
value sym_MathParams           : symbol;
value sym_MathStyle            : symbol;
value sym_Measure              : symbol;
value sym_MedMathSkip          : symbol;
value sym_MinSize              : symbol;
value sym_Miter                : symbol;
value sym_ModifyGalleyGlue     : symbol;
value sym_Name                 : symbol;
value sym_NewArea              : symbol;
value sym_NewGalley            : symbol;
value sym_NewLayout            : symbol;
value sym_NewMarks             : symbol;
value sym_NoMath               : symbol;
value sym_None                 : symbol;
value sym_NullDelimiterSpace   : symbol;
value sym_OldMarks             : symbol;
value sym_Open                 : symbol;
value sym_Operator             : symbol;
value sym_Optional             : symbol;
value sym_Ordinary             : symbol;
value sym_Overline             : symbol;
value sym_PageNo               : symbol;
value sym_Paragraph            : symbol;
value sym_ParIndent            : symbol;
value sym_ParFillSkip          : symbol;
value sym_ParParams            : symbol;
value sym_ParShape             : symbol;
value sym_ParSkip              : symbol;
value sym_PDF                  : symbol;
value sym_Phantom              : symbol;
value sym_PostProcessLine      : symbol;
value sym_PostScript           : symbol;
value sym_Preamble             : symbol;
value sym_PreTolerance         : symbol;
value sym_Punct                : symbol;
value sym_PutBox               : symbol;
value sym_PutGalleyInVBox      : symbol;
value sym_Register             : symbol;
value sym_Relation             : symbol;
value sym_RelPenalty           : symbol;
value sym_RGB                  : symbol;
value sym_Right                : symbol;
value sym_RightHyphenMin       : symbol;
value sym_RightSkip            : symbol;
value sym_RiverDemerits        : symbol;
value sym_RiverThreshold       : symbol;
value sym_RL                   : symbol;
value sym_RLBox                : symbol;
value sym_Root                 : symbol;
value sym_Round                : symbol;
value sym_Rule                 : symbol;
value sym_Scale                : symbol;
value sym_Script               : symbol;
value sym_ScriptLang           : symbol;
value sym_Script2              : symbol;
value sym_ScriptSpace          : symbol;
value sym_ScriptSize           : symbol;
value sym_Script2Size          : symbol;
value sym_Separator            : symbol;
value sym_Series               : symbol;
value sym_SetAlpha             : symbol;
value sym_SetBgColour          : symbol;
value sym_SetColour            : symbol;
value sym_SetFont              : symbol;
value sym_SetLineCap           : symbol;
value sym_SetLineJoin          : symbol;
value sym_SetLineWidth         : symbol;
value sym_SetMiterLimit        : symbol;
value sym_Shape                : symbol;
value sym_ShipOut              : symbol;
value sym_Shrink               : symbol;
value sym_ShrinkFactor         : symbol;
value sym_ShrinkOrder          : symbol;
value sym_SimpleBreaking       : symbol;
value sym_Size                 : symbol;
value sym_Skew                 : symbol;
value sym_SkewGlyph            : symbol;
value sym_Skyline              : symbol;
value sym_Space                : symbol;
value sym_SpaceFactor          : symbol;
value sym_SpaceParams          : symbol;
value sym_SpaceSkip            : symbol;
value sym_Square               : symbol;
value sym_Stretch              : symbol;
value sym_StretchFactor        : symbol;
value sym_StretchOrder         : symbol;
value sym_Stroke               : symbol;
value sym_SubScript            : symbol;
value sym_SuperScript          : symbol;
value sym_Table                : symbol;
value sym_TableEntry           : symbol;
value sym_TeX                  : symbol;
value sym_Text                 : symbol;
value sym_TextSize             : symbol;
value sym_ThickMathSkip        : symbol;
value sym_ThinMathSkip         : symbol;
value sym_Tolerance            : symbol;
value sym_Top                  : symbol;
value sym_TopSkip              : symbol;
value sym_Underline            : symbol;
value sym_VBox                 : symbol;
value sym_VBoxSpread           : symbol;
value sym_VBoxTo               : symbol;
value sym_Vert                 : symbol;
value sym_VictorianSpacing     : symbol;
value sym_VInsert              : symbol;
value sym_WidowPenalty         : symbol;
value sym_Width                : symbol;
value sym_XSpaceSkip           : symbol;

value decode_symbol    : string -> unknown -> symbol;
value decode_int       : string -> unknown -> int;
value decode_bool      : string -> unknown -> bool;
value decode_char      : string -> unknown -> int;
value decode_option    : string -> (string -> unknown -> 'a) -> unknown -> option 'a;
value decode_uc_string : string -> unknown -> uc_string;
value decode_tuple     : string -> unknown -> array unknown;
value decode_dict      : string -> unknown -> SymbolMap.t unknown;

value lookup : (unknown -> 'a) -> SymbolMap.t unknown -> symbol -> option 'a;

value lookup_string : string -> SymbolMap.t unknown -> symbol -> option uc_string;
value lookup_bool   : string -> SymbolMap.t unknown -> symbol -> option bool;
value lookup_int    : string -> SymbolMap.t unknown -> symbol -> option int;
value lookup_num    : string -> SymbolMap.t unknown -> symbol -> option num;
value lookup_symbol : string -> SymbolMap.t unknown -> symbol -> option symbol;
value lookup_dict   : string -> SymbolMap.t unknown -> symbol -> option (SymbolMap.t unknown);
value lookup_tuple  : string -> SymbolMap.t unknown -> symbol -> option (array unknown);
value lookup_list   : string -> SymbolMap.t unknown -> symbol -> option (list unknown);

value decode_opaque   : string -> (Opaque.opaque unknown -> 'a) -> string -> unknown -> 'a;

value encode_location       : UCStream.location -> partial_value;
value encode_index_position : Typesetting.Box.index_position -> partial_value;
value encode_math_code      : Typesetting.Box.math_code -> partial_value;
value encode_math_style     : Typesetting.MathLayout.math_style -> partial_value;
value encode_mode           : ParseState.mode -> partial_value;
value encode_hbox_dir       : [= `LR | `RL | `Default] -> partial_value;
value encode_colour         : Graphic.colour -> partial_value;

value decode_location       : string -> unknown -> UCStream.location;
value decode_index_position : string -> unknown -> Typesetting.Box.index_position;
value decode_math_code      : string -> unknown -> Typesetting.Box.math_code;
value decode_math_style     : string -> unknown -> Typesetting.MathLayout.math_style;
value decode_mode           : string -> unknown -> ParseState.mode;
value decode_hbox_dir       : string -> unknown -> [= `LR | `RL | `Default ];
value decode_colour         : string -> unknown -> Graphic.colour;

