/*-
******************************************************************************
******************************************************************************
**
**  ARCHIVE HEADER INFORMATION
**
**  @C-file{
**      FILENAME    = "local.h",
**      VERSION     = "1.00",
**      DATE        = "",
**      TIME        = "",
**
**      AUTHOR      = "Niel Kempson",
**      ADDRESS     = "25 Whitethorn Drive, Cheltenham, GL52 5LL, England",
**      TELEPHONE   = "+44-242 579105",
**      EMAIL       = "kempson@tex.ac.uk (Internet)",
**
**      SUPPORTED   = "yes",
**      ARCHIVED    = "tex.ac.uk, ftp.tex.ac.uk",
**      KEYWORDS    = "VVcode",
**
**      CODETABLE   = "ISO/ASCII",
**      CHECKSUM    = "51492 1481 5732 57976",
**
**      DOCSTRING   = { This file is part of VVcode.
**                  }
**  }
**
**  MODULE CONTENTS
**
**      [tbs]
**
**  COPYRIGHT
**
**      Copyright (c) 1991-1993 by Niel Kempson <kempson@tex.ac.uk>
**
**      This program is free software; you can redistribute it and/or
**      modify it under the terms of the GNU General Public License as
**      published by the Free Software Foundation; either version 1, or
**      (at your option) any later version.
**
**      This program is distributed in the hope that it will be useful,
**      but WITHOUT ANY WARRANTY; without even the implied warranty of
**      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
**      General Public License for more details.
**
**      You should have received a copy of the GNU General Public License
**      along with this program; if not, write to the Free Software
**      Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
**
**      In other words, you are welcome to use, share and improve this
**      program.  You are forbidden to forbid anyone else to use, share
**      and improve what you give them.   Help stamp out software-hoarding!  
**
**  CHANGE LOG
**
******************************************************************************
******************************************************************************
*/


/*-
**----------------------------------------------------------------------------
** VV_DEBUG_SUPPORT controls whether the debugging code is compiled into the 
** program.  Define to one of the following two values:
**
**  0       don't compile in debugging code
**  1       compile in debugging code
**----------------------------------------------------------------------------
*/
#define VV_DEBUG_SUPPORT        1



/*-
**----------------------------------------------------------------------------
** VV_TIMEZONE defines the timezone of your local computer.  On most Unix
** systems the timezone will be known to the operating system, so this
** definition will not strictly be necessary.  It is however essential for
** systems such as MS-DOS where writers of many compilers have assumed their
** local timezone (e.g. Microsoft C assumes US West Coast time and Turbo C
** assumes US East Coast time).
**
** The string to be used for the times should conform to the Unix standard
** format for timezones, namely:
**
**      SSSwwDDD
**
**  SSS     the three letter abbreviation of the timezone.
**  ww      the number of hours WEST of GMT (Universal Time) in this timezone.
**          Timezones EAST of GMT have negative values.
**  DDD     (optional) the three letter abbreviation of the timezone when
**          daylight saving time is in effect.  If this part of the string is
**          not present it is assumed that daylight saving time is never in
**          effect.
**
** Examples of valid timezones are shown below, though some of the names may
** be incorrect.
**
**
**  NST-12NDT   New Zealand Standard Time
**  ???-11???   GMT+1100
**  EST-10???   Eastern Australia Standard Time
**  JST-9???    Japanese Standard Time
**  WST-8???    Western Australia Standard Time
**  ???-7???    GMT+0700 
**  ???-6???    GMT+0600
**  ???-5???    GMT+0500
**  ???-4???    GMT+0400
**  ???-3???    GMT+0300
**  EET-2EST    East European Time
**  CET-1CST    Central European Time
**
**  UTC0        Coordinated universal time (GMT)
**  GMT0BST     Greenwich Mean Time, British Summer Time
**
**  ???1???     GMT-0100
**  ???2???     GMT-0200
**  ???3???     GMT-0300
**  AST4ADT     Atlantic Standard Time
**  EST5EDT     Eastern Standard Time
**  CST6CDT     Central Standard Time
**  MST7MDT     Mountain Standard Time
**  PST8PDT     Pacific Standard Time
**  YST9YDT     Yukon Standard Time
**  HST10HDT    Hawaii Standard Time
**  BST11BDT    Bering Standard Time
**----------------------------------------------------------------------------
*/
#define VV_TIMEZONE             "GMT0BST"



/*-
**----------------------------------------------------------------------------
** DEFAULT FILE EXTENSIONS
**
** VVcode uses default file 'extensions' for different types of files.  If the
** implementation is compiled with STICKY_DEFAULTS defined, the appropriate
** 'extension' will be assumed if a file without 'extension' is specified.
** The file 'extensions' used are:
**
**  DEF_ENC_EXT     -   VVcode encoding table files
**  DEF_IDX_EXT     -   VVdecode translation table index files
**  DEF_LOG_EXT     -   VVcode log files
**  DEF_VV_EXT      -   VVcode 'VVE' files
**  DEF_XLT_EXT     -   VVcode character set translation files
**
** Examples are:
**
**  #define DEF_ENC_EXT             "tbl"
**  #define DEF_IDX_EXT             "idx"
**  #define DEF_LOG_EXT             "log"
**  #define DEF_VV_EXT              "vve"
**  #define DEF_XLT_EXT             "xlt"
**
** NOTE:    most operating systems separate the 'extension' from the 'name'
**          by a certain character (e.g. '.' for MS-DOS, VAX/VMS and ' ' for
**          VM/CMS).  DO NOT include this character in the 'extension' string.
**----------------------------------------------------------------------------
*/
#define DEF_ENC_EXT             "tbl"
#define DEF_IDX_EXT             "idx"
#define DEF_LOG_EXT             "log"
#define DEF_VV_EXT              "vve"
#define DEF_XLT_EXT             "xlt"



/*-
**----------------------------------------------------------------------------
** DEFAULTS FOR MULTI-PART VVE FILES
**
** When encoding and decoding multi-part VVE files, VVcode uses different 
** file 'extensions' to identify the different parts.
**
**  VV_EXT_FMT      -   printf() compatible format used to construct the 
**                      string for the file 'extension'.  The format string
**                      must accept one Int16 integer as an argument and must
**                      result in a legal file 'extension' for this
**                      implementation of VVcode.
**  MAX_VV_PARTS    -   the maximum number of VVE parts allowed.  It must be
**                      be less than or equal to the unique file 'extensions' 
**                      that can be constructed by the VV_EXT_FMT format 
**                      string.
**
** Examples are:
**
**  #define VV_EXT_FMT    "v%02d"
**  #define MAX_VV_PARTS  99
**
**  #define VV_EXT_FMT    "vve_part_%04x"
**  #define MAX_VV_PARTS  32767
**----------------------------------------------------------------------------
*/
#define VV_EXT_FMT    "v%02d"
#define MAX_VV_PARTS  99



/*-
**----------------------------------------------------------------------------
** LOCAL CHARACTER SET
**
**----------------------------------------------------------------------------
*/
#define VV_CHARACTERSET         "ASCII"



/*-
**----------------------------------------------------------------------------
** VVDECODE INDEX FILE DEFAULTS
**
** When decoding a VVE file encoded on a system with a different character
** set, VVdecode can use a character translation table.  If the user does not
** explictily specify the table file with the "translation_file" command 
** qualifier, VVdecode expects to look up the correct translation file in a
** translation index file.  This file contains lines of the form:
**
**      ##-----------------------------------------------
**      ##  From            To              Translation
**      ##  char set        char set        table file
**      ##-----------------------------------------------
**          ASCII           EBCDIC-1        asc-ebc1.xlt
**          ASCII           PC-437          asc-437.xlt
**      ##-----------------------------------------------
**
** VVdecode tries to determine the index file to use by applying the
** following rules in order:
**
**  1.  If the "index_file" command qualifier was used to specify the index
**      file, use its value as the file specification of the index file.
**
**  2.  If the environment variable specified by the preprocessor macro
**      VV_INDEX_ENVVAR is defined, use its value as the file specification of
**      the index file.  If the operating system does not support environment
**      variables and retrieval of their values by getenv(), set this value to
**      NULL.
**
**  3.  The preprocessor macro VV_INDEX_FILE specifies the default index file
**      to be used if neither of the preceeding cases were successful.  If
**      a default file is not to be used, set this value to NULL.
**
** The preprocessor macros VV_INDEX_ENVVAR and VV_INDEX_FILE should be defined
** below.
**----------------------------------------------------------------------------
*/
#define VV_INDEX_ENVVAR         "VV_INDEX_FILE"
#define VV_INDEX_FILE           "vv-xlt.idx"
