#ifndef	_TEXPERF
#define	_TEXPERF
/****************************************************************************
 *
 * Copyright (c) 1992-1996 John Forkosh Associates.  All rights reserved.
 * --------------------------------------------------------------------------
 *
 * Header:	texperf
 *
 * Purpose:	Defines the layout of WordPerfect document files,
 *		control sequences, etc, and allocates i/o buffers.
 *
 * Source:	TEXPERF.H
 *
 * Notes:     o
 *
 * --------------------------------------------------------------------------
 * Revision History:
 * 12/19/92	J.Forkosh	Installation.
 * 08/08/96	J.Forkosh	Modified and streamlined for copyleft release
 *
 ***************************************************************************/

/* --------------------------------------------------------------------------
Prototypes for non-integer functions (see below also)
-------------------------------------------------------------------------- */
char	*texcommand();			/* returns a string (null=no more) */

/* --------------------------------------------------------------------------
TeX Macro Package Translation Requested, TeX modes, and TeX Commands
-------------------------------------------------------------------------- */
/* --- TeX macro package --- */
#define	TEX	(1)			/* plain TeX */
#define	LATEX	(TEX+1)			/* LaTeX */
#define	AMSTEX	(LATEX+1)		/* AMS-TeX */
#define	ALLTEX	(AMSTEX+1)		/* applies to all TeX types */
#define	TEXTYPE	LATEX			/* default textype */
/* --- TeX modes (also xlated TeX commands) --- */
#define	PARMODE	(1)			/* paragraph mode (normal) */
#define	MATHMODE (PARMODE+1)		/* math mode */
#define	DISPMATH (MATHMODE+1)		/* display math mode */
#define	PARDISP  (DISPMATH+1)		/* par mode after display math */
#define	USERPAR  (PARDISP+1)		/* disp mode reset by user $$ */
#define	USERMATH (USERPAR+1)		/* math/par mode set by user $ */
#define	USERDISP (USERMATH+1)		/* disp/par mode set by user $$ */
#define	TOKENMODE (USERDISP+1)		/* same mode as token (internal) */
/* --- TeX Commands - commands that differ for TeX, LaTeX and AMS-TeX --- */
#define	HEADER	(TOKENMODE+1)		/* several lines of header info */
#define	PREAMBLE (HEADER+1)		/* preamble info */
#define	TRAILER	(PREAMBLE+1)		/* just one line, e.g., \end{doc} */
#define	EJECT	(TRAILER+1)		/* \eject or \clearpage */
#define	SETCMD	(-998)			/*signals texcommand() to set string*/
/* --- TeX characters that control token identification --- */
#define	TEXBACKSLASH "#$%&~_^{}"	/*char requiring preceding backslash*/
#define	TEXMATH "=\\{}*+<>|_^"		/*chars that signal math mode token*/
#define	TEXPUNC ".,;:`\'\""		/* punctuation chars - might add ) */
#define	TEXLQUOTE "``"			/* left/open quote */
#define	TEXRQUOTE "\'\'"		/* right/close quote */
#define	TEX1LETWDS "AaIOo"		/* single-char parmode words */
#define	LETTERS "abcdefghijklmnopqrstuvwxyz" /* lower-case letters */
#define	DIGITS "0123456789"		/* decimal digits */

/* --------------------------------------------------------------------------
Bit field manipulation macros
-------------------------------------------------------------------------- */
#define	bitmask(nbits)	((1<<(nbits))-1) /* = binary 111...1 (nbits 1's) */
#define getbit(x,bitn)	(((x)>>(bitn)) & 1) /*get bitn-th bit of x (1 or 0)*/
#define setbit(x,bitn)	((x) |= (1<<(bitn))) /* set bitn-th bit of x to 1 */
#define getbitfld(x,bit1,nbits)	(((x)>>(bit1)) & (bitmask(nbits)))
#define setbitfld(bit1,x,fld)	((x) |= ((fld)<<(bit1)))

/* --------------------------------------------------------------------------
WordPerfect document file data types, and units information
-------------------------------------------------------------------------- */
/* --- document file data types --- */
#define	byte	unsigned char		/* 8-bit byte */
#define	word	short			/* 16-bit, byte-reversed */
#define	dword	long			/* 32-bit, word- and byte-reversed */
/* --- units information --- */
#define	WPU	(1200)			/* WordPerfect Units/inch */
#define	CPI	(10)			/* Columns/inch */

/* --------------------------------------------------------------------------
16-byte WordPerfect File Prefix, Header Index Block, Packet Index Block
-------------------------------------------------------------------------- */
/* --- 16-byte WordPerfect File Prefix --- */
#define	WPFILEPREF struct wpfilepref_struct /*typedef for file prefix struct*/
WPFILEPREF
  {
  byte	fileid[4];			/* must contain "\377WPC" ('-1'WPC)*/
  dword	docoffset;			/* byte offset to document area */
  byte	prodtype;			/* product type = 1 for WordPerf */
  byte	filetype;			/* file type = 0x0A for document */
  byte	majorver;			/* major version = 0 for WP 5.x*/
  byte	minorver;			/* minor version = 1 for WP 5.1 */
  word	encryptkey;			/* 0 = not encrypted */
  word	reserved;			/* Do not use.  Must be 0. */
  } ; /* --- end-of-struct wpfilepref_struct --- */
/* --- Special Header Index Block --- */
#define	WPINDEXBLK struct wpindexblk_struct /*typedef for index block struct*/
WPINDEXBLK
  {
  word	pkttype;			/* packet type = 0x0FFFB */
  word	nindex;				/* #index = 5 */
  word	indexsz;			/* index size = #index*10(decimal) */
  dword	nextblk;			/* byte offset to next block */
  } ; /* --- end-of-struct wpindexblk_struct --- */
/* --- Packet Index Block --- */
#define	WPPKTBLK struct wppktblk_struct	/* typedef for packet block struct */
WPPKTBLK
  {
  word	pkttype;			/* packet type */
  dword	pktlen;				/* length of data packet */
  dword	pktoffset;			/* byte offset to data packet */
  } ; /* --- end-of-struct wppktblk_struct --- */

/* --------------------------------------------------------------------------
Memory and File Buffer Structure
-------------------------------------------------------------------------- */
/* --- memory buffer --- */
#define	MEMBUFFSIZE 8192		/* buffer size in bytes */
#define	MEMBUFF struct membuff_struct	/* typedef for memory buffer struct */
MEMBUFF
  {
  unsigned char *buffer;		/* memory buffer */
  int	buffsize;			/* total allocated size of buffer */
  int	buffhead;			/* offset to leading char in buffer */
  int	bufftail;			/* offset past last char in buffer */
  int	buffchar;			/* current char = buffer[buffhead] */
  } ; /* --- end-of-struct membuff_struct --- */
MEMBUFF *tpmalloc();			/* malloc a MEMBUFF and its buffer */

/* --- file buffer --- */
#define	FILEBUFF struct filebuff_struct	/* typedef for file buffer struct */
FILEBUFF
  {
  char	filename[64];			/* [path]filename (64-char max) */
  char	accessmode[8];			/* access mode ("rb","w",etc) */
  FILE	*fp;				/* fopen() file pointer */
  MEMBUFF *filebuff;			/* memory buffer for file */
  } ; /* --- end-of-struct filebuff_struct --- */

/* --------------------------------------------------------------------------
TexPerfect File Control Block
-------------------------------------------------------------------------- */
#define	TPFCB struct tpfcb_struct	/* typedef for TexPerf fcb struct */
TPFCB
  {
  /* --- TexPerfect file control block header --- */
  char	ident[8];			/* first 5 chars should be "tpfcb" */
  int	msglevel;			/* output message level */
  int	textype;			/* plain TeX, LaTeX, or AMS-TeX */
  /* VARDEF *tpvars; */			/* address of input variable struct */
  /* --- WordPerfect document information --- */
  FILEBUFF wpdoc;			/* WordPerfect document file */
  WPFILEPREF wpfilepref;		/* file prefix */
  long	wpdocoffset;			/* byte offset to document area */
  long	wpdocsize;			/* total #bytes processed */
  int	wpcodetblsz;			/* #entries in wpcodetbl[] */
  int	*wpcodetbl;			/* char indexes type code */
  char	***wpchartbl;			/* extended character tables */
  char	*argstr;			/* argument passed thru struct */
  /* --- TexPerfect information --- */
  FILEBUFF tpfile;			/* TexPerfect output file */
  int	texmode;			/* par mode, math mode */
  int	tokenlen;			/* #characters in current token */
  int	isheader;			/* true after header written */
  int	isdblspace;			/* true for extra CR after HARDCR */
  int	nhardcr;			/* # consecutive hard cr's */
  } ; /* --- end-of-struct tpfcb_struct --- */

/* --------------------------------------------------------------------------
TexPerfect Defaults
-------------------------------------------------------------------------- */
/* --- macros to check character class --- */
#define	ismychar(charclass,mychar) \
	( (mychar)!='\000' && strchr(charclass,(mychar))!=(char *)NULL )
#define	ismystr(charclass,mystr) \
	( (*(mystr))!='\000' && strspn(mystr,charclass)==strlen(mystr) )
#define	WHITESPACE	" \t\r\n"	/* characters interpreted as white */

/* --------------------------------------------------------------------------
WordPerfect Codes and Functions
-------------------------------------------------------------------------- */
/* --- data types --- */
#define	ERROR	(-1)			/* illegal value */
#define	ASCII	(ERROR+1)		/* ascii character */
#define	WHITE	(ASCII+1)		/* white-space ascii character */
#define	CTRL	(WHITE+1)		/* single-byte control code */
#define	FUNC	(CTRL+1)		/* single-byte function code */
#define	FIXLEN	(FUNC+1)		/* fixed-length function codes */
#define	VARLEN	(FIXLEN+1)		/* variable-length function codes */
/* --- single-byte control codes (that we recognize in wp2tex) --- */
#define	HARDCR	('\012')		/* hard return = 00Ax = Ctrl-J */
#define	SOFTPG	('\013')		/* soft page =   00Bx = Ctrl-K */
#define	HARDPG	('\014')		/* hard page =   00Cx = Ctrl-L */
#define	SOFTCR	('\015')		/* soft return = 00Dx = Ctrl=M */
/* --- single-byte function codes (that we recognize in wpfunc()) --- */
#define	HARDCRSOFTPG ((unsigned char)('\214')) /*combo hardCR,softPG = 08Cx*/
#define	HARDENDOFCENTER ((unsigned char)('\217')) /*hard endofcenter = 08Fx*/
#define	HARDSPACE2   ((unsigned char)('\223')) /* Invisible SRt = 093x */
#define	DORMHARDCR   ((unsigned char)('\231')) /* Dormant CR =  099x */
#define	HARDSPACE    ((unsigned char)('\240')) /* hard space =  0A0x */
/* --- fixed-length, multi-byte function codes (in wpfixlen()) --- */
#define	EXTENDCHAR   ((unsigned char)('\300')) /* extended char = 0C0x */
#define	TABCENTER    ((unsigned char)('\301')) /* tab,center,etc= 0C1x */
#define	INDENT       ((unsigned char)('\302')) /* indent =        0C2x */
#define	ATTRIBUTEON  ((unsigned char)('\303')) /* attribute on =  0C3x */
#define	ATTRIBUTEOFF ((unsigned char)('\304')) /* attribute off = 0C4x */
#define	BLOCKPROTECT ((unsigned char)('\305')) /* block protect = 0C5x */
#define	ENDOFINDENT  ((unsigned char)('\306')) /* end of indent = 0C6x */
/* --- variable-length, multi-byte function codes (in wpvarlen()) --- */
#define	FUNCD0	((unsigned char)('\320')) /* 0D0x = Page Format Group */
#define	FUNCD1	((unsigned char)('\321')) /* 0D1x = Font Group */
#define	FUNCD2	((unsigned char)('\322')) /* 0D2x = Definition Group */
#define	FUNCD3	((unsigned char)('\323')) /* 0D3x = Set Group */
#define	FUNCD4	((unsigned char)('\324')) /* 0D4x = Format Group */
#define	FUNCDA	((unsigned char)('\332')) /* 0D4x = Box Group */
#define	FUNCDF	((unsigned char)('\337')) /* 0DFx = Equation Nested Group */
#define	TABSET	('\004')		/* D0-subfunction */
#define	ENDOFPAGE ('\000')		/* D4-subfunction */
#define	EQUATION ('\004')		/* DA-subfunction */
#define	EQNESTED ('\000')		/* DF-subfunction */
/* --- attributes --- */
#define	ATTRIBUTE0   100		/*to avoid collisions with commands*/
#define	EXTRALARGE   ((byte)(ATTRIBUTE0+0))  /* 0 = extra large */
#define	VERYLARGE    ((byte)(ATTRIBUTE0+1))  /* 1 = very large */
#define	LARGE        ((byte)(ATTRIBUTE0+2))  /* 2 = large */
#define	SMALL        ((byte)(ATTRIBUTE0+3))  /* 3 = small */
#define	FINE         ((byte)(ATTRIBUTE0+4))  /* 4 = fine */
#define	SUPERSCRIPT  ((byte)(ATTRIBUTE0+5))  /* 5 = superscript */
#define	SUBSCRIPT    ((byte)(ATTRIBUTE0+6))  /* 6 = subscript */
#define	OUTLINE      ((byte)(ATTRIBUTE0+7))  /* 7 = outline */
#define	ITALICS      ((byte)(ATTRIBUTE0+8))  /* 8 = italics */
#define	SHADOW       ((byte)(ATTRIBUTE0+9))  /* 9 = shadow */
#define	REDLINE      ((byte)(ATTRIBUTE0+10)) /* a = redline */
#define	DBLUNDERLINE ((byte)(ATTRIBUTE0+11)) /* b = double underline */
#define	BOLD         ((byte)(ATTRIBUTE0+12)) /* c = bold */
#define	STRIKEOUT    ((byte)(ATTRIBUTE0+13)) /* d = strikeout */
#define	UNDERLINE    ((byte)(ATTRIBUTE0+14)) /* e = underline */
#define	SMALLCAPS    ((byte)(ATTRIBUTE0+15)) /* f = small caps */
/* ----------------------- END-OF-FILE TEXPERF.H ------------------------- */
#endif
