/* Counter.h
 *
 * LameTeX needs to keep track of a number of counters, just like LaTeX does,
 * for things like tables, footnotes, chapters and sections, and enumerations.
 * Since all counters need to be handled in much the same way, the Counter
 * derived class under the Parameters class has been defined.
 *
 * Copyright 1992 Jonathan Monsarrat. Permission given to freely distribute,
 * edit and use as long as this copyright statement remains intact.
 *
 */

class Counter : public Param {
 public:
   enum CounterType {   // The official LaTeX counters. All start at zero.
      Part,
      Chapter,
      Section,
      Subsection,
      Subsubsection,
      Paragraph,
      Subparagraph,
      Page,
      Equation,
      Figure,
      Table,
      Footnote,
      Mpfootnote,
      Description,
      Enum,
      Enumi,
      Enumii,
      Enumiii,
      Enumiv,
      Itemize,
      Item,
      LastType
   };

   Counter();
   Counter(Counter *);
   Param *copy();
   int set(int, float, char*);
   float get(int, char*);
   void postscript_set(int);
   void revert(Param *);
   void downcase_roman(int, char*);
   void upcase_roman(int, char*);
   void arabic(int, char*);
   void downcase_alpha(int, char*);
   void upcase_alpha(int, char*);
 private:
   int counters[LastType];
   void description();
};

