/*
 * Decompiled with CFR 0.152.
 */
package com.dickimawbooks.jmakepdfx;

import com.dickimawbooks.jmakepdfx.Jmakepdfx;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Properties;
import java.util.Vector;
import javax.swing.JMenu;
import javax.swing.JMenuItem;

public class JpdfxProperties
extends Properties {
    private File propFile;
    private static final String baseName = "jmakepdfx.prop";
    private static String recentName = "recentfiles";
    private static final int MAX_RECENT_FILES = 10;
    private Jmakepdfx app;
    private File recentFile;
    private Vector<String> recentList;
    private static final long DEFAULT_TIMEOUT = 10800000L;

    public JpdfxProperties(File file, File file2, boolean bl, Jmakepdfx jmakepdfx) throws IOException {
        BufferedReader bufferedReader;
        this.app = jmakepdfx;
        this.propFile = file;
        this.recentFile = file2;
        this.recentList = new Vector();
        if (file != null && file.exists() && bl) {
            bufferedReader = new BufferedReader(new FileReader(file));
            this.load(bufferedReader);
            bufferedReader.close();
        } else {
            this.setDefaults();
        }
        if (file2 != null && file2.exists()) {
            bufferedReader = new BufferedReader(new FileReader(file2));
            this.loadRecentFiles(bufferedReader);
            bufferedReader.close();
        }
    }

    public JpdfxProperties(Jmakepdfx jmakepdfx) {
        this.app = jmakepdfx;
        this.propFile = null;
        this.recentFile = null;
        this.setDefaults();
    }

    protected void setDefaults() {
        this.setProperty("directory", ".");
        this.setProperty("toolbarorient", "0");
    }

    public static JpdfxProperties fetchProperties(Jmakepdfx jmakepdfx) throws IOException {
        boolean bl;
        File file = null;
        File file2 = null;
        File file3 = null;
        String string = System.getProperty("user.home");
        boolean bl2 = bl = string != null;
        if (bl && !(file = new File(string, ".jmakepdfx")).isDirectory() && !(file = new File(string, "jmakepdfx-settings")).isDirectory()) {
            file = null;
        }
        if (file != null) {
            file2 = new File(file, baseName);
            file3 = new File(file, recentName);
        } else {
            bl = false;
        }
        return new JpdfxProperties(file2, file3, bl, jmakepdfx);
    }

    public void save() throws IOException {
        Object object;
        String string;
        if (this.propFile == null) {
            string = System.getProperty("user.home");
            if (string == null) {
                throw new IOException(Jmakepdfx.getLabel("error.home_null"));
            }
            object = System.getProperty("os.name").equals("Windows") ? new File(string, "jmakepdfx-settings") : new File(string, ".jmakepdfx");
            if (!((File)object).mkdir()) {
                throw new IOException(Jmakepdfx.getLabelWithValue("error.io.cant_mkdir", ((File)object).getAbsolutePath()));
            }
            this.propFile = new File((File)object, baseName);
        }
        if ((string = this.getDefaultDirectorySetting()) == null) {
            string = "home";
        }
        if (string.equals("home")) {
            this.setDefaultDirectory(System.getProperty("user.home"));
        } else if (string.equals("last")) {
            this.setDefaultDirectory(this.app.getCurrentDirectory());
        }
        object = new PrintWriter(new FileWriter(this.propFile));
        this.store((Writer)object, "jmakepdfx-gui properties");
        ((PrintWriter)object).close();
        if (this.recentFile == null) {
            this.recentFile = new File(this.propFile.getParentFile(), recentName);
        }
        object = new PrintWriter(new FileWriter(this.recentFile));
        int n = this.recentList.size();
        for (int i = 0; i < n; ++i) {
            ((PrintWriter)object).println(this.recentList.get(i));
        }
        ((PrintWriter)object).close();
    }

    private void loadRecentFiles(BufferedReader bufferedReader) throws IOException {
        String string;
        while ((string = bufferedReader.readLine()) != null) {
            this.recentList.add(string);
        }
    }

    public void addRecentFile(String string) {
        this.recentList.remove(string);
        this.recentList.add(string);
    }

    public void setRecentFiles(JMenu jMenu, ActionListener actionListener) {
        if (this.recentList == null) {
            return;
        }
        if (jMenu.getMenuComponentCount() > 0) {
            jMenu.removeAll();
        }
        int n = this.recentList.size() - 1;
        int n2 = Math.min(9, n);
        for (int i = 0; i <= n2; ++i) {
            File file = new File(this.recentList.get(n - i));
            String string = "" + i;
            JMenuItem jMenuItem = new JMenuItem(string + ": " + file.getName());
            jMenuItem.setMnemonic(string.charAt(0));
            jMenuItem.setToolTipText(file.getAbsolutePath());
            jMenuItem.setActionCommand(string);
            jMenuItem.addActionListener(actionListener);
            jMenu.add(jMenuItem);
        }
    }

    public String getRecentFileName(int n) {
        return this.recentList.get(this.recentList.size() - 1 - n);
    }

    public void clearRecentList() {
        this.recentList.clear();
    }

    public String getDefaultDirectory() {
        return this.getProperty("directory");
    }

    public void setDefaultDirectory(String string) {
        if (string != null) {
            this.setProperty("directory", string);
        }
    }

    public String getDefaultDirectorySetting() {
        return this.getProperty("directory.setting");
    }

    public void setDefaultDirectorySetting(String string) {
        if (string != null) {
            this.setProperty("directory.setting", string);
        }
    }

    public void setDefaultHomeDir() {
        this.setDefaultDirectorySetting("home");
    }

    public void setDefaultLastDir() {
        this.setDefaultDirectorySetting("last");
    }

    public void setDefaultCustomDir(String string) {
        if (string == null) {
            this.setDefaultDirectorySetting("last");
        } else {
            this.setDefaultDirectorySetting("custom");
            this.setDefaultDirectory(string);
        }
    }

    public String getPdfViewer() {
        return this.getProperty("pdfviewer");
    }

    public void setPdfViewer(String string) {
        if (string == null) {
            this.setProperty("pdfviewer", "");
        } else {
            this.setProperty("pdfviewer", string);
        }
    }

    public int getToolBarOrientation() {
        String string = this.getProperty("toolbarorient");
        if (string == null) {
            return 0;
        }
        try {
            return Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            return 0;
        }
    }

    public void setToolBarOrientation(int n) {
        this.setProperty("toolbarorient", "" + n);
    }

    public String getToolBarPosition() {
        String string = this.getProperty("toolbarpos");
        return string == null ? "North" : string;
    }

    public void setToolBarPosition(String string) {
        if (string == null) {
            this.setProperty("toolbarpos", "North");
        } else {
            this.setProperty("toolbarpos", string);
        }
    }

    public String getICCFile() {
        return this.getProperty("iccfile");
    }

    public void setICCFile(String string) {
        this.setProperty("iccfile", string);
    }

    public String getGSApp() {
        return this.getProperty("gs");
    }

    public void setGSApp(String string) {
        this.setProperty("gs", string);
    }

    public String getPDFViewer() {
        return this.getProperty("pdfviewer");
    }

    public void setPDFViewer(String string) {
        this.setProperty("pdfviewer", string);
    }

    public String getProfile() {
        String string = this.getProperty("profile");
        if (string == null) {
            string = "gray";
        }
        if (!string.equals("gray") && !string.equals("cmyk")) {
            throw new IllegalArgumentException("Invalid profile '" + string + "'");
        }
        return string;
    }

    public boolean isUseICC() {
        return Boolean.parseBoolean(this.getProperty("useicc", this.isGrayProfile() ? "false" : "true"));
    }

    public void setUseICC(boolean bl) {
        this.setProperty("useicc", bl ? "true" : "false");
    }

    public boolean isGrayProfile() {
        return this.getProfile().equals("gray");
    }

    public boolean isCMYKProfile() {
        return this.getProfile().equals("cmyk");
    }

    public void setProfile(String string) {
        if (!string.equals("gray") && !string.equals("cmyk")) {
            throw new IllegalArgumentException("Invalid profile '" + string + "'");
        }
        this.setProperty("profile", string);
    }

    public long getMaxProcessTime() {
        String string = this.getProperty("timeout");
        long l = 10800000L;
        if (string != null) {
            try {
                l = Long.parseLong(string);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return l;
    }

    public void setMaxProcessTime(long l) {
        if (l <= 0L) {
            throw new IllegalArgumentException("Illegal process timeout value '" + l + "'");
        }
        this.setProperty("timeout", "" + l);
    }
}

