package com.dickimawbooks.jmakepdfx;

import java.io.*;
import java.awt.*;
import java.awt.event.*;

import javax.swing.*;

public class IccSelector extends JDialog
   implements ActionListener
{
   public IccSelector(Jmakepdfx application)
   {
      super(application, application.getLabel("iccselect.title"), true);

      JTextArea textArea = new JTextArea(app.getLabel("properties.fetch_icc.info"));
      textArea.setEditable(false);
      textArea.setLineWrap(true);
      textArea.setWrapStyleWord(true);

      getContentPane().add(textArea, "North");

      Box mainPanel = Box.createHorizontalBox();

      JLabel label = new JLabel(app.getLabel("properties.path.icc"));
      label.setDisplayedMnemonic(app.getMnemonic("properties.path.icc"));

      mainPanel.add(label);

      fileChooser = new JFileChooser();

      fileField = new FileField(this, fileChooser);

      mainPanel.add(fileField);

      JButton fetchButton = new JButton(app.getLabel("properties.fetch_icc"));
      fetchButton.setMnemonic(app.getMnemonic("properties.fetch_icc"));
      fetchButton.setActionCommand("fetchicc");
      fetchButton.addActionListener(this);

      mainPanel.add(fetchButton);

      getContentPane().add(mainPanel, "Center");

      JPanel buttonPanel = new JPanel();
      add(buttonPanel, "South");

      buttonPanel.add(JpdfxResources.createOkayButton(this));
      buttonPanel.add(JpdfxResources.createCancelButton(this));

      pack();
      Dimension dim = getSize();

      dim.width += 50;
      dim.height += 10;

      setSize(dim);

      setLocationRelativeTo(application);
   }

   public void actionPerformed(ActionEvent evt)
   {
      String action = evt.getActionCommand();

      if (action == null) return;

      if (action.equals("choose"))
      {
         if (fileChooser.showOpenDialog(this)
           == JFileChooser.APPROVE_OPTION)
         {
            fileField.setFileName(fileChooser.getSelectedFile().getAbsolutePath());
         }
      }
      else if (action.equals("fetchicc"))
      {
         try
         {
            File file = app.fetchICCFile();

            if (file != null)
            {
               fileField.setFileName(file.getAbsolutePath());
            }
         }
         catch (Exception e)
         {
            app.error(e);
         }
      }
      else if (action.equals("okay"))
      {
         selectedFile = fileField.getFile();

         if (selectedFile == null || selectedFile.equals(""))
         {
            JpdfxResources.error(this,
               Jmakepdfx.getLabel("error.no_file"));
         }
         else
         {
            setVisible(false);
         }
      }
      else if (action.equals("cancel"))
      {
         setVisible(false);
      }
   }

   public File fetchPath()
   {
      setVisible(true);

      return selectedFile;
   }

   private File selectedFile = null;

   private FileField fileField;

   private JFileChooser fileChooser;
   
   private Jmakepdfx app;

}
