import java.io.*;
import java.awt.*;

/*
 * Constants.java
 *
 * Created on 14. Oktober 2005, 9:04
 */

/**
 *
 * This class class manages settings and defaults as well as constants.
 *
 * @author  Olle Nebendahl
 */

class Constants 
{
    //static final int NEW=0;
    //static final int LOAD=1;
    //static final int EMPTY=2;
    
    static boolean DBG = false;
    static boolean redundantOrder = true;
    static boolean prefTagOrCommand = false;
        
    static final int NO_SLIDE_ID=-1;
    static final int NO_TALK_ID=-1;
    static final int SEARCH_REFINE=0;
    static final int SEARCH_EXCLUDE=1;
    static final int SEARCH_ADD=2;
    
    static final String DESKEY="01234567";
    
    private static final String INITFILE="SlidePool.ini";
    
    static String DBDriverName;
    static String DBMS;
    static String DBName;
    static String DBUser;
    static String DBUserPwd;
    
    static String DBURL; //will be connected DBMS+"/"+DBName
    
    static Point mainWindowCoordinates = new Point(58,58);
    static Point prefSlideCommandsGUICoordinates = new Point(58,58);
    static Point prefPathGUICoordinates = new Point(58,58);
    
    static Point prefSlidePoolCoordinates = new Point(58,58);
    static Point prefFoundGUICoordinates = new Point(58,58);
    static Point prefWorkingGUICoordinates = new Point(58,58);
    static Point prefSearchGUICoordinates = new Point(58,58);
    static Point prefSlideEditGUICoordinates = new Point(58,58);
    static Point prefAddTalkGUICoordinates = new Point(58,58);
    static Point prefTalkEditGUICoordinates = new Point(58,58);
    static Point prefTalkListGUICoordinates = new Point(58,58);
    
    
    
    static String prefLastOpenDir = new String(".");
    static String lastSearch = new String("enter search here");
    static TagRepresentation prefTag = new TagRepresentation("\\begin{slides}","\\end{slides}");
    static CommandRepresentation prefCommand = new CommandRepresentation(2,"\\createslide",2,1);
    
    static boolean savePreferences()
    {
        StringBuffer preferences = new StringBuffer();
        Double d;
        d =mainWindowCoordinates.getX();
        preferences.append(d.toString());preferences.append('\n');
        d =mainWindowCoordinates.getY();
        preferences.append(d.toString());preferences.append('\n');
        preferences.append("% It is unwise to alter this file unless You know, what You do.");
        preferences.append('\n');
        d =prefSlideCommandsGUICoordinates.getX();
        preferences.append(d.toString());preferences.append('\n');
        d =prefSlideCommandsGUICoordinates.getY();
        preferences.append(d.toString());preferences.append('\n');
        d =prefPathGUICoordinates.getX();
        preferences.append(d.toString());preferences.append('\n');
        d =prefPathGUICoordinates.getY();
        preferences.append(d.toString());preferences.append('\n');
        
        d =prefSlidePoolCoordinates.getX();
        preferences.append(d.toString());preferences.append('\n');
        d =prefSlidePoolCoordinates.getY();
        preferences.append(d.toString());preferences.append('\n');
        d =prefFoundGUICoordinates.getX();
        preferences.append(d.toString());preferences.append('\n');
        d =prefFoundGUICoordinates.getY();
        preferences.append(d.toString());preferences.append('\n');
        d =prefSearchGUICoordinates.getX();
        preferences.append(d.toString());preferences.append('\n');
        d =prefSearchGUICoordinates.getY();
        preferences.append(d.toString());preferences.append('\n');
        d =prefSlideEditGUICoordinates.getX();
        preferences.append(d.toString());preferences.append('\n');
        d =prefSlideEditGUICoordinates.getY();
        preferences.append(d.toString());preferences.append('\n');
        preferences.append(prefLastOpenDir);preferences.append('\n');
        preferences.append(prefCommand);preferences.append('\n');
        preferences.append(prefTag);
        preferences.append(redundantOrder);preferences.append('\n');
        preferences.append(prefTagOrCommand);preferences.append('\n');

        d =prefAddTalkGUICoordinates.getX();
        preferences.append(d.toString());preferences.append('\n');
        d =prefAddTalkGUICoordinates.getY();
        preferences.append(d.toString());preferences.append('\n');

        d =prefTalkEditGUICoordinates.getX();
        preferences.append(d.toString());preferences.append('\n');
        d =prefTalkEditGUICoordinates.getY();
        preferences.append(d.toString());preferences.append('\n');
        
        d =prefTalkListGUICoordinates.getX();
        preferences.append(d.toString());preferences.append('\n');
        d =prefTalkListGUICoordinates.getY();
        preferences.append(d.toString());preferences.append('\n');


        d =prefWorkingGUICoordinates.getX();
        preferences.append(d.toString());preferences.append('\n');
        d =prefWorkingGUICoordinates.getY();
        preferences.append(d.toString());preferences.append('\n');
        preferences.append(lastSearch);preferences.append('\n');
        
        return FOS.writeToFile("preferences.ini",preferences.toString());
    }
    
    static boolean loadPreferences()
    {
        String loaded=FOS.readFromFileWithoutTexComments("preferences.ini");
        if(null==loaded)return false;
  
        String[] preferences = loaded.split("\n");
        try
        {
            int i = 0;
            String s1; String s2;
            mainWindowCoordinates.setLocation(new Double(preferences[i++]),new Double(preferences[i++]));
            while(preferences[i].equals(""))i++;
            prefSlideCommandsGUICoordinates.setLocation(new Double(preferences[i++]),new Double(preferences[i++]));
            while(preferences[i].equals(""))i++;
            prefPathGUICoordinates.setLocation(new Double(preferences[i++]),new Double(preferences[i++]));
            while(preferences[i].equals(""))i++;
            prefSlidePoolCoordinates.setLocation(new Double(preferences[i++]),new Double(preferences[i++]));
            while(preferences[i].equals(""))i++;
            prefFoundGUICoordinates.setLocation(new Double(preferences[i++]),new Double(preferences[i++]));
            while(preferences[i].equals(""))i++;
            prefSearchGUICoordinates.setLocation(new Double(preferences[i++]),new Double(preferences[i++]));
            while(preferences[i].equals(""))i++;
            prefSlideEditGUICoordinates.setLocation(new Double(preferences[i++]),new Double(preferences[i++]));
            prefLastOpenDir=preferences[i++];
            prefCommand=new CommandRepresentation(preferences[i++]);
            s1=preferences[i++];
            s2=preferences[i++];
            prefTag=new TagRepresentation(s1,s2);
            redundantOrder=  Boolean.valueOf(preferences[i++]).booleanValue();
            prefTagOrCommand=  Boolean.valueOf(preferences[i++]).booleanValue();
            prefAddTalkGUICoordinates.setLocation(new Double(preferences[i++]),new Double(preferences[i++]));
            prefTalkEditGUICoordinates.setLocation(new Double(preferences[i++]),new Double(preferences[i++]));
            prefTalkListGUICoordinates.setLocation(new Double(preferences[i++]),new Double(preferences[i++]));
            prefWorkingGUICoordinates.setLocation(new Double(preferences[i++]),new Double(preferences[i++]));
            lastSearch=preferences[i++];
            
        }
        catch (Exception e)
        {
            Logger.logSevere("Constants.loadPreferences()"+e);
            return false;
        }
        return true;
    }
  
  static boolean getDBaccessData()
  {
    try
    {
        String[] DBaccessData = DES.readDESfromFile(INITFILE).split("\n");
        int i=0;
        DBDriverName=DBaccessData[0];
        DBMS=DBaccessData[1];
        DBName=DBaccessData[2];
        DBUser=DBaccessData[3];
        DBUserPwd=DBaccessData[4];
    }
    catch(Exception e)
    {
        System.out.println(e);
        System.out.println("User settings for Data-Bank access cannot be loaded.");
        System.out.println("Check presence of file \""+INITFILE+"\".");
        return false;
    }
    return true;
  }
  
    protected void finalize() throws Throwable 
    {
        try 
        {
            savePreferences();
        } finally 
        {
            super.finalize();
        }
    }  

    
    static
    {
        if(!getDBaccessData())  
        {
            DBDriverName="org.gjt.mm.mysql.Driver" ;
            DBMS="jdbc:mysql://localhost:3306/";
            DBName="test1";
            DBUser="peter";
            DBUserPwd="jpd0815";
        }
        DBURL=DBMS+DBName;
        loadPreferences();
    }
    
    public static void main(String[] a)
    {
        System.out.println(Constants.prefCommand);
        savePreferences();
    }
}
