# NVIDIA Nsight Systems GUI WebRTC container

Self-isolated Docker container for accessing NVIDIA Nsight Systems through browser using WebRTC.

## Prerequisites

* x86_64 Linux [compaitable with NVIDIA Nsight Systems](https://docs.nvidia.com/nsight-systems/InstallationGuide/index.html#supported-platforms)

* [Docker](https://docs.docker.com/engine/install/)
  
* Internet access for downloading Ubuntu packages inside the container.

## Build

To build the docker container use the follwing command:

    $ sudo ./build.sh

The above command will create a docker image, which can be run using `run.sh`

### Additional docker build arguments

Additional [docker build](https://docs.docker.com/engine/reference/commandline/build/) arguments may be passed to the `build.sh`. For example:

    $ sudo ./build.sh --network=host

## Run

To run the docker container the command below can be used:

    $ sudo ./run.sh

At the end of `run.sh` it will provide you with an URL to connect to the WebRTC client. It will look something like: http://$HOST_IP:8080/. You can use this address in your browser to access Nsight Systems user interface.

### Additional docker run arguments

Additional [docker run](https://docs.docker.com/engine/reference/commandline/run/) arguments may be passed to the run.sh. These argument can be used to mount host directories with NVIDIA Nsight Systems reports to the docker container. For example:

    $ sudo ./run.sh -v $HOME:/mnt/host/home -v /myawesomereports:/mnt/host/myawesomereports


### Runtime environment variables

Can be used to configure runtime parameters.

| Variable       | Description                                                                                                                           | Default value                                           |
| :------------- | :------------------------------------------------------------------------------------------------------------------------------------ | :------------------------------------------------------ |
| HOST_IP        | IP of the server that will be sent to client. This IP should be accessible from the client side to establish client/server connection | The IP address of the first available network interface |
| HTTP_PORT      | TCP port for HTTP access to Nsight System user interface                                                                              | 8080                                                    |
| MEDIA_PORT     | TCP port that will be used for WebRTC data transmission                                                                               | 3478                                                    |  |
| SCREEN         | Resolution of the screen used for rendering. Only 1920x1080, 1280x720, 1152x648, 1024x576, 960x720, 800x600 are currently supported   | 1920x1080                                               |
| CONTAINER_NAME | Name which will be assigned to a running container                                                                                    | nvidia-devtools-streamer-nsys                           |


### Volumes

List of usefull internal Docker folders:

| Docker folder  | Purpose                          | Description                                        |
| :------------- | :------------------------------- | :------------------------------------------------- |
| /mnt/host/logs | Folder with Docker services logs | May be useful to send reports to NVIDIA developers |

### Examples

To run the container on 10.10.10.10 network interface, using 8000 HTTP port, 3479 media port:

    $ sudo HOST_IP=10.10.10.10 HTTP_PORT=8000 MEDIA_PORT=3479 ./run.sh

## Stop

To stop the docker container the command below can be used:

    $ sudo ./stop.sh

If the `CONTAINER_NAME`` environment variable was used to specify the name of a container during its start-up, the same variable should also be used when issuing the command to stop the container.
