/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.config.migration.wizards.pgadmin;

import java.io.File;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.config.migration.ImportConfigMessages;
import org.jkiss.dbeaver.ui.controls.TextWithOpenFile;

public class ConfigImportWizardPagePgAdminSettings
extends WizardPage {
    private TextWithOpenFile filePathText;
    private File inputFile;

    protected ConfigImportWizardPagePgAdminSettings() {
        super(ImportConfigMessages.config_import_wizard_custom_driver_settings);
        this.setTitle(ImportConfigMessages.config_import_wizard_custom_driver_import_settings_name);
        this.setDescription(ImportConfigMessages.config_import_wizard_pgadmin_description);
    }

    public void createControl(@NotNull Composite parent) {
        Composite placeholder = UIUtils.createPlaceholder((Composite)parent, (int)1);
        UIUtils.createControlLabel((Composite)placeholder, (String)ImportConfigMessages.config_import_wizard_custom_input_file);
        this.filePathText = new TextWithOpenFile(placeholder, ImportConfigMessages.config_import_wizard_custom_input_file_configuration, new String[]{"*.json"});
        this.filePathText.setLayoutData((Object)new GridData(768));
        this.setInputFileAndUpdateButtons();
        this.filePathText.getTextControl().addModifyListener(e -> this.setInputFileAndUpdateButtons());
        this.setControl((Control)placeholder);
    }

    public boolean isPageComplete() {
        return this.inputFile != null && this.inputFile.exists();
    }

    @NotNull
    public File getInputFile() {
        return this.inputFile;
    }

    private void setInputFileAndUpdateButtons() {
        if (this.filePathText.getText().isBlank()) {
            return;
        }
        this.inputFile = new File(this.filePathText.getText());
        if (!this.inputFile.exists()) {
            this.setErrorMessage(NLS.bind((String)ImportConfigMessages.config_import_wizard_file_doesnt_exist_error, (Object)this.inputFile.getAbsolutePath()));
        } else {
            this.setErrorMessage(null);
            this.getWizard().getContainer().updateButtons();
        }
    }
}

