/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.editors.content;

import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IPropertyListener;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.EditorPart;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.ui.IActiveWorkbenchPart;
import org.jkiss.dbeaver.ui.IRefreshablePart;
import org.jkiss.dbeaver.ui.UIUtils;

public class ContentPagePart
extends EditorPart
implements IPropertyListener,
IActiveWorkbenchPart,
IRefreshablePart,
IAdaptable {
    private final IEditorPart editorPart;
    private Composite composite;
    private boolean activated;

    public ContentPagePart(@NotNull IEditorPart editorPart) {
        this.editorPart = editorPart;
        this.editorPart.addPropertyListener((IPropertyListener)this);
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        this.setSite((IWorkbenchPartSite)site);
        this.setInput(input);
    }

    public void createPartControl(Composite composite) {
        this.composite = composite;
    }

    public void doSave(IProgressMonitor monitor) {
        if (this.activated) {
            this.editorPart.doSave(monitor);
        }
    }

    public void doSaveAs() {
        if (this.activated) {
            this.editorPart.doSaveAs();
        }
    }

    public boolean isDirty() {
        return this.activated && this.editorPart.isDirty();
    }

    public boolean isSaveAsAllowed() {
        return this.activated && this.editorPart.isSaveAsAllowed();
    }

    public void setFocus() {
        if (this.activated) {
            this.editorPart.setFocus();
        }
    }

    public String getTitle() {
        return this.editorPart.getTitle();
    }

    public String getTitleToolTip() {
        return this.editorPart.getTitleToolTip();
    }

    public Image getTitleImage() {
        return this.editorPart.getTitleImage();
    }

    public IRefreshablePart.RefreshResult refreshPart(Object source, boolean force) {
        if (this.activated && this.editorPart instanceof IRefreshablePart) {
            return ((IRefreshablePart)this.editorPart).refreshPart(source, force);
        }
        return IRefreshablePart.RefreshResult.IGNORED;
    }

    public void activatePart() {
        if (!this.activated) {
            try {
                try {
                    this.createRealPart();
                }
                catch (PartInitException e) {
                    throw new IllegalStateException("Error initializing real editor part", e);
                }
            }
            finally {
                this.activated = true;
            }
        }
    }

    public void deactivatePart() {
    }

    public void propertyChanged(Object source, int propId) {
        this.firePropertyChange(propId);
    }

    public void dispose() {
        this.editorPart.removePropertyListener((IPropertyListener)this);
        this.editorPart.dispose();
        super.dispose();
    }

    private void createRealPart() throws PartInitException {
        UIUtils.disposeChildControls((Composite)this.composite);
        this.editorPart.init((IEditorSite)this.getSite(), this.getEditorInput());
        this.editorPart.createPartControl(this.composite);
        this.composite.layout(true, true);
    }

    public <T> T getAdapter(Class<T> adapter) {
        return (T)this.editorPart.getAdapter(adapter);
    }
}

