/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.preference;

import org.eclipse.jface.preference.IPreferenceNode;
import org.eclipse.jface.preference.PreferenceManager;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;

public class PreferenceContentProvider
implements ITreeContentProvider {
    private PreferenceManager manager;

    @Override
    public void dispose() {
        this.manager = null;
    }

    private IPreferenceNode findParent(IPreferenceNode parent, IPreferenceNode target) {
        IPreferenceNode[] children;
        if (parent.getId().equals(target.getId())) {
            return null;
        }
        IPreferenceNode found = parent.findSubNode(target.getId());
        if (found != null) {
            return parent;
        }
        IPreferenceNode[] iPreferenceNodeArray = children = parent.getSubNodes();
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            IPreferenceNode element = iPreferenceNodeArray[n2];
            found = this.findParent(element, target);
            if (found != null) {
                return found;
            }
            ++n2;
        }
        return null;
    }

    @Override
    public Object[] getChildren(Object parentElement) {
        return ((IPreferenceNode)parentElement).getSubNodes();
    }

    @Override
    public Object[] getElements(Object inputElement) {
        return this.getChildren(((PreferenceManager)inputElement).getRoot());
    }

    @Override
    public Object getParent(Object element) {
        IPreferenceNode targetNode = (IPreferenceNode)element;
        IPreferenceNode root = this.manager.getRoot();
        return this.findParent(root, targetNode);
    }

    @Override
    public boolean hasChildren(Object element) {
        return this.getChildren(element).length > 0;
    }

    @Override
    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        this.manager = (PreferenceManager)newInput;
    }

    protected void setManager(PreferenceManager manager) {
        this.manager = manager;
    }
}

