"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || (function () {
    var ownKeys = function(o) {
        ownKeys = Object.getOwnPropertyNames || function (o) {
            var ar = [];
            for (var k in o) if (Object.prototype.hasOwnProperty.call(o, k)) ar[ar.length] = k;
            return ar;
        };
        return ownKeys(o);
    };
    return function (mod) {
        if (mod && mod.__esModule) return mod;
        var result = {};
        if (mod != null) for (var k = ownKeys(mod), i = 0; i < k.length; i++) if (k[i] !== "default") __createBinding(result, mod, k[i]);
        __setModuleDefault(result, mod);
        return result;
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
exports.definitions = void 0;
const fz = __importStar(require("../converters/fromZigbee"));
const exposes = __importStar(require("../lib/exposes"));
const legacy = __importStar(require("../lib/legacy"));
const m = __importStar(require("../lib/modernExtend"));
const reporting = __importStar(require("../lib/reporting"));
const tuya = __importStar(require("../lib/tuya"));
const e = exposes.presets;
const ea = exposes.access;
exports.definitions = [
    {
        fingerprint: tuya.fingerprint("TS0601", ["_TZE284_sonkaxrd"]),
        model: "E12",
        vendor: "Nous",
        description: "Carbon monoxide alarm",
        extend: [tuya.modernExtend.tuyaBase({ dp: true })],
        exposes: [
            e.carbon_monoxide().withDescription("Indicates if CO level and exposure time are above safety limits, triggering the alarm"),
            e.numeric("carbon_monoxide_value", ea.STATE).withUnit("ppm").withDescription("Current CO concentration"),
            e.binary("warming_up", ea.STATE, true, false).withDescription("Sensor preheating status: Takes 120 to complete after power on"),
            e
                .enum("test", ea.STATE_SET, ["test"])
                .withDescription("Triggers the self-checking process: Beeps 4 times and takes 20 seconds to complete")
                .withLabel("Test device"),
            e.binary("testing", ea.STATE, true, false).withDescription("Indicates if self-checking is currently running"),
            e.binary("fault", ea.STATE, true, false).withDescription("Sensor fault indicator"),
            e
                .binary("end_of_life", ea.STATE, true, false)
                .withDescription("Indicates whether the sensor is past its certified service life (10 years) and should be replaced"),
            tuya.exposes.batteryState(),
        ],
        meta: {
            tuyaDatapoints: [
                // co_status
                [1, "carbon_monoxide", tuya.valueConverter.trueFalseEnum0],
                // co_value
                [2, "carbon_monoxide_value", tuya.valueConverter.raw],
                // self_checking
                [8, "test", tuya.valueConverterBasic.lookup({ test: true, idle: false })],
                // checking_result
                [9, "testing", tuya.valueConverter.trueFalseEnum0],
                // preheat
                [10, "warming_up", tuya.valueConverter.raw],
                // fault - bitmap, no info from Tuya
                [
                    11,
                    "fault",
                    {
                        from: (v) => !!v,
                    },
                ],
                // lifecycle
                [12, "end_of_life", tuya.valueConverter.trueFalseInvert],
                [14, "battery_state", tuya.valueConverter.batteryState],
            ],
        },
    },
    {
        fingerprint: tuya.fingerprint("TS0601", ["_TZE284_1di7ujzp"]),
        model: "E13",
        vendor: "Nous",
        description: "Water leakage or shortage sensor with sound alarm",
        extend: [tuya.modernExtend.tuyaBase({ dp: true })],
        exposes: [
            e.water(),
            e.water_leak().withDescription("Indicates whether the device detected a water leak and the buzzer is ringing"),
            e
                .enum("alarm_mode", ea.STATE_SET, ["water_presence", "water_absence"])
                .withDescription("When to consider a water leak and sound the alarm")
                .withCategory("config"),
            e
                .enum("ringtone", ea.STATE_SET, ["muted", "tone_1", "tone_2", "tone_3"])
                .withDescription("Selected buzzer ringtone for the alarm")
                .withCategory("config"),
            e.battery(),
        ],
        meta: {
            tuyaDatapoints: [
                [1, "water", tuya.valueConverter.trueFalse1],
                [4, "battery", tuya.valueConverter.raw],
                [
                    101,
                    "alarm_mode",
                    tuya.valueConverterBasic.lookup({
                        water_presence: tuya.enum(0),
                        water_absence: tuya.enum(1),
                    }),
                ],
                [102, "water_leak", tuya.valueConverter.trueFalse1],
                [
                    103,
                    "ringtone",
                    tuya.valueConverterBasic.lookup({
                        muted: tuya.enum(0),
                        tone_1: tuya.enum(1),
                        tone_2: tuya.enum(2),
                        tone_3: tuya.enum(3),
                    }),
                ],
            ],
        },
    },
    {
        fingerprint: tuya.fingerprint("TS0201", ["_TZ3000_lbtpiody"]),
        model: "E5",
        vendor: "Nous",
        description: "Temperature & humidity",
        fromZigbee: [fz.temperature, fz.humidity],
        exposes: [e.temperature(), e.humidity()],
        extend: [m.battery()],
    },
    {
        fingerprint: tuya.fingerprint("TS0601", [
            "_TZE200_lve3dvpy",
            "_TZE200_c7emyjom",
            "_TZE200_locansqn",
            "_TZE200_qrztc3ev",
            "_TZE200_snloy4rw",
            "_TZE200_eanjj2pa",
            "_TZE200_ydrdfkim",
            "_TZE284_locansqn",
        ]),
        model: "SZ-T04",
        vendor: "Nous",
        whiteLabel: [tuya.whitelabel("Tuya", "TH01Z", "Temperature and humidity sensor with clock", ["_TZE200_locansqn"])],
        description: "Temperature and humidity sensor with clock",
        fromZigbee: [legacy.fz.nous_lcd_temperature_humidity_sensor, fz.ignore_tuya_set_time],
        toZigbee: [legacy.tz.nous_lcd_temperature_humidity_sensor],
        extend: [tuya.modernExtend.tuyaBase({ forceTimeUpdates: true, timeStart: "1970" })],
        configure: async (device, coordinatorEndpoint) => {
            const endpoint = device.getEndpoint(1);
            await reporting.bind(endpoint, coordinatorEndpoint, ["genBasic"]);
        },
        exposes: [
            e.temperature(),
            e.humidity(),
            e.battery(),
            e
                .numeric("temperature_report_interval", ea.STATE_SET)
                .withUnit("min")
                .withValueMin(5)
                .withValueMax(120)
                .withValueStep(5)
                .withDescription("Temperature Report interval"),
            e
                .numeric("humidity_report_interval", ea.STATE_SET)
                .withUnit("min")
                .withValueMin(5)
                .withValueMax(120)
                .withValueStep(5)
                .withDescription("Humidity Report interval"),
            e.enum("temperature_unit_convert", ea.STATE_SET, ["celsius", "fahrenheit"]).withDescription("Current display unit"),
            e.enum("temperature_alarm", ea.STATE, ["canceled", "lower_alarm", "upper_alarm"]).withDescription("Temperature alarm status"),
            e.numeric("max_temperature", ea.STATE_SET).withUnit("°C").withValueMin(-20).withValueMax(60).withDescription("Alarm temperature max"),
            e.numeric("min_temperature", ea.STATE_SET).withUnit("°C").withValueMin(-20).withValueMax(60).withDescription("Alarm temperature min"),
            e
                .numeric("temperature_sensitivity", ea.STATE_SET)
                .withUnit("°C")
                .withValueMin(0.1)
                .withValueMax(50)
                .withValueStep(0.1)
                .withDescription("Temperature sensitivity"),
            e.enum("humidity_alarm", ea.STATE, ["canceled", "lower_alarm", "upper_alarm"]).withDescription("Humidity alarm status"),
            e.numeric("max_humidity", ea.STATE_SET).withUnit("%").withValueMin(0).withValueMax(100).withDescription("Alarm humidity max"),
            e.numeric("min_humidity", ea.STATE_SET).withUnit("%").withValueMin(0).withValueMax(100).withDescription("Alarm humidity min"),
            e
                .numeric("humidity_sensitivity", ea.STATE_SET)
                .withUnit("%")
                .withValueMin(1)
                .withValueMax(100)
                .withValueStep(1)
                .withDescription("Humidity sensitivity"),
        ],
    },
    {
        fingerprint: tuya.fingerprint("TS0601", ["_TZE284_wtikaxzs", "_TZE200_nnrfa68v", "_TZE200_zppcgbdj", "_TZE200_wtikaxzs"]),
        model: "E6",
        vendor: "Nous",
        description: "Temperature & humidity LCD sensor",
        fromZigbee: [legacy.fz.nous_lcd_temperature_humidity_sensor, fz.ignore_tuya_set_time],
        toZigbee: [legacy.tz.nous_lcd_temperature_humidity_sensor],
        extend: [tuya.modernExtend.tuyaBase({ forceTimeUpdates: true, bindBasicOnConfigure: true, timeStart: "1970" })],
        exposes: [
            e.temperature(),
            e.humidity(),
            e.battery(),
            e.battery_low(),
            e.enum("temperature_unit_convert", ea.STATE_SET, ["celsius", "fahrenheit"]).withDescription("Current display unit"),
            e.enum("temperature_alarm", ea.STATE, ["canceled", "lower_alarm", "upper_alarm"]).withDescription("Temperature alarm status"),
            e.numeric("max_temperature", ea.STATE_SET).withUnit("°C").withValueMin(-20).withValueMax(60).withDescription("Alarm temperature max"),
            e.numeric("min_temperature", ea.STATE_SET).withUnit("°C").withValueMin(-20).withValueMax(60).withDescription("Alarm temperature min"),
            e.enum("humidity_alarm", ea.STATE, ["canceled", "lower_alarm", "upper_alarm"]).withDescription("Humidity alarm status"),
            e.numeric("max_humidity", ea.STATE_SET).withUnit("%").withValueMin(1).withValueMax(100).withDescription("Alarm humidity max"),
            e.numeric("min_humidity", ea.STATE_SET).withUnit("%").withValueMin(1).withValueMax(100).withDescription("Alarm humidity min"),
            e
                .numeric("temperature_sensitivity", ea.STATE_SET)
                .withUnit("°C")
                .withValueMin(0.1)
                .withValueMax(50)
                .withValueStep(0.1)
                .withDescription("Temperature sensitivity"),
            e
                .numeric("temperature_report_interval", ea.STATE_SET)
                .withUnit("min")
                .withValueMin(1)
                .withValueMax(120)
                .withValueStep(1)
                .withDescription("Temperature Report interval"),
            e
                .numeric("humidity_sensitivity", ea.STATE_SET)
                .withUnit("%")
                .withValueMin(1)
                .withValueMax(100)
                .withValueStep(1)
                .withDescription("Humidity sensitivity"),
        ],
    },
    {
        fingerprint: tuya.fingerprint("TS0601", ["_TZE204_qvxrkeif"]),
        model: "E9",
        vendor: "Nous",
        description: "Zigbee gas sensor",
        extend: [tuya.modernExtend.tuyaBase({ dp: true })],
        exposes: [
            e.gas(),
            e.binary("preheat", ea.STATE, true, false).withDescription("Indicates sensor preheat is active"),
            tuya.exposes.faultAlarm(),
            e.binary("lifecycle", ea.STATE, true, false).withDescription("Sensor lifetime limit"),
        ],
        meta: {
            tuyaDatapoints: [
                [1, "gas", tuya.valueConverter.trueFalse0],
                [10, "preheat", tuya.valueConverter.raw],
                [11, "fault_alarm", tuya.valueConverter.trueFalse1],
                [12, "lifecycle", tuya.valueConverter.trueFalse0],
            ],
        },
    },
    {
        fingerprint: tuya.fingerprint("TS0601", ["_TZE204_t9ffmdin"]),
        model: "D5Z",
        vendor: "Nous",
        description: "Zigbee smart energy meter with leakage and prepayment",
        extend: [tuya.modernExtend.tuyaBase({ dp: true })],
        exposes: [
            e.energy(),
            e.produced_energy(),
            e.current(),
            e.temperature(),
            e.numeric("leakage_current", ea.STATE).withUnit("mA").withDescription("Leakage current"),
            e.switch().withDescription("Relay switch control"),
            e.binary("reclosing_enable", ea.ALL, true, false).withDescription("Reclosing enable"),
            e.numeric("timer", ea.ALL).withDescription("Timer (schedule control in seconds)").withValueMin(0).withValueMax(86400),
            e.text("cycle_schedule", ea.ALL).withDescription("Cycle schedule configuration (JSON string)"),
            e.binary("clear_energy", ea.SET, true, false).withDescription("Clear accumulated forward and reverse energy"),
            e.binary("switch_prepayment", ea.STATE_SET, true, false).withDescription("Switch prepayment mode ON/OFF"),
            e.numeric("balance_energy", ea.STATE).withUnit("kWh").withDescription("Remaining energy balance for prepayment"),
            e.numeric("charge_energy", ea.STATE).withUnit("kWh").withDescription("Last charged energy amount"),
            e.binary("fault", ea.STATE, true, false).withDescription("General fault detected"),
            e.text("status", ea.STATE).withDescription("Detailed status information (e.g., fault codes)"),
            e.numeric("reclose_recover_seconds", ea.STATE).withUnit("s").withDescription("Time for auto reclosing recovery"),
            e.numeric("power_on_delay", ea.STATE).withUnit("s").withDescription("Power-on delay time"),
            e.numeric("overcurrent_threshold_time", ea.STATE).withUnit("s").withDescription("Overcurrent event threshold time"),
            e.numeric("lost_flow_threshold_time", ea.STATE).withUnit("s").withDescription("Lost flow event threshold time"),
            e.binary("relay_status_on_power_on", ea.STATE, true, false).withDescription("Relay status after power on (true=ON)"),
            e.text("alarm_set_1", ea.ALL).withDescription("Alarm set 1 configuration"),
            e.text("alarm_set_2", ea.ALL).withDescription("Alarm set 2 configuration"),
            e.text("alarm_set_3", ea.ALL).withDescription("Alarm set 3 configuration"),
        ],
        meta: {
            tuyaDatapoints: [
                [1, "energy", tuya.valueConverter.divideBy100],
                [6, "current", tuya.valueConverter.divideBy1000],
                [15, "leakage_current", tuya.valueConverter.divideBy10],
                [110, "produced_energy", tuya.valueConverter.divideBy100],
                [16, "state", tuya.valueConverter.onOff],
                [9, "fault", tuya.valueConverter.trueFalse1],
                [103, "temperature", tuya.valueConverter.raw],
                [104, "reclosing_enable", tuya.valueConverter.trueFalse1],
                [105, "timer", tuya.valueConverter.raw],
                [106, "cycle_schedule", tuya.valueConverter.raw],
                [107, "reclose_recover_seconds", tuya.valueConverter.raw],
                [127, "status", tuya.valueConverter.raw],
                [134, "relay_status_on_power_on", tuya.valueConverter.raw],
                [11, "switch_prepayment", tuya.valueConverter.trueFalse1],
                [12, "clear_energy", tuya.valueConverter.raw],
                [13, "balance_energy", tuya.valueConverter.divideBy100],
                [14, "charge_energy", tuya.valueConverter.divideBy100],
                [17, "alarm_set_1", tuya.valueConverter.raw],
                [18, "alarm_set_2", tuya.valueConverter.raw],
                [119, "power_on_delay", tuya.valueConverter.raw],
                [124, "overcurrent_threshold_time", tuya.valueConverter.raw],
                [125, "lost_flow_threshold_time", tuya.valueConverter.raw],
                [126, "alarm_set_3", tuya.valueConverter.raw],
            ],
        },
    },
    {
        fingerprint: tuya.fingerprint("TS011F", ["_TZ3210_6cmeijtd"]),
        model: "A11Z",
        vendor: "Nous",
        description: "3-channel power strip with total energy monitoring",
        extend: [
            m.deviceEndpoints({ endpoints: { l1: 1, l2: 2, l3: 3 } }),
            tuya.clusters.addTuyaCommonPrivateCluster(),
            tuya.modernExtend.tuyaOnOff({
                powerOnBehavior2: true,
                onOffCountdown: true,
                indicatorMode: true,
                childLock: true,
                switchTypeButton: true,
                endpoints: ["l1", "l2", "l3"],
            }),
            m.electricityMeter({
                current: { divisor: 1000, multiplier: 1 },
                voltage: { divisor: 1, multiplier: 1 },
                power: { divisor: 1, multiplier: 1 },
                energy: { divisor: 100, multiplier: 1 },
                fzElectricalMeasurement: tuya.fz.TS011F_electrical_measurement,
            }),
            m.identify(),
        ],
        meta: {
            multiEndpoint: true,
            multiEndpointSkip: ["energy", "current", "voltage", "power"],
        },
        configure: async (device, coordinatorEndpoint) => {
            await tuya.configureMagicPacket(device, coordinatorEndpoint);
        },
    },
];
//# sourceMappingURL=nous.js.map