//go:build m5paper

package machine

const (
	IO0  = GPIO0
	IO1  = GPIO1
	IO2  = GPIO2
	IO3  = GPIO3
	IO4  = GPIO4
	IO5  = GPIO5
	IO6  = GPIO6
	IO7  = GPIO7
	IO8  = GPIO8
	IO9  = GPIO9
	IO10 = GPIO10
	IO11 = GPIO11
	IO12 = GPIO12
	IO13 = GPIO13
	IO14 = GPIO14
	IO15 = GPIO15
	IO16 = GPIO16
	IO17 = GPIO17
	IO18 = GPIO18
	IO19 = GPIO19
	IO21 = GPIO21
	IO22 = GPIO22
	IO23 = GPIO23
	IO25 = GPIO25
	IO26 = GPIO26
	IO27 = GPIO27
	IO32 = GPIO32
	IO33 = GPIO33
	IO34 = GPIO34
	IO35 = GPIO35
	IO36 = GPIO36
	IO37 = GPIO37
	IO38 = GPIO38
	IO39 = GPIO39
)

const (
	POWER_PIN     = IO2
	EXT_POWER_PIN = IO5
	EPD_POWER_PIN = IO23

	// Buttons
	BUTTON_RIGHT = IO39
	BUTTON_PUSH  = IO38
	BUTTON_LEFT  = IO37
	BUTTON       = BUTTON_PUSH

	// Touch Screen Interrupt
	TOUCH_INT = IO36
)

// SPI pins
const (
	SPI0_SCK_PIN = IO14
	SPI0_SDO_PIN = IO12
	SPI0_SDI_PIN = IO13

	// EPD (IT8951)
	EPD_SCK_PIN  = SPI0_SCK_PIN
	EPD_SDO_PIN  = SPI0_SDO_PIN
	EPD_SDI_PIN  = SPI0_SDI_PIN
	EPD_CS_PIN   = IO15
	EPD_BUSY_PIN = IO27

	// SD CARD
	SDCARD_SCK_PIN = SPI0_SCK_PIN
	SDCARD_SDO_PIN = SPI0_SDO_PIN
	SDCARD_SDI_PIN = SPI0_SDI_PIN
	SDCARD_CS_PIN  = IO4
)

// I2C pins
const (
	SDA0_PIN = IO21
	SCL0_PIN = IO22

	SDA_PIN = SDA0_PIN
	SCL_PIN = SCL0_PIN

	I2C_TEMP_ADDR  = 0x44 // temperature sensor (SHT30)
	I2C_CLOCK_ADDR = 0x51 // real time clock (BM8563)
	I2C_TOUCH_ADDR = 0x5D // touch screen controller (GT911)
)

// ADC pins
const (
	ADC1 Pin = IO35
	ADC2 Pin = IO36

	BATTERY_ADC_PIN = ADC1
)

// DAC pins
const (
	DAC1 Pin = IO25
	DAC2 Pin = IO26
)

// UART pins
const (
	// UART0 (CP2104)
	UART0_TX_PIN = IO1
	UART0_RX_PIN = IO3

	UART_TX_PIN = UART0_TX_PIN
	UART_RX_PIN = UART0_RX_PIN
)
