/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cef;

import com.jetbrains.cef.SharedMemory;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.cef.misc.Utils;

public class SharedMemoryCache {
    private static final int CLEAN_CACHE_TIME_MS = Utils.getInteger("jcef.remote.clean_shmem_cache_time_ms", 10000);
    private static final int CACHE_SIZE = Utils.getInteger("jcef.remote.shmem_cache_size", 2);
    private final Map<String, SharedMemory.WithRaster> myCache = new ConcurrentHashMap<String, SharedMemory.WithRaster>();

    public SharedMemory.WithRaster get(String sharedMemName, long sharedMemHandle) {
        SharedMemory.WithRaster mem = this.myCache.get(sharedMemName);
        if (mem == null) {
            this.cleanCacheIfNecessary();
            mem = new SharedMemory.WithRaster(sharedMemName, sharedMemHandle);
            this.myCache.put(sharedMemName, mem);
        }
        mem.lasUsedMs = System.currentTimeMillis();
        return mem;
    }

    private void cleanCacheIfNecessary() {
        long timeMs = System.currentTimeMillis();
        if (this.myCache.size() < CACHE_SIZE) {
            return;
        }
        ArrayList<String> toRemove = new ArrayList<String>();
        for (Map.Entry<String, SharedMemory.WithRaster> item : this.myCache.entrySet()) {
            if (timeMs - item.getValue().lasUsedMs <= (long)CLEAN_CACHE_TIME_MS) continue;
            toRemove.add(item.getKey());
        }
        for (String name : toRemove) {
            this.myCache.remove(name);
        }
    }
}

