/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.packaging.repository;

import com.intellij.util.io.HttpRequests;
import com.intellij.util.io.RequestBuilder;
import com.jetbrains.python.packaging.repository.PyPackageRepository;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import kotlin.Metadata;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000\u001c\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\u001a\u0016\u0010\u0000\u001a\u00020\u0001*\u00020\u00012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003H\u0001\u001a\f\u0010\u0004\u001a\u00020\u0005*\u00020\u0003H\u0001\u001a\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\u0007H\u0001\u00a8\u0006\n"}, d2={"withBasicAuthorization", "Lcom/intellij/util/io/RequestBuilder;", "repository", "Lcom/jetbrains/python/packaging/repository/PyPackageRepository;", "checkValid", "", "encodeCredentialsForUrl", "", "login", "password", "intellij.python.community.impl"})
@JvmName(name="PyPackageRepositoryUtil")
public final class PyPackageRepositoryUtil {
    @ApiStatus.Experimental
    @NotNull
    public static final RequestBuilder withBasicAuthorization(@NotNull RequestBuilder $this$withBasicAuthorization, @Nullable PyPackageRepository repository) {
        Intrinsics.checkNotNullParameter((Object)$this$withBasicAuthorization, (String)"<this>");
        if (repository == null) {
            return $this$withBasicAuthorization;
        }
        String password = repository.getPassword();
        if (repository.getLogin() != null && password != null) {
            Base64.Encoder encoder = Base64.getEncoder();
            Object object = repository.getLogin() + ":" + password;
            byte[] byArray = ((String)object).getBytes(Charsets.UTF_8);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
            byte[] byArray2 = encoder.encode(byArray);
            Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"encode(...)");
            byte[] byArray3 = byArray2;
            Charset charset = StandardCharsets.UTF_8;
            Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"UTF_8");
            object = charset;
            String credentials = new String(byArray3, (Charset)object);
            $this$withBasicAuthorization.tuner(arg_0 -> PyPackageRepositoryUtil.withBasicAuthorization$lambda$0(credentials, arg_0));
        }
        return $this$withBasicAuthorization;
    }

    @ApiStatus.Experimental
    public static final boolean checkValid(@NotNull PyPackageRepository $this$checkValid) {
        Intrinsics.checkNotNullParameter((Object)$this$checkValid, (String)"<this>");
        String string = $this$checkValid.getRepositoryUrl();
        Intrinsics.checkNotNull((Object)string);
        RequestBuilder requestBuilder = HttpRequests.request((String)string);
        Intrinsics.checkNotNullExpressionValue((Object)requestBuilder, (String)"request(...)");
        return PyPackageRepositoryUtil.withBasicAuthorization(requestBuilder, $this$checkValid).connectTimeout(3000).throwStatusCodeException(false).tryConnect() == 200;
    }

    @ApiStatus.Experimental
    @NotNull
    public static final String encodeCredentialsForUrl(@NotNull String login, @NotNull String password) {
        Intrinsics.checkNotNullParameter((Object)login, (String)"login");
        Intrinsics.checkNotNullParameter((Object)password, (String)"password");
        return URLEncoder.encode(login, StandardCharsets.UTF_8) + ":" + URLEncoder.encode(password, StandardCharsets.UTF_8);
    }

    private static final void withBasicAuthorization$lambda$0(String $credentials, URLConnection connection) {
        Intrinsics.checkNotNullParameter((Object)connection, (String)"connection");
        connection.setRequestProperty("Authorization", "Basic " + $credentials);
    }
}

