/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.opensearch.planner.rules;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import org.apache.calcite.adapter.enumerable.EnumerableProject;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelTrait;
import org.apache.calcite.plan.RelTraitDef;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.plan.volcano.AbstractConverter;
import org.apache.calcite.plan.volcano.RelSubset;
import org.apache.calcite.rel.RelCollation;
import org.apache.calcite.rel.RelCollationTraitDef;
import org.apache.calcite.rel.RelFieldCollation;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.Project;
import org.apache.calcite.rex.RexNode;
import org.apache.commons.lang3.tuple.Pair;
import org.immutables.value.Value;
import org.opensearch.sql.calcite.plan.rule.OpenSearchRuleConfig;
import org.opensearch.sql.calcite.utils.PlanUtils;
import org.opensearch.sql.opensearch.planner.rules.ImmutableExpandCollationOnProjectExprRule;
import org.opensearch.sql.opensearch.planner.rules.InterruptibleRelRule;
import org.opensearch.sql.opensearch.storage.scan.CalciteEnumerableIndexScan;
import org.opensearch.sql.opensearch.util.OpenSearchRelOptUtil;

@Value.Enclosing
public class ExpandCollationOnProjectExprRule
extends InterruptibleRelRule<Config> {
    protected ExpandCollationOnProjectExprRule(Config config) {
        super(config);
    }

    @Override
    protected void onMatchImpl(RelOptRuleCall call) {
        AbstractConverter converter = (AbstractConverter)call.rel(0);
        Project project = (Project)call.rel(1);
        RelTraitSet toTraits = converter.getTraitSet();
        RelCollation toCollation = (RelCollation)toTraits.getTrait((RelTraitDef)RelCollationTraitDef.INSTANCE);
        assert (toCollation != null && toCollation.getFieldCollations() != null) : "Output field collations should not be null";
        HashMap<Integer, Optional<Pair<Integer, Boolean>>> orderEquivInfoMap = new HashMap<Integer, Optional<Pair<Integer, Boolean>>>();
        for (RelFieldCollation relFieldCollation : toCollation.getFieldCollations()) {
            orderEquivInfoMap.put(relFieldCollation.getFieldIndex(), OpenSearchRelOptUtil.getOrderEquivalentInputInfo((RexNode)project.getProjects().get(relFieldCollation.getFieldIndex())));
        }
        if (this.handleComplexExpressionsSortedByScan(call, project, toTraits, toCollation, orderEquivInfoMap)) {
            return;
        }
        this.handleSimpleExpressionFieldSorts(call, project, toTraits, toCollation, orderEquivInfoMap);
    }

    private boolean handleComplexExpressionsSortedByScan(RelOptRuleCall call, Project project, RelTraitSet toTraits, RelCollation toCollation, Map<Integer, Optional<Pair<Integer, Boolean>>> orderEquivInfoMap) {
        if (toCollation == null || toCollation.getFieldCollations().isEmpty()) {
            return false;
        }
        CalciteEnumerableIndexScan scan = ExpandCollationOnProjectExprRule.extractEnumerableScanFromInput(project.getInput());
        if (scan == null) {
            return false;
        }
        if (OpenSearchRelOptUtil.canScanProvideSortCollation(scan, project, toCollation, orderEquivInfoMap)) {
            Project newProject = project.copy(toTraits, project.getInput(), project.getProjects(), project.getRowType());
            call.transformTo((RelNode)newProject);
            return true;
        }
        return false;
    }

    private void handleSimpleExpressionFieldSorts(RelOptRuleCall call, Project project, RelTraitSet toTraits, RelCollation toCollation, Map<Integer, Optional<Pair<Integer, Boolean>>> orderEquivInfoMap) {
        RelTrait fromTrait = project.getInput().getTraitSet().getTrait((RelTraitDef)RelCollationTraitDef.INSTANCE);
        if (fromTrait instanceof RelCollation) {
            RelCollation fromCollation = (RelCollation)fromTrait;
            if (toCollation == null || toCollation.getFieldCollations().isEmpty() || fromCollation.getFieldCollations().size() < toCollation.getFieldCollations().size()) {
                return;
            }
            for (int i = 0; i < toCollation.getFieldCollations().size(); ++i) {
                RelFieldCollation toCollationFieldCollation = (RelFieldCollation)toCollation.getFieldCollations().get(i);
                if (OpenSearchRelOptUtil.sourceCollationSatisfiesTargetCollation((RelFieldCollation)fromCollation.getFieldCollations().get(i), toCollationFieldCollation, orderEquivInfoMap.get(toCollationFieldCollation.getFieldIndex()))) continue;
                return;
            }
            Project newProject = project.copy(toTraits, project.getInput(), project.getProjects(), project.getRowType());
            call.transformTo((RelNode)newProject);
            PlanUtils.tryPruneRelNodes((RelOptRuleCall)call);
        }
    }

    private static CalciteEnumerableIndexScan extractEnumerableScanFromInput(RelNode input) {
        RelSubset subset;
        RelNode bestPlan;
        if (input instanceof CalciteEnumerableIndexScan) {
            return (CalciteEnumerableIndexScan)input;
        }
        if (input instanceof RelSubset && (bestPlan = (subset = (RelSubset)input).getBest()) != null) {
            return ExpandCollationOnProjectExprRule.extractEnumerableScanFromInput(bestPlan);
        }
        return null;
    }

    @Value.Immutable
    public static interface Config
    extends OpenSearchRuleConfig {
        public static final Config DEFAULT = ImmutableExpandCollationOnProjectExprRule.Config.builder().build().withOperandSupplier(b0 -> b0.operand(AbstractConverter.class).oneInput(b1 -> b1.operand(EnumerableProject.class).predicate(Predicate.not(Project::containsOver).and(PlanUtils::containsRexCall)).anyInputs()));

        default public ExpandCollationOnProjectExprRule toRule() {
            return new ExpandCollationOnProjectExprRule(this);
        }
    }
}

