/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.randomcutforest;

import com.amazon.randomcutforest.CommonUtils;
import com.amazon.randomcutforest.RandomCutForest;
import com.amazon.randomcutforest.config.ForestMode;
import com.amazon.randomcutforest.config.ImputationMethod;
import com.amazon.randomcutforest.config.TransformMethod;
import com.amazon.randomcutforest.preprocessor.IPreprocessor;
import com.amazon.randomcutforest.preprocessor.Preprocessor;
import com.amazon.randomcutforest.returntypes.DensityOutput;
import com.amazon.randomcutforest.returntypes.DiVector;
import com.amazon.randomcutforest.returntypes.InterpolationMeasure;
import com.amazon.randomcutforest.returntypes.SampleSummary;
import java.util.Arrays;
import java.util.Optional;
import java.util.Random;

public class PredictiveRandomCutForest {
    protected TransformMethod transformMethod = TransformMethod.NORMALIZE;
    protected RandomCutForest forest;
    protected IPreprocessor preprocessor;
    protected ForestMode forestMode = ForestMode.STANDARD;

    public PredictiveRandomCutForest(Builder<?> builder) {
        this.transformMethod = builder.transformMethod;
        Object preprocessorBuilder = ((Preprocessor.Builder)((Preprocessor.Builder)Preprocessor.builder().shingleSize(builder.shingleSize)).transformMethod(builder.transformMethod)).forestMode(builder.forestMode);
        int dimensions = builder.inputDimensions * builder.shingleSize;
        if (builder.forestMode == ForestMode.TIME_AUGMENTED) {
            dimensions += builder.shingleSize;
            ((Preprocessor.Builder)preprocessorBuilder).normalizeTime(true);
            builder.internalShinglingEnabled = Optional.of(true);
        } else if (builder.forestMode == ForestMode.STREAMING_IMPUTE) {
            ((Preprocessor.Builder)preprocessorBuilder).normalizeTime(true);
            builder.internalShinglingEnabled = Optional.of(true);
            ((Preprocessor.Builder)preprocessorBuilder).imputationMethod(builder.imputationMethod);
            if (builder.fillValues != null) {
                ((Preprocessor.Builder)preprocessorBuilder).fillValues(builder.fillValues);
            }
            ((Preprocessor.Builder)preprocessorBuilder).useImputedFraction(builder.useImputedFraction.orElse(0.5));
        } else {
            builder.internalShinglingEnabled = Optional.of(true);
        }
        this.forestMode = builder.forestMode;
        this.forest = builder.buildForest();
        this.validateNonNegativeArray(builder.weights);
        ((Preprocessor.Builder)preprocessorBuilder).inputLength(builder.inputDimensions);
        ((Preprocessor.Builder)preprocessorBuilder).weights(builder.weights);
        ((Preprocessor.Builder)preprocessorBuilder).weightTime(builder.weightTime.orElse(1.0));
        ((Preprocessor.Builder)preprocessorBuilder).transformDecay(builder.transformDecay.orElse(1.0 / (double)builder.sampleSize));
        ((Preprocessor.Builder)preprocessorBuilder).randomSeed(builder.randomSeed.orElse(0L) + 1L);
        ((Preprocessor.Builder)preprocessorBuilder).dimensions(dimensions);
        ((Preprocessor.Builder)preprocessorBuilder).stopNormalization(builder.stopNormalization.orElse(Preprocessor.DEFAULT_STOP_NORMALIZATION));
        ((Preprocessor.Builder)preprocessorBuilder).startNormalization(builder.startNormalization.orElse(Preprocessor.DEFAULT_START_NORMALIZATION));
        this.preprocessor = ((Preprocessor.Builder)preprocessorBuilder).build();
    }

    public PredictiveRandomCutForest(ForestMode forestMode, TransformMethod method, IPreprocessor preprocessor, RandomCutForest forest) {
        this.forestMode = forestMode;
        this.transformMethod = method;
        this.preprocessor = preprocessor;
        this.forest = forest;
    }

    void validateNonNegativeArray(double[] array) {
        if (array != null) {
            for (double element : array) {
                CommonUtils.checkArgument(element >= 0.0, " has to be non-negative");
            }
        }
    }

    public SampleSummary predict(float[] inputPoint, long timestamp, int[] missingValues, int numberOfRepresentatives, double shrinkage, double centrality) {
        float[] point;
        CommonUtils.checkArgument(inputPoint.length == this.preprocessor.getInputLength(), "incorrect length");
        int[] newMissingValues = new int[]{};
        if (missingValues != null) {
            CommonUtils.checkArgument(missingValues.length <= inputPoint.length, " incorrect data");
            newMissingValues = new int[missingValues.length];
            int startPosition = this.forest.getDimensions() - this.forest.getDimensions() / this.preprocessor.getShingleSize();
            for (int i = 0; i < missingValues.length; ++i) {
                CommonUtils.checkArgument(missingValues[i] >= 0, " missing values cannot be at negative position");
                CommonUtils.checkArgument(missingValues[i] <= inputPoint.length, "missing values cannot be at position larger than input length");
                CommonUtils.checkArgument(this.forestMode == ForestMode.TIME_AUGMENTED || missingValues[i] < inputPoint.length, "cannot be equal to input length");
                newMissingValues[i] = this.forestMode == ForestMode.STREAMING_IMPUTE ? startPosition + missingValues[i] : missingValues[i];
            }
        }
        if ((point = this.preprocessor.getScaledShingledInput(CommonUtils.toDoubleArray(inputPoint), timestamp, missingValues, this.forest)) == null) {
            return new SampleSummary(this.preprocessor.getInputLength());
        }
        return this.preprocessor.invertInPlaceRecentSummaryBlock(this.forest.getConditionalFieldSummary(point, newMissingValues, numberOfRepresentatives, shrinkage, true, false, centrality, this.preprocessor.getShingleSize()));
    }

    public SampleSummary predict(float[] inputPoint, long timestamp, int[] missingValues) {
        return this.predict(inputPoint, timestamp, missingValues, 5, 0.3, 0.5);
    }

    public SampleSummary neighborSummary(float[] inputPoint, long timestamp) {
        return this.predict(inputPoint, timestamp, null, 1, 0.0, 1.0);
    }

    public double getExpectedInverseDepthScore(float[] inputPoint, long timestamp) {
        CommonUtils.checkArgument(inputPoint.length == this.preprocessor.getInputLength(), "incorrect length");
        float[] point = this.preprocessor.getScaledShingledInput(CommonUtils.toDoubleArray(inputPoint), timestamp, null, this.forest);
        return point != null ? this.forest.getAnomalyScore(point) : 0.0;
    }

    public DiVector getExpectedInverseDepthAttribution(float[] inputPoint, long timestamp) {
        CommonUtils.checkArgument(inputPoint.length == this.preprocessor.getInputLength(), "incorrect length");
        float[] point = this.preprocessor.getScaledShingledInput(CommonUtils.toDoubleArray(inputPoint), timestamp, null, this.forest);
        return point != null ? this.forest.getAnomalyAttribution(point) : new DiVector(this.forest.getDimensions());
    }

    public DensityOutput getSimpleDensity(float[] inputPoint, long timestamp) {
        CommonUtils.checkArgument(inputPoint.length == this.preprocessor.getInputLength(), "incorrect length");
        float[] scaled = this.preprocessor.getScaledShingledInput(CommonUtils.toDoubleArray(inputPoint), timestamp, null, this.forest);
        DensityOutput answer = scaled != null ? this.forest.getSimpleDensity(scaled) : new DensityOutput(new InterpolationMeasure(inputPoint.length, 0));
        double[] scale = this.preprocessor.getScale();
        for (int i = 0; i < answer.getDimensions(); ++i) {
            int n = i;
            answer.distances.high[n] = answer.distances.high[n] * scale[i % scale.length];
            int n2 = i;
            answer.distances.low[n2] = answer.distances.low[n2] * scale[i % scale.length];
        }
        return answer;
    }

    public DiVector getRCFDistanceAttribution(float[] inputPoint, long timestamp) {
        DensityOutput test = this.getSimpleDensity(inputPoint, timestamp);
        return test.distances;
    }

    public void update(float[] record, long timestamp) {
        this.update(record, timestamp, null);
    }

    public void update(float[] record, long timestamp, int[] missing) {
        float[] scaled = this.preprocessor.getScaledShingledInput(CommonUtils.toDoubleArray(record), timestamp, missing, this.forest);
        this.preprocessor.update(CommonUtils.toDoubleArray(record), scaled, timestamp, missing, this.forest);
    }

    public RandomCutForest getForest() {
        return this.forest;
    }

    public IPreprocessor getPreprocessor() {
        return this.preprocessor;
    }

    public ForestMode getForestMode() {
        return this.forestMode;
    }

    public TransformMethod getTransformMethod() {
        return this.transformMethod;
    }

    public static Builder<?> builder() {
        return new Builder();
    }

    public static class Builder<T extends Builder<T>> {
        protected int inputDimensions;
        protected int sampleSize = 256;
        protected Optional<Integer> outputAfter = Optional.empty();
        protected Optional<Integer> startNormalization = Optional.empty();
        protected Optional<Integer> stopNormalization = Optional.empty();
        protected int numberOfTrees = 50;
        protected Optional<Double> timeDecay = Optional.empty();
        protected Optional<Double> lowerThreshold = Optional.empty();
        protected Optional<Double> weightTime = Optional.empty();
        protected boolean normalizeTime = true;
        protected Optional<Long> randomSeed = Optional.empty();
        protected boolean storeSequenceIndexesEnabled = false;
        protected boolean centerOfMassEnabled = false;
        protected boolean parallelExecutionEnabled = false;
        protected Optional<Integer> threadPoolSize = Optional.empty();
        protected double boundingBoxCacheFraction = 1.0;
        protected int shingleSize = 1;
        protected Optional<Boolean> internalShinglingEnabled = Optional.empty();
        protected double initialAcceptFraction = 1.0;
        protected TransformMethod transformMethod = TransformMethod.NONE;
        protected ImputationMethod imputationMethod = ImputationMethod.PREVIOUS;
        protected ForestMode forestMode = ForestMode.STANDARD;
        protected double[] weights = null;
        protected double[] fillValues = null;
        protected Optional<Double> useImputedFraction = Optional.empty();
        protected Optional<Double> transformDecay = Optional.empty();

        void validate() {
            if (this.forestMode == ForestMode.TIME_AUGMENTED) {
                if (this.internalShinglingEnabled.isPresent()) {
                    CommonUtils.checkArgument(this.shingleSize == 1 || this.internalShinglingEnabled.get() != false, " shingle size has to be 1 or internal shingling must turned on");
                    CommonUtils.checkArgument(this.transformMethod == TransformMethod.NONE || this.internalShinglingEnabled.get() != false, " internal shingling must turned on for transforms");
                } else {
                    this.internalShinglingEnabled = Optional.of(true);
                }
                if (this.useImputedFraction.isPresent()) {
                    throw new IllegalArgumentException(" imputation infeasible");
                }
            } else if (this.forestMode == ForestMode.STREAMING_IMPUTE) {
                CommonUtils.checkArgument(this.shingleSize > 1, "imputation with shingle size 1 is not meaningful");
                this.internalShinglingEnabled.ifPresent(x -> CommonUtils.checkArgument((boolean)x, " input cannot be shingled (even if internal representation is different) "));
            } else {
                if (!this.internalShinglingEnabled.isPresent()) {
                    this.internalShinglingEnabled = Optional.of(true);
                }
                if (this.useImputedFraction.isPresent()) {
                    throw new IllegalArgumentException(" imputation infeasible");
                }
            }
            if (this.startNormalization.isPresent()) {
                if (this.outputAfter.isPresent()) {
                    CommonUtils.checkArgument(this.outputAfter.get() + this.shingleSize - 1 > this.startNormalization.get(), "output after has to wait till normalization, reduce normalization");
                } else {
                    int n = this.startNormalization.get();
                    CommonUtils.checkArgument(n > 0, " startNormalization has to be positive");
                    this.outputAfter = Optional.of(Math.max(Math.max(1, (int)((double)this.sampleSize * 0.25)), n - this.shingleSize + 1));
                }
            } else if (this.outputAfter.isPresent()) {
                this.startNormalization = Optional.of(Math.min(Preprocessor.DEFAULT_START_NORMALIZATION, this.outputAfter.get()));
            }
        }

        public PredictiveRandomCutForest build() {
            this.validate();
            return new PredictiveRandomCutForest(this);
        }

        protected RandomCutForest buildForest() {
            int dimensions = this.inputDimensions * this.shingleSize + (this.forestMode == ForestMode.TIME_AUGMENTED ? this.shingleSize : 0);
            Object builder = ((RandomCutForest.Builder)((RandomCutForest.Builder)((RandomCutForest.Builder)((RandomCutForest.Builder)((RandomCutForest.Builder)((RandomCutForest.Builder)((RandomCutForest.Builder)((RandomCutForest.Builder)((RandomCutForest.Builder)new RandomCutForest.Builder().dimensions(dimensions)).sampleSize(this.sampleSize)).numberOfTrees(this.numberOfTrees)).storeSequenceIndexesEnabled(this.storeSequenceIndexesEnabled)).centerOfMassEnabled(this.centerOfMassEnabled)).parallelExecutionEnabled(this.parallelExecutionEnabled)).boundingBoxCacheFraction(this.boundingBoxCacheFraction)).shingleSize(this.shingleSize)).internalShinglingEnabled(this.internalShinglingEnabled.get())).initialAcceptFraction(this.initialAcceptFraction);
            this.outputAfter.ifPresent(arg_0 -> builder.outputAfter(arg_0));
            this.timeDecay.ifPresent(arg_0 -> builder.timeDecay(arg_0));
            this.randomSeed.ifPresent(arg_0 -> builder.randomSeed(arg_0));
            this.threadPoolSize.ifPresent(arg_0 -> builder.threadPoolSize(arg_0));
            return ((RandomCutForest.Builder)builder).build();
        }

        public T inputDimensions(int dimensions) {
            this.inputDimensions = dimensions;
            return (T)this;
        }

        public T sampleSize(int sampleSize) {
            this.sampleSize = sampleSize;
            return (T)this;
        }

        public T startNormalization(int startNormalization) {
            this.startNormalization = Optional.of(startNormalization);
            return (T)this;
        }

        public T stopNormalization(int stopNormalization) {
            this.stopNormalization = Optional.of(stopNormalization);
            return (T)this;
        }

        public T outputAfter(int outputAfter) {
            this.outputAfter = Optional.of(outputAfter);
            return (T)this;
        }

        public T numberOfTrees(int numberOfTrees) {
            this.numberOfTrees = numberOfTrees;
            return (T)this;
        }

        public T shingleSize(int shingleSize) {
            this.shingleSize = shingleSize;
            return (T)this;
        }

        public T timeDecay(double timeDecay) {
            this.timeDecay = Optional.of(timeDecay);
            return (T)this;
        }

        public T transformDecay(double transformDecay) {
            this.transformDecay = Optional.of(transformDecay);
            return (T)this;
        }

        public T randomSeed(long randomSeed) {
            this.randomSeed = Optional.of(randomSeed);
            return (T)this;
        }

        public T centerOfMassEnabled(boolean centerOfMassEnabled) {
            this.centerOfMassEnabled = centerOfMassEnabled;
            return (T)this;
        }

        public T parallelExecutionEnabled(boolean parallelExecutionEnabled) {
            this.parallelExecutionEnabled = parallelExecutionEnabled;
            return (T)this;
        }

        public T forestMode(ForestMode forestMode) {
            this.forestMode = forestMode;
            return (T)this;
        }

        public T threadPoolSize(int threadPoolSize) {
            this.threadPoolSize = Optional.of(threadPoolSize);
            return (T)this;
        }

        public T storeSequenceIndexesEnabled(boolean storeSequenceIndexesEnabled) {
            this.storeSequenceIndexesEnabled = storeSequenceIndexesEnabled;
            return (T)this;
        }

        public T boundingBoxCacheFraction(double boundingBoxCacheFraction) {
            this.boundingBoxCacheFraction = boundingBoxCacheFraction;
            return (T)this;
        }

        public T initialAcceptFraction(double initialAcceptFraction) {
            this.initialAcceptFraction = initialAcceptFraction;
            return (T)this;
        }

        public Random getRandom() {
            return this.randomSeed.map(Random::new).orElseGet(Random::new);
        }

        public T weights(double[] values) {
            this.weights = Arrays.copyOf(values, values.length);
            return (T)this;
        }

        public T imputationMethod(ImputationMethod imputationMethod) {
            this.imputationMethod = imputationMethod;
            return (T)this;
        }

        public T transformMethod(TransformMethod method) {
            this.transformMethod = method;
            return (T)this;
        }

        public T fillValues(double[] values) {
            this.fillValues = Arrays.copyOf(values, values.length);
            return (T)this;
        }

        public T useImputedFraction(double fraction) {
            this.useImputedFraction = Optional.of(fraction);
            return (T)this;
        }

        public T weightTime(double value) {
            this.weightTime = Optional.of(value);
            return (T)this;
        }

        public T normalizeTime(boolean normalizeTime) {
            this.normalizeTime = normalizeTime;
            return (T)this;
        }
    }
}

