/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.painless.ir;

import java.lang.runtime.SwitchBootstraps;
import org.opensearch.painless.ClassWriter;
import org.opensearch.painless.Location;
import org.opensearch.painless.MethodWriter;
import org.opensearch.painless.ir.ExpressionNode;
import org.opensearch.painless.phase.IRTreeVisitor;
import org.opensearch.painless.symbol.WriteScope;

public class ConstantNode
extends ExpressionNode {
    private Object constant;

    public void setConstant(Object constant) {
        this.constant = constant;
    }

    public Object getConstant() {
        return this.constant;
    }

    @Override
    public <Scope> void visit(IRTreeVisitor<Scope> irTreeVisitor, Scope scope) {
        irTreeVisitor.visitConstant(this, scope);
    }

    @Override
    public <Scope> void visitChildren(IRTreeVisitor<Scope> irTreeVisitor, Scope scope) {
    }

    public ConstantNode(Location location) {
        super(location);
    }

    @Override
    protected void write(ClassWriter classWriter, MethodWriter methodWriter, WriteScope writeScope) {
        Object object = this.constant;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{String.class, Double.class, Float.class, Long.class, Integer.class, Character.class, Short.class, Byte.class, Boolean.class}, (Object)object, n)) {
            case 0: {
                String stringValue = (String)object;
                methodWriter.push(stringValue);
                break;
            }
            case 1: {
                Double doubleValue = (Double)object;
                methodWriter.push(doubleValue);
                break;
            }
            case 2: {
                Float floatValue = (Float)object;
                methodWriter.push(floatValue.floatValue());
                break;
            }
            case 3: {
                Long longValue = (Long)object;
                methodWriter.push(longValue);
                break;
            }
            case 4: {
                Integer intValue = (Integer)object;
                methodWriter.push(intValue);
                break;
            }
            case 5: {
                Character charValue = (Character)object;
                methodWriter.push(charValue.charValue());
                break;
            }
            case 6: {
                Short shortValue = (Short)object;
                methodWriter.push(shortValue.shortValue());
                break;
            }
            case 7: {
                Byte byteValue = (Byte)object;
                methodWriter.push(byteValue.byteValue());
                break;
            }
            case 8: {
                Boolean boolValue = (Boolean)object;
                methodWriter.push(boolValue);
                break;
            }
            default: {
                throw new IllegalStateException("unexpected constant [" + String.valueOf(this.constant) + "]");
            }
        }
    }
}

